/*
 * Decompiled with CFR 0.152.
 */
package dev.rndmorris.salisarcana.config;

import dev.rndmorris.salisarcana.config.modules.BaseConfigModule;
import dev.rndmorris.salisarcana.config.modules.BiomeColorModule;
import dev.rndmorris.salisarcana.config.modules.BugfixesModule;
import dev.rndmorris.salisarcana.config.modules.CommandsModule;
import dev.rndmorris.salisarcana.config.modules.EnhancementsModule;
import dev.rndmorris.salisarcana.config.modules.ModCompatModule;
import java.io.File;
import java.nio.file.Paths;
import net.minecraftforge.common.config.Configuration;

public class ConfigModuleRoot {
    public static final BiomeColorModule biomeColors;
    public static final BugfixesModule bugfixes;
    public static final CommandsModule commands;
    public static final EnhancementsModule enhancements;
    public static final ModCompatModule modCompat;
    public static boolean enableVersionChecking;
    private static final BaseConfigModule[] modules;

    public static void synchronizeConfiguration() {
        String rootConfigFile = Paths.get("config", "salisarcana.cfg").toString();
        Configuration rootConfig = new Configuration(new File(rootConfigFile));
        enableVersionChecking = rootConfig.getBoolean("enableversionChecking", "general", true, "Check for new versions of Salis Arcana on startup");
        for (BaseConfigModule module : modules) {
            String toggleName = String.format("Enable %s module", module.getModuleId());
            boolean enabled = rootConfig.getBoolean(toggleName, "modules", module.isEnabled(), module.getModuleComment());
            module.setEnabled(enabled);
            if (!enabled) continue;
            Configuration moduleConfig = ConfigModuleRoot.getModuleConfig(module);
            module.loadModuleFromConfig(moduleConfig);
            if (!moduleConfig.hasChanged()) continue;
            moduleConfig.save();
        }
        if (rootConfig.hasChanged()) {
            rootConfig.save();
        }
    }

    private static Configuration getModuleConfig(BaseConfigModule module) {
        String path = Paths.get("config", "salisarcana", module.getModuleId() + ".cfg").toString();
        return new Configuration(new File(path));
    }

    static {
        BaseConfigModule[] baseConfigModuleArray = new BaseConfigModule[5];
        biomeColors = new BiomeColorModule();
        baseConfigModuleArray[0] = biomeColors;
        bugfixes = new BugfixesModule();
        baseConfigModuleArray[1] = bugfixes;
        commands = new CommandsModule();
        baseConfigModuleArray[2] = commands;
        enhancements = new EnhancementsModule();
        baseConfigModuleArray[3] = enhancements;
        modCompat = new ModCompatModule();
        baseConfigModuleArray[4] = modCompat;
        modules = baseConfigModuleArray;
    }
}

