/*
 * Decompiled with CFR 0.152.
 */
package dev.rndmorris.salisarcana.common.commands.arguments.handlers.positional;

import com.google.common.collect.PeekingIterator;
import dev.rndmorris.salisarcana.common.commands.CommandErrors;
import dev.rndmorris.salisarcana.common.commands.arguments.handlers.IArgumentHandler;
import dev.rndmorris.salisarcana.common.commands.arguments.handlers.positional.IPositionalArgumentHandler;
import dev.rndmorris.salisarcana.config.ConfigModuleRoot;
import dev.rndmorris.salisarcana.config.settings.CommandSettings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.command.ICommandSender;

public class CommandNameHandler
implements IPositionalArgumentHandler {
    public static final IArgumentHandler INSTANCE = new CommandNameHandler();

    @Override
    public Object parse(ICommandSender sender, PeekingIterator<String> args) {
        CommandSettings command = this.findCommand((String)args.next());
        if (command == null) {
            CommandErrors.commandNotFound();
        }
        if (!sender.func_70003_b(command.getPermissionLevel(), command.getFullName())) {
            CommandErrors.insufficientPermission();
        }
        return command;
    }

    @Override
    public List<String> getAutocompleteOptions(ICommandSender sender, PeekingIterator<String> args) {
        args.next();
        CommandSettings[] settingsArr = ConfigModuleRoot.commands.commandsSettings;
        if (!args.hasNext()) {
            ArrayList<String> results = new ArrayList<String>(settingsArr.length * 2);
            for (CommandSettings settings : settingsArr) {
                if (!settings.isEnabled()) continue;
                Collections.addAll(results, settings.getFullName(), settings.name);
                results.addAll(settings.aliases);
            }
            return results;
        }
        return null;
    }

    @Override
    @Nonnull
    public Class<?> getOutputType() {
        return CommandSettings.class;
    }

    private CommandSettings findCommand(String current) {
        CommandSettings foundCommand = null;
        block0: for (CommandSettings settings : ConfigModuleRoot.commands.commandsSettings) {
            if (!settings.isEnabled()) continue;
            if (settings.name.equalsIgnoreCase(current) || settings.getFullName().equalsIgnoreCase(current)) {
                foundCommand = settings;
                break;
            }
            for (String alias : settings.aliases) {
                if (!alias.equalsIgnoreCase(current)) continue;
                foundCommand = settings;
                continue block0;
            }
        }
        return foundCommand;
    }
}

