/*
 * Decompiled with CFR 0.152.
 */
package openmods.network.event;

import com.google.common.base.Preconditions;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import cpw.mods.fml.relauncher.Side;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageCodec;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.minecraft.network.INetHandler;
import openmods.OpenMods;
import openmods.network.event.EventDirection;
import openmods.network.event.INetworkEventType;
import openmods.network.event.NetworkEvent;
import openmods.network.event.NetworkEventRegistry;
import openmods.utils.io.PacketChunker;

@ChannelHandler.Sharable
public class NetworkEventCodec
extends MessageToMessageCodec<FMLProxyPacket, NetworkEvent> {
    private final PacketChunker chunker = new PacketChunker();
    private final NetworkEventRegistry registry;

    public NetworkEventCodec(NetworkEventRegistry registry) {
        this.registry = registry;
    }

    protected void encode(ChannelHandlerContext ctx, NetworkEvent msg, List<Object> out) throws IOException {
        int id = this.registry.getIdForClass(((Object)((Object)msg)).getClass());
        INetworkEventType type = this.registry.getTypeForId(id);
        byte[] payload = NetworkEventCodec.toRawBytes(msg, type.isCompressed());
        Channel channel = ctx.channel();
        Side side = (Side)channel.attr(NetworkRegistry.CHANNEL_SOURCE).get();
        EventDirection validator = type.getDirection();
        Preconditions.checkState((validator != null && validator.validateSend(side) ? 1 : 0) != 0, (String)"Invalid direction: sending packet %s on side %s", (Object[])new Object[]{((Object)((Object)msg)).getClass(), side});
        if (type.isChunked()) {
            byte[][] chunked;
            int maxChunkSize = side == Side.SERVER ? 0x1FFFF0 : Short.MAX_VALUE;
            for (byte[] chunk : chunked = this.chunker.splitIntoChunks(payload, maxChunkSize)) {
                FMLProxyPacket partialPacket = NetworkEventCodec.createPacket(id, chunk);
                partialPacket.setDispatcher(msg.dispatcher);
                out.add(partialPacket);
            }
        } else {
            FMLProxyPacket partialPacket = NetworkEventCodec.createPacket(id, payload);
            partialPacket.setDispatcher(msg.dispatcher);
            out.add(partialPacket);
        }
    }

    protected void decode(ChannelHandlerContext ctx, FMLProxyPacket msg, List<Object> out) throws Exception {
        int bufferJunkSize;
        ByteBuf payload = msg.payload();
        int typeId = ByteBufUtils.readVarInt((ByteBuf)payload, (int)5);
        INetworkEventType type = this.registry.getTypeForId(typeId);
        Channel channel = ctx.channel();
        Side side = (Side)channel.attr(NetworkRegistry.CHANNEL_SOURCE).get();
        EventDirection validator = type.getDirection();
        Preconditions.checkState((validator != null && validator.validateReceive(side) ? 1 : 0) != 0, (String)"Invalid direction: receiving packet %s on side %s", (Object[])new Object[]{msg.getClass(), side});
        Object input = new ByteBufInputStream(payload);
        if (type.isChunked()) {
            byte[] fullPayload = this.chunker.consumeChunk((InputStream)input, ((InputStream)input).available());
            if (fullPayload == null) {
                return;
            }
            input = new ByteArrayInputStream(fullPayload);
        }
        if (type.isCompressed()) {
            input = new GZIPInputStream((InputStream)input);
        }
        DataInputStream data = new DataInputStream((InputStream)input);
        NetworkEvent event = type.createPacket();
        event.readFromStream(data);
        event.dispatcher = msg.getDispatcher();
        INetHandler handler = msg.handler();
        if (handler != null) {
            event.sender = OpenMods.proxy.getPlayerFromHandler(handler);
        }
        if ((bufferJunkSize = ((InputStream)input).available()) > 0) {
            Preconditions.checkState((((InputStream)input).read() == -1 ? 1 : 0) != 0, (String)"%s junk bytes left in buffer, event", (Object[])new Object[]{bufferJunkSize, event});
        }
        ((InputStream)input).close();
        out.add((Object)event);
    }

    private static FMLProxyPacket createPacket(int id, byte[] payload) {
        ByteBuf buf = Unpooled.buffer((int)(payload.length + 5));
        ByteBufUtils.writeVarInt((ByteBuf)buf, (int)id, (int)5);
        buf.writeBytes(payload);
        FMLProxyPacket partialPacket = new FMLProxyPacket(buf.copy(), "OpenMods|E");
        return partialPacket;
    }

    private static byte[] toRawBytes(NetworkEvent event, boolean compress) throws IOException {
        ByteArrayOutputStream payload = new ByteArrayOutputStream();
        OutputStream stream = compress ? new GZIPOutputStream(payload) : payload;
        DataOutputStream output = new DataOutputStream(stream);
        event.writeToStream(output);
        stream.close();
        return payload.toByteArray();
    }
}

