/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.SolarSystem.planets.kuiperbelt.dimension;

import galaxyspace.SolarSystem.SolarSystemPlanets;
import galaxyspace.SolarSystem.planets.kuiperbelt.dimension.ChunkProviderKuiper;
import galaxyspace.SolarSystem.planets.kuiperbelt.dimension.KuiperSaveData;
import galaxyspace.SolarSystem.planets.kuiperbelt.dimension.WorldChunkManagerKuiper;
import java.util.HashSet;
import java.util.Set;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.planets.asteroids.dimension.WorldProviderAsteroids;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.biome.WorldChunkManager;
import net.minecraft.world.chunk.IChunkProvider;

public class WorldProviderKuiper
extends WorldProviderAsteroids {
    private final Set<AsteroidData> asteroids = new HashSet<AsteroidData>();
    private boolean dataNotLoaded = true;
    private KuiperSaveData datafile;

    public CelestialBody getCelestialBody() {
        return SolarSystemPlanets.planetKuiperBelt;
    }

    public Class<? extends IChunkProvider> getChunkProviderClass() {
        return ChunkProviderKuiper.class;
    }

    public Class<? extends WorldChunkManager> getWorldChunkManagerClass() {
        return WorldChunkManagerKuiper.class;
    }

    public float getGravity() {
        return 0.075f;
    }

    public boolean canSpaceshipTierPass(int tier) {
        return tier >= SolarSystemPlanets.planetKuiperBelt.getTierRequirement();
    }

    public float getThermalLevelModifier() {
        return -4.0f;
    }

    public void addAsteroid(int x, int y, int z, int size, int core) {
        AsteroidData coords = new AsteroidData(x, y, z, size, core);
        if (!this.asteroids.contains(coords)) {
            if (this.dataNotLoaded) {
                this.loadAsteroidSavedData();
            }
            if (!this.asteroids.contains(coords)) {
                this.addToNBT(this.datafile.datacompound, coords);
                this.asteroids.add(coords);
            }
        }
    }

    public void removeAsteroid(int x, int y, int z) {
        AsteroidData coords = new AsteroidData(x, y, z);
        if (this.asteroids.contains(coords)) {
            this.asteroids.remove(coords);
            if (this.dataNotLoaded) {
                this.loadAsteroidSavedData();
            }
            this.writeToNBT(this.datafile.datacompound);
        }
    }

    private void loadAsteroidSavedData() {
        this.datafile = (KuiperSaveData)this.field_76579_a.func_72943_a(KuiperSaveData.class, "GSKuiperData");
        if (this.datafile == null) {
            this.datafile = new KuiperSaveData();
            this.field_76579_a.func_72823_a("GSKuiperData", (WorldSavedData)this.datafile);
            this.writeToNBT(this.datafile.datacompound);
        } else {
            this.readFromNBT(this.datafile.datacompound);
        }
        this.dataNotLoaded = false;
    }

    private void readFromNBT(NBTTagCompound nbt) {
        NBTTagList coordList = nbt.func_150295_c("coords", 10);
        if (coordList.func_74745_c() > 0) {
            for (int j = 0; j < coordList.func_74745_c(); ++j) {
                NBTTagCompound tag1 = coordList.func_150305_b(j);
                if (tag1 == null) continue;
                this.asteroids.add(AsteroidData.readFromNBT(tag1));
            }
        }
    }

    private void writeToNBT(NBTTagCompound nbt) {
        NBTTagList coordList = new NBTTagList();
        for (AsteroidData coords : this.asteroids) {
            NBTTagCompound tag = new NBTTagCompound();
            coords.writeToNBT(tag);
            coordList.func_74742_a((NBTBase)tag);
        }
        nbt.func_74782_a("coords", (NBTBase)coordList);
        this.datafile.func_76185_a();
    }

    private void addToNBT(NBTTagCompound nbt, AsteroidData coords) {
        NBTTagList coordList = nbt.func_150295_c("coords", 10);
        NBTTagCompound tag = new NBTTagCompound();
        coords.writeToNBT(tag);
        coordList.func_74742_a((NBTBase)tag);
        nbt.func_74782_a("coords", (NBTBase)coordList);
        this.datafile.func_76185_a();
    }

    public BlockVec3 getClosestAsteroidXZ(int x, int y, int z) {
        if (this.dataNotLoaded) {
            this.loadAsteroidSavedData();
        }
        if (this.asteroids.size() == 0) {
            return null;
        }
        BlockVec3 result = null;
        AsteroidData resultRoid = null;
        int lowestDistance = Integer.MAX_VALUE;
        for (AsteroidData test : this.asteroids) {
            int dz;
            int dx;
            int a;
            if ((test.sizeAndLandedFlag & 0x80) != 0 || (a = (dx = x - test.centre.x) * dx + (dz = z - test.centre.z) * dz) >= lowestDistance) continue;
            lowestDistance = a;
            result = test.centre;
            resultRoid = test;
        }
        if (result == null) {
            return null;
        }
        resultRoid.sizeAndLandedFlag |= 0x80;
        this.writeToNBT(this.datafile.datacompound);
        return result.clone();
    }

    private static class AsteroidData {
        protected BlockVec3 centre;
        protected int sizeAndLandedFlag = 15;
        protected int coreAndSpawnedFlag = -2;

        public AsteroidData(int x, int y, int z) {
            this.centre = new BlockVec3(x, y, z);
        }

        public AsteroidData(int x, int y, int z, int size, int core) {
            this.centre = new BlockVec3(x, y, z);
            this.sizeAndLandedFlag = size;
            this.coreAndSpawnedFlag = core;
        }

        public AsteroidData(BlockVec3 bv) {
            this.centre = bv;
        }

        public int hashCode() {
            if (this.centre != null) {
                return this.centre.hashCode();
            }
            return 0;
        }

        public boolean equals(Object o) {
            if (o instanceof AsteroidData) {
                BlockVec3 vector = ((AsteroidData)o).centre;
                return this.centre.x == vector.x && this.centre.y == vector.y && this.centre.z == vector.z;
            }
            if (o instanceof BlockVec3) {
                BlockVec3 vector = (BlockVec3)o;
                return this.centre.x == vector.x && this.centre.y == vector.y && this.centre.z == vector.z;
            }
            return false;
        }

        public NBTTagCompound writeToNBT(NBTTagCompound tag) {
            tag.func_74768_a("x", this.centre.x);
            tag.func_74768_a("y", this.centre.y);
            tag.func_74768_a("z", this.centre.z);
            tag.func_74768_a("coreAndFlag", this.coreAndSpawnedFlag);
            tag.func_74768_a("sizeAndFlag", this.sizeAndLandedFlag);
            return tag;
        }

        public static AsteroidData readFromNBT(NBTTagCompound tag) {
            BlockVec3 tempVector = new BlockVec3();
            tempVector.x = tag.func_74762_e("x");
            tempVector.y = tag.func_74762_e("y");
            tempVector.z = tag.func_74762_e("z");
            AsteroidData roid = new AsteroidData(tempVector);
            if (tag.func_74764_b("coreAndFlag")) {
                roid.coreAndSpawnedFlag = tag.func_74762_e("coreAndFlag");
            }
            if (tag.func_74764_b("sizeAndFlag")) {
                roid.sizeAndLandedFlag = tag.func_74762_e("sizeAndFlag");
            }
            return roid;
        }
    }
}

