/*
 * Decompiled with CFR 0.152.
 */
package gtnhlanth.common.tileentity;

import bartworks.common.loaders.ItemRegistry;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ISecondaryDescribable;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.metatileentity.implementations.MTEEnhancedMultiBlockBase;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.recipe.check.SimpleCheckRecipeResult;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.api.util.shutdown.ShutDownReasonRegistry;
import gtnhlanth.api.recipe.LanthanidesRecipeMaps;
import gtnhlanth.util.DescTextLocalization;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class MTEDissolutionTank
extends MTEEnhancedMultiBlockBase<MTEDissolutionTank>
implements ISurvivalConstructable,
ISecondaryDescribable {
    private final IStructureDefinition<MTEDissolutionTank> multiDefinition;

    public MTEDissolutionTank(String name) {
        super(name);
        this.multiDefinition = StructureDefinition.builder().addShape(this.mName, StructureUtility.transpose((String[][])new String[][]{{" sss ", "sssss", "sssss", "sssss", " sss "}, {"sgggs", "g---g", "g---g", "g---g", "sgggs"}, {"sgggs", "g---g", "g---g", "g---g", "sgggs"}, {"ss~ss", "shhhs", "shhhs", "shhhs", "sssss"}, {"s   s", "     ", "     ", "     ", "s   s"}})).addElement('s', GTStructureUtility.buildHatchAdder(MTEDissolutionTank.class).atLeast(HatchElement.InputHatch, HatchElement.OutputHatch, HatchElement.InputBus, HatchElement.OutputBus, HatchElement.Maintenance, HatchElement.Energy).casingIndex(49).dot(1).buildAndChain(GregTechAPI.sBlockCasings4, 1)).addElement('h', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings1, (int)11)).addElement('g', StructureUtility.ofBlockAdder(MTEDissolutionTank::addGlass, (Block)ItemRegistry.bw_glasses[0], (int)1)).build();
    }

    public MTEDissolutionTank(int id, String name, String nameRegional) {
        super(id, name, nameRegional);
        this.multiDefinition = StructureDefinition.builder().addShape(this.mName, StructureUtility.transpose((String[][])new String[][]{{" sss ", "sssss", "sssss", "sssss", " sss "}, {"sgggs", "g---g", "g---g", "g---g", "sgggs"}, {"sgggs", "g---g", "g---g", "g---g", "sgggs"}, {"ss~ss", "shhhs", "shhhs", "shhhs", "sssss"}, {"s   s", "     ", "     ", "     ", "s   s"}})).addElement('s', GTStructureUtility.buildHatchAdder(MTEDissolutionTank.class).atLeast(HatchElement.InputHatch, HatchElement.OutputHatch, HatchElement.InputBus, HatchElement.OutputBus, HatchElement.Maintenance, HatchElement.Energy).casingIndex(49).dot(1).buildAndChain(GregTechAPI.sBlockCasings4, 1)).addElement('h', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings1, (int)11)).addElement('g', StructureUtility.ofBlockAdder(MTEDissolutionTank::addGlass, (Block)ItemRegistry.bw_glasses[0], (int)1)).build();
    }

    @Override
    public IStructureDefinition<MTEDissolutionTank> getStructureDefinition() {
        return this.multiDefinition;
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        return this.checkPiece(this.mName, 2, 3, 0) && this.mMaintenanceHatches.size() == 1;
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    private boolean addGlass(Block block, int meta) {
        return block == ItemRegistry.bw_glasses[0];
    }

    @Override
    public RecipeMap<?> getRecipeMap() {
        return LanthanidesRecipeMaps.dissolutionTankRecipes;
    }

    @Override
    protected ProcessingLogic createProcessingLogic() {
        return new ProcessingLogic(){

            @Override
            @NotNull
            protected CheckRecipeResult onRecipeStart(@Nonnull GTRecipe recipe) {
                if (!MTEDissolutionTank.this.checkRatio(recipe, Arrays.asList(this.inputFluids))) {
                    MTEDissolutionTank.this.stopMachine(ShutDownReasonRegistry.CRITICAL_NONE);
                    return SimpleCheckRecipeResult.ofFailurePersistOnShutdown("dissolution_ratio");
                }
                return CheckRecipeResultRegistry.SUCCESSFUL;
            }
        };
    }

    @Override
    public boolean supportsVoidProtection() {
        return true;
    }

    @Override
    public boolean supportsInputSeparation() {
        return true;
    }

    @Override
    public boolean supportsBatchMode() {
        return true;
    }

    @Override
    public boolean supportsSingleRecipeLocking() {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean checkRatio(GTRecipe tRecipe, List<FluidStack> tFluidInputs) {
        int minorAmount;
        int majorAmount;
        FluidStack majorGenericFluid = tRecipe.mFluidInputs[0];
        FluidStack minorGenericFluid = tRecipe.mFluidInputs[1];
        FluidStack fluidInputOne = tFluidInputs.get(0);
        FluidStack fluidInputTwo = tFluidInputs.get(1);
        if (fluidInputOne.getUnlocalizedName().equals(majorGenericFluid.getUnlocalizedName())) {
            if (!fluidInputTwo.getUnlocalizedName().equals(minorGenericFluid.getUnlocalizedName())) return false;
            majorAmount = fluidInputOne.amount;
            minorAmount = fluidInputTwo.amount;
        } else {
            if (!fluidInputTwo.getUnlocalizedName().equals(majorGenericFluid.getUnlocalizedName())) return false;
            if (!fluidInputOne.getUnlocalizedName().equals(minorGenericFluid.getUnlocalizedName())) return false;
            majorAmount = fluidInputTwo.amount;
            minorAmount = fluidInputOne.amount;
        }
        if (majorAmount / tRecipe.mSpecialValue != minorAmount) return false;
        return true;
    }

    @Override
    public int getMaxEfficiency(ItemStack itemStack) {
        return 10000;
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity arg0) {
        return new MTEDissolutionTank(this.mName);
    }

    public void construct(ItemStack itemStack, boolean b) {
        this.buildPiece(this.mName, itemStack, b, 2, 3, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivialBuildPiece(this.mName, stackSize, 2, 3, 0, elementBudget, env, false, true);
    }

    @Override
    public String[] getStructureDescription(ItemStack arg0) {
        return DescTextLocalization.addText("DissolutionTank.hint", 4);
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity te, ForgeDirection side, ForgeDirection facing, int colorIndex, boolean active, boolean redstone) {
        if (side == facing) {
            if (active) {
                return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][49], TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_OIL_CRACKER_ACTIVE).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_OIL_CRACKER_ACTIVE_GLOW).extFacing().glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][49], TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_OIL_CRACKER).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_OIL_CRACKER_GLOW).extFacing().glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][49]};
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType("Dissolution Tank").addInfo("Input Water and Fluid, output Fluid").addInfo("You must input the Fluids at the correct Ratio").beginStructureBlock(5, 5, 5, true).addController("Front bottom").addCasingInfoExactly("Clean Stainless Steel Machine Casing", 42, false).addCasingInfoExactly("Titanium Reinforced Borosilicate Glass", 24, false).addCasingInfoExactly("Heat Proof Machine Casing", 9, false).addInputHatch("Hint block with dot 1").addInputBus("Hint block with dot 1").addOutputHatch("Hint block with dot 1").addOutputBus("Hint block with dot 1").addMaintenanceHatch("Hint block with dot 1").toolTipFinisher(new String[0]);
        return tt;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack arg0) {
        return false;
    }

    @Override
    public int getDamageToComponent(ItemStack arg0) {
        return 0;
    }
}

