/*
 * Decompiled with CFR 0.152.
 */
package gtnhlanth.common.beamline;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.enums.Dyes;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaPipeEntity;
import gregtech.common.GTClient;
import gregtech.common.render.GTTextureBuilder;
import gtnhlanth.common.beamline.IConnectsToBeamline;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;

public class MTEBeamlinePipe
extends MetaPipeEntity
implements IConnectsToBeamline {
    private static Textures.BlockIcons.CustomIcon pipe;
    private byte connectionCount = 0;
    private boolean active;

    public MTEBeamlinePipe(int id, String name, String nameRegional) {
        super(id, name, nameRegional, 0);
    }

    public MTEBeamlinePipe(String name) {
        super(name, 0);
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aBaseMetaTileEntity.isServerSide()) {
            if ((aTick & 0x1FL) == 31L) {
                this.mConnections = 0;
                this.connectionCount = 0;
                for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                    IMetaTileEntity meta;
                    ForgeDirection d1 = dir.getOpposite();
                    TileEntity tTileEntity = aBaseMetaTileEntity.getTileEntityAtSide(dir);
                    if (tTileEntity instanceof IConnectsToBeamline) {
                        if (!((IConnectsToBeamline)tTileEntity).canConnect(d1)) continue;
                        this.mConnections = (byte)(this.mConnections | 1 << dir.ordinal());
                        this.connectionCount = (byte)(this.connectionCount + 1);
                        continue;
                    }
                    if (!(tTileEntity instanceof IGregTechTileEntity) || !((meta = ((IGregTechTileEntity)tTileEntity).getMetaTileEntity()) instanceof IConnectsToBeamline) || !((IConnectsToBeamline)meta).canConnect(d1)) continue;
                    this.mConnections = (byte)(this.mConnections | 1 << dir.ordinal());
                    this.connectionCount = (byte)(this.connectionCount + 1);
                }
            }
        } else if (aBaseMetaTileEntity.isClientSide() && GTClient.changeDetected == 4) {
            aBaseMetaTileEntity.issueTextureUpdate();
        }
    }

    @Override
    public byte getTileEntityBaseType() {
        return 7;
    }

    @Override
    public void loadNBTData(NBTTagCompound arg0) {
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity arg0) {
        return new MTEBeamlinePipe(this.mName);
    }

    @Override
    public void saveNBTData(NBTTagCompound arg0) {
    }

    @Override
    public float getCollisionThickness() {
        return 0.5f;
    }

    @Override
    public boolean renderInside(ForgeDirection arg0) {
        return false;
    }

    @Override
    public boolean canConnect(ForgeDirection side) {
        return true;
    }

    @Override
    public IConnectsToBeamline getNext(IConnectsToBeamline source) {
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister aBlockIconRegister) {
        pipe = new Textures.BlockIcons.CustomIcon("iconsets/pipe");
        super.registerIcons(aBlockIconRegister);
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection aSide, int aConnections, int aColorIndex, boolean aConnected, boolean aRedstone) {
        return new ITexture[]{new GTTextureBuilder().addIcon(pipe).build(), new GTTextureBuilder().addIcon(pipe).setRGBA(Dyes.getModulation((byte)aColorIndex, Dyes.MACHINE_METAL.getRGBA())).build()};
    }

    public void markUsed() {
        this.active = true;
    }

    @Override
    public boolean isDataInputFacing(ForgeDirection side) {
        return true;
    }

    @Override
    public String[] getDescription() {
        return new String[]{StatCollector.func_74838_a((String)"beamline.pipe.desc.0"), EnumChatFormatting.AQUA + StatCollector.func_74838_a((String)"beamline.pipe.desc.1"), "Added by " + EnumChatFormatting.GREEN + "GTNH: Lanthanides"};
    }

    @Override
    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return false;
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return false;
    }
}

