/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.production;

import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.TAE;
import gregtech.api.enums.TierEU;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.recipe.check.SimpleCheckRecipeResult;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.common.config.MachineStats;
import gregtech.common.pollution.PollutionConfig;
import gtPlusPlus.api.recipe.GTPPRecipeMaps;
import gtPlusPlus.core.block.ModBlocks;
import gtPlusPlus.core.util.minecraft.PlayerUtils;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.GTPPMultiBlockBase;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class MTEMassFabricator
extends GTPPMultiBlockBase<MTEMassFabricator>
implements ISurvivalConstructable {
    public static int sUUAperUUM = 1;
    public static int sUUASpeedBonus = 4;
    public static int sDurationMultiplier = 3200;
    public static String mCasingName1 = "Matter Fabricator Casing";
    public static String mCasingName2 = "Containment Casing";
    public static String mCasingName3 = "Matter Generation Coil";
    private int mMode = 0;
    private static final int MODE_SCRAP = 1;
    private static final int MODE_UU = 0;
    public static boolean sRequiresUUA = false;
    private static final FluidStack[] mUU = new FluidStack[2];
    private static final ItemStack[] mScrap = new ItemStack[2];
    private int mCasing;
    private static IStructureDefinition<MTEMassFabricator> STRUCTURE_DEFINITION = null;
    public static boolean sInit = false;

    public MTEMassFabricator(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public MTEMassFabricator(String aName) {
        super(aName);
    }

    @Override
    public String getMachineType() {
        return "Mass Fabricator, Recycler";
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType(this.getMachineType()).addInfo("Speed: +0% | EU Usage: 80%").addInfo("Parallel: Scrap = 64 | UU = 8 * Tier").addInfo(StatCollector.func_74838_a((String)"GT5U.machines.perfectoc.tooltip")).addInfo("Produces UU-A, UU-M & Scrap").addInfo("Change mode with screwdriver").addPollutionAmount(this.getPollutionPerSecond(null)).beginStructureBlock(5, 4, 5, true).addController("Front Center").addCasingInfoMin(mCasingName3, 9, false).addCasingInfoMin(mCasingName2, 24, false).addCasingInfoMin(mCasingName1, 36, false).addInputBus("Any Casing", 1).addOutputBus("Any Casing", 1).addInputHatch("Any Casing", 1).addOutputHatch("Any Casing", 1).addEnergyHatch("Any Casing", 1).addMaintenanceHatch("Any Casing", 1).addMufflerHatch("Any Casing", 1).toolTipFinisher(new String[0]);
        return tt;
    }

    @Override
    protected IIconContainer getActiveOverlay() {
        return TexturesGtBlock.Overlay_MatterFab_Active_Animated;
    }

    @Override
    protected IIconContainer getActiveGlowOverlay() {
        return TexturesGtBlock.Overlay_MatterFab_Active_Animated_Glow;
    }

    @Override
    protected IIconContainer getInactiveOverlay() {
        return TexturesGtBlock.Overlay_MatterFab_Animated;
    }

    @Override
    protected IIconContainer getInactiveGlowOverlay() {
        return TexturesGtBlock.Overlay_MatterFab_Animated_Glow;
    }

    @Override
    protected int getCasingTextureId() {
        return TAE.GTPP_INDEX(9);
    }

    @Override
    public void onConfigLoad() {
        super.onConfigLoad();
        sDurationMultiplier = MachineStats.massFabricator.durationMultiplier;
        sUUAperUUM = MachineStats.massFabricator.UUAPerUUM;
        sUUASpeedBonus = MachineStats.massFabricator.UUASpeedBonus;
        sRequiresUUA = MachineStats.massFabricator.requiresUUA;
    }

    public static void init() {
        if (!sInit) {
            if (mScrap[0] == null) {
                MTEMassFabricator.mScrap[0] = ItemList.IC2_Scrap.get(1L, new Object[0]);
            }
            if (mScrap[1] == null) {
                MTEMassFabricator.mScrap[1] = ItemList.IC2_Scrapbox.get(1L, new Object[0]);
            }
            if (mUU[0] == null) {
                MTEMassFabricator.mUU[0] = Materials.UUAmplifier.getFluid(100L);
            }
            if (mUU[1] == null) {
                MTEMassFabricator.mUU[1] = Materials.UUMatter.getFluid(100L);
            }
            sInit = true;
        }
    }

    @Override
    public IStructureDefinition<MTEMassFabricator> getStructureDefinition() {
        if (STRUCTURE_DEFINITION == null) {
            STRUCTURE_DEFINITION = StructureDefinition.builder().addShape(this.mName, StructureUtility.transpose((String[][])new String[][]{{"CCCCC", "CCCCC", "CCCCC", "CCCCC", "CCCCC"}, {"CGGGC", "G---G", "G---G", "G---G", "CGGGC"}, {"CGGGC", "G---G", "G---G", "G---G", "CGGGC"}, {"CC~CC", "CHHHC", "CHHHC", "CHHHC", "CCCCC"}})).addElement('C', GTStructureUtility.buildHatchAdder(MTEMassFabricator.class).atLeast(HatchElement.InputBus, HatchElement.OutputBus, HatchElement.InputHatch, HatchElement.OutputHatch, HatchElement.Maintenance, HatchElement.Energy, HatchElement.Muffler).casingIndex(TAE.GTPP_INDEX(9)).dot(1).buildAndChain(StructureUtility.onElementPass(x -> ++x.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)ModBlocks.blockCasingsMisc, (int)9)))).addElement('H', StructureUtility.ofBlock((Block)ModBlocks.blockCasingsMisc, (int)8)).addElement('G', StructureUtility.ofBlock((Block)ModBlocks.blockCasings3Misc, (int)15)).build();
        }
        return STRUCTURE_DEFINITION;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(this.mName, stackSize, hintsOnly, 2, 3, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivialBuildPiece(this.mName, stackSize, 2, 3, 0, elementBudget, env, false, true);
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.mCasing = 0;
        return this.checkPiece(this.mName, 2, 3, 0) && this.mCasing >= 36 && this.checkHatch();
    }

    @Override
    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    @Override
    public int getPollutionPerSecond(ItemStack aStack) {
        return PollutionConfig.pollutionPerSecondMultiMassFabricator;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEMassFabricator(this.mName);
    }

    @Override
    public RecipeMap<?> getRecipeMap() {
        return this.mMode == 1 ? RecipeMaps.recyclerRecipes : GTPPRecipeMaps.multiblockMassFabricatorRecipes;
    }

    @Override
    @Nonnull
    public Collection<RecipeMap<?>> getAvailableRecipeMaps() {
        return Arrays.asList(RecipeMaps.recyclerRecipes, GTPPRecipeMaps.multiblockMassFabricatorRecipes);
    }

    @Override
    protected ProcessingLogic createProcessingLogic() {
        return new ProcessingLogic(){

            @Override
            @NotNull
            public CheckRecipeResult process() {
                MTEMassFabricator.init();
                return super.process();
            }

            @Override
            @NotNull
            protected CheckRecipeResult validateRecipe(@NotNull GTRecipe recipe) {
                if (MTEMassFabricator.this.mMode == 1 && recipe.mOutputs == null) {
                    return SimpleCheckRecipeResult.ofSuccess("no_scrap");
                }
                return CheckRecipeResultRegistry.SUCCESSFUL;
            }

            @Override
            @Nonnull
            protected Stream<GTRecipe> findRecipeMatches(@Nullable RecipeMap<?> map) {
                if (MTEMassFabricator.this.mMode == 1) {
                    if (this.inputItems != null) {
                        for (ItemStack item : this.inputItems) {
                            ItemStack[] itemStackArray;
                            if (item == null || item.field_77994_a == 0) continue;
                            ItemStack aPotentialOutput = GTModHandler.getRecyclerOutput(GTUtility.copyAmount(1, item), 0);
                            ItemStack[] itemStackArray2 = new ItemStack[]{GTUtility.copyAmount(1, item)};
                            if (aPotentialOutput == null) {
                                itemStackArray = null;
                            } else {
                                ItemStack[] itemStackArray3 = new ItemStack[1];
                                itemStackArray = itemStackArray3;
                                itemStackArray3[0] = aPotentialOutput;
                            }
                            GTRecipe recipe = new GTRecipe(false, itemStackArray2, itemStackArray, null, new int[]{2000}, null, null, 40, (int)TierEU.RECIPE_LV, 0);
                            return Stream.of(recipe);
                        }
                    }
                    return Stream.empty();
                }
                return super.findRecipeMatches(map);
            }
        }.setEuModifier(0.8f).setMaxParallelSupplier(this::getTrueParallel);
    }

    @Override
    protected void setupProcessingLogic(ProcessingLogic logic) {
        super.setupProcessingLogic(logic);
        logic.enablePerfectOverclock();
    }

    @Override
    public int getMaxParallelRecipes() {
        return this.mMode == 1 ? 64 : 8 * Math.max(1, GTUtility.getTier(this.getMaxInputVoltage()));
    }

    @Override
    public void onModeChangeByScrewdriver(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        int aMode = this.mMode + 1;
        if (aMode > 1) {
            this.mMode = 0;
            PlayerUtils.messagePlayer(aPlayer, "Mode [" + this.mMode + "]: Matter/AmpliFabricator");
        } else if (aMode == 1) {
            this.mMode = 1;
            PlayerUtils.messagePlayer(aPlayer, "Mode [" + this.mMode + "]: Recycler");
        } else {
            this.mMode = 1;
            PlayerUtils.messagePlayer(aPlayer, "Mode [" + this.mMode + "]: Recycler");
        }
        this.mLastRecipe = null;
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.func_74768_a("mMode", this.mMode);
        super.saveNBTData(aNBT);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        this.mMode = aNBT.func_74762_e("mMode");
        super.loadNBTData(aNBT);
    }

    @Override
    public void getWailaNBTData(EntityPlayerMP player, TileEntity tile, NBTTagCompound tag, World world, int x, int y, int z) {
        super.getWailaNBTData(player, tile, tag, world, x, y, z);
        tag.func_74768_a("mode", this.mMode);
    }

    @Override
    public void getWailaBody(ItemStack itemStack, List<String> currentTip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.getWailaBody(itemStack, currentTip, accessor, config);
        NBTTagCompound tag = accessor.getNBTData();
        currentTip.add(StatCollector.func_74838_a((String)"GT5U.machines.oreprocessor1") + " " + EnumChatFormatting.WHITE + StatCollector.func_74838_a((String)("GT5U.GTPP_MULTI_MASS_FABRICATOR.mode." + tag.func_74762_e("mode"))) + EnumChatFormatting.RESET);
    }
}

