/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.processing.steam;

import com.google.common.collect.ImmutableList;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.SoundResource;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.metatileentity.implementations.MTEHatch;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.api.util.OverclockCalculator;
import gregtech.common.blocks.BlockCasings1;
import gregtech.common.blocks.BlockCasings2;
import gtPlusPlus.api.recipe.GTPPRecipeMaps;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.MTESteamMultiBase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class MTESteamRockBreaker
extends MTESteamMultiBase<MTESteamRockBreaker>
implements ISurvivalConstructable {
    private static final String STRUCTURE_PIECE_MAIN = "main";
    private static final String STRUCTURE_PIECE_MAIN_SURVIVAL = "main_survival";
    private IStructureDefinition<MTESteamRockBreaker> STRUCTURE_DEFINITION = null;
    private static final int HORIZONTAL_OFF_SET = 5;
    private static final int VERTICAL_OFF_SET = 4;
    private static final int DEPTH_OFF_SET = 0;
    private int mCounCasing = 0;
    private int tierMachine = 0;
    private int tierMachineCasing = -1;
    private final String[][] shape = new String[][]{{"           ", "           ", "           ", "           ", "     E     ", "    EEE    ", "     E     ", "           ", "           ", "           ", "           "}, {"           ", "           ", "           ", "           ", "     E     ", "    E E    ", "     E     ", "           ", "           ", "           ", "           "}, {"           ", "   C   C   ", "   C   C   ", " CCD   DCC ", "     E     ", "    E E    ", "     E     ", " CCD   DCC ", "   C   C   ", "   C   C   ", "           "}, {"   C   C   ", "           ", "           ", "C  D   D  C", "     E     ", "    E E    ", "     E     ", "C  D   D  C", "           ", "           ", "   C   C   "}, {" CCCC~CCCC ", "CFFFFCFFFFC", "CFFFGEGFFFC", "CFFGEEEGFFC", "CFGEEEEEGFC", " CEEEEEEEC ", "CFGEEEEEGFC", "CFFGEEEGFFC", "CFFFGEGFFFC", "CFFFFCFFFFC", " CCCC CCCC "}, {"CCCCCCCCCCC", "CAAAACAAAAC", "CACCCCCCCAC", "CACBBBBBCAC", "CACBBBBBCAC", "CCCBBBBBCCC", "CACBBBBBCAC", "CACBBBBBCAC", "CACCCCCCCAC", "CAAAACAAAAC", "CCCCCCCCCCC"}};
    private int tierPipeCasing = -1;

    public MTESteamRockBreaker(String aName) {
        super(aName);
    }

    public MTESteamRockBreaker(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity arg0) {
        return new MTESteamRockBreaker(this.mName);
    }

    @Override
    public String getMachineType() {
        return "Rock Breaker";
    }

    public int getTierMachineCasing(Block block, int meta) {
        if (block == GregTechAPI.sBlockCasings1 && 10 == meta) {
            ++this.mCounCasing;
            return 1;
        }
        if (block == GregTechAPI.sBlockCasings2 && 0 == meta) {
            ++this.mCounCasing;
            return 2;
        }
        return 0;
    }

    public int getTierPipeCasing(Block block, int meta) {
        if (block == GregTechAPI.sBlockCasings2 && 12 == meta) {
            return 1;
        }
        if (block == GregTechAPI.sBlockCasings2 && 13 == meta) {
            return 2;
        }
        return 0;
    }

    protected void updateHatchTexture() {
        for (MTEHatch h : this.mSteamInputs) {
            h.updateTexture(this.getCasingTextureID());
        }
        for (MTEHatch h : this.mSteamOutputs) {
            h.updateTexture(this.getCasingTextureID());
        }
        for (MTEHatch h : this.mSteamInputFluids) {
            h.updateTexture(this.getCasingTextureID());
        }
    }

    private int getCasingTextureID() {
        if (this.tierMachineCasing == 2) {
            return ((BlockCasings2)GregTechAPI.sBlockCasings2).getTextureIndex(0);
        }
        return ((BlockCasings1)GregTechAPI.sBlockCasings1).getTextureIndex(10);
    }

    @Override
    public void onValueUpdate(byte aValue) {
        this.tierMachineCasing = aValue;
    }

    @Override
    public byte getUpdateData() {
        return (byte)this.tierMachineCasing;
    }

    @Override
    protected ITexture getFrontOverlay() {
        return TextureFactory.of(Textures.BlockIcons.OVERLAY_TOP_STEAM_MACERATOR);
    }

    @Override
    protected ITexture getFrontOverlayActive() {
        return TextureFactory.of(Textures.BlockIcons.OVERLAY_TOP_STEAM_MACERATOR_ACTIVE);
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int aColorIndex, boolean aActive, boolean aRedstone) {
        if (side == facing) {
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(this.getCasingTextureID()), aActive ? this.getFrontOverlayActive() : this.getFrontOverlay()};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(this.getCasingTextureID())};
    }

    @Override
    public IStructureDefinition<MTESteamRockBreaker> getStructureDefinition() {
        if (this.STRUCTURE_DEFINITION == null) {
            this.STRUCTURE_DEFINITION = StructureDefinition.builder().addShape(STRUCTURE_PIECE_MAIN, StructureUtility.transpose((String[][])this.shape)).addShape(STRUCTURE_PIECE_MAIN_SURVIVAL, (String[][])Arrays.stream(StructureUtility.transpose((String[][])this.shape)).map(sa -> (String[])Arrays.stream(sa).map(s -> s.replaceAll("F", " ")).map(s -> s.replaceAll("E", " ")).toArray(String[]::new)).toArray(x$0 -> new String[x$0][])).addElement('C', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{MTESteamRockBreaker.buildSteamInput(MTESteamRockBreaker.class).casingIndex(10).dot(1).build(), GTStructureUtility.buildHatchAdder(MTESteamRockBreaker.class).atLeast(MTESteamMultiBase.SteamHatchElement.InputBus_Steam, MTESteamMultiBase.SteamHatchElement.OutputBus_Steam).casingIndex(10).dot(1).buildAndChain(new IStructureElement[0]), StructureUtility.ofBlocksTiered(this::getTierMachineCasing, (List)ImmutableList.of((Object)Pair.of((Object)GregTechAPI.sBlockCasings1, (Object)10), (Object)Pair.of((Object)GregTechAPI.sBlockCasings2, (Object)0)), (Object)-1, (t, m) -> {
                t.tierMachineCasing = m;
            }, t -> t.tierMachineCasing)})).addElement('A', StructureUtility.ofBlocksTiered(this::getTierPipeCasing, (List)ImmutableList.of((Object)Pair.of((Object)GregTechAPI.sBlockCasings2, (Object)12), (Object)Pair.of((Object)GregTechAPI.sBlockCasings2, (Object)13)), (Object)-1, (t, m) -> {
                t.tierPipeCasing = m;
            }, t -> t.tierPipeCasing)).addElement('B', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings4, (int)15)).addElement('D', StructureUtility.ofBlock((Block)Blocks.field_150339_S, (int)0)).addElement('F', GTStructureUtility.ofAnyWater(true)).addElement('E', GTStructureUtility.ofAnyLava(true)).addElement('G', StructureUtility.ofBlock((Block)Blocks.field_150347_e, (int)0)).build();
        }
        return this.STRUCTURE_DEFINITION;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(STRUCTURE_PIECE_MAIN, stackSize, hintsOnly, 5, 4, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        int built = this.survivialBuildPiece(STRUCTURE_PIECE_MAIN_SURVIVAL, stackSize, 5, 4, 0, elementBudget, env, true);
        if (built == -1) {
            GTUtility.sendChatToPlayer(env.getActor(), EnumChatFormatting.GOLD + "Auto placing done ! Now go place the water and lava by yourself !");
            return 0;
        }
        return built;
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.tierPipeCasing = -1;
        this.tierMachineCasing = -1;
        this.mCounCasing = 0;
        if (!this.checkPiece(STRUCTURE_PIECE_MAIN, 5, 4, 0)) {
            return false;
        }
        if (this.tierPipeCasing < 0 && this.tierMachineCasing < 0) {
            return false;
        }
        if (this.tierPipeCasing == 1 && this.tierMachineCasing == 1 && this.mCounCasing >= 14 && this.checkHatches()) {
            this.updateHatchTexture();
            this.tierMachine = 1;
            return true;
        }
        if (this.tierPipeCasing == 2 && this.tierMachineCasing == 2 && this.mCounCasing >= 14 && this.checkHatches()) {
            this.updateHatchTexture();
            this.tierMachine = 2;
            return true;
        }
        return false;
    }

    private boolean checkHatches() {
        return !this.mSteamInputFluids.isEmpty() && !this.mSteamInputs.isEmpty() && !this.mSteamOutputs.isEmpty() && this.mOutputHatches.isEmpty() && this.mInputHatches.isEmpty();
    }

    @Override
    public int getMaxParallelRecipes() {
        return 8;
    }

    @Override
    public RecipeMap<?> getRecipeMap() {
        return GTPPRecipeMaps.multiblockRockBreakerRecipes;
    }

    @Override
    protected ProcessingLogic createProcessingLogic() {
        return new ProcessingLogic(){

            @Override
            @Nonnull
            protected CheckRecipeResult validateRecipe(@Nonnull GTRecipe recipe) {
                if (this.availableVoltage < (long)recipe.mEUt) {
                    return CheckRecipeResultRegistry.insufficientPower(recipe.mEUt);
                }
                return CheckRecipeResultRegistry.SUCCESSFUL;
            }

            @Override
            @Nonnull
            protected OverclockCalculator createOverclockCalculator(@NotNull GTRecipe recipe) {
                return OverclockCalculator.ofNoOverclock(recipe).setEUtDiscount(1.25 * (double)MTESteamRockBreaker.this.tierMachine).setDurationModifier(1.6 / (double)MTESteamRockBreaker.this.tierMachine);
            }
        }.setMaxParallelSupplier(this::getTrueParallel);
    }

    @Override
    public int getTierRecipes() {
        return 1;
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType(this.getMachineType()).addInfo("Works as a Rock Breaker, but big").addInfo("Cog 1 = Cobblestone, Cog 2 = Stone, Cog 3 = Obsidian").addInfo("Processes up to 8 recipes at once").addInfo(EnumChatFormatting.AQUA + "" + EnumChatFormatting.ITALIC + "STOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOONE").addInfo(EnumChatFormatting.AQUA + "" + EnumChatFormatting.ITALIC + "Keep an eye for Wallsharing :>").addInfo("Processing Speed & Steam Consumption is doubled under High Pressure").toolTipFinisher(new String[0]);
        return tt;
    }

    @Override
    public String[] getInfoData() {
        ArrayList<String> info = new ArrayList<String>(Arrays.asList(super.getInfoData()));
        info.add("Machine Tier: " + EnumChatFormatting.YELLOW + this.tierMachine);
        info.add("Parallel: " + EnumChatFormatting.YELLOW + this.getTrueParallel());
        return info.toArray(new String[0]);
    }

    @Override
    public void getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.getWailaBody(itemStack, currenttip, accessor, config);
        NBTTagCompound tag = accessor.getNBTData();
        currenttip.add(StatCollector.func_74838_a((String)"GTPP.machines.tier") + ": " + EnumChatFormatting.YELLOW + MTESteamRockBreaker.getSteamTierTextForWaila(tag) + EnumChatFormatting.RESET);
        currenttip.add(StatCollector.func_74838_a((String)"GT5U.multiblock.curparallelism") + ": " + EnumChatFormatting.BLUE + tag.func_74762_e("parallel") + EnumChatFormatting.RESET);
    }

    @Override
    public void getWailaNBTData(EntityPlayerMP player, TileEntity tile, NBTTagCompound tag, World world, int x, int y, int z) {
        super.getWailaNBTData(player, tile, tag, world, x, y, z);
        tag.func_74768_a("tierMachine", this.tierMachine);
        tag.func_74768_a("parallel", this.getTrueParallel());
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74768_a("tierMachine", this.tierMachine);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.tierMachine = aNBT.func_74762_e("tierMachine");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected SoundResource getActivitySoundLoop() {
        return SoundResource.IC2_MACHINES_ELECTROFURNACE_LOOP;
    }
}

