/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.processing.steam;

import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.api.util.OverclockCalculator;
import gregtech.common.blocks.BlockCasingsSteam;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.MTEBetterSteamMultiBase;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.NotNull;

public class MTESteamMultiSmelter
extends MTEBetterSteamMultiBase<MTESteamMultiSmelter>
implements ISurvivalConstructable {
    private static final String STRUCTURE_PIECE_MAIN = "main";
    private static final IStructureDefinition<MTESteamMultiSmelter> STRUCTURE_DEFINITION = StructureDefinition.builder().addShape("main", StructureUtility.transpose((String[][])new String[][]{{"ccc", "ccc", "ccc"}, {"CCC", "C-C", "CCC"}, {"c~c", "ccc", "ccc"}})).addElement('c', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{MTESteamMultiSmelter.buildSteamInput(MTESteamMultiSmelter.class).casingIndex(((BlockCasingsSteam)GregTechAPI.sBlockCasingsSteam).getTextureIndex(8)).dot(1).build(), GTStructureUtility.buildHatchAdder(MTESteamMultiSmelter.class).atLeast(MTEBetterSteamMultiBase.SteamHatchElement.InputBus_Steam, MTEBetterSteamMultiBase.SteamHatchElement.OutputBus_Steam).casingIndex(((BlockCasingsSteam)GregTechAPI.sBlockCasingsSteam).getTextureIndex(8)).dot(1).buildAndChain(new IStructureElement[0]), StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasingsSteam, (int)8)})).addElement('C', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasingsSteam, (int)7)).build();

    public MTESteamMultiSmelter(String aName) {
        super(aName);
    }

    public MTESteamMultiSmelter(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    @Override
    protected MTEBetterSteamMultiBase.SteamTypes getSteamType() {
        return MTEBetterSteamMultiBase.SteamTypes.SH_STEAM;
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType(this.getMachineType()).addInfo("Uses " + EnumChatFormatting.GOLD + "Superheated Steam").addInfo("Smelts up to 32 items per 8 seconds").addInfo(EnumChatFormatting.AQUA + "" + EnumChatFormatting.ITALIC + "There is no way you can smelt the thousands of ingots you will need with").addInfo(EnumChatFormatting.AQUA + "" + EnumChatFormatting.ITALIC + "simple stone furnaces or steam ovens... Fortunately, the new metals you have").addInfo(EnumChatFormatting.AQUA + "" + EnumChatFormatting.ITALIC + "invented could easily allow you to meet these demands.").addInfo("Author: " + GTValues.AuthorSteamIsTheNumber).toolTipFinisher(new String[0]);
        return tt;
    }

    @Override
    public String getMachineType() {
        return "Steam Furnace";
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(STRUCTURE_PIECE_MAIN, stackSize, hintsOnly, 1, 2, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivialBuildPiece(STRUCTURE_PIECE_MAIN, stackSize, 1, 2, 0, elementBudget, env, false, true);
    }

    @Override
    public RecipeMap<?> getRecipeMap() {
        return RecipeMaps.furnaceRecipes;
    }

    @Override
    public boolean supportsPowerPanel() {
        return false;
    }

    @Override
    @NotNull
    public CheckRecipeResult checkProcessing() {
        int maxParallel;
        ArrayList<ItemStack> tInputList = this.getStoredInputs();
        if (tInputList.isEmpty()) {
            return CheckRecipeResultRegistry.NO_RECIPE;
        }
        int fakeOriginalMaxParallel = 1;
        OverclockCalculator calculator = new OverclockCalculator().setEUt(this.getAverageInputVoltage()).setAmperage(this.getMaxInputAmps()).setRecipeEUt(30L).setDuration(160).setAmperageOC(false).setParallel(fakeOriginalMaxParallel);
        int originalMaxParallel = maxParallel = 32;
        double tickTimeAfterOC = calculator.calculateDurationUnderOneTick();
        if (tickTimeAfterOC < 1.0) {
            maxParallel = GTUtility.safeInt((long)((double)maxParallel / tickTimeAfterOC), 0);
        }
        int maxParallelBeforeBatchMode = maxParallel;
        if (this.isBatchModeEnabled()) {
            maxParallel = GTUtility.safeInt((long)maxParallel * (long)this.getMaxBatchSize(), 0);
        }
        int currentParallel = 0;
        for (ItemStack item : tInputList) {
            ItemStack smeltedOutput = GTModHandler.getSmeltingOutput(item, false, null);
            if (smeltedOutput == null) continue;
            if (item.field_77994_a <= maxParallel - currentParallel) {
                currentParallel += item.field_77994_a;
                continue;
            }
            currentParallel = maxParallel;
            break;
        }
        if (currentParallel <= 0) {
            return CheckRecipeResultRegistry.NO_RECIPE;
        }
        int currentParallelBeforeBatchMode = Math.min(currentParallel, maxParallelBeforeBatchMode);
        int fakeCurrentParallel = (int)Math.ceil((double)currentParallelBeforeBatchMode / (double)originalMaxParallel);
        calculator.setCurrentParallel(fakeCurrentParallel).calculate();
        double batchMultiplierMax = 1.0;
        if (currentParallel > maxParallelBeforeBatchMode && calculator.getDuration() < this.getMaxBatchSize()) {
            batchMultiplierMax = (double)this.getMaxBatchSize() / (double)calculator.getDuration();
            batchMultiplierMax = Math.min(batchMultiplierMax, (double)currentParallel / (double)maxParallelBeforeBatchMode);
        }
        int finalParallel = (int)(batchMultiplierMax * (double)currentParallelBeforeBatchMode);
        ArrayList<ItemStack> smeltedOutputs = new ArrayList<ItemStack>();
        int remainingCost = finalParallel;
        for (ItemStack item : tInputList) {
            ItemStack smeltedOutput = GTModHandler.getSmeltingOutput(item, false, null);
            if (smeltedOutput == null || remainingCost <= 0) continue;
            if (remainingCost >= item.field_77994_a) {
                remainingCost -= item.field_77994_a;
                smeltedOutput.field_77994_a *= item.field_77994_a;
                item.field_77994_a = 0;
                smeltedOutputs.add(smeltedOutput);
                continue;
            }
            smeltedOutput.field_77994_a *= remainingCost;
            item.field_77994_a -= remainingCost;
            smeltedOutputs.add(smeltedOutput);
            break;
        }
        this.mOutputItems = smeltedOutputs.toArray(new ItemStack[0]);
        this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
        this.mEfficiencyIncrease = 10000;
        this.mMaxProgresstime = (int)((double)calculator.getDuration() * batchMultiplierMax);
        this.lEUt = calculator.getConsumption();
        if (this.lEUt > 0L) {
            this.lEUt = -this.lEUt;
        }
        this.updateSlots();
        return CheckRecipeResultRegistry.SUCCESSFUL;
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int aColorIndex, boolean aActive, boolean aRedstone) {
        ITexture[] rTexture = side == facing ? (aActive ? new ITexture[]{Textures.BlockIcons.getCasingTextureForId(GTUtility.getCasingTextureIndex(GregTechAPI.sBlockCasingsSteam, 8)), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_STEAM_SMELTER_ACTIVE).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_STEAM_SMELTER_ACTIVE).extFacing().glow().build()} : new ITexture[]{Textures.BlockIcons.getCasingTextureForId(GTUtility.getCasingTextureIndex(GregTechAPI.sBlockCasingsSteam, 8)), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_STEAM_SMELTER_INACTIVE).extFacing().build()}) : new ITexture[]{Textures.BlockIcons.getCasingTextureForId(GTUtility.getCasingTextureIndex(GregTechAPI.sBlockCasingsSteam, 8))};
        return rTexture;
    }

    @Override
    public IStructureDefinition<MTESteamMultiSmelter> getStructureDefinition() {
        return STRUCTURE_DEFINITION;
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        return this.checkPiece(STRUCTURE_PIECE_MAIN, 1, 2, 0);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTESteamMultiSmelter(this.mName);
    }
}

