/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.processing.steam;

import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.SoundResource;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.metatileentity.implementations.MTEHatch;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.common.blocks.BlockCasings1;
import gtPlusPlus.core.block.ModBlocks;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.MTEBetterSteamMultiBase;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.NotNull;

public class MTESteamInfernalCokeOven
extends MTEBetterSteamMultiBase<MTESteamInfernalCokeOven>
implements ISurvivalConstructable {
    private float speedup = 1.0f;
    private int runningTickCounter = 0;
    private static final String STRUCTURE_PIECE_MAIN = "main";
    private static final String[][] structure = StructureUtility.transpose((String[][])new String[][]{{"CCCCC", "CCCCC", "CCCCC", "CCCCC", "CCCCC"}, {"AAAAA", "A   A", "A   A", "A   A", "AAAAA"}, {"BBBBB", "B   B", "B   B", "B   B", "BBBBB"}, {"AA~AA", "A   A", "A   A", "A   A", "AAAAA"}, {"CCCCC", "CCCCC", "CCCCC", "CCCCC", "CCCCC"}});
    private static final int HORIZONTAL_OFF_SET = 2;
    private static final int VERTICAL_OFF_SET = 3;
    private static final int DEPTH_OFF_SET = 0;
    private int mCounCasing = 0;

    public MTESteamInfernalCokeOven(String aName) {
        super(aName);
    }

    public MTESteamInfernalCokeOven(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity arg0) {
        return new MTESteamInfernalCokeOven(this.mName);
    }

    @Override
    public String getMachineType() {
        return "Coke Oven";
    }

    @Override
    public IStructureDefinition<MTESteamInfernalCokeOven> getStructureDefinition() {
        return StructureDefinition.builder().addShape(STRUCTURE_PIECE_MAIN, structure).addElement('A', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GTStructureUtility.buildHatchAdder(MTESteamInfernalCokeOven.class).atLeast(MTEBetterSteamMultiBase.SteamHatchElement.InputBus_Steam, MTEBetterSteamMultiBase.SteamHatchElement.OutputBus_Steam, HatchElement.OutputHatch).casingIndex(((BlockCasings1)GregTechAPI.sBlockCasings1).getTextureIndex(10)).dot(1).buildAndChain(new IStructureElement[0]), StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings1, (int)10)})).addElement('B', StructureUtility.ofBlock((Block)ModBlocks.blockCasingsMisc, (int)2)).addElement('C', StructureUtility.ofBlock((Block)Blocks.field_150385_bj, (int)0)).build();
    }

    protected void updateHatchTexture() {
        for (MTEHatch h : this.mSteamInputs) {
            h.updateTexture(this.getCasingTextureID());
        }
        for (MTEHatch h : this.mSteamOutputs) {
            h.updateTexture(this.getCasingTextureID());
        }
        for (MTEHatch h : this.mOutputHatches) {
            h.updateTexture(this.getCasingTextureID());
        }
    }

    private int getCasingTextureID() {
        return ((BlockCasings1)GregTechAPI.sBlockCasings1).getTextureIndex(10);
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity baseMetaTileEntity, ForgeDirection side, ForgeDirection aFacing, int colorIndex, boolean aActive, boolean redstoneLevel) {
        ITexture[] rTexture = side == aFacing ? (aActive ? new ITexture[]{Textures.BlockIcons.getCasingTextureForId(GTUtility.getCasingTextureIndex(GregTechAPI.sBlockCasings1, 10)), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_STEAM_COKE_OVEN_ACTIVE).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_STEAM_COKE_OVEN_ACTIVE_GLOW).extFacing().glow().build()} : new ITexture[]{Textures.BlockIcons.getCasingTextureForId(GTUtility.getCasingTextureIndex(GregTechAPI.sBlockCasings1, 10)), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_STEAM_COKE_OVEN).extFacing().build()}) : new ITexture[]{Textures.BlockIcons.getCasingTextureForId(GTUtility.getCasingTextureIndex(GregTechAPI.sBlockCasings1, 10))};
        return rTexture;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(STRUCTURE_PIECE_MAIN, stackSize, hintsOnly, 2, 3, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        return this.survivialBuildPiece(STRUCTURE_PIECE_MAIN, stackSize, 2, 3, 0, elementBudget, env, false, true);
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        return this.checkPiece(STRUCTURE_PIECE_MAIN, 2, 3, 0);
    }

    @Override
    public boolean onRunningTick(ItemStack aStack) {
        ++this.runningTickCounter;
        if (this.runningTickCounter % 100 == 0 && this.speedup < 7.0f) {
            this.runningTickCounter = 0;
            this.speedup += 0.1f;
        }
        return super.onRunningTick(aStack);
    }

    @Override
    protected ProcessingLogic createProcessingLogic() {
        return new ProcessingLogic(){

            @Override
            @NotNull
            protected CheckRecipeResult validateRecipe(@NotNull GTRecipe recipe) {
                this.setSpeedBonus(1.0f / MTESteamInfernalCokeOven.this.speedup);
                return super.validateRecipe(recipe);
            }
        }.setMaxParallelSupplier(this::getTrueParallel);
    }

    @Override
    public int getMaxParallelRecipes() {
        return 16;
    }

    @Override
    public RecipeMap<?> getRecipeMap() {
        return RecipeMaps.infernalCockRecipes;
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType("Coke Oven").addInfo("Works more efficiently than a clay oven").addInfo("Every 5 seconds of continuous working it gets 1% faster, up to 600%").addInfo(EnumChatFormatting.AQUA + "" + EnumChatFormatting.ITALIC + "Poggers").toolTipFinisher(new String[0]);
        return tt;
    }

    @Override
    public void getWailaNBTData(EntityPlayerMP player, TileEntity tile, NBTTagCompound tag, World world, int x, int y, int z) {
        super.getWailaNBTData(player, tile, tag, world, x, y, z);
    }

    @Override
    public void getWailaBody(ItemStack itemStack, List<String> currentTip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.getWailaBody(itemStack, currentTip, accessor, config);
        NBTTagCompound tag = accessor.getNBTData();
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74776_a("steam", this.speedup);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.speedup = aNBT.func_74760_g("steam");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected SoundResource getActivitySoundLoop() {
        return SoundResource.IC2_MACHINES_MACERATOR_OP;
    }
}

