/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.processing.advanced;

import com.gtnewhorizon.structurelib.alignment.IAlignmentLimits;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.TAE;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.MTEHatch;
import gregtech.api.metatileentity.implementations.MTEHatchInput;
import gregtech.api.metatileentity.implementations.MTEHatchOutput;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.registries.LHECoolantRegistry;
import gregtech.api.util.GTLog;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.common.tileentities.machines.IRecipeProcessingAwareHatch;
import gregtech.common.tileentities.machines.MTEHatchInputME;
import gtPlusPlus.core.block.ModBlocks;
import gtPlusPlus.core.block.base.BasicBlock;
import gtPlusPlus.core.block.base.BlockBaseModular;
import gtPlusPlus.core.material.MaterialsAlloy;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.GTPPMultiBlockBase;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class MTEAdvHeatExchanger
extends GTPPMultiBlockBase<MTEAdvHeatExchanger> {
    private static final int CASING_INDEX = TAE.getIndexFromPage(1, 12);
    private static final String STRUCTURE_PIECE_MAIN = "main";
    private static final IStructureDefinition<MTEAdvHeatExchanger> STRUCTURE_DEFINITION = StructureDefinition.builder().addShape("main", StructureUtility.transpose((String[][])new String[][]{{" ccc ", "cCCCc", "cCCCc", "cCCCc", " ccc "}, {" ccc ", "cPPPc", "cPPPc", "cPPPc", " ccc "}, {" ccc ", "cPPPc", "cPPPc", "cPPPc", " ccc "}, {" ccc ", "cPPPc", "cPPPc", "cPPPc", " ccc "}, {" ccc ", "cPPPc", "cPPPc", "cPPPc", " ccc "}, {" c~c ", "cPPPc", "cPPPc", "cPPPc", " ccc "}, {" hhh ", "hHHHh", "hHHHh", "hHHHh", " hhh "}, {" f f ", "f   f", "     ", "f   f", " f f "}, {" f f ", "f   f", "     ", "f   f", " f f "}})).addElement('P', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings2, (int)15)).addElement('f', StructureUtility.ofBlock((Block)MTEAdvHeatExchanger.getFrame(), (int)0)).addElement('C', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GTStructureUtility.ofHatchAdder(MTEAdvHeatExchanger::addColdFluidOutputToMachineList, CASING_INDEX, 2), StructureUtility.onElementPass(MTEAdvHeatExchanger::onCasingAdded, (IStructureElement)StructureUtility.ofBlock((Block)ModBlocks.blockSpecialMultiCasings, (int)14))})).addElement('H', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GTStructureUtility.ofHatchAdder(MTEAdvHeatExchanger::addHotFluidInputToMachineList, CASING_INDEX, 3), StructureUtility.onElementPass(MTEAdvHeatExchanger::onCasingAdded, (IStructureElement)StructureUtility.ofBlock((Block)ModBlocks.blockSpecialMultiCasings, (int)14))})).addElement('h', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GTStructureUtility.ofHatchAdder(GTPPMultiBlockBase::addInputToMachineList, CASING_INDEX, 1), GTStructureUtility.ofHatchAdder(GTPPMultiBlockBase::addOutputToMachineList, CASING_INDEX, 1), GTStructureUtility.ofHatchAdder(GTPPMultiBlockBase::addMaintenanceToMachineList, CASING_INDEX, 1), StructureUtility.onElementPass(MTEAdvHeatExchanger::onCasingAdded, (IStructureElement)StructureUtility.ofBlock((Block)ModBlocks.blockSpecialMultiCasings, (int)14))})).addElement('c', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{StructureUtility.onElementPass(MTEAdvHeatExchanger::onCasingAdded, (IStructureElement)StructureUtility.ofBlock((Block)ModBlocks.blockSpecialMultiCasings, (int)14))})).build();
    public static float penalty_per_config = 0.015f;
    private MTEHatchInput mInputHotFluidHatch;
    private MTEHatchOutput mOutputColdFluidHatch;
    private boolean superheated = false;
    private int superheated_threshold = 0;
    private float water;
    private int mCasingAmount;
    private static Block sFrame;

    public MTEAdvHeatExchanger(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public MTEAdvHeatExchanger(String aName) {
        super(aName);
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType(this.getMachineType()).addInfo("More complicated than a Fusion Reactor. Seriously").addInfo("But you know this by now, right?").addInfo("Works as fast as 32 Large Heat Exchangers").addSeparator().addInfo("Inputs are Hot Coolant or Lava").addInfo("Outputs Coolant or Pahoehoe Lava and SH Steam/Steam").addInfo("Outputs SH Steam if input flow is equal to or above a certain value:").addInfo("Hot Coolant: 25,600 L/s, maximum 51,200 L/s, max output 10,240,000 SH Steam/s").addInfo("Lava: 32,000 L/s, maximum 64,000 L/s, max output 5,120,000 SH Steam/s").addInfo("A circuit in the controller lowers the SH Steam threshold and efficiency").addInfo("3.75% reduction and 1.5% efficiency loss per circuit config over 1").beginStructureBlock(5, 9, 5, false).addController("Front bottom").addCasingInfoMin("Reinforced Heat Exchanger Casing", 90, false).addOtherStructurePart("Tungstensteel Pipe Casing", "Center 3x5x3 (45 blocks)").addMaintenanceHatch("Any casing", 1).addInputHatch("Hot fluid, bottom center", 2).addInputHatch("Distilled water, any bottom layer casing", 1).addOutputHatch("Cold fluid, top center", 3).addOutputHatch("Steam/SH Steam, any bottom layer casing", 1).toolTipFinisher(new String[0]);
        return tt;
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        this.superheated = aNBT.func_74767_n("superheated");
        super.loadNBTData(aNBT);
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.func_74757_a("superheated", this.superheated);
        super.saveNBTData(aNBT);
    }

    @Override
    public boolean supportsPowerPanel() {
        return false;
    }

    @Override
    protected IIconContainer getActiveOverlay() {
        return TexturesGtBlock.oMCAAdvancedHeatExchangerActive;
    }

    @Override
    protected IIconContainer getActiveGlowOverlay() {
        return TexturesGtBlock.oMCAAdvancedHeatExchangerActiveGlow;
    }

    @Override
    protected IIconContainer getInactiveOverlay() {
        return TexturesGtBlock.oMCAAdvancedHeatExchanger;
    }

    @Override
    protected IIconContainer getInactiveGlowOverlay() {
        return TexturesGtBlock.oMCAAdvancedHeatExchangerGlow;
    }

    @Override
    protected int getCasingTextureId() {
        return CASING_INDEX;
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    @Override
    protected IAlignmentLimits getInitialAlignmentLimits() {
        return (d, r, f) -> !r.isUpsideDown() && !f.isVerticallyFliped();
    }

    @Override
    @NotNull
    public CheckRecipeResult checkProcessing() {
        int circuit_config;
        FluidStack hotFluid = null;
        MTEHatchInput mTEHatchInput = this.mInputHotFluidHatch;
        if (mTEHatchInput instanceof MTEHatchInputME) {
            MTEHatchInputME inputME = (MTEHatchInputME)mTEHatchInput;
            FluidStack[] fluids = inputME.getStoredFluids();
            if (fluids.length > 0) {
                hotFluid = fluids[0];
            }
        } else {
            hotFluid = this.mInputHotFluidHatch.getFluid();
        }
        if (hotFluid == null) {
            return CheckRecipeResultRegistry.SUCCESSFUL;
        }
        int fluidAmountToConsume = hotFluid.amount;
        this.superheated_threshold = 128000;
        float efficiency = 1.0f;
        int shs_reduction_per_config = 4800;
        float steam_output_multiplier = 20.0f;
        float penalty = 0.0f;
        if (this.mInventory[1] != null && this.mInventory[1].func_77977_a().startsWith("gt.integrated_circuit") && (circuit_config = this.mInventory[1].func_77960_j()) >= 1 && circuit_config <= 25) {
            penalty = (float)(circuit_config - 1) * penalty_per_config;
            this.superheated_threshold -= shs_reduction_per_config * (circuit_config - 1);
        }
        efficiency -= penalty;
        LHECoolantRegistry.LHECoolantInfo coolant = LHECoolantRegistry.getCoolant(hotFluid.getFluid());
        if (coolant == null) {
            this.superheated_threshold = 0;
            return CheckRecipeResultRegistry.NO_RECIPE;
        }
        steam_output_multiplier = (float)((double)steam_output_multiplier * coolant.steamMultiplier);
        this.superheated_threshold = (int)((double)this.superheated_threshold * coolant.superheatedThreshold);
        this.superheated = fluidAmountToConsume >= this.superheated_threshold;
        fluidAmountToConsume = Math.min(fluidAmountToConsume, this.superheated_threshold * 2);
        this.mInputHotFluidHatch.drain(ForgeDirection.UNKNOWN, new FluidStack(hotFluid.getFluid(), fluidAmountToConsume), true);
        this.mOutputColdFluidHatch.fill(coolant.getColdFluid(fluidAmountToConsume), true);
        this.mMaxProgresstime = 20;
        this.lEUt = (long)((float)fluidAmountToConsume * steam_output_multiplier * efficiency);
        this.mEfficiencyIncrease = 80;
        return CheckRecipeResultRegistry.SUCCESSFUL;
    }

    private int useWater(float input) {
        this.water += input;
        int usage = (int)this.water;
        this.water -= (float)usage;
        return usage;
    }

    @Override
    public boolean onRunningTick(ItemStack aStack) {
        if (this.lEUt > 0L) {
            int tGeneratedEU = (int)(this.lEUt * 2L * (long)this.mEfficiency / 10000L);
            if (tGeneratedEU > 0) {
                if (this.superheated) {
                    tGeneratedEU /= 2;
                }
                int distilledConsumed = this.useWater((float)tGeneratedEU / 160.0f);
                FluidStack distilledStack = GTModHandler.getDistilledWater(distilledConsumed);
                this.startRecipeProcessing();
                if (this.depleteInput(distilledStack)) {
                    if (this.superheated) {
                        this.addOutput(FluidRegistry.getFluidStack((String)"ic2superheatedsteam", (int)tGeneratedEU));
                    } else {
                        this.addOutput(GTModHandler.getSteam(tGeneratedEU));
                    }
                } else {
                    GTLog.exp.println(this.mName + " had no more Distilled water!");
                    this.explodeMultiblock();
                }
                this.endRecipeProcessing();
            }
            return true;
        }
        return true;
    }

    @Override
    public IStructureDefinition<MTEAdvHeatExchanger> getStructureDefinition() {
        return STRUCTURE_DEFINITION;
    }

    private void onCasingAdded() {
        ++this.mCasingAmount;
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.mOutputColdFluidHatch = null;
        this.mInputHotFluidHatch = null;
        this.mCasingAmount = 0;
        return this.checkPiece(STRUCTURE_PIECE_MAIN, 2, 5, 0) && this.mCasingAmount >= 90 && this.mMaintenanceHatches.size() == 1;
    }

    public boolean addColdFluidOutputToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof MTEHatchOutput) {
            ((MTEHatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            this.mOutputColdFluidHatch = (MTEHatchOutput)aMetaTileEntity;
            return true;
        }
        return false;
    }

    public boolean addHotFluidInputToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof MTEHatchInput) {
            ((MTEHatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            ((MTEHatchInput)aMetaTileEntity).mRecipeMap = this.getRecipeMap();
            this.mInputHotFluidHatch = (MTEHatchInput)aMetaTileEntity;
            return true;
        }
        return false;
    }

    @Override
    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEAdvHeatExchanger(this.mName);
    }

    @Override
    public boolean isGivingInformation() {
        return super.isGivingInformation();
    }

    @Override
    public String[] getExtraInfoData() {
        return new String[]{StatCollector.func_74838_a((String)"GT5U.multiblock.Progress") + ": " + EnumChatFormatting.GREEN + GTUtility.formatNumbers(this.mProgresstime / 20) + EnumChatFormatting.RESET + " s / " + EnumChatFormatting.YELLOW + GTUtility.formatNumbers(this.mMaxProgresstime / 20) + EnumChatFormatting.RESET + " s", StatCollector.func_74838_a((String)"GT5U.multiblock.usage") + " " + StatCollector.func_74838_a((String)"GT5U.LHE.steam") + ": " + (this.superheated ? EnumChatFormatting.RED : EnumChatFormatting.YELLOW) + GTUtility.formatNumbers(this.superheated ? -2L * this.lEUt : -this.lEUt) + EnumChatFormatting.RESET + " EU/t", StatCollector.func_74838_a((String)"GT5U.multiblock.problems") + ": " + EnumChatFormatting.RED + (this.getIdealStatus() - this.getRepairStatus()) + EnumChatFormatting.RESET + " " + StatCollector.func_74838_a((String)"GT5U.multiblock.efficiency") + ": " + EnumChatFormatting.YELLOW + (float)this.mEfficiency / 100.0f + EnumChatFormatting.RESET + " %", StatCollector.func_74838_a((String)"GT5U.LHE.superheated") + ": " + (this.superheated ? EnumChatFormatting.RED : EnumChatFormatting.BLUE) + this.superheated + EnumChatFormatting.RESET, StatCollector.func_74838_a((String)"GT5U.LHE.superheated") + " " + StatCollector.func_74838_a((String)"GT5U.LHE.threshold") + ": " + EnumChatFormatting.GREEN + GTUtility.formatNumbers(this.superheated_threshold) + EnumChatFormatting.RESET};
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(STRUCTURE_PIECE_MAIN, stackSize, hintsOnly, 2, 5, 0);
    }

    @Override
    public String getMachineType() {
        return "Heat Exchanger";
    }

    @Override
    public int getMaxParallelRecipes() {
        return 0;
    }

    public static Block getFrame() {
        if (sFrame == null) {
            sFrame = BlockBaseModular.getMaterialBlock(MaterialsAlloy.TALONITE, BasicBlock.BlockTypes.FRAME);
        }
        return sFrame;
    }

    @Override
    public void startRecipeProcessing() {
        super.startRecipeProcessing();
        MTEHatchInput mTEHatchInput = this.mInputHotFluidHatch;
        if (mTEHatchInput instanceof IRecipeProcessingAwareHatch) {
            IRecipeProcessingAwareHatch aware = (IRecipeProcessingAwareHatch)((Object)mTEHatchInput);
            if (this.mInputHotFluidHatch.isValid()) {
                aware.startRecipeProcessing();
            }
        }
    }

    @Override
    public void endRecipeProcessing() {
        super.endRecipeProcessing();
        MTEHatchInput mTEHatchInput = this.mInputHotFluidHatch;
        if (mTEHatchInput instanceof IRecipeProcessingAwareHatch) {
            IRecipeProcessingAwareHatch aware = (IRecipeProcessingAwareHatch)((Object)mTEHatchInput);
            if (this.mInputHotFluidHatch.isValid()) {
                aware.endRecipeProcessing(this);
            }
        }
    }
}

