/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.processing;

import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.TAE;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.common.pollution.PollutionConfig;
import gtPlusPlus.api.recipe.GTPPRecipeMaps;
import gtPlusPlus.core.block.ModBlocks;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.GTPPMultiBlockBase;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;

public class MTENuclearSaltProcessingPlant
extends GTPPMultiBlockBase<MTENuclearSaltProcessingPlant>
implements ISurvivalConstructable {
    protected GTRecipe lastRecipeToBuffer;
    private int casing;
    private static IStructureDefinition<MTENuclearSaltProcessingPlant> STRUCTURE_DEFINITION = null;

    public MTENuclearSaltProcessingPlant(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public MTENuclearSaltProcessingPlant(String mName) {
        super(mName);
    }

    @Override
    public String getMachineType() {
        return "Reactor Processing Unit, Cold Trap";
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity tileEntity) {
        return new MTENuclearSaltProcessingPlant(this.mName);
    }

    @Override
    public int getMaxEfficiency(ItemStack itemStack) {
        return 10000;
    }

    @Override
    public int getPollutionPerSecond(ItemStack aStack) {
        return PollutionConfig.pollutionPerSecondNuclearSaltProcessingPlant;
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType(this.getMachineType()).addInfo("Processes depleted nuclear salts that come from the LFTR").addInfo("Handles the recipes of the Reactor Processor Unit and Cold Trap").addInfo("Only Thermally Insulated Casings can be replaced with hatches").addInfo("Mufflers on top, Energy Hatches on bottom, exactly 2 of each are required").addInfo("Maintenance Hatch goes on the back, opposite of the controller block").addInfo("Inputs go on the left side of the multi, outputs on the right side").addInfo("150% faster than using single block machines of the same voltage").addInfo("Processes two items per voltage tier").addPollutionAmount(this.getPollutionPerSecond(null)).beginStructureBlock(3, 3, 3, true).addController("Front Center").addCasingInfoMin("IV Machine Casing", 58, false).addCasingInfoMin("Thermally Insulated Casing", 1, false).addInputBus("Left Half", 2).addInputHatch("Left Half", 2).addOutputBus("Right Half", 3).addOutputHatch("Right Half", 3).addMufflerHatch("Top Side, 2 Required", 4).addEnergyHatch("Bottom Side, 2 Required", 5).addMaintenanceHatch("Back Side, Opposite of Controller", 6).toolTipFinisher(new String[0]);
        return tt;
    }

    @Override
    protected IIconContainer getActiveOverlay() {
        return Textures.BlockIcons.OVERLAY_FRONT_DISASSEMBLER_ACTIVE;
    }

    @Override
    protected IIconContainer getActiveGlowOverlay() {
        return Textures.BlockIcons.OVERLAY_FRONT_DISASSEMBLER_ACTIVE_GLOW;
    }

    @Override
    protected IIconContainer getInactiveOverlay() {
        return Textures.BlockIcons.OVERLAY_FRONT_DISASSEMBLER;
    }

    @Override
    protected IIconContainer getInactiveGlowOverlay() {
        return Textures.BlockIcons.OVERLAY_FRONT_DISASSEMBLER_GLOW;
    }

    @Override
    protected int getCasingTextureId() {
        return TAE.getIndexFromPage(0, 10);
    }

    @Override
    public IStructureDefinition<MTENuclearSaltProcessingPlant> getStructureDefinition() {
        if (STRUCTURE_DEFINITION == null) {
            STRUCTURE_DEFINITION = StructureDefinition.builder().addShape(this.mName, StructureUtility.transpose((String[][])new String[][]{{"AAA   AAA", "ADA   ADA", "AAA   AAA"}, {"ABBA ACCA", "B  AAA  C", "ABBA ACCA"}, {"ABBB~CCCA", "B       C", "ABBBFCCCA"}, {"ABBA ACCA", "B  AAA  C", "ABBA ACCA"}, {"AAA   AAA", "AEA   AEA", "AAA   AAA"}})).addElement('A', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings1, (int)5)).addElement('B', GTStructureUtility.buildHatchAdder(MTENuclearSaltProcessingPlant.class).atLeast(HatchElement.InputBus, HatchElement.InputHatch).casingIndex(TAE.getIndexFromPage(0, 10)).dot(2).buildAndChain(StructureUtility.onElementPass(x -> ++x.casing, (IStructureElement)StructureUtility.ofBlock((Block)ModBlocks.blockSpecialMultiCasings, (int)8)))).addElement('C', GTStructureUtility.buildHatchAdder(MTENuclearSaltProcessingPlant.class).atLeast(HatchElement.OutputBus, HatchElement.OutputHatch).casingIndex(TAE.getIndexFromPage(0, 10)).dot(3).buildAndChain(StructureUtility.onElementPass(x -> ++x.casing, (IStructureElement)StructureUtility.ofBlock((Block)ModBlocks.blockSpecialMultiCasings, (int)8)))).addElement('D', GTStructureUtility.buildHatchAdder(MTENuclearSaltProcessingPlant.class).atLeast(HatchElement.Muffler).casingIndex(TAE.getIndexFromPage(0, 10)).dot(4).buildAndChain(StructureUtility.onElementPass(x -> ++x.casing, (IStructureElement)StructureUtility.ofBlock((Block)ModBlocks.blockSpecialMultiCasings, (int)8)))).addElement('E', GTStructureUtility.buildHatchAdder(MTENuclearSaltProcessingPlant.class).atLeast(HatchElement.Energy).casingIndex(TAE.getIndexFromPage(0, 10)).dot(5).buildAndChain(StructureUtility.onElementPass(x -> ++x.casing, (IStructureElement)StructureUtility.ofBlock((Block)ModBlocks.blockSpecialMultiCasings, (int)8)))).addElement('F', GTStructureUtility.buildHatchAdder(MTENuclearSaltProcessingPlant.class).atLeast(HatchElement.Maintenance).casingIndex(TAE.getIndexFromPage(0, 10)).dot(6).buildAndChain(StructureUtility.onElementPass(x -> ++x.casing, (IStructureElement)StructureUtility.ofBlock((Block)ModBlocks.blockSpecialMultiCasings, (int)8)))).build();
        }
        return STRUCTURE_DEFINITION;
    }

    public void construct(ItemStack itemStack, boolean hintsOnly) {
        this.buildPiece(this.mName, itemStack, hintsOnly, 4, 2, 0);
    }

    public int survivalConstruct(ItemStack itemStack, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivialBuildPiece(this.mName, itemStack, 4, 2, 0, elementBudget, env, false, true);
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity baseMetaTileEntity, ItemStack itemStack) {
        this.casing = 0;
        return this.checkPiece(this.mName, 4, 2, 0) && this.checkHatch();
    }

    @Override
    public boolean checkHatch() {
        return this.mEnergyHatches.size() == 2 && this.mMufflerHatches.size() == 2 && super.checkHatch();
    }

    @Override
    public RecipeMap<?> getRecipeMap() {
        return GTPPRecipeMaps.nuclearSaltProcessingPlantRecipes;
    }

    @Override
    protected ProcessingLogic createProcessingLogic() {
        return new ProcessingLogic().setSpeedBonus(0.4f).setMaxParallelSupplier(this::getTrueParallel);
    }

    @Override
    public int getMaxParallelRecipes() {
        return 2 * Math.max(1, GTUtility.getTier(this.getMaxInputVoltage()));
    }

    @Override
    public String[] getExtraInfoData() {
        String running = this.mMaxProgresstime > 0 ? "Salt Plant running" : "Salt Plant stopped";
        String maintenance = this.getIdealStatus() == this.getRepairStatus() ? "No Maintenance issues" : "Needs Maintenance";
        String tSpecialText = this.lastRecipeToBuffer != null && this.lastRecipeToBuffer.mOutputs[0].func_82833_r() != null ? "Currently processing: " + this.lastRecipeToBuffer.mOutputs[0].func_82833_r() : "Currently processing: Nothing";
        return new String[]{"Nuclear Salt Processing Plant", running, maintenance, tSpecialText};
    }

    @Override
    public boolean supportsInputSeparation() {
        return true;
    }
}

