/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.processing;

import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.SoundResource;
import gregtech.api.enums.TAE;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.common.pollution.PollutionConfig;
import gtPlusPlus.core.block.ModBlocks;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.GTPPMultiBlockBase;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;

public class MTEIndustrialSifter
extends GTPPMultiBlockBase<MTEIndustrialSifter>
implements ISurvivalConstructable {
    private int mCasing;
    private static IStructureDefinition<MTEIndustrialSifter> STRUCTURE_DEFINITION = null;

    public MTEIndustrialSifter(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public MTEIndustrialSifter(String aName) {
        super(aName);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEIndustrialSifter(this.mName);
    }

    @Override
    public String getMachineType() {
        return "Sifter";
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType(this.getMachineType()).addInfo("400% faster than single-block machines of the same voltage").addInfo("Only uses 75% of the EU/t normally required").addInfo("Processes four items per voltage tier").addPollutionAmount(this.getPollutionPerSecond(null)).beginStructureBlock(5, 3, 5, false).addController("Bottom Center").addCasingInfoMin("Sieve Grate", 18, false).addCasingInfoMin("Sieve Casings", 35, false).addInputBus("Any Casing", 1).addOutputBus("Any Casing", 1).addInputHatch("Any Casing", 1).addOutputHatch("Any Casing", 1).addEnergyHatch("Any Casing", 1).addMaintenanceHatch("Any Casing", 1).addMufflerHatch("Any Casing", 1).toolTipFinisher(new String[0]);
        return tt;
    }

    @Override
    public IStructureDefinition<MTEIndustrialSifter> getStructureDefinition() {
        if (STRUCTURE_DEFINITION == null) {
            STRUCTURE_DEFINITION = StructureDefinition.builder().addShape(this.mName, StructureUtility.transpose((String[][])new String[][]{{"CCCCC", "CMMMC", "CMMMC", "CMMMC", "CCCCC"}, {"CCCCC", "CMMMC", "CMMMC", "CMMMC", "CCCCC"}, {"CC~CC", "CCCCC", "CCCCC", "CCCCC", "CCCCC"}})).addElement('C', GTStructureUtility.buildHatchAdder(MTEIndustrialSifter.class).atLeast(HatchElement.InputBus, HatchElement.OutputBus, HatchElement.Maintenance, HatchElement.Energy, HatchElement.Muffler, HatchElement.InputHatch, HatchElement.OutputHatch).casingIndex(TAE.GTPP_INDEX(21)).dot(1).buildAndChain(StructureUtility.onElementPass(x -> ++x.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)ModBlocks.blockCasings2Misc, (int)5)))).addElement('M', StructureUtility.ofBlock((Block)ModBlocks.blockCasings2Misc, (int)6)).build();
        }
        return STRUCTURE_DEFINITION;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(this.mName, stackSize, hintsOnly, 2, 2, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivialBuildPiece(this.mName, stackSize, 2, 2, 0, elementBudget, env, false, true);
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.mCasing = 0;
        return this.checkPiece(this.mName, 2, 2, 0) && this.mCasing >= 35 && this.checkHatch();
    }

    @Override
    protected IIconContainer getActiveOverlay() {
        return TexturesGtBlock.oMCDIndustrialSifterActive;
    }

    @Override
    protected IIconContainer getActiveGlowOverlay() {
        return TexturesGtBlock.oMCDIndustrialSifterActiveGlow;
    }

    @Override
    protected IIconContainer getInactiveOverlay() {
        return TexturesGtBlock.oMCDIndustrialSifter;
    }

    @Override
    protected IIconContainer getInactiveGlowOverlay() {
        return TexturesGtBlock.oMCDIndustrialSifterGlow;
    }

    @Override
    protected int getCasingTextureId() {
        return TAE.GTPP_INDEX(21);
    }

    @Override
    public RecipeMap<?> getRecipeMap() {
        return RecipeMaps.sifterRecipes;
    }

    @Override
    public int getRecipeCatalystPriority() {
        return -1;
    }

    @Override
    public void onPreTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPreTick(aBaseMetaTileEntity, aTick);
        if (aBaseMetaTileEntity.isClientSide() && aBaseMetaTileEntity.isActive() && aBaseMetaTileEntity.getFrontFacing() != ForgeDirection.UP && !aBaseMetaTileEntity.hasCoverAtSide(ForgeDirection.UP) && !aBaseMetaTileEntity.getOpacityAtSide(ForgeDirection.UP)) {
            Random tRandom = aBaseMetaTileEntity.getWorld().field_73012_v;
            if ((double)tRandom.nextFloat() > 0.4) {
                return;
            }
            int xDir = aBaseMetaTileEntity.getBackFacing().offsetX * 2;
            int zDir = aBaseMetaTileEntity.getBackFacing().offsetZ * 2;
            aBaseMetaTileEntity.getWorld().func_72869_a("smoke", (double)((float)(aBaseMetaTileEntity.getXCoord() + xDir) + 2.1f - tRandom.nextFloat() * 3.2f), (double)((float)aBaseMetaTileEntity.getYCoord() + 2.5f + tRandom.nextFloat() * 1.2f), (double)((float)(aBaseMetaTileEntity.getZCoord() + zDir) + 2.1f - tRandom.nextFloat() * 3.2f), 0.0, 0.0, 0.0);
        }
    }

    @Override
    protected ProcessingLogic createProcessingLogic() {
        return new ProcessingLogic().setSpeedBonus(0.2f).setEuModifier(0.75).setMaxParallelSupplier(this::getTrueParallel);
    }

    @Override
    public int getMaxParallelRecipes() {
        return 4 * GTUtility.getTier(this.getMaxInputVoltage());
    }

    @Override
    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    @Override
    public int getPollutionPerSecond(ItemStack aStack) {
        return PollutionConfig.pollutionPerSecondMultiIndustrialSifter;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected SoundResource getActivitySoundLoop() {
        return SoundResource.GT_MACHINES_SIFTER_LOOP;
    }
}

