/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.processing;

import com.gtnewhorizon.structurelib.alignment.IAlignmentLimits;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.HatchElement;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.common.pollution.PollutionConfig;
import gtPlusPlus.api.recipe.GTPPRecipeMaps;
import gtPlusPlus.core.block.ModBlocks;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.GTPPMultiBlockBase;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;

public class MTEIndustrialMolecularTransformer
extends GTPPMultiBlockBase<MTEIndustrialMolecularTransformer>
implements ISurvivalConstructable {
    private static final int CASING_TEXTURE_ID = 48;
    private int mCasing = 0;
    private static final String STRUCTURE_PIECE_MAIN = "main";
    private static IStructureDefinition<MTEIndustrialMolecularTransformer> STRUCTURE_DEFINITION = null;

    public MTEIndustrialMolecularTransformer(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public MTEIndustrialMolecularTransformer(String aName) {
        super(aName);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEIndustrialMolecularTransformer(this.mName);
    }

    @Override
    public String getMachineType() {
        return "Molecular Transformer";
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType(this.getMachineType()).addInfo("Changes the structure of items to produce new ones").addInfo("Maximum 1x of each bus/hatch.").addPollutionAmount(this.getPollutionPerSecond(null)).beginStructureBlock(7, 7, 7, false).addController("Top Center").addCasingInfoMin("Robust Tungstensteel Machine Casing", 40, false).addCasingInfoMin("TPV-Alloy Coils", 16, false).addCasingInfoMin("Molecular Containment Casing", 52, false).addCasingInfoMin("High Voltage Current Capacitor", 32, false).addCasingInfoMin("Particle Containment Casing", 4, false).addCasingInfoMin("Resonance Chamber I", 5, false).addCasingInfoMin("Modulator I", 4, false).addInputBus("Any Robust Tungstensteel Machine Casing", 1).addOutputBus("Any Robust Tungstensteel Machine Casing", 1).addEnergyHatch("Any Robust Tungstensteel Machine Casing", 1).addMaintenanceHatch("Any Robust Tungstensteel Machine Casing", 1).addMufflerHatch("Any Robust Tungstensteel Machine Casing", 1).toolTipFinisher(new String[0]);
        return tt;
    }

    @Override
    public IStructureDefinition<MTEIndustrialMolecularTransformer> getStructureDefinition() {
        if (STRUCTURE_DEFINITION == null) {
            STRUCTURE_DEFINITION = StructureDefinition.builder().addShape(STRUCTURE_PIECE_MAIN, (String[][])new String[][]{{"       ", "       ", "  xxx  ", "  x~x  ", "  xxx  ", "       ", "       "}, {"       ", "  xxx  ", " xyyyx ", " xyzyx ", " xyyyx ", "  xxx  ", "       "}, {"       ", "  xxx  ", " xyyyx ", " xyzyx ", " xyyyx ", "  xxx  ", "       "}, {"       ", "  xxx  ", " xyyyx ", " xyzyx ", " xyyyx ", "  xxx  ", "       "}, {"   t   ", " ttxtt ", " tyyyt ", "txyzyxt", " tyyyt ", " ttxtt ", "   t   "}, {"   c   ", " ccecc ", " cxfxc ", "cefefec", " cxfxc ", " ccecc ", "   c   "}, {"   h   ", " hhhhh ", " hhhhh ", "hhhhhhh", " hhhhh ", " hhhhh ", "   h   "}}).addElement('x', StructureUtility.ofBlock((Block)MTEIndustrialMolecularTransformer.getCasingBlock(), (int)MTEIndustrialMolecularTransformer.getCasingMeta())).addElement('y', StructureUtility.ofBlock((Block)MTEIndustrialMolecularTransformer.getCasingBlock(), (int)MTEIndustrialMolecularTransformer.getCasingMeta2())).addElement('z', StructureUtility.ofBlock((Block)MTEIndustrialMolecularTransformer.getCasingBlock(), (int)MTEIndustrialMolecularTransformer.getCasingMeta3())).addElement('e', StructureUtility.ofBlock((Block)MTEIndustrialMolecularTransformer.getCasingBlock2(), (int)0)).addElement('f', StructureUtility.ofBlock((Block)MTEIndustrialMolecularTransformer.getCasingBlock2(), (int)4)).addElement('c', StructureUtility.ofBlock((Block)MTEIndustrialMolecularTransformer.getCoilBlock(), (int)3)).addElement('t', StructureUtility.ofBlock((Block)MTEIndustrialMolecularTransformer.getCasingBlock3(), (int)MTEIndustrialMolecularTransformer.getTungstenCasingMeta())).addElement('h', GTStructureUtility.buildHatchAdder(MTEIndustrialMolecularTransformer.class).atLeast(HatchElement.InputBus, HatchElement.OutputBus, HatchElement.Maintenance, HatchElement.Energy, HatchElement.Muffler).casingIndex(MTEIndustrialMolecularTransformer.getCasingTextureIndex()).dot(1).buildAndChain(StructureUtility.onElementPass(x -> ++x.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)MTEIndustrialMolecularTransformer.getCasingBlock3(), (int)MTEIndustrialMolecularTransformer.getTungstenCasingMeta())))).build();
        }
        return STRUCTURE_DEFINITION;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(STRUCTURE_PIECE_MAIN, stackSize, hintsOnly, 3, 3, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivialBuildPiece(STRUCTURE_PIECE_MAIN, stackSize, 3, 3, 0, elementBudget, env, false, true);
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.mCasing = 0;
        boolean aDidBuild = this.checkPiece(STRUCTURE_PIECE_MAIN, 3, 3, 0);
        if (this.mInputBusses.size() != 1 || this.mOutputBusses.size() != 1 || this.mEnergyHatches.size() != 1) {
            return false;
        }
        return aDidBuild && this.mCasing >= 24 && this.checkHatch();
    }

    protected static int getCasingTextureIndex() {
        return 48;
    }

    protected static Block getCasingBlock() {
        return ModBlocks.blockSpecialMultiCasings;
    }

    protected static Block getCasingBlock2() {
        return ModBlocks.blockSpecialMultiCasings2;
    }

    protected static Block getCasingBlock3() {
        return GregTechAPI.sBlockCasings4;
    }

    protected static Block getCoilBlock() {
        return GregTechAPI.sBlockCasings5;
    }

    protected static int getCasingMeta() {
        return 11;
    }

    protected static int getCasingMeta2() {
        return 12;
    }

    protected static int getCasingMeta3() {
        return 13;
    }

    protected static int getTungstenCasingMeta() {
        return 0;
    }

    @Override
    protected IAlignmentLimits getInitialAlignmentLimits() {
        return (d, r, f) -> d == ForgeDirection.UP;
    }

    @Override
    protected IIconContainer getActiveOverlay() {
        return TexturesGtBlock.oMCAIndustrialMolecularTransformerActive;
    }

    @Override
    protected IIconContainer getActiveGlowOverlay() {
        return TexturesGtBlock.oMCAIndustrialMolecularTransformerActiveGlow;
    }

    @Override
    protected IIconContainer getInactiveOverlay() {
        return TexturesGtBlock.oMCAIndustrialMolecularTransformer;
    }

    @Override
    protected IIconContainer getInactiveGlowOverlay() {
        return TexturesGtBlock.oMCAIndustrialMolecularTransformerGlow;
    }

    @Override
    protected int getCasingTextureId() {
        return 44;
    }

    @Override
    public RecipeMap<?> getRecipeMap() {
        return GTPPRecipeMaps.molecularTransformerRecipes;
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    @Override
    protected ProcessingLogic createProcessingLogic() {
        return new ProcessingLogic();
    }

    @Override
    public int getMaxParallelRecipes() {
        return 1;
    }

    @Override
    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    @Override
    public int getPollutionPerSecond(ItemStack aStack) {
        return PollutionConfig.pollutionPerSecondMultiMolecularTransformer;
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }
}

