/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.basic;

import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.forge.IItemHandlerModifiable;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.api.widget.IWidgetBuilder;
import com.gtnewhorizons.modularui.common.widget.DrawableWidget;
import com.gtnewhorizons.modularui.common.widget.FakeSyncWidget;
import com.gtnewhorizons.modularui.common.widget.SlotWidget;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.Materials;
import gregtech.api.enums.SoundResource;
import gregtech.api.enums.Textures;
import gregtech.api.gui.modularui.GTUITextures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.items.MetaGeneratedTool;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.MTEBasicMachine;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTUtility;
import gregtech.common.items.IDMetaTool01;
import gregtech.common.items.MetaGeneratedTool01;
import gregtech.common.pollution.Pollution;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.item.general.ItemAirFilter;
import gtPlusPlus.core.item.general.ItemBasicScrubberTurbine;
import gtPlusPlus.core.recipe.common.CI;
import gtPlusPlus.core.util.math.MathUtils;
import gtPlusPlus.xmod.gregtech.api.gui.GTPPUITextures;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.commons.lang3.ArrayUtils;

public class MTEAtmosphericReconditioner
extends MTEBasicMachine {
    public int mPollutionReduction = 0;
    protected int mBaseEff = 2500;
    protected int mOptimalAirFlow = 0;
    protected boolean mHasPollution = false;
    protected int SLOT_ROTOR = 5;
    protected int SLOT_FILTER = 6;
    protected boolean mSaveRotor = false;
    private static ItemStack[] sGregTurbines;

    public MTEAtmosphericReconditioner(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, 2, "Making sure you don't live in Gwalior - Uses 2A", 3, 0, TextureFactory.of(TextureFactory.of(Textures.BlockIcons.OVERLAY_SIDE_MASSFAB_ACTIVE), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_SIDE_MASSFAB_ACTIVE_GLOW).glow().build()), TextureFactory.of(TextureFactory.of(Textures.BlockIcons.OVERLAY_SIDE_MASSFAB), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_SIDE_MASSFAB_GLOW).glow().build()), TextureFactory.of(TextureFactory.of(TexturesGtBlock.Overlay_MatterFab_Active), TextureFactory.builder().addIcon(TexturesGtBlock.Overlay_MatterFab_Active_Glow).glow().build()), TextureFactory.of(TextureFactory.of(TexturesGtBlock.Overlay_MatterFab), TextureFactory.builder().addIcon(TexturesGtBlock.Overlay_MatterFab_Glow).glow().build()), TextureFactory.of(TexturesGtBlock.Overlay_Machine_Vent_Fast), TextureFactory.of(TexturesGtBlock.Overlay_Machine_Vent), TextureFactory.of(TextureFactory.of(Textures.BlockIcons.OVERLAY_BOTTOM_MASSFAB_ACTIVE), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_BOTTOM_MASSFAB_ACTIVE_GLOW).glow().build()), TextureFactory.of(TextureFactory.of(Textures.BlockIcons.OVERLAY_BOTTOM_MASSFAB), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_BOTTOM_MASSFAB_GLOW).glow().build()));
    }

    public MTEAtmosphericReconditioner(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 2, aDescription, aTextures, 2, 0);
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEAtmosphericReconditioner(this.mName, this.mTier, this.mDescriptionArray, this.mTextures);
    }

    @Override
    public String[] getDescription() {
        boolean highTier = this.mTier >= 7;
        String[] A = (String[])ArrayUtils.addAll((Object[])this.mDescriptionArray, (Object[])new String[]{highTier ? "Will attempt to remove 1/4 pollution from 8 surrounding chunks" : "", highTier ? "If these chunks are not loaded, they will be ignored" : "", "Requires a turbine rotor and an Air Filter [T1/T2] to run.", "The turbine rotor must be manually inserted/replaced", "Can be configured with a soldering iron to change modes", "Low Efficiency: Removes half pollution, Turbine takes 50% dmg", "High Efficiency: Removes full pollution, Turbine takes 100% dmg", "Turbine Rotor will not break in LE mode", "Insert an equal tier Conveyor Module to enable automation"});
        return A;
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74768_a("mOptimalAirFlow", this.mOptimalAirFlow);
        aNBT.func_74757_a("mSaveRotor", this.mSaveRotor);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.mOptimalAirFlow = aNBT.func_74762_e("mOptimalAirFlow");
        this.mSaveRotor = aNBT.func_74767_n("mSaveRotor");
    }

    @Override
    public long maxAmperesIn() {
        return 2L;
    }

    @Override
    public long getMinimumStoredEU() {
        return GTValues.V[this.mTier] * 2L;
    }

    @Override
    public long maxEUStore() {
        return GTValues.V[this.mTier] * 256L;
    }

    @Override
    public long maxEUInput() {
        return GTValues.V[this.mTier];
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (aBaseMetaTileEntity.isServerSide()) {
            int mCurrentPollution = this.getCurrentChunkPollution();
            boolean isIdle = true;
            ItemStack stackRotor = this.mInventory[this.SLOT_ROTOR];
            ItemStack stackFilter = this.mInventory[this.SLOT_FILTER];
            long drainEU = this.maxEUInput() * this.maxAmperesIn();
            if (aBaseMetaTileEntity.isActive() && aBaseMetaTileEntity.getStoredEU() >= drainEU) {
                if (aBaseMetaTileEntity.decreaseStoredEnergyUnits(drainEU, false)) {
                    isIdle = false;
                } else {
                    aBaseMetaTileEntity.setActive(false);
                    this.sendSound((byte)-122);
                }
            } else if (!aBaseMetaTileEntity.isActive() && aBaseMetaTileEntity.getStoredEU() >= drainEU / 4L) {
                if (aBaseMetaTileEntity.decreaseStoredEnergyUnits(drainEU / 4L, false)) {
                    isIdle = false;
                } else {
                    aBaseMetaTileEntity.setActive(false);
                    this.sendSound((byte)-122);
                }
            } else {
                aBaseMetaTileEntity.setActive(false);
                this.sendSound((byte)-122);
            }
            if (!isIdle && aTick % 20L == 0L) {
                int i;
                for (i = 0; i < this.mInventory.length; ++i) {
                    ItemStack aSlotContent = this.mInventory[i];
                    if (aSlotContent == null) continue;
                    Logger.INFO("Found " + aSlotContent.func_82833_r() + " in slot " + i);
                }
                for (i = 0; i < this.mInventory.length; ++i) {
                    if (!this.hasRotor(this.mInventory[i])) continue;
                    Logger.INFO("Found Rotor in slot " + i);
                    break;
                }
                for (i = 0; i < this.mInventory.length; ++i) {
                    if (!this.hasAirFilter(this.mInventory[i])) continue;
                    Logger.INFO("Found Filter in slot " + i);
                    break;
                }
                if (aBaseMetaTileEntity.isAllowedToWork()) {
                    Logger.INFO("Can work.");
                    if (this.hasRotor(stackRotor) && this.hasAirFilter(stackFilter) && this.mHasPollution) {
                        if (!this.getBaseMetaTileEntity().isActive()) {
                            Logger.INFO("Set Active.");
                            aBaseMetaTileEntity.setActive(true);
                        }
                    } else if (!(this.mHasPollution && mCurrentPollution > 0 && stackRotor != null && stackFilter != null && this.hasRotor(stackRotor) && this.hasAirFilter(stackFilter) || this.getBaseMetaTileEntity().isActive())) {
                        Logger.INFO("Set Inactive.");
                        aBaseMetaTileEntity.setActive(false);
                        this.sendSound((byte)-122);
                    }
                    if (aBaseMetaTileEntity.isActive()) {
                        Logger.INFO("Doing something.");
                        if (this.mHasPollution && mCurrentPollution > 0) {
                            Logger.INFO("Has Pollution? " + this.mHasPollution + ", Current Pollution: " + mCurrentPollution);
                            if (this.hasRotor(stackRotor) && this.hasAirFilter(stackFilter)) {
                                Logger.INFO("Found Turbine.");
                                this.mBaseEff = this.getBaseEfficiency(stackRotor);
                                this.mOptimalAirFlow = this.getOptimalAirFlow(stackRotor);
                                if (this.mBaseEff > 0 && this.mOptimalAirFlow > 0) {
                                    Logger.INFO("mBaseEff[1]:" + this.mBaseEff);
                                    Logger.INFO("mOptimalAirFlow[1]:" + this.mOptimalAirFlow);
                                    byte tTier = (byte)Math.max(1, GTUtility.getTier(drainEU));
                                    int mAirSides = this.getFreeSpaces();
                                    int reduction = 0;
                                    if (mAirSides > 0) {
                                        Logger.INFO("mPollutionReduction[1]:" + (reduction += Math.max(tTier - 2, 1) * 2 * 50 * mAirSides));
                                        reduction = MathUtils.safeInt((long)reduction * (long)this.mBaseEff) / 100000 * mAirSides * Math.max(tTier - 2, 1);
                                        Logger.INFO("reduction[2]:" + reduction);
                                        reduction = MathUtils.safeInt((long)reduction / 100L * (long)this.mOptimalAirFlow);
                                        Logger.INFO("reduction[3]:" + reduction);
                                        this.mPollutionReduction = reduction;
                                        int toRemove = 0;
                                        Logger.INFO("mCurrentPollution[4]:" + mCurrentPollution);
                                        Logger.INFO("mCurrentPollution[5]:" + reduction);
                                        toRemove = Math.min(reduction, mCurrentPollution) / 2;
                                        Logger.INFO("mCurrentPollution[6]:" + toRemove);
                                        if (toRemove > 0) {
                                            if (this.damageTurbineRotor() && this.damageAirFilter()) {
                                                Logger.INFO("Removing " + toRemove + " pollution");
                                                this.removePollution(this.mSaveRotor ? toRemove / 2 : toRemove);
                                                Logger.INFO("mNewPollution[4]:" + this.getCurrentChunkPollution());
                                            } else {
                                                Logger.INFO("Could not damage turbine rotor or Air Filter.");
                                                aBaseMetaTileEntity.setActive(false);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    } else if (!aBaseMetaTileEntity.isActive()) {
                        return;
                    }
                }
            } else if (this.hasRotor(stackRotor) && this.hasAirFilter(stackFilter) && this.mHasPollution && !isIdle && aBaseMetaTileEntity.isAllowedToWork()) {
                aBaseMetaTileEntity.setActive(true);
            } else if (isIdle || !this.mHasPollution || mCurrentPollution <= 0 || stackRotor == null || stackFilter == null || !this.hasRotor(stackRotor) || !this.hasAirFilter(stackFilter)) {
                aBaseMetaTileEntity.setActive(false);
            }
            if (this.getBaseMetaTileEntity().isActive() && MathUtils.randInt(0, 5) <= 2) {
                this.sendSound((byte)-120);
            }
        }
    }

    public int getCurrentChunkPollution() {
        int mCurrentChunkPollution = 0;
        if (this.mTier < 7) {
            mCurrentChunkPollution = Pollution.getPollution(this.getBaseMetaTileEntity());
        } else {
            ArrayList<Chunk> aSurrounding = new ArrayList<Chunk>();
            World aWorld = this.getBaseMetaTileEntity().getWorld();
            int xPos = this.getBaseMetaTileEntity().getXCoord();
            int zPos = this.getBaseMetaTileEntity().getZCoord();
            Chunk a1 = aWorld.func_72938_d(xPos - 32, zPos - 32);
            Chunk a2 = aWorld.func_72938_d(xPos - 32, zPos);
            Chunk a3 = aWorld.func_72938_d(xPos - 32, zPos + 32);
            Chunk b1 = aWorld.func_72938_d(xPos, zPos - 32);
            Chunk b2 = aWorld.func_72938_d(xPos, zPos);
            Chunk b3 = aWorld.func_72938_d(xPos, zPos + 32);
            Chunk c1 = aWorld.func_72938_d(xPos + 32, zPos - 32);
            Chunk c2 = aWorld.func_72938_d(xPos + 32, zPos);
            Chunk c3 = aWorld.func_72938_d(xPos + 32, zPos + 32);
            aSurrounding.add(a1);
            aSurrounding.add(a2);
            aSurrounding.add(a3);
            aSurrounding.add(b1);
            aSurrounding.add(b2);
            aSurrounding.add(b3);
            aSurrounding.add(c1);
            aSurrounding.add(c2);
            aSurrounding.add(c3);
            for (Chunk r : aSurrounding) {
                mCurrentChunkPollution += this.getPollutionInChunk(r);
            }
        }
        this.mHasPollution = mCurrentChunkPollution > 0;
        return mCurrentChunkPollution;
    }

    public int getPollutionInChunk(Chunk aChunk) {
        int mCurrentChunkPollution = Pollution.getPollution(aChunk);
        this.mHasPollution = mCurrentChunkPollution > 0;
        return mCurrentChunkPollution;
    }

    public boolean hasRotor(ItemStack rotorStack) {
        if (rotorStack != null) {
            if (rotorStack.func_77973_b() instanceof ItemBasicScrubberTurbine) {
                return true;
            }
            if (rotorStack.func_77973_b() instanceof MetaGeneratedTool && rotorStack.func_77960_j() >= 170 && rotorStack.func_77960_j() <= 179) {
                return true;
            }
        }
        return false;
    }

    public boolean damageTurbineRotor() {
        block21: {
            try {
                boolean creativeRotor = false;
                ItemStack rotorStack = this.mInventory[this.SLOT_ROTOR];
                if (rotorStack == null) {
                    return false;
                }
                if (rotorStack.func_77973_b() instanceof ItemBasicScrubberTurbine) {
                    long currentUse = ItemBasicScrubberTurbine.getFilterDamage(rotorStack);
                    if (rotorStack.func_77960_j() == 0 && currentUse >= 1990L) {
                        Logger.INFO("Depleting ItemBasicScrubberTurbine T1");
                        this.mInventory[this.SLOT_FILTER] = null;
                        return false;
                    }
                    if (rotorStack.func_77960_j() == 1 && currentUse >= 3990L) {
                        Logger.INFO("Depleting ItemBasicScrubberTurbine T2");
                        this.mInventory[this.SLOT_FILTER] = null;
                        return false;
                    }
                    if (rotorStack.func_77960_j() == 2 && currentUse >= 5990L) {
                        Logger.INFO("Depleting ItemBasicScrubberTurbine T3");
                        this.mInventory[this.SLOT_FILTER] = null;
                        return false;
                    }
                    Logger.INFO("Damaging ItemBasicScrubberTurbine");
                    ItemBasicScrubberTurbine.setFilterDamage(rotorStack, currentUse + 10L);
                    Logger.INFO("Rotor Damage: " + currentUse);
                    return true;
                }
                if (rotorStack.func_77973_b() instanceof MetaGeneratedTool01) {
                    Materials t1 = MetaGeneratedTool.getPrimaryMaterial(rotorStack);
                    Materials t2 = MetaGeneratedTool.getSecondaryMaterial(rotorStack);
                    if (t1 == Materials._NULL && t2 == Materials._NULL) {
                        Logger.INFO("Found creative rotor.");
                        creativeRotor = true;
                    }
                } else {
                    Logger.INFO("Bad item in rotor slot.");
                    return false;
                }
                if (this.mInventory[this.SLOT_ROTOR].func_77973_b() instanceof MetaGeneratedTool01 && ((MetaGeneratedTool)this.mInventory[this.SLOT_ROTOR].func_77973_b()).getToolStats(this.mInventory[this.SLOT_ROTOR]).getSpeedMultiplier() > 0.0f && MetaGeneratedTool.getPrimaryMaterial((ItemStack)this.mInventory[this.SLOT_ROTOR]).mToolSpeed > 0.0f) {
                    long damageValue = (long)Math.floor(Math.abs(MathUtils.randFloat(1.0f, 2.0f) - MathUtils.randFloat(1.0f, 3.0f)) * 3.0f + 1.0f);
                    double fDam = Math.floor(Math.abs(MathUtils.randFloat(1.0f, 2.0f) - MathUtils.randFloat(1.0f, 2.0f)) * 2.0f + 1.0f);
                    damageValue = (long)((double)damageValue - fDam);
                    long rotorDamage = creativeRotor ? 0L : MetaGeneratedTool.getToolDamage(this.mInventory[this.SLOT_ROTOR]);
                    long rotorDurabilityMax = creativeRotor ? Integer.MAX_VALUE : MetaGeneratedTool.getToolMaxDamage(this.mInventory[this.SLOT_ROTOR]);
                    long rotorDurability = rotorDurabilityMax - rotorDamage;
                    Logger.INFO("Rotor Damage: " + rotorDamage + " | Max Durability: " + rotorDurabilityMax + " |  Remaining Durability: " + rotorDurability);
                    if (rotorDurability >= damageValue) {
                        if (!this.mSaveRotor) {
                            long tempDur;
                            Logger.INFO("Damaging Rotor.");
                            if (!creativeRotor) {
                                GTModHandler.damageOrDechargeItem(this.mInventory[this.SLOT_ROTOR], (int)damageValue, 0, null);
                            }
                            if ((tempDur = MetaGeneratedTool.getToolDamage(this.mInventory[this.SLOT_ROTOR])) < rotorDurabilityMax) {
                                return true;
                            }
                            rotorDurability = 0L;
                        } else {
                            Logger.INFO("Damaging Rotor.");
                            if (rotorDurability > 1000L) {
                                long tempDur;
                                if (!creativeRotor) {
                                    GTModHandler.damageOrDechargeItem(this.mInventory[this.SLOT_ROTOR], (int)damageValue / 2, 0, null);
                                }
                                if ((tempDur = MetaGeneratedTool.getToolDamage(this.mInventory[this.SLOT_ROTOR])) < rotorDurabilityMax) {
                                    return true;
                                }
                                rotorDurability = 0L;
                            }
                        }
                    }
                    if (rotorDurability <= 0L && !this.mSaveRotor && !creativeRotor) {
                        Logger.INFO("Destroying Rotor.");
                        this.mInventory[this.SLOT_ROTOR] = null;
                        return false;
                    }
                    if (rotorDurability <= 0L && this.mSaveRotor) {
                        Logger.INFO("Saving Rotor.");
                        return false;
                    }
                    break block21;
                }
                Logger.INFO("Bad Rotor.");
                return false;
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return false;
    }

    public int getFreeSpaces() {
        int mAir = 0;
        IGregTechTileEntity aBaseMetaTileEntity = this.getBaseMetaTileEntity();
        if (aBaseMetaTileEntity.getAirOffset(1, 0, 0)) {
            ++mAir;
        }
        if (aBaseMetaTileEntity.getAirOffset(-1, 0, 0)) {
            ++mAir;
        }
        if (aBaseMetaTileEntity.getAirOffset(0, 0, 1)) {
            ++mAir;
        }
        if (aBaseMetaTileEntity.getAirOffset(0, 0, -1)) {
            ++mAir;
        }
        if (aBaseMetaTileEntity.getAirOffset(0, 1, 0)) {
            ++mAir;
        }
        if (aBaseMetaTileEntity.getAirOffset(0, -1, 0)) {
            ++mAir;
        }
        return mAir;
    }

    public boolean removePollution(int toRemove) {
        if (this.getBaseMetaTileEntity() == null || this.getBaseMetaTileEntity().getWorld() == null) {
            return false;
        }
        if (this.mTier < 7) {
            int startPollution = this.getCurrentChunkPollution();
            Logger.INFO("Current Chunk Pollution: " + startPollution);
            Pollution.addPollution(this.getBaseMetaTileEntity(), -toRemove);
            int after = this.getCurrentChunkPollution();
            Logger.INFO("Current Chunk Pollution: " + after);
            return after < startPollution;
        }
        int chunksWithRemoval = 0;
        int totalRemoved = 0;
        ArrayList<Chunk> aSurrounding = new ArrayList<Chunk>();
        Chunk aThisChunk = this.getBaseMetaTileEntity().getWorld().func_72938_d(this.getBaseMetaTileEntity().getXCoord(), this.getBaseMetaTileEntity().getZCoord());
        int mainChunkX = aThisChunk.field_76635_g;
        int mainChunkZ = aThisChunk.field_76647_h;
        World aWorld = this.getBaseMetaTileEntity().getWorld();
        int xPos = this.getBaseMetaTileEntity().getXCoord();
        int zPos = this.getBaseMetaTileEntity().getZCoord();
        Chunk a1 = aWorld.func_72938_d(xPos - 32, zPos - 32);
        Chunk a2 = aWorld.func_72938_d(xPos - 32, zPos);
        Chunk a3 = aWorld.func_72938_d(xPos - 32, zPos + 32);
        Chunk b1 = aWorld.func_72938_d(xPos, zPos - 32);
        Chunk b2 = aWorld.func_72938_d(xPos, zPos);
        Chunk b3 = aWorld.func_72938_d(xPos, zPos + 32);
        Chunk c1 = aWorld.func_72938_d(xPos + 32, zPos - 32);
        Chunk c2 = aWorld.func_72938_d(xPos + 32, zPos);
        Chunk c3 = aWorld.func_72938_d(xPos + 32, zPos + 32);
        aSurrounding.add(a1);
        aSurrounding.add(a2);
        aSurrounding.add(a3);
        aSurrounding.add(b1);
        aSurrounding.add(b2);
        aSurrounding.add(b3);
        aSurrounding.add(c1);
        aSurrounding.add(c2);
        aSurrounding.add(c3);
        for (Chunk r : aSurrounding) {
            int startPollution;
            if (!r.field_76636_d || (startPollution = this.getPollutionInChunk(r)) == 0) continue;
            Logger.INFO("Trying to remove pollution from chunk " + r.field_76635_g + ", " + r.field_76647_h + " | " + startPollution);
            int after = 0;
            boolean isMainChunk = r.func_76600_a(mainChunkX, mainChunkZ);
            int removal = Math.max(0, !isMainChunk ? toRemove / 4 : toRemove);
            if (this.removePollution(r, removal)) {
                ++chunksWithRemoval;
                after = this.getPollutionInChunk(r);
            } else {
                after = 0;
            }
            if (startPollution - after > 0) {
                totalRemoved += startPollution - after;
            }
            Logger.INFO("Removed " + (startPollution - after) + " pollution from chunk " + r.field_76635_g + ", " + r.field_76647_h + " | " + after);
        }
        return totalRemoved > 0 && chunksWithRemoval > 0;
    }

    public boolean removePollution(Chunk aChunk, int toRemove) {
        int before = this.getCurrentChunkPollution();
        Pollution.addPollution(aChunk, -toRemove);
        int after = this.getCurrentChunkPollution();
        return after < before;
    }

    public boolean hasAirFilter(ItemStack filter) {
        if (filter == null) {
            return false;
        }
        return filter.func_77973_b() instanceof ItemAirFilter;
    }

    public boolean damageAirFilter() {
        ItemStack filter = this.mInventory[this.SLOT_FILTER];
        if (filter == null) {
            return false;
        }
        boolean creativeRotor = false;
        ItemStack rotorStack = this.mInventory[this.SLOT_ROTOR];
        if (rotorStack != null && rotorStack.func_77973_b() instanceof MetaGeneratedTool01) {
            Materials t1 = MetaGeneratedTool.getPrimaryMaterial(rotorStack);
            Materials t2 = MetaGeneratedTool.getSecondaryMaterial(rotorStack);
            if (t1 == Materials._NULL && t2 == Materials._NULL) {
                creativeRotor = true;
            }
        }
        if (creativeRotor) {
            return true;
        }
        if (filter.func_77973_b() instanceof ItemAirFilter) {
            long currentUse = ItemAirFilter.getFilterDamage(filter);
            if (filter.func_77960_j() == 0 && currentUse >= 49L) {
                this.mInventory[this.SLOT_FILTER] = null;
                return false;
            }
            if (filter.func_77960_j() == 1 && currentUse >= 2499L) {
                this.mInventory[this.SLOT_FILTER] = null;
                return false;
            }
            ItemAirFilter.setFilterDamage(filter, currentUse + 1L);
            Logger.INFO("Filter Damage: " + currentUse);
            return true;
        }
        return false;
    }

    @Override
    public boolean func_102007_a(int aIndex, ItemStack aStack, int ordinalSide) {
        if (aIndex == this.SLOT_FILTER && aStack.func_77973_b() instanceof ItemAirFilter) {
            Logger.INFO("Inserting Air Filter into " + aIndex);
            return true;
        }
        if (aIndex == this.SLOT_ROTOR && this.mInventory[7] != null) {
            Logger.INFO("Found conveyor, can automate turbines. Inserting into " + aIndex);
            if (aStack.func_77973_b() instanceof ItemBasicScrubberTurbine) {
                return true;
            }
            return aStack.func_77973_b() instanceof MetaGeneratedTool && aStack.func_77960_j() >= 170 && aStack.func_77960_j() <= 179;
        }
        return false;
    }

    @Override
    public void onScrewdriverRightClick(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        super.onScrewdriverRightClick(side, aPlayer, aX, aY, aZ);
    }

    @Override
    public void doSound(byte aIndex, double aX, double aY, double aZ) {
        if (aIndex == -120) {
            GTUtility.doSoundAtClient(SoundResource.IC2_TOOLS_BATTERY_USE, MathUtils.randInt(5, 50), 0.05f, aX, aY, aZ);
        } else {
            super.doSound((byte)0, aX, aY, aZ);
        }
    }

    @Override
    public String[] getInfoData() {
        ArrayList<String> aTooltipSuper = new ArrayList<String>(Arrays.asList(super.getInfoData()));
        int mAirSides = this.getFreeSpaces();
        int reduction = 0;
        try {
            long tVoltage = this.maxEUInput();
            byte tTier = (byte)Math.max(1, GTUtility.getTier(tVoltage));
            reduction += Math.max(tTier - 2, 1) * 2 * 50 * mAirSides;
            reduction = MathUtils.safeInt((long)reduction * (long)this.mBaseEff) / 100000 * mAirSides * Math.max(tTier - 2, 1);
            reduction = MathUtils.safeInt((long)reduction / 100L * (long)this.mOptimalAirFlow);
            aTooltipSuper.add(StatCollector.func_74837_a((String)"gtpp.infodata.atmospheric_reconditioner.maximum_pollution_removed", (Object[])new Object[]{reduction}));
        }
        catch (Throwable t) {
            aTooltipSuper.add(StatCollector.func_74837_a((String)"gtpp.infodata.atmospheric_reconditioner.maximum_pollution_removed", (Object[])new Object[]{this.mPollutionReduction}));
        }
        aTooltipSuper.add(StatCollector.func_74837_a((String)"gtpp.infodata.atmospheric_reconditioner.air_sides", (Object[])new Object[]{mAirSides}));
        String[] mBuiltOutput = new String[aTooltipSuper.size()];
        int aIndex = 0;
        for (String i : aTooltipSuper) {
            mBuiltOutput[aIndex++] = i;
        }
        return mBuiltOutput;
    }

    @Override
    public boolean isGivingInformation() {
        return true;
    }

    @Override
    public boolean allowCoverOnSide(ForgeDirection side, ItemStack coverItem) {
        if (side.offsetY != 0) {
            return false;
        }
        return super.allowCoverOnSide(side, coverItem);
    }

    @Override
    public ITexture[] getTopFacingInactive(byte aColor) {
        return super.getTopFacingInactive(aColor);
    }

    @Override
    public void setItemNBT(NBTTagCompound aNBT) {
        if (this.mOptimalAirFlow > 0) {
            aNBT.func_74768_a("mOptimalAirFlow", this.mOptimalAirFlow);
        }
        if (this.mSaveRotor) {
            aNBT.func_74757_a("mSaveRotor", true);
        }
        super.setItemNBT(aNBT);
    }

    public static ItemStack getTieredTurbine(int aTier) {
        if (sGregTurbines != null) {
            return sGregTurbines[aTier];
        }
        sGregTurbines = new ItemStack[3];
        MTEAtmosphericReconditioner.sGregTurbines[0] = MetaGeneratedTool.sInstances.get("gt.metatool.01").getToolWithStats(IDMetaTool01.TURBINE_SMALL.ID, 1, Materials.Iron, Materials.Iron, null);
        MTEAtmosphericReconditioner.sGregTurbines[1] = MetaGeneratedTool.sInstances.get("gt.metatool.01").getToolWithStats(IDMetaTool01.TURBINE_SMALL.ID, 1, Materials.Bronze, Materials.Bronze, null);
        MTEAtmosphericReconditioner.sGregTurbines[2] = MetaGeneratedTool.sInstances.get("gt.metatool.01").getToolWithStats(IDMetaTool01.TURBINE_SMALL.ID, 1, Materials.Steel, Materials.Steel, null);
        return null;
    }

    public int getBaseEfficiency(ItemStack aStackRotor) {
        if (aStackRotor.func_77973_b() instanceof ItemBasicScrubberTurbine) {
            return this.getBaseEfficiency(MTEAtmosphericReconditioner.getTieredTurbine(aStackRotor.func_77960_j()));
        }
        return (int)((50.0f + 10.0f * ((MetaGeneratedTool)aStackRotor.func_77973_b()).getToolCombatDamage(aStackRotor)) * 100.0f);
    }

    public int getOptimalAirFlow(ItemStack aStackRotor) {
        if (aStackRotor.func_77973_b() instanceof ItemBasicScrubberTurbine) {
            return this.getOptimalAirFlow(MTEAtmosphericReconditioner.getTieredTurbine(aStackRotor.func_77960_j()));
        }
        return (int)Math.max(Float.MIN_NORMAL, ((MetaGeneratedTool)aStackRotor.func_77973_b()).getToolStats(aStackRotor).getSpeedMultiplier() * MetaGeneratedTool.getPrimaryMaterial((ItemStack)aStackRotor).mToolSpeed * 50.0f);
    }

    @Override
    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        ((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(new SlotWidget((IItemHandlerModifiable)this.inventoryHandler, this.SLOT_ROTOR).setFilter(stack -> {
            if (stack.func_77973_b() instanceof ItemBasicScrubberTurbine) {
                return true;
            }
            return stack.func_77973_b() instanceof MetaGeneratedTool && stack.func_77960_j() >= 170 && stack.func_77960_j() <= 179;
        }).setBackground(new IDrawable[]{this.getGUITextureSet().getItemSlot(), GTPPUITextures.OVERLAY_SLOT_TURBINE}).setPos(52, 24))).widget(new SlotWidget((IItemHandlerModifiable)this.inventoryHandler, this.SLOT_FILTER).setFilter(stack -> stack.func_77973_b() instanceof ItemAirFilter).setBackground(new IDrawable[]{this.getGUITextureSet().getItemSlot(), GTUITextures.OVERLAY_SLOT_RECYCLE}).setPos(106, 24))).widget(new SlotWidget((IItemHandlerModifiable)this.inventoryHandler, 7).setFilter(stack -> GTUtility.areStacksEqual(stack, CI.getConveyor(this.mTier, 1), true)).setPos(124, 62));
        builder.widget(new DrawableWidget().setDrawable((IDrawable)GTUITextures.PICTURE_INFORMATION).dynamicTooltip(() -> Collections.singletonList("Reduction: " + this.mPollutionReduction + "/s")).attachSyncer((FakeSyncWidget)new FakeSyncWidget.IntegerSyncer(() -> this.mPollutionReduction, val -> {
            this.mPollutionReduction = val;
        }), (IWidgetBuilder)builder, (widget, val) -> widget.notifyTooltipChange()).setPos(163, 5).setSize(7, 18));
    }
}

