/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.automation;

import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IDigitalChest;
import gregtech.api.interfaces.tileentity.IGregTechDeviceInformation;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.MTEBasicTank;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTUtility;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.lib.GTPPCore;
import gtPlusPlus.core.util.minecraft.PlayerUtils;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import gtPlusPlus.xmod.gregtech.common.helpers.tesseract.TesseractHelper;
import gtPlusPlus.xmod.gregtech.common.tileentities.automation.MTETesseractTerminal;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import org.apache.commons.lang3.ArrayUtils;

public class MTETesseractGenerator
extends MTEBasicTank {
    public static int TESSERACT_ENERGY_COST_DIMENSIONAL = 512;
    public static int TESSERACT_ENERGY_COST = 128;
    public byte isWorking = 0;
    public int oFrequency = 0;
    public int mNeededEnergy = 0;
    public int mFrequency = 0;
    public UUID mOwner;

    public MTETesseractGenerator(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, 3, "", new ITexture[0]);
    }

    public MTETesseractGenerator(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 3, aDescription, aTextures);
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTETesseractGenerator(this.mName, this.mTier, this.mDescriptionArray, this.mTextures);
    }

    @Override
    public boolean isFacingValid(ForgeDirection facing) {
        return true;
    }

    @Override
    public boolean isEnetInput() {
        return true;
    }

    @Override
    public boolean isEnetOutput() {
        return false;
    }

    @Override
    public boolean isInputFacing(ForgeDirection side) {
        return true;
    }

    @Override
    public boolean isOutputFacing(ForgeDirection side) {
        return side == this.getBaseMetaTileEntity().getBackFacing();
    }

    @Override
    public boolean isValidSlot(int aIndex) {
        return false;
    }

    @Override
    public long getMinimumStoredEU() {
        return this.getBaseMetaTileEntity().getEUCapacity() / 2L;
    }

    @Override
    public long maxEUInput() {
        return 512L;
    }

    @Override
    public long maxEUOutput() {
        return 0L;
    }

    @Override
    public long maxEUStore() {
        return 16384L;
    }

    @Override
    public long maxSteamStore() {
        return this.maxEUStore();
    }

    @Override
    public boolean isAccessAllowed(EntityPlayer aPlayer) {
        return true;
    }

    @Override
    public boolean ownerControl() {
        return true;
    }

    @Override
    public int getProgresstime() {
        return TesseractHelper.getGeneratorByFrequency(PlayerUtils.getPlayerOnServerFromUUID(this.mOwner), this.mFrequency) == this && this.isWorking >= 20 ? 999 : 0;
    }

    @Override
    public int maxProgresstime() {
        return 1000;
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.func_74768_a("mFrequency", this.mFrequency);
        if (this.mOwner != null) {
            aNBT.func_74778_a("mOwner", this.mOwner.toString());
        }
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        this.mFrequency = aNBT.func_74762_e("mFrequency");
        try {
            this.mOwner = UUID.fromString(aNBT.func_74779_i("mOnwer"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Override
    public void onConfigLoad() {
        int J = 4;
        TESSERACT_ENERGY_COST = 128 * J;
        TESSERACT_ENERGY_COST_DIMENSIONAL = 512 * J;
    }

    @Override
    public void onServerStart() {
        GTPPCore.sTesseractGeneratorOwnershipMap.clear();
        GTPPCore.sTesseractTerminalOwnershipMap.clear();
    }

    public void onServerStop() {
        GTPPCore.sTesseractGeneratorOwnershipMap.clear();
        GTPPCore.sTesseractTerminalOwnershipMap.clear();
    }

    @Override
    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer, ForgeDirection side, float aX, float aY, float aZ) {
        if (this.mOwner == null && this.getBaseMetaTileEntity().getOwnerName() != null && !this.getBaseMetaTileEntity().getOwnerName().isEmpty() && this.getBaseMetaTileEntity().getOwnerName().equalsIgnoreCase(aPlayer.getDisplayName())) {
            this.mOwner = PlayerUtils.getPlayersUUIDByName(this.getBaseMetaTileEntity().getOwnerName());
        }
        if (side == this.getBaseMetaTileEntity().getFrontFacing()) {
            if (aPlayer.func_110124_au().compareTo(this.mOwner) == 0) {
                float[] tCoords = GTUtility.getClickedFacingCoords(side, aX, aY, aZ);
                switch ((byte)((byte)(tCoords[0] * 2.0f) + 2 * (byte)(tCoords[1] * 2.0f))) {
                    case 0: {
                        Logger.WARNING("Freq. -1 | " + this.mFrequency);
                        try {
                            GTPPCore.sTesseractGeneratorOwnershipMap.get(this.mOwner).remove(this.mFrequency);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        --this.mFrequency;
                        break;
                    }
                    case 1: {
                        Logger.WARNING("Freq. +1 | " + this.mFrequency);
                        try {
                            GTPPCore.sTesseractGeneratorOwnershipMap.get(this.mOwner).remove(this.mFrequency);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        ++this.mFrequency;
                    }
                }
                if (this.getGeneratorEntity(this.mFrequency) != null && this.getGeneratorEntity(this.mFrequency) != this) {
                    GTUtility.sendChatToPlayer(aPlayer, "Frequency: " + this.mFrequency + EnumChatFormatting.RED + " (Occupied)");
                } else {
                    GTUtility.sendChatToPlayer(aPlayer, "Frequency: " + this.mFrequency);
                }
            } else if (aPlayer.func_110124_au().compareTo(this.mOwner) != 0) {
                GTUtility.sendChatToPlayer(aPlayer, "This is not your Tesseract Generator to configure.");
            }
        }
        return true;
    }

    @Override
    public void onScrewdriverRightClick(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (aPlayer.func_110124_au().compareTo(this.mOwner) == 0) {
            if (side == this.getBaseMetaTileEntity().getFrontFacing()) {
                float[] tCoords = GTUtility.getClickedFacingCoords(side, aX, aY, aZ);
                switch ((byte)((byte)(tCoords[0] * 2.0f) + 2 * (byte)(tCoords[1] * 2.0f))) {
                    case 0: {
                        try {
                            GTPPCore.sTesseractGeneratorOwnershipMap.get(this.mOwner).remove(this.mFrequency);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        this.mFrequency -= 64;
                        break;
                    }
                    case 1: {
                        try {
                            GTPPCore.sTesseractGeneratorOwnershipMap.get(this.mOwner).remove(this.mFrequency);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        this.mFrequency += 64;
                        break;
                    }
                    case 2: {
                        try {
                            GTPPCore.sTesseractGeneratorOwnershipMap.get(this.mOwner).remove(this.mFrequency);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        this.mFrequency -= 512;
                        break;
                    }
                    case 3: {
                        try {
                            GTPPCore.sTesseractGeneratorOwnershipMap.get(this.mOwner).remove(this.mFrequency);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        this.mFrequency += 512;
                    }
                }
                if (this.getGeneratorEntity(this.mFrequency) != null && this.getGeneratorEntity(this.mFrequency) != this) {
                    GTUtility.sendChatToPlayer(aPlayer, "Frequency: " + this.mFrequency + EnumChatFormatting.RED + " (Occupied)");
                } else {
                    GTUtility.sendChatToPlayer(aPlayer, "Frequency: " + this.mFrequency);
                }
            }
        } else {
            GTUtility.sendChatToPlayer(aPlayer, "This is not your Tesseract Generator to configure.");
        }
    }

    public boolean allowCoverOnSide(ForgeDirection side, int aCoverID) {
        return side != this.getBaseMetaTileEntity().getFrontFacing();
    }

    @Override
    public String[] getInfoData() {
        TileEntity tTileEntity = this.getBaseMetaTileEntity().getTileEntityAtSide(this.getBaseMetaTileEntity().getBackFacing());
        if (tTileEntity != null && this.getBaseMetaTileEntity().isAllowedToWork() && tTileEntity instanceof IGregTechDeviceInformation && ((IGregTechDeviceInformation)tTileEntity).isGivingInformation()) {
            return ((IGregTechDeviceInformation)tTileEntity).getInfoData();
        }
        return new String[]{"Tesseract Generator", StatCollector.func_74837_a((String)"gtpp.infodata.tesseract_generator.frequency", (Object[])new Object[]{this.mFrequency}), this.getGeneratorEntity() == this && this.isWorking >= 20 ? StatCollector.func_74838_a((String)"gtpp.infodata.tesseract_generator.status.active") : StatCollector.func_74838_a((String)"gtpp.infodata.tesseract_generator.status.inactive")};
    }

    @Override
    public boolean isGivingInformation() {
        return true;
    }

    public boolean isSendingInformation() {
        TileEntity tTileEntity = this.getBaseMetaTileEntity().getTileEntityAtSide(this.getBaseMetaTileEntity().getBackFacing());
        if (tTileEntity != null && this.getBaseMetaTileEntity().isAllowedToWork() && tTileEntity instanceof IGregTechDeviceInformation) {
            return ((IGregTechDeviceInformation)tTileEntity).isGivingInformation();
        }
        return false;
    }

    @Override
    public boolean isDigitalChest() {
        TileEntity tTileEntity = this.getBaseMetaTileEntity().getTileEntityAtSide(this.getBaseMetaTileEntity().getBackFacing());
        if (tTileEntity != null && this.getBaseMetaTileEntity().isAllowedToWork() && tTileEntity instanceof IDigitalChest) {
            return ((IDigitalChest)tTileEntity).isDigitalChest();
        }
        return false;
    }

    @Override
    public ItemStack[] getStoredItemData() {
        TileEntity tTileEntity = this.getBaseMetaTileEntity().getTileEntityAtSide(this.getBaseMetaTileEntity().getBackFacing());
        if (tTileEntity != null && this.getBaseMetaTileEntity().isAllowedToWork() && tTileEntity instanceof IDigitalChest) {
            return ((IDigitalChest)tTileEntity).getStoredItemData();
        }
        return new ItemStack[0];
    }

    @Override
    public void setItemCount(int aCount) {
        TileEntity tTileEntity = this.getBaseMetaTileEntity().getTileEntityAtSide(this.getBaseMetaTileEntity().getBackFacing());
        if (tTileEntity != null && this.getBaseMetaTileEntity().isAllowedToWork() && tTileEntity instanceof IDigitalChest) {
            ((IDigitalChest)tTileEntity).setItemCount(aCount);
        }
    }

    @Override
    public int getMaxItemCount() {
        TileEntity tTileEntity = this.getBaseMetaTileEntity().getTileEntityAtSide(this.getBaseMetaTileEntity().getBackFacing());
        if (tTileEntity != null && this.getBaseMetaTileEntity().isAllowedToWork() && tTileEntity instanceof IDigitalChest) {
            return ((IDigitalChest)tTileEntity).getMaxItemCount();
        }
        return 0;
    }

    @Override
    public boolean func_94041_b(int aIndex, ItemStack aStack) {
        IInventory tTileEntity = this.getBaseMetaTileEntity().getIInventoryAtSide(this.getBaseMetaTileEntity().getBackFacing());
        if (tTileEntity == null || !this.getBaseMetaTileEntity().isAllowedToWork()) {
            return false;
        }
        return tTileEntity.func_94041_b(aIndex, aStack);
    }

    @Override
    public int[] func_94128_d(int ordinalSide) {
        IInventory tTileEntity = this.getBaseMetaTileEntity().getIInventoryAtSide(this.getBaseMetaTileEntity().getBackFacing());
        if (tTileEntity == null || !this.getBaseMetaTileEntity().isAllowedToWork()) {
            return new int[0];
        }
        if (tTileEntity instanceof ISidedInventory) {
            return ((ISidedInventory)tTileEntity).func_94128_d(ordinalSide);
        }
        int[] rArray = new int[this.func_70302_i_()];
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            rArray[i] = i;
        }
        return rArray;
    }

    @Override
    public boolean func_102007_a(int aIndex, ItemStack aStack, int ordinalSide) {
        IInventory tTileEntity = this.getBaseMetaTileEntity().getIInventoryAtSide(this.getBaseMetaTileEntity().getBackFacing());
        if (tTileEntity == null || !this.getBaseMetaTileEntity().isAllowedToWork()) {
            return false;
        }
        if (tTileEntity instanceof ISidedInventory) {
            return ((ISidedInventory)tTileEntity).func_102007_a(aIndex, aStack, ordinalSide);
        }
        return true;
    }

    @Override
    public boolean func_102008_b(int aIndex, ItemStack aStack, int ordinalSide) {
        IInventory tTileEntity = this.getBaseMetaTileEntity().getIInventoryAtSide(this.getBaseMetaTileEntity().getBackFacing());
        if (tTileEntity == null || !this.getBaseMetaTileEntity().isAllowedToWork()) {
            return false;
        }
        if (tTileEntity instanceof ISidedInventory) {
            return ((ISidedInventory)tTileEntity).func_102008_b(aIndex, aStack, ordinalSide);
        }
        return true;
    }

    @Override
    public int func_70302_i_() {
        IInventory tTileEntity = this.getBaseMetaTileEntity().getIInventoryAtSide(this.getBaseMetaTileEntity().getBackFacing());
        if (tTileEntity == null || !this.getBaseMetaTileEntity().isAllowedToWork()) {
            return 0;
        }
        return tTileEntity.func_70302_i_();
    }

    @Override
    public ItemStack func_70301_a(int aIndex) {
        IInventory tTileEntity = this.getBaseMetaTileEntity().getIInventoryAtSide(this.getBaseMetaTileEntity().getBackFacing());
        if (tTileEntity == null || !this.getBaseMetaTileEntity().isAllowedToWork()) {
            return null;
        }
        return tTileEntity.func_70301_a(aIndex);
    }

    @Override
    public void func_70299_a(int aIndex, ItemStack aStack) {
        IInventory tTileEntity = this.getBaseMetaTileEntity().getIInventoryAtSide(this.getBaseMetaTileEntity().getBackFacing());
        if (tTileEntity == null || !this.getBaseMetaTileEntity().isAllowedToWork()) {
            return;
        }
        tTileEntity.func_70299_a(aIndex, aStack);
    }

    @Override
    public ItemStack func_70298_a(int aIndex, int aAmount) {
        IInventory tTileEntity = this.getBaseMetaTileEntity().getIInventoryAtSide(this.getBaseMetaTileEntity().getBackFacing());
        if (tTileEntity == null || !this.getBaseMetaTileEntity().isAllowedToWork()) {
            return null;
        }
        return tTileEntity.func_70298_a(aIndex, aAmount);
    }

    @Override
    public String func_145825_b() {
        IInventory tTileEntity = this.getBaseMetaTileEntity().getIInventoryAtSide(this.getBaseMetaTileEntity().getBackFacing());
        if (tTileEntity == null || !this.getBaseMetaTileEntity().isAllowedToWork()) {
            return "";
        }
        return tTileEntity.func_145825_b();
    }

    @Override
    public int func_70297_j_() {
        IInventory tTileEntity = this.getBaseMetaTileEntity().getIInventoryAtSide(this.getBaseMetaTileEntity().getBackFacing());
        if (tTileEntity == null || !this.getBaseMetaTileEntity().isAllowedToWork()) {
            return 0;
        }
        return tTileEntity.func_70297_j_();
    }

    @Override
    public boolean canFill(ForgeDirection aSide, Fluid aFluid) {
        IFluidHandler tTileEntity = this.getBaseMetaTileEntity().getITankContainerAtSide(this.getBaseMetaTileEntity().getBackFacing());
        if (tTileEntity == null || !this.getBaseMetaTileEntity().isAllowedToWork()) {
            return false;
        }
        return tTileEntity.canFill(aSide, aFluid);
    }

    @Override
    public boolean canDrain(ForgeDirection aSide, Fluid aFluid) {
        IFluidHandler tTileEntity = this.getBaseMetaTileEntity().getITankContainerAtSide(this.getBaseMetaTileEntity().getBackFacing());
        if (tTileEntity == null || !this.getBaseMetaTileEntity().isAllowedToWork()) {
            return false;
        }
        return tTileEntity.canDrain(aSide, aFluid);
    }

    @Override
    public FluidTankInfo[] getTankInfo(ForgeDirection aSide) {
        IFluidHandler tTileEntity = this.getBaseMetaTileEntity().getITankContainerAtSide(this.getBaseMetaTileEntity().getBackFacing());
        if (tTileEntity == null || !this.getBaseMetaTileEntity().isAllowedToWork()) {
            return new FluidTankInfo[0];
        }
        return tTileEntity.getTankInfo(aSide);
    }

    @Override
    public int fill_default(ForgeDirection aDirection, FluidStack aFluid, boolean doFill) {
        IFluidHandler tTileEntity = this.getBaseMetaTileEntity().getITankContainerAtSide(this.getBaseMetaTileEntity().getBackFacing());
        if (tTileEntity == null || !this.getBaseMetaTileEntity().isAllowedToWork()) {
            return 0;
        }
        return tTileEntity.fill(aDirection, aFluid, doFill);
    }

    @Override
    public FluidStack drain(ForgeDirection aDirection, int maxDrain, boolean doDrain) {
        IFluidHandler tTileEntity = this.getBaseMetaTileEntity().getITankContainerAtSide(this.getBaseMetaTileEntity().getBackFacing());
        if (tTileEntity == null || !this.getBaseMetaTileEntity().isAllowedToWork()) {
            return null;
        }
        return tTileEntity.drain(aDirection, maxDrain, doDrain);
    }

    @Override
    public FluidStack drain(ForgeDirection aSide, FluidStack aFluid, boolean doDrain) {
        IFluidHandler tTileEntity = this.getBaseMetaTileEntity().getITankContainerAtSide(this.getBaseMetaTileEntity().getBackFacing());
        if (tTileEntity == null || !this.getBaseMetaTileEntity().isAllowedToWork()) {
            return null;
        }
        return tTileEntity.drain(aSide, aFluid, doDrain);
    }

    public boolean addEnergyConsumption(MTETesseractTerminal aTerminal) {
        if (!this.getBaseMetaTileEntity().isAllowedToWork()) {
            return false;
        }
        int J = aTerminal.getBaseMetaTileEntity().getWorld() == this.getBaseMetaTileEntity().getWorld() ? TESSERACT_ENERGY_COST : TESSERACT_ENERGY_COST_DIMENSIONAL;
        this.mNeededEnergy += (J *= 4);
        return true;
    }

    public boolean isValidTesseractGenerator(String aOwnerName, boolean aWorkIrrelevant) {
        return !(this.getBaseMetaTileEntity() == null || this.getBaseMetaTileEntity().isInvalidTileEntity() || !this.getBaseMetaTileEntity().isAllowedToWork() || aOwnerName != null && !this.getBaseMetaTileEntity().getOwnerName().equals(aOwnerName) || !aWorkIrrelevant && this.isWorking < 20);
    }

    @Override
    public void onPreTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPreTick(aBaseMetaTileEntity, aTick);
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (this.getBaseMetaTileEntity().isServerSide()) {
            if (PlayerUtils.getPlayersUUIDByName(this.getBaseMetaTileEntity().getOwnerName()) != null && this.mOwner == null) {
                Logger.WARNING("Setting Generators Owner. 1");
                this.mOwner = PlayerUtils.getPlayersUUIDByName(this.getBaseMetaTileEntity().getOwnerName());
            }
            if (this.mFrequency != this.oFrequency) {
                Logger.WARNING("mFreq != oFreq");
                if (this.getGeneratorEntity() == this) {
                    this.getGeneratorEntity(this.oFrequency);
                    this.getBaseMetaTileEntity().issueBlockUpdate();
                    Logger.WARNING("this Gen == oFreq on map - do block update");
                }
                Logger.WARNING("mFreq will be set to oFreq");
                this.oFrequency = this.mFrequency;
            }
            if (this.getBaseMetaTileEntity().isAllowedToWork() && this.getBaseMetaTileEntity().decreaseStoredEnergyUnits(this.mNeededEnergy, false)) {
                if (this.getGeneratorEntity(this.mFrequency) == null || !this.getGeneratorEntity(this.mFrequency).isValidTesseractGenerator(null, true)) {
                    TesseractHelper.setGeneratorOwnershipByPlayer(PlayerUtils.getPlayerOnServerFromUUID(this.mOwner), this.mFrequency, this);
                }
            } else {
                if (this.getGeneratorEntity(this.mFrequency) == this) {
                    Logger.WARNING("this gen == mFreq on map - do block update");
                    TesseractHelper.removeGenerator(PlayerUtils.getPlayerOnServerFromUUID(this.mOwner), this.mFrequency);
                    this.getBaseMetaTileEntity().issueBlockUpdate();
                }
                this.isWorking = 0;
            }
            if (this.getGeneratorEntity(this.mFrequency) == this) {
                if (this.isWorking < 20) {
                    this.isWorking = (byte)(this.isWorking + 1);
                }
                if (this.isWorking == 20) {
                    this.getBaseMetaTileEntity().issueBlockUpdate();
                    this.isWorking = (byte)(this.isWorking + 1);
                }
            } else {
                this.isWorking = 0;
            }
            this.mNeededEnergy = 0;
        }
        super.onPostTick(aBaseMetaTileEntity, aTick);
    }

    @Override
    public String[] getDescription() {
        return (String[])ArrayUtils.addAll((Object[])this.mDescriptionArray, (Object[])new String[]{"Generates a Tesseract for the attached Inventory", "Connect with pipes to insert items", "Consumes " + TESSERACT_ENERGY_COST + "EU/t for same dimension transfers", "Consumes " + TESSERACT_ENERGY_COST_DIMENSIONAL + "EU/t for cross dimensional transfers", GTPPCore.GT_Tooltip.get()});
    }

    @Override
    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return false;
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return false;
    }

    @Override
    public ITexture[][][] getTextureSet(ITexture[] aTextures) {
        return new ITexture[0][0][0];
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int aColorIndex, boolean aActive, boolean aRedstone) {
        ITexture[] iTextureArray;
        if (side == facing) {
            ITexture[] iTextureArray2 = new ITexture[2];
            iTextureArray2[0] = TextureFactory.of(TexturesGtBlock.Casing_Machine_Dimensional);
            iTextureArray = iTextureArray2;
            iTextureArray2[1] = TextureFactory.of(TexturesGtBlock.Casing_Machine_Screen_Frequency);
        } else {
            ITexture[] iTextureArray3 = new ITexture[2];
            iTextureArray3[0] = TextureFactory.of(TexturesGtBlock.Casing_Machine_Dimensional);
            iTextureArray = iTextureArray3;
            iTextureArray3[1] = TextureFactory.of(Textures.BlockIcons.VOID);
        }
        return iTextureArray;
    }

    @Override
    public boolean doesFillContainers() {
        return false;
    }

    @Override
    public boolean doesEmptyContainers() {
        return false;
    }

    @Override
    public boolean canTankBeFilled() {
        return false;
    }

    @Override
    public boolean canTankBeEmptied() {
        return false;
    }

    private MTETesseractGenerator getGeneratorEntity() {
        return TesseractHelper.getGeneratorByFrequency(PlayerUtils.getPlayerOnServerFromUUID(this.mOwner), this.mFrequency);
    }

    private MTETesseractGenerator getGeneratorEntity(int frequency) {
        return TesseractHelper.getGeneratorByFrequency(PlayerUtils.getPlayerOnServerFromUUID(this.mOwner), frequency);
    }

    @Override
    public void onCreated(ItemStack aStack, World aWorld, EntityPlayer aPlayer) {
        if (this.getBaseMetaTileEntity().getOwnerName() != null && !this.getBaseMetaTileEntity().getOwnerName().isEmpty()) {
            this.mOwner = PlayerUtils.getPlayersUUIDByName(this.getBaseMetaTileEntity().getOwnerName());
            Logger.WARNING("Setting Generators Owner. 2");
        }
        super.onCreated(aStack, aWorld, aPlayer);
    }

    @Override
    public void onRemoval() {
        try {
            GTPPCore.sTesseractGeneratorOwnershipMap.get(this.mOwner).remove(this.mFrequency);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        super.onRemoval();
    }
}

