/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.covers;

import com.google.common.io.ByteArrayDataInput;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import gregtech.api.covers.CoverContext;
import gregtech.api.gui.modularui.CoverUIBuildContext;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.MTEBasicTank;
import gregtech.api.metatileentity.implementations.MTEFluidPipe;
import gregtech.api.util.GTUtility;
import gregtech.common.covers.Cover;
import gregtech.common.gui.mui1.cover.OverflowUIFactory;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class CoverOverflowValve
extends Cover {
    private final int minOverflowPoint = 0;
    private final int maxOverflowPoint;
    private int overflowPoint;
    private int voidingRate;
    private boolean canFluidInput;
    private boolean canFluidOutput;

    public CoverOverflowValve(CoverContext context, int maxOverflowPoint) {
        super(context, null);
        this.maxOverflowPoint = maxOverflowPoint;
        this.initializeData(context.getCoverInitializer());
    }

    public int getMinOverflowPoint() {
        return 0;
    }

    public int getMaxOverflowPoint() {
        return this.maxOverflowPoint;
    }

    public int getOverflowPoint() {
        return this.overflowPoint;
    }

    public CoverOverflowValve setOverflowPoint(int overflowPoint) {
        this.overflowPoint = overflowPoint;
        return this;
    }

    public int getVoidingRate() {
        return this.voidingRate;
    }

    public CoverOverflowValve setVoidingRate(int voidingRate) {
        this.voidingRate = voidingRate;
        return this;
    }

    public boolean canFluidInput() {
        return this.canFluidInput;
    }

    public CoverOverflowValve setCanFluidInput(boolean canFluidInput) {
        this.canFluidInput = canFluidInput;
        return this;
    }

    public boolean canFluidOutput() {
        return this.canFluidOutput;
    }

    public CoverOverflowValve setCanFluidOutput(boolean canFluidOutput) {
        this.canFluidOutput = canFluidOutput;
        return this;
    }

    @Override
    protected void initializeData() {
        this.overflowPoint = this.maxOverflowPoint;
        this.voidingRate = this.maxOverflowPoint / 10;
        this.canFluidInput = true;
        this.canFluidOutput = true;
    }

    @Override
    protected void loadFromNbt(NBTBase nbt) {
        if (nbt instanceof NBTTagCompound) {
            NBTTagCompound tag = (NBTTagCompound)nbt;
            this.overflowPoint = tag.func_74762_e("overflowPoint");
            this.voidingRate = tag.func_74762_e("voidingRate");
            this.canFluidInput = tag.func_74767_n("canFluidInput");
            this.canFluidOutput = tag.func_74767_n("canFluidOutput");
        } else {
            this.initializeData();
        }
    }

    @Override
    protected void readFromPacket(ByteArrayDataInput byteData) {
        this.overflowPoint = byteData.readInt();
        this.voidingRate = byteData.readInt();
        this.canFluidInput = byteData.readBoolean();
        this.canFluidOutput = byteData.readBoolean();
    }

    @Override
    @NotNull
    protected NBTBase saveDataToNbt() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("overflowPoint", this.overflowPoint);
        tag.func_74768_a("voidingRate", this.voidingRate);
        tag.func_74757_a("canFluidInput", this.canFluidInput);
        tag.func_74757_a("canFluidOutput", this.canFluidOutput);
        return tag;
    }

    @Override
    protected void writeDataToByteBuf(ByteBuf byteBuf) {
        byteBuf.writeInt(this.overflowPoint).writeInt(this.voidingRate).writeBoolean(this.canFluidInput).writeBoolean(this.canFluidOutput);
    }

    private FluidStack doOverflowThing(FluidStack fluid) {
        if (fluid != null && fluid.amount > this.overflowPoint) {
            fluid.amount = Math.max(fluid.amount - this.voidingRate, this.overflowPoint);
        }
        return fluid;
    }

    private void doOverflowThings(FluidStack[] fluids) {
        for (FluidStack fluid : fluids) {
            this.doOverflowThing(fluid);
        }
    }

    @Override
    public void doCoverThings(byte aInputRedstone, long aTimer) {
        if (this.overflowPoint == 0 || this.voidingRate == 0) {
            return;
        }
        Object t = this.coveredTile.get();
        if (t instanceof IGregTechTileEntity) {
            MTEFluidPipe fluidPipe;
            IGregTechTileEntity gregTE = (IGregTechTileEntity)t;
            IMetaTileEntity tile = gregTE.getMetaTileEntity();
            if (tile instanceof MTEBasicTank) {
                MTEBasicTank fluidTank = (MTEBasicTank)tile;
                fluidTank.setDrainableStack(this.doOverflowThing(fluidTank.getDrainableStack()));
            } else if (tile instanceof MTEFluidPipe && (fluidPipe = (MTEFluidPipe)tile).isConnectedAtSide(this.coverSide)) {
                this.doOverflowThings(fluidPipe.mFluids);
            }
        }
    }

    @Override
    public boolean alwaysLookConnected() {
        return true;
    }

    @Override
    public int getMinimumTickRate() {
        return 5;
    }

    @Override
    public boolean letsItemsOut(int aSlot) {
        return true;
    }

    @Override
    public boolean letsItemsIn(int aSlot) {
        return true;
    }

    @Override
    public boolean letsFluidOut(Fluid aFluid) {
        return this.canFluidOutput;
    }

    @Override
    public boolean letsFluidIn(Fluid aFluid) {
        return this.canFluidInput;
    }

    @Override
    public boolean letsEnergyOut() {
        return true;
    }

    @Override
    public boolean letsEnergyIn() {
        return true;
    }

    @Override
    public boolean letsRedstoneGoOut() {
        return true;
    }

    @Override
    public boolean letsRedstoneGoIn() {
        return true;
    }

    @Override
    public void onCoverScrewdriverClick(EntityPlayer aPlayer, float aX, float aY, float aZ) {
        this.overflowPoint = GTUtility.getClickedFacingCoords(this.coverSide, aX, aY, aZ)[0] >= 0.5f ? (this.overflowPoint += (int)((float)this.maxOverflowPoint * (aPlayer.func_70093_af() ? 0.1f : 0.01f))) : (this.overflowPoint -= (int)((float)this.maxOverflowPoint * (aPlayer.func_70093_af() ? 0.1f : 0.01f)));
        if (this.overflowPoint > this.maxOverflowPoint) {
            this.overflowPoint = 0;
        }
        if (this.overflowPoint <= 0) {
            this.overflowPoint = this.maxOverflowPoint;
        }
        GTUtility.sendChatToPlayer(aPlayer, StatCollector.func_74837_a((String)"GTPP.chat.text.cover_overflow_valve_overflow_point", (Object[])new Object[]{this.overflowPoint}));
    }

    @Override
    public boolean onCoverRightClick(EntityPlayer aPlayer, float aX, float aY, float aZ) {
        int amount;
        int n = amount = aPlayer.func_70093_af() ? 128 : 8;
        this.overflowPoint = GTUtility.getClickedFacingCoords(this.coverSide, aX, aY, aZ)[0] >= 0.5f ? (this.overflowPoint += amount) : (this.overflowPoint -= amount);
        if (this.overflowPoint > this.maxOverflowPoint) {
            this.overflowPoint = 0;
        }
        if (this.overflowPoint <= 0) {
            this.overflowPoint = this.maxOverflowPoint;
        }
        GTUtility.sendChatToPlayer(aPlayer, StatCollector.func_74837_a((String)"GTPP.chat.text.cover_overflow_valve_overflow_point", (Object[])new Object[]{this.overflowPoint}));
        return true;
    }

    @Override
    public boolean hasCoverGUI() {
        return true;
    }

    @Override
    public ModularWindow createWindow(CoverUIBuildContext buildContext) {
        return new OverflowUIFactory(buildContext).createWindow();
    }
}

