/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.generators;

import gregtech.api.enums.GTValues;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.RecipeMapWorkable;
import gregtech.api.metatileentity.implementations.MTEBasicTank;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTUtility;
import gregtech.common.pollution.Pollution;
import gregtech.common.pollution.PollutionConfig;
import gtPlusPlus.core.lib.GTPPCore;
import gtPlusPlus.core.util.math.MathUtils;
import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.ArrayUtils;

public abstract class MTERocketFuelGeneratorBase
extends MTEBasicTank
implements RecipeMapWorkable {
    protected int pollMin;
    protected int pollMax;

    public MTERocketFuelGeneratorBase(int aID, String aName, String aNameRegional, int aTier, String aDescription, ITexture ... aTextures) {
        super(aID, aName, aNameRegional, aTier, 3, aDescription, aTextures);
        this.pollMin = (int)((double)PollutionConfig.baseMinPollutionPerSecondRocketFuelGenerator * PollutionConfig.pollutionReleasedByTierRocketFuelGenerator[this.mTier]);
        this.pollMax = (int)((double)PollutionConfig.baseMaxPollutionPerSecondRocketFuelGenerator * PollutionConfig.pollutionReleasedByTierRocketFuelGenerator[this.mTier]);
    }

    public MTERocketFuelGeneratorBase(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 3, aDescription, aTextures);
        this.pollMin = (int)((double)PollutionConfig.baseMinPollutionPerSecondRocketFuelGenerator * PollutionConfig.pollutionReleasedByTierRocketFuelGenerator[this.mTier]);
        this.pollMax = (int)((double)PollutionConfig.baseMaxPollutionPerSecondRocketFuelGenerator * PollutionConfig.pollutionReleasedByTierRocketFuelGenerator[this.mTier]);
    }

    @Override
    public ITexture[][][] getTextureSet(ITexture[] aTextures) {
        ITexture[][][] rTextures = new ITexture[10][17][];
        for (byte i = -1; i < 16; i = (byte)(i + 1)) {
            rTextures[0][i + 1] = this.getFront(i);
            rTextures[1][i + 1] = this.getBack(i);
            rTextures[2][i + 1] = this.getBottom(i);
            rTextures[3][i + 1] = this.getTop(i);
            rTextures[4][i + 1] = this.getSides(i);
            rTextures[5][i + 1] = this.getFrontActive(i);
            rTextures[6][i + 1] = this.getBackActive(i);
            rTextures[7][i + 1] = this.getBottomActive(i);
            rTextures[8][i + 1] = this.getTopActive(i);
            rTextures[9][i + 1] = this.getSidesActive(i);
        }
        return rTextures;
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int aColorIndex, boolean aActive, boolean aRedstone) {
        return this.mTextures[(aActive ? 5 : 0) + (side == facing ? 0 : (side == facing.getOpposite() ? 1 : (side == ForgeDirection.DOWN ? 2 : (side == ForgeDirection.UP ? 3 : 4))))][aColorIndex + 1];
    }

    @Override
    public String[] getDescription() {
        String aPollution = "Causes between " + this.pollMin + " and " + this.pollMax + " Pollution per second";
        return (String[])ArrayUtils.addAll((Object[])this.mDescriptionArray, (Object[])new String[]{"Fuel Efficiency: " + this.getEfficiency() + "%", aPollution, GTPPCore.GT_Tooltip.get()});
    }

    @Override
    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        this.openGui(aPlayer);
        return true;
    }

    public ITexture[] getFront(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1]};
    }

    public ITexture[] getBack(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1]};
    }

    public ITexture[] getBottom(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1]};
    }

    public ITexture[] getTop(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1]};
    }

    public ITexture[] getSides(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1]};
    }

    public ITexture[] getFrontActive(byte aColor) {
        return this.getFront(aColor);
    }

    public ITexture[] getBackActive(byte aColor) {
        return this.getBack(aColor);
    }

    public ITexture[] getBottomActive(byte aColor) {
        return this.getBottom(aColor);
    }

    public ITexture[] getTopActive(byte aColor) {
        return this.getTop(aColor);
    }

    public ITexture[] getSidesActive(byte aColor) {
        return this.getSides(aColor);
    }

    @Override
    public boolean isFacingValid(ForgeDirection side) {
        return side.offsetY == 0;
    }

    @Override
    public boolean isValidSlot(int aIndex) {
        return aIndex < 2;
    }

    @Override
    public boolean isEnetOutput() {
        return true;
    }

    @Override
    public boolean isOutputFacing(ForgeDirection side) {
        return this.getBaseMetaTileEntity().getFrontFacing() == side;
    }

    @Override
    public boolean isAccessAllowed(EntityPlayer aPlayer) {
        return true;
    }

    @Override
    public long maxEUOutput() {
        return GTValues.V[this.mTier];
    }

    @Override
    public long maxEUStore() {
        return Math.max(this.getEUVar(), GTValues.V[this.mTier] * 500L + this.getMinimumStoredEU());
    }

    @Override
    public boolean doesFillContainers() {
        return false;
    }

    @Override
    public boolean doesEmptyContainers() {
        return true;
    }

    @Override
    public boolean canTankBeFilled() {
        return true;
    }

    @Override
    public boolean canTankBeEmptied() {
        return false;
    }

    @Override
    public boolean isFluidInputAllowed(FluidStack aFluid) {
        return this.getFuelValue(aFluid) > 0;
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aBaseMetaTileEntity.isServerSide() && aBaseMetaTileEntity.isAllowedToWork() && aTick % 10L == 0L) {
            int tFuelValue;
            if (this.mFluid == null) {
                if (aBaseMetaTileEntity.getUniversalEnergyStored() < this.maxEUOutput() + this.getMinimumStoredEU()) {
                    this.mInventory[this.getStackDisplaySlot()] = null;
                } else {
                    if (this.mInventory[this.getStackDisplaySlot()] == null) {
                        this.mInventory[this.getStackDisplaySlot()] = new ItemStack((Block)Blocks.field_150480_ab, 1);
                    }
                    this.mInventory[this.getStackDisplaySlot()].func_151001_c("Generating: " + (aBaseMetaTileEntity.getUniversalEnergyStored() - this.getMinimumStoredEU()) + " EU");
                }
            } else {
                long tFluidAmountToUse;
                tFuelValue = this.getFuelValue(this.mFluid);
                int tConsumed = this.consumedFluidPerOperation(this.mFluid);
                if (tFuelValue > 0 && tConsumed > 0 && this.mFluid.amount >= tConsumed && (tFluidAmountToUse = Math.min((long)(this.mFluid.amount / tConsumed), (this.maxEUOutput() * 20L + this.getMinimumStoredEU() - aBaseMetaTileEntity.getUniversalEnergyStored()) / (long)tFuelValue)) > 0L && aBaseMetaTileEntity.increaseStoredEnergyUnits(tFluidAmountToUse * (long)tFuelValue, true)) {
                    int aSafeFloor = (int)Math.max(tFluidAmountToUse * (long)tConsumed / 3L, 1L);
                    this.mFluid.amount -= aSafeFloor;
                    Pollution.addPollution(this.getBaseMetaTileEntity(), this.getPollution() / 2);
                }
            }
            if (this.mInventory[this.getInputSlot()] != null && aBaseMetaTileEntity.getUniversalEnergyStored() < this.maxEUOutput() * 20L + this.getMinimumStoredEU() && GTUtility.getFluidForFilledItem(this.mInventory[this.getInputSlot()], true) == null && (tFuelValue = this.getFuelValue(this.mInventory[this.getInputSlot()])) > 0) {
                ItemStack tEmptyContainer = this.getEmptyContainer(this.mInventory[this.getInputSlot()]);
                if (aBaseMetaTileEntity.addStackToSlot(this.getOutputSlot(), tEmptyContainer)) {
                    aBaseMetaTileEntity.increaseStoredEnergyUnits(tFuelValue, true);
                    aBaseMetaTileEntity.func_70298_a(this.getInputSlot(), 1);
                    Pollution.addPollution(this.getBaseMetaTileEntity(), this.getPollution() / 2);
                }
            }
        }
        if (aBaseMetaTileEntity.isServerSide()) {
            aBaseMetaTileEntity.setActive(aBaseMetaTileEntity.isAllowedToWork() && aBaseMetaTileEntity.getUniversalEnergyStored() >= this.maxEUOutput() + this.getMinimumStoredEU());
        }
    }

    public int getPollution() {
        return MathUtils.randInt(this.pollMin, this.pollMax);
    }

    @Override
    public abstract RecipeMap<?> getRecipeMap();

    public abstract int getEfficiency();

    public int consumedFluidPerOperation(FluidStack aLiquid) {
        return 1;
    }

    public int getFuelValue(FluidStack aLiquid) {
        if (aLiquid == null || this.getRecipeMap() == null) {
            return 0;
        }
        Collection<GTRecipe> tRecipeList = this.getRecipeMap().getAllRecipes();
        for (GTRecipe tFuel : tRecipeList) {
            FluidStack tLiquid = tFuel.mFluidInputs[0];
            if (tLiquid == null || !aLiquid.isFluidEqual(tLiquid)) continue;
            int aperOp = this.consumedFluidPerOperation(tLiquid);
            return (int)((long)tFuel.mSpecialValue * (long)this.getEfficiency() * (long)aperOp / 100L);
        }
        return 0;
    }

    public int getFuelValue(ItemStack aStack) {
        if (GTUtility.isStackInvalid(aStack) || this.getRecipeMap() == null) {
            return 0;
        }
        GTRecipe tFuel = this.getRecipeMap().findRecipeQuery().items(aStack).find();
        if (tFuel != null) {
            return (int)((long)tFuel.mSpecialValue * 1000L * (long)this.getEfficiency() / 100L);
        }
        return 0;
    }

    public ItemStack getEmptyContainer(ItemStack aStack) {
        if (GTUtility.isStackInvalid(aStack) || this.getRecipeMap() == null) {
            return null;
        }
        GTRecipe tFuel = this.getRecipeMap().findRecipeQuery().items(aStack).find();
        if (tFuel != null) {
            return GTUtility.copy(tFuel.getOutput(0));
        }
        return GTUtility.getContainerItem(aStack, true);
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return super.allowPutStack(aBaseMetaTileEntity, aIndex, side, aStack) && (this.getFuelValue(aStack) > 0 || this.getFuelValue(GTUtility.getFluidForFilledItem(aStack, true)) > 0);
    }

    @Override
    public int getCapacity() {
        return 32000;
    }
}

