/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base;

import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.drawable.ItemDrawable;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.DrawableWidget;
import com.gtnewhorizons.modularui.common.widget.FakeSyncWidget;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.GTMod;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.StructureError;
import gregtech.api.enums.Textures;
import gregtech.api.gui.modularui.CircularGaugeDrawable;
import gregtech.api.gui.modularui.GTUITextures;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IItemLockable;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.metatileentity.implementations.MTEHatch;
import gregtech.api.metatileentity.implementations.MTEHatchInput;
import gregtech.api.metatileentity.implementations.MTEHatchInputBus;
import gregtech.api.metatileentity.implementations.MTEHatchOutput;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.GTWaila;
import gregtech.api.util.HatchElementBuilder;
import gregtech.api.util.IGTHatchAdder;
import gregtech.api.util.shutdown.ShutDownReasonRegistry;
import gtPlusPlus.core.util.minecraft.FluidUtils;
import gtPlusPlus.xmod.gregtech.api.enums.GregtechItemList;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.MTEHatchSteamBusInput;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.MTEHatchSteamBusOutput;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.GTPPMultiBlockBase;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.MTEHatchCustomFluidBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.SpecialChars;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import tectech.thing.CustomItemList;

public abstract class MTESteamMultiBase<T extends MTESteamMultiBase<T>>
extends GTPPMultiBlockBase<T> {
    public ArrayList<MTEHatchSteamBusInput> mSteamInputs = new ArrayList();
    public ArrayList<MTEHatchSteamBusOutput> mSteamOutputs = new ArrayList();
    public ArrayList<MTEHatchCustomFluidBase> mSteamInputFluids = new ArrayList();
    protected static final String TT_steaminputbus = StatCollector.func_74838_a((String)"GTPP.MBTT.SteamInputBus");
    protected static final String TT_steamoutputbus = StatCollector.func_74838_a((String)"GTPP.MBTT.SteamOutputBus");
    protected static final String TT_steamhatch = StatCollector.func_74838_a((String)"GTPP.MBTT.SteamHatch");
    protected static final String HIGH_PRESSURE_TOOLTIP_NOTICE = "Processing Speed & Steam Consumption is doubled under High Pressure";
    private int uiSteamStored = 0;
    private int uiSteamCapacity = 0;
    private int uiSteamStoredOfAllTypes = 0;

    public MTESteamMultiBase(String aName) {
        super(aName);
    }

    public MTESteamMultiBase(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    @Override
    protected boolean explodesImmediately() {
        return false;
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int aColorIndex, boolean aActive, boolean aRedstone) {
        if (side == facing) {
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(this.getCasingTextureIndex()), aActive ? this.getFrontOverlayActive() : this.getFrontOverlay()};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(this.getCasingTextureIndex())};
    }

    protected abstract ITexture getFrontOverlay();

    protected abstract ITexture getFrontOverlayActive();

    public abstract int getTierRecipes();

    private int getCasingTextureIndex() {
        return 10;
    }

    @Override
    public boolean supportsInputSeparation() {
        return true;
    }

    @Override
    @NotNull
    protected CheckRecipeResult doCheckRecipe() {
        CheckRecipeResult result = CheckRecipeResultRegistry.NO_RECIPE;
        if ((result = this.checkRecipeForCustomHatches(result)).wasSuccessful()) {
            return result;
        }
        this.processingLogic.setInputFluids(this.getStoredFluids());
        if (this.isInputSeparationEnabled()) {
            if (this.mSteamInputs.isEmpty()) {
                CheckRecipeResult foundResult = this.processingLogic.process();
                if (foundResult.wasSuccessful()) {
                    return foundResult;
                }
                if (foundResult != CheckRecipeResultRegistry.NO_RECIPE) {
                    result = foundResult;
                }
            } else {
                for (MTEHatchSteamBusInput bus : this.mSteamInputs) {
                    ArrayList<ItemStack> inputItems = new ArrayList<ItemStack>();
                    for (int i = bus.func_70302_i_() - 1; i >= 0; --i) {
                        ItemStack stored = bus.func_70301_a(i);
                        if (stored == null) continue;
                        inputItems.add(stored);
                    }
                    if (this.canUseControllerSlotForRecipe() && this.getControllerSlot() != null) {
                        inputItems.add(this.getControllerSlot());
                    }
                    this.processingLogic.setInputItems(inputItems);
                    CheckRecipeResult foundResult = this.processingLogic.process();
                    if (foundResult.wasSuccessful()) {
                        return foundResult;
                    }
                    if (foundResult == CheckRecipeResultRegistry.NO_RECIPE) continue;
                    result = foundResult;
                }
            }
        } else {
            ArrayList<ItemStack> inputItems = this.getStoredInputs();
            if (this.canUseControllerSlotForRecipe() && this.getControllerSlot() != null) {
                inputItems.add(this.getControllerSlot());
            }
            this.processingLogic.setInputItems(inputItems);
            CheckRecipeResult foundResult = this.processingLogic.process();
            if (foundResult.wasSuccessful()) {
                return foundResult;
            }
            if (foundResult != CheckRecipeResultRegistry.NO_RECIPE) {
                result = foundResult;
            }
        }
        return result;
    }

    @Override
    protected ProcessingLogic createProcessingLogic() {
        return new ProcessingLogic().setMaxParallelSupplier(this::getTrueParallel);
    }

    protected SteamTypes getSteamType() {
        return SteamTypes.STEAM;
    }

    public ArrayList<FluidStack> getAllSteamStacks() {
        ArrayList<FluidStack> aFluids = new ArrayList<FluidStack>();
        for (FluidStack aFluid : this.getStoredFluids()) {
            if (aFluid.getFluid() != this.getSteamType().fluid) continue;
            aFluids.add(aFluid);
        }
        return aFluids;
    }

    private int getTotalSteamStoredOfAnyType() {
        int aSteam = 0;
        for (FluidStack aFluid : this.getStoredFluids()) {
            if (aFluid == null) continue;
            for (SteamTypes type : SteamTypes.VALUES) {
                if (aFluid.getFluid() != type.fluid) continue;
                aSteam += aFluid.amount;
            }
        }
        return aSteam;
    }

    @Override
    protected void setProcessingLogicPower(ProcessingLogic logic) {
        logic.setAvailableVoltage(GTValues.V[this.getTierRecipes()]);
        logic.setAvailableAmperage(this.getMaxParallelRecipes());
        logic.setAmperageOC(false);
    }

    public int getTotalSteamStored() {
        int aSteam = 0;
        for (FluidStack aFluid : this.getAllSteamStacks()) {
            aSteam += aFluid.amount;
        }
        return aSteam;
    }

    public int getTotalSteamCapacity() {
        int aSteam = 0;
        for (MTEHatchCustomFluidBase tHatch : GTUtility.validMTEList(this.mSteamInputFluids)) {
            aSteam += tHatch.getRealCapacity();
        }
        return aSteam;
    }

    public boolean tryConsumeSteam(int aAmount) {
        if (this.getTotalSteamStored() <= 0) {
            return false;
        }
        return this.depleteInput(new FluidStack(this.getSteamType().fluid, aAmount));
    }

    @Override
    public int getMaxEfficiency(ItemStack arg0) {
        return 0;
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aBaseMetaTileEntity.isServerSide() && (this.mUpdate == 1 || this.mStartUpCheck == 1)) {
            this.mSteamInputs.clear();
            this.mSteamOutputs.clear();
            this.mInputHatches.clear();
            this.mSteamInputFluids.clear();
        }
        super.onPostTick(aBaseMetaTileEntity, aTick);
    }

    @Override
    public boolean onRunningTick(ItemStack aStack) {
        long aSteamVal;
        if (this.lEUt < 0L && !this.tryConsumeSteam((int)(aSteamVal = -this.lEUt * 10000L / (long)Math.max(1000, this.mEfficiency)))) {
            this.stopMachine(ShutDownReasonRegistry.POWER_LOSS);
            return false;
        }
        return true;
    }

    @Override
    public boolean addToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            this.log("Invalid IGregTechTileEntity");
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            this.log("Invalid IMetaTileEntity");
            return false;
        }
        boolean aDidAdd = false;
        if (aMetaTileEntity instanceof MTEHatchCustomFluidBase) {
            this.log("Adding Steam Input Hatch");
            aDidAdd = this.addToMachineListInternal(this.mSteamInputFluids, aMetaTileEntity, aBaseCasingIndex);
        } else if (aMetaTileEntity instanceof MTEHatchSteamBusInput) {
            this.log("Trying to set recipe map. Type: " + (this.getRecipeMap() != null ? this.getRecipeMap().unlocalizedName : "Null"));
            this.resetRecipeMapForHatch(aTileEntity, this.getRecipeMap());
            this.log("Adding Steam Input Bus");
            aDidAdd = this.addToMachineListInternal(this.mSteamInputs, aMetaTileEntity, aBaseCasingIndex);
        } else if (aMetaTileEntity instanceof MTEHatchSteamBusOutput) {
            this.log("Adding Steam Output Bus");
            aDidAdd = this.addToMachineListInternal(this.mSteamOutputs, aMetaTileEntity, aBaseCasingIndex);
        } else if (aMetaTileEntity instanceof MTEHatchInput) {
            aDidAdd = this.addToMachineListInternal(this.mInputHatches, aMetaTileEntity, aBaseCasingIndex);
        } else if (aMetaTileEntity instanceof MTEHatchOutput) {
            // empty if block
        }
        return aDidAdd;
    }

    @Override
    public boolean depleteInput(FluidStack aLiquid) {
        if (aLiquid == null) {
            return false;
        }
        for (MTEHatchCustomFluidBase tHatch : GTUtility.validMTEList(this.mSteamInputFluids)) {
            FluidStack tLiquid = tHatch.getFluid();
            if (tLiquid == null || !tLiquid.isFluidEqual(aLiquid) || (tLiquid = tHatch.drain(aLiquid.amount, false)) == null || tLiquid.amount < aLiquid.amount) continue;
            tLiquid = tHatch.drain(aLiquid.amount, true);
            return tLiquid != null && tLiquid.amount >= aLiquid.amount;
        }
        return false;
    }

    @Override
    public boolean depleteInput(ItemStack aStack) {
        if (GTUtility.isStackInvalid(aStack)) {
            return false;
        }
        FluidStack aLiquid = GTUtility.getFluidForFilledItem(aStack, true);
        if (aLiquid != null) {
            return this.depleteInput(aLiquid);
        }
        for (MTEHatch tHatch : GTUtility.validMTEList(this.mSteamInputFluids)) {
            if (!GTUtility.areStacksEqual(aStack, tHatch.getBaseMetaTileEntity().func_70301_a(0)) || tHatch.getBaseMetaTileEntity().func_70301_a((int)0).field_77994_a < aStack.field_77994_a) continue;
            tHatch.getBaseMetaTileEntity().func_70298_a(0, aStack.field_77994_a);
            return true;
        }
        for (MTEHatch tHatch : GTUtility.validMTEList(this.mSteamInputs)) {
            ((MTEHatchSteamBusInput)tHatch).mRecipeMap = this.getRecipeMap();
            for (int i = tHatch.getBaseMetaTileEntity().func_70302_i_() - 1; i >= 0; --i) {
                if (!GTUtility.areStacksEqual(aStack, tHatch.getBaseMetaTileEntity().func_70301_a(i)) || tHatch.getBaseMetaTileEntity().func_70301_a((int)0).field_77994_a < aStack.field_77994_a) continue;
                tHatch.getBaseMetaTileEntity().func_70298_a(0, aStack.field_77994_a);
                return true;
            }
        }
        return false;
    }

    @Override
    public ArrayList<FluidStack> getStoredFluids() {
        ArrayList<FluidStack> rList = new ArrayList<FluidStack>();
        for (MTEHatchCustomFluidBase tHatch : GTUtility.validMTEList(this.mSteamInputFluids)) {
            if (tHatch.getFillableStack() == null) continue;
            rList.add(tHatch.getFillableStack());
        }
        for (MTEHatchInput hatch : this.mInputHatches) {
            if (hatch.getFillableStack() == null) continue;
            rList.add(hatch.getFillableStack());
        }
        return rList;
    }

    @Override
    public ArrayList<ItemStack> getStoredInputs() {
        ArrayList<ItemStack> rList = new ArrayList<ItemStack>();
        for (MTEHatchSteamBusInput tHatch : GTUtility.validMTEList(this.mSteamInputs)) {
            tHatch.mRecipeMap = this.getRecipeMap();
            for (int i = tHatch.getBaseMetaTileEntity().func_70302_i_() - 1; i >= 0; --i) {
                if (tHatch.getBaseMetaTileEntity().func_70301_a(i) == null) continue;
                rList.add(tHatch.getBaseMetaTileEntity().func_70301_a(i));
            }
        }
        return rList;
    }

    @Override
    public boolean addOutput(ItemStack aStack) {
        if (GTUtility.isStackInvalid(aStack)) {
            return false;
        }
        aStack = GTUtility.copy(aStack);
        List validBusses = GTUtility.filterValidMTEs(this.mSteamOutputs);
        if (this.dumpItem(validBusses, aStack, true, false)) {
            return true;
        }
        if (this.dumpItem(validBusses, aStack, false, false)) {
            return true;
        }
        boolean outputSuccess = true;
        while (outputSuccess && aStack.field_77994_a > 0) {
            outputSuccess = false;
            ItemStack single = aStack.func_77979_a(1);
            for (MTEHatchOutput tHatch : GTUtility.validMTEList(this.mOutputHatches)) {
                if (outputSuccess || !tHatch.outputsItems() || !tHatch.getBaseMetaTileEntity().addStackToSlot(1, single)) continue;
                outputSuccess = true;
            }
        }
        return outputSuccess;
    }

    private boolean dumpItem(List<MTEHatchSteamBusOutput> outputBuses, ItemStack itemStack, boolean restrictiveBusesOnly, boolean simulate) {
        for (MTEHatchSteamBusOutput outputBus : outputBuses) {
            if (restrictiveBusesOnly && !outputBus.isLocked() || !outputBus.storePartial(itemStack, simulate)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ArrayList<ItemStack> getStoredOutputs() {
        ArrayList<ItemStack> rList = new ArrayList<ItemStack>();
        for (MTEHatchSteamBusOutput tHatch : GTUtility.validMTEList(this.mSteamOutputs)) {
            for (int i = tHatch.getBaseMetaTileEntity().func_70302_i_() - 1; i >= 0; --i) {
                rList.add(tHatch.getBaseMetaTileEntity().func_70301_a(i));
            }
        }
        return rList;
    }

    @Override
    public List<ItemStack> getItemOutputSlots(ItemStack[] toOutput) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        for (MTEHatch tBus : GTUtility.validMTEList(this.mSteamOutputs)) {
            IGregTechTileEntity tBusInv = tBus.getBaseMetaTileEntity();
            for (int i = 0; i < tBusInv.func_70302_i_(); ++i) {
                IItemLockable lockable;
                ItemStack stackInSlot = tBus.func_70301_a(i);
                if (stackInSlot == null && tBus instanceof IItemLockable && (lockable = (IItemLockable)((Object)tBus)).isLocked()) {
                    assert (lockable.getLockedItem() != null);
                    ItemStack fakeItemStack = lockable.getLockedItem().func_77946_l();
                    fakeItemStack.field_77994_a = 0;
                    ret.add(fakeItemStack);
                    continue;
                }
                ret.add(stackInSlot);
            }
        }
        return ret;
    }

    @Override
    public void updateSlots() {
        for (MTEHatch tHatch : GTUtility.validMTEList(this.mSteamInputFluids)) {
            ((MTEHatchCustomFluidBase)tHatch).updateSlots();
        }
        for (MTEHatch tHatch : GTUtility.validMTEList(this.mSteamInputs)) {
            ((MTEHatchInputBus)tHatch).updateSlots();
        }
    }

    @Override
    public boolean supportsBatchMode() {
        return false;
    }

    @Override
    public void clearHatches() {
        super.clearHatches();
        this.mInputHatches.clear();
        this.mSteamInputFluids.clear();
        this.mSteamInputs.clear();
        this.mSteamOutputs.clear();
    }

    @Override
    protected void validateStructure(Collection<StructureError> errors, NBTTagCompound context) {
        super.validateStructure(errors, context);
        if (this.mSteamInputFluids.isEmpty()) {
            errors.add(StructureError.MISSING_STEAM_HATCH);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void localizeStructureErrors(Collection<StructureError> errors, NBTTagCompound context, List<String> lines) {
        super.localizeStructureErrors(errors, context, lines);
        if (errors.contains((Object)StructureError.MISSING_STEAM_HATCH)) {
            lines.add(StatCollector.func_74837_a((String)"GT5U.gui.missing_hatch", (Object[])new Object[]{GregtechItemList.Hatch_Input_Steam.get(1L, new Object[0]).func_82833_r()}));
        }
    }

    @Override
    public boolean resetRecipeMapForAllInputHatches(RecipeMap<?> aMap) {
        boolean ret = super.resetRecipeMapForAllInputHatches(aMap);
        for (MTEHatchSteamBusInput hatch : this.mSteamInputs) {
            if (!this.resetRecipeMapForHatch(hatch, aMap)) continue;
            ret = true;
        }
        for (MTEHatchInput g : this.mInputHatches) {
            if (!this.resetRecipeMapForHatch(g, aMap)) continue;
            ret = true;
        }
        return ret;
    }

    @Override
    public void getWailaBody(ItemStack itemStack, List<String> currentTip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        long actualEnergyUsage;
        NBTTagCompound tag = accessor.getNBTData();
        if (tag.func_74767_n("incompleteStructure")) {
            currentTip.add(SpecialChars.RED + StatCollector.func_74837_a((String)"GT5U.waila.multiblock.status.incomplete", (Object[])new Object[0]) + SpecialChars.RESET);
        }
        String efficiency = SpecialChars.RESET + StatCollector.func_74837_a((String)"GT5U.waila.multiblock.status.efficiency", (Object[])new Object[]{Float.valueOf(tag.func_74760_g("efficiency"))});
        if (tag.func_74767_n("hasProblems")) {
            currentTip.add(SpecialChars.RED + StatCollector.func_74838_a((String)"GT5U.waila.multiblock.status.has_problem") + efficiency);
        } else if (!tag.func_74767_n("incompleteStructure")) {
            currentTip.add(SpecialChars.GREEN + StatCollector.func_74838_a((String)"GT5U.waila.multiblock.status.running_fine") + efficiency);
        }
        boolean isActive = tag.func_74767_n("isActive");
        if (isActive && (actualEnergyUsage = tag.func_74763_f("energyUsage")) > 0L) {
            currentTip.add(StatCollector.func_74837_a((String)"GTPP.waila.steam.use", (Object[])new Object[]{GTUtility.formatNumbers(actualEnergyUsage * 20L)}));
        }
        currentTip.add(GTWaila.getMachineProgressString(isActive, tag.func_74767_n("isAllowedToWork"), tag.func_74762_e("maxProgress"), tag.func_74762_e("progress")));
        if (GTMod.gregtechproxy.wailaAverageNS && tag.func_74764_b("averageNS")) {
            int tAverageTime = tag.func_74762_e("averageNS");
            currentTip.add(StatCollector.func_74837_a((String)"GT5U.waila.multiblock.status.cpu_load", (Object[])new Object[]{GTUtility.formatNumbers(tAverageTime)}));
        }
        super.getMTEWailaBody(itemStack, currentTip, accessor, config);
    }

    protected static String getSteamTierTextForWaila(NBTTagCompound tag) {
        int tierMachine = tag.func_74762_e("tierMachine");
        String tierMachineText = tierMachine == 1 ? "Basic" : (tierMachine == 2 ? "High Pressure" : String.valueOf(tierMachine));
        return tierMachineText;
    }

    protected static <T extends MTESteamMultiBase<T>> HatchElementBuilder<T> buildSteamInput(Class<T> typeToken) {
        return GTStructureUtility.buildHatchAdder(typeToken).adder(MTESteamMultiBase::addToMachineList).hatchIds(31040, 15511).shouldReject(t -> !t.mSteamInputFluids.isEmpty());
    }

    @Override
    public boolean getDefaultHasMaintenanceChecks() {
        return false;
    }

    @Override
    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        super.addUIWidgets(builder, buildContext);
        builder.widget((Widget)new FakeSyncWidget.IntegerSyncer(this::getTotalSteamCapacity, val -> {
            this.uiSteamCapacity = val;
        }));
        builder.widget((Widget)new FakeSyncWidget.IntegerSyncer(this::getTotalSteamStored, val -> {
            this.uiSteamStored = val;
        }));
        builder.widget((Widget)new FakeSyncWidget.IntegerSyncer(this::getTotalSteamStoredOfAnyType, val -> {
            this.uiSteamStoredOfAllTypes = val;
        }));
        builder.widget(new DrawableWidget().setDrawable((IDrawable)GTUITextures.STEAM_GAUGE_BG).dynamicTooltip(() -> {
            ArrayList<String> ret = new ArrayList<String>();
            ret.add(this.getSteamType().name + ": " + this.uiSteamStored + "/" + this.uiSteamCapacity + "L");
            if (this.uiSteamStored == 0 && this.uiSteamStoredOfAllTypes != 0) {
                ret.add(EnumChatFormatting.RED + "Found steam of wrong type!");
            }
            return ret;
        }).setTooltipShowUpDelay(5).setUpdateTooltipEveryTick(true).setSize(64, 42).setPos(-64, 100));
        builder.widget(new DrawableWidget().setDrawable((IDrawable)new CircularGaugeDrawable(() -> (float)this.uiSteamStored / (float)this.uiSteamCapacity)).setPos(-43, 121).setSize(18, 4));
        builder.widget(new ItemDrawable(CustomItemList.Fools_FakeItemSiren.get(1L, new Object[0])).asWidget().setPos(-50, 80).setEnabled(w -> this.uiSteamStored == 0 && this.uiSteamStoredOfAllTypes != 0));
    }

    protected static enum SteamTypes {
        STEAM("Steam", FluidUtils.getSteam(1).getFluid()),
        SH_STEAM("Superheated Steam", FluidUtils.getSuperHeatedSteam(1).getFluid()),
        SC_STEAM("Supercritical Steam", FluidRegistry.getFluidStack((String)"supercriticalsteam", (int)1).getFluid());

        static final SteamTypes[] VALUES;
        final String name;
        final Fluid fluid;

        private SteamTypes(String name, Fluid fluid) {
            this.name = name;
            this.fluid = fluid;
        }

        static {
            VALUES = SteamTypes.values();
        }
    }

    protected static enum SteamHatchElement implements IHatchElement<MTESteamMultiBase<?>>
    {
        InputBus_Steam{

            @Override
            public List<? extends Class<? extends IMetaTileEntity>> mteClasses() {
                return Collections.singletonList(MTEHatchSteamBusInput.class);
            }

            @Override
            public long count(MTESteamMultiBase<?> t) {
                return t.mSteamInputs.size();
            }
        }
        ,
        OutputBus_Steam{

            @Override
            public List<? extends Class<? extends IMetaTileEntity>> mteClasses() {
                return Collections.singletonList(MTEHatchSteamBusOutput.class);
            }

            @Override
            public long count(MTESteamMultiBase<?> t) {
                return t.mSteamOutputs.size();
            }
        };


        @Override
        public IGTHatchAdder<? super MTESteamMultiBase<?>> adder() {
            return MTESteamMultiBase::addToMachineList;
        }
    }
}

