/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base;

import com.gtnewhorizons.modularui.common.widget.FluidSlotWidget;
import gregtech.GTMod;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.MTEHatch;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTUtility;
import java.util.ArrayList;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class MTEHatchCustomFluidBase
extends MTEHatch {
    public final Set<Fluid> mLockedFluids;
    public final int mFluidCapacity;
    protected FluidStack mLockedStack = null;
    protected String mTempMod = null;

    public MTEHatchCustomFluidBase(Set<Fluid> aFluids, int aAmount, int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, 3, new String[]{"Fluid Input for Multiblocks", "Capacity: " + GTUtility.formatNumbers(aAmount) + "L"}, new ITexture[0]);
        this.mLockedFluids = aFluids;
        this.mFluidCapacity = aAmount;
    }

    public MTEHatchCustomFluidBase(Set<Fluid> aFluids, int aAmount, String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 3, aDescription, aTextures);
        this.mLockedFluids = aFluids;
        this.mFluidCapacity = aAmount;
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        if (side == aBaseMetaTileEntity.getFrontFacing() && aIndex == 0) {
            FluidStack fs = GTUtility.getFluidForFilledItem(aStack, true);
            return fs != null && this.mLockedFluids.contains(fs.getFluid());
        }
        return false;
    }

    @Override
    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return side == aBaseMetaTileEntity.getFrontFacing() && aIndex == 1;
    }

    @Override
    public ITexture[] getTexturesActive(ITexture aBaseTexture) {
        ITexture[] iTextureArray;
        if (GTMod.gregtechproxy.mRenderIndicatorsOnHatch) {
            ITexture[] iTextureArray2 = new ITexture[3];
            iTextureArray2[0] = aBaseTexture;
            iTextureArray2[1] = TextureFactory.of(Textures.BlockIcons.OVERLAY_PIPE_IN);
            iTextureArray = iTextureArray2;
            iTextureArray2[2] = TextureFactory.of(Textures.BlockIcons.FLUID_STEAM_IN_SIGN);
        } else {
            ITexture[] iTextureArray3 = new ITexture[2];
            iTextureArray3[0] = aBaseTexture;
            iTextureArray = iTextureArray3;
            iTextureArray3[1] = TextureFactory.of(Textures.BlockIcons.OVERLAY_PIPE_IN);
        }
        return iTextureArray;
    }

    @Override
    public ITexture[] getTexturesInactive(ITexture aBaseTexture) {
        ITexture[] iTextureArray;
        if (GTMod.gregtechproxy.mRenderIndicatorsOnHatch) {
            ITexture[] iTextureArray2 = new ITexture[3];
            iTextureArray2[0] = aBaseTexture;
            iTextureArray2[1] = TextureFactory.of(Textures.BlockIcons.OVERLAY_PIPE_IN);
            iTextureArray = iTextureArray2;
            iTextureArray2[2] = TextureFactory.of(Textures.BlockIcons.FLUID_STEAM_IN_SIGN);
        } else {
            ITexture[] iTextureArray3 = new ITexture[2];
            iTextureArray3[0] = aBaseTexture;
            iTextureArray = iTextureArray3;
            iTextureArray3[1] = TextureFactory.of(Textures.BlockIcons.OVERLAY_PIPE_IN);
        }
        return iTextureArray;
    }

    @Override
    public boolean isFacingValid(ForgeDirection facing) {
        return true;
    }

    @Override
    public boolean isAccessAllowed(EntityPlayer aPlayer) {
        return true;
    }

    @Override
    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        this.openGui(aPlayer);
        return true;
    }

    @Override
    public boolean doesFillContainers() {
        return false;
    }

    @Override
    public boolean doesEmptyContainers() {
        return true;
    }

    @Override
    public boolean canTankBeFilled() {
        return true;
    }

    @Override
    public boolean canTankBeEmptied() {
        return true;
    }

    public void updateSlots() {
        if (this.mInventory[this.getInputSlot()] != null && this.mInventory[this.getInputSlot()].field_77994_a <= 0) {
            this.mInventory[this.getInputSlot()] = null;
        }
    }

    @Override
    public int getCapacity() {
        return this.mFluidCapacity;
    }

    @Override
    public String[] getDescription() {
        if (this.mLockedFluids == null) {
            return new String[]{"INVALID HATCH. ASSIGN LOCKED FLUIDS"};
        }
        ArrayList<String> desc = new ArrayList<String>();
        desc.add("Fluid Input for Multiblocks");
        desc.add("Capacity: " + this.getCapacity() + "L");
        desc.add("Accepts Fluids: ");
        for (Fluid allowed : this.mLockedFluids) {
            desc.add("-" + allowed.getLocalizedName(new FluidStack(allowed, 1)));
        }
        return desc.toArray(new String[0]);
    }

    @Override
    public boolean isFluidInputAllowed(FluidStack aFluid) {
        for (Fluid allowed : this.mLockedFluids) {
            if (!allowed.getName().equals(aFluid.getFluid().getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEHatchCustomFluidBase(this.mLockedFluids, this.mFluidCapacity, this.mName, this.mTier, this.mDescriptionArray, this.mTextures);
    }

    @Override
    protected FluidSlotWidget createFluidSlot() {
        return super.createFluidSlot().setFilter(this.mLockedFluids::contains);
    }
}

