/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.api.metatileentity.implementations;

import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.forge.ItemHandlerHelper;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import gregtech.GTMod;
import gregtech.api.enums.Textures;
import gregtech.api.gui.widgets.PhantomItemButton;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IItemLockable;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.MTEHatch;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTUtility;
import gtPlusPlus.core.lib.GTPPCore;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.Nullable;

public class MTEHatchSteamBusOutput
extends MTEHatch
implements IItemLockable {
    protected ItemStack lockedItem = null;
    private static final String LOCKED_ITEM_NBT_KEY = "lockedItem";

    public MTEHatchSteamBusOutput(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, MTEHatchSteamBusOutput.getSlots(aTier), new String[]{"Item Output for Steam Multiblocks", aTier == 0 ? "Does not automatically export items" : EnumChatFormatting.BOLD + "DOES" + EnumChatFormatting.RESET + EnumChatFormatting.GRAY + " automatically export items", "Capacity: " + MTEHatchSteamBusOutput.getSlots(aTier + 1) + " stacks", "Does not work with non-steam multiblocks", GTPPCore.GT_Tooltip.get()}, new ITexture[0]);
    }

    public MTEHatchSteamBusOutput(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, MTEHatchSteamBusOutput.getSlots(aTier + 1), aDescription, aTextures);
    }

    @Override
    public ITexture[] getTexturesActive(ITexture aBaseTexture) {
        ITexture[] iTextureArray;
        if (GTMod.gregtechproxy.mRenderIndicatorsOnHatch) {
            ITexture[] iTextureArray2 = new ITexture[3];
            iTextureArray2[0] = aBaseTexture;
            iTextureArray2[1] = TextureFactory.of(Textures.BlockIcons.OVERLAY_PIPE_OUT);
            iTextureArray = iTextureArray2;
            iTextureArray2[2] = TextureFactory.of(Textures.BlockIcons.ITEM_OUT_SIGN);
        } else {
            ITexture[] iTextureArray3 = new ITexture[2];
            iTextureArray3[0] = aBaseTexture;
            iTextureArray = iTextureArray3;
            iTextureArray3[1] = TextureFactory.of(Textures.BlockIcons.OVERLAY_PIPE_OUT);
        }
        return iTextureArray;
    }

    @Override
    public ITexture[] getTexturesInactive(ITexture aBaseTexture) {
        ITexture[] iTextureArray;
        if (GTMod.gregtechproxy.mRenderIndicatorsOnHatch) {
            ITexture[] iTextureArray2 = new ITexture[3];
            iTextureArray2[0] = aBaseTexture;
            iTextureArray2[1] = TextureFactory.of(Textures.BlockIcons.OVERLAY_PIPE_OUT);
            iTextureArray = iTextureArray2;
            iTextureArray2[2] = TextureFactory.of(Textures.BlockIcons.ITEM_OUT_SIGN);
        } else {
            ITexture[] iTextureArray3 = new ITexture[2];
            iTextureArray3[0] = aBaseTexture;
            iTextureArray = iTextureArray3;
            iTextureArray3[1] = TextureFactory.of(Textures.BlockIcons.OVERLAY_PIPE_OUT);
        }
        return iTextureArray;
    }

    @Override
    public boolean isFacingValid(ForgeDirection facing) {
        return true;
    }

    @Override
    public boolean isValidSlot(int aIndex) {
        return true;
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEHatchSteamBusOutput(this.mName, this.mTier, this.mDescriptionArray, this.mTextures);
    }

    @Override
    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        this.openGui(aPlayer);
        return true;
    }

    @Override
    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return side == aBaseMetaTileEntity.getFrontFacing();
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return false;
    }

    public boolean canPush() {
        return this.mTier > 0;
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        IInventory tTileEntity;
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (aBaseMetaTileEntity.isServerSide() && aBaseMetaTileEntity.isAllowedToWork() && (aTick & 7L) == 0L && this.canPush() && (tTileEntity = aBaseMetaTileEntity.getIInventoryAtSide(aBaseMetaTileEntity.getFrontFacing())) != null) {
            GTUtility.moveMultipleItemStacks(aBaseMetaTileEntity, tTileEntity, aBaseMetaTileEntity.getFrontFacing(), aBaseMetaTileEntity.getBackFacing(), null, false, (byte)64, (byte)1, (byte)64, (byte)1, this.mInventory.length);
            for (int i = 0; i < this.mInventory.length; ++i) {
                if (this.mInventory[i] == null || this.mInventory[i].field_77994_a > 0) continue;
                this.mInventory[i] = null;
            }
        }
    }

    @Override
    public ITexture[][][] getTextureSet(ITexture[] aTextures) {
        ITexture[][][] rTextures = new ITexture[14][17][];
        for (byte c = -1; c < 16; c = (byte)(c + 1)) {
            if (rTextures[0][c + 1] == null) {
                rTextures[0][c + 1] = this.getSideFacingActive(c);
            }
            if (rTextures[1][c + 1] == null) {
                rTextures[1][c + 1] = this.getSideFacingInactive(c);
            }
            if (rTextures[2][c + 1] == null) {
                rTextures[2][c + 1] = this.getFrontFacingActive(c);
            }
            if (rTextures[3][c + 1] == null) {
                rTextures[3][c + 1] = this.getFrontFacingInactive(c);
            }
            if (rTextures[4][c + 1] == null) {
                rTextures[4][c + 1] = this.getTopFacingActive(c);
            }
            if (rTextures[5][c + 1] == null) {
                rTextures[5][c + 1] = this.getTopFacingInactive(c);
            }
            if (rTextures[6][c + 1] == null) {
                rTextures[6][c + 1] = this.getBottomFacingActive(c);
            }
            if (rTextures[7][c + 1] == null) {
                rTextures[7][c + 1] = this.getBottomFacingInactive(c);
            }
            if (rTextures[8][c + 1] == null) {
                rTextures[8][c + 1] = this.getBottomFacingPipeActive(c);
            }
            if (rTextures[9][c + 1] == null) {
                rTextures[9][c + 1] = this.getBottomFacingPipeInactive(c);
            }
            if (rTextures[10][c + 1] == null) {
                rTextures[10][c + 1] = this.getTopFacingPipeActive(c);
            }
            if (rTextures[11][c + 1] == null) {
                rTextures[11][c + 1] = this.getTopFacingPipeInactive(c);
            }
            if (rTextures[12][c + 1] == null) {
                rTextures[12][c + 1] = this.getSideFacingPipeActive(c);
            }
            if (rTextures[13][c + 1] != null) continue;
            rTextures[13][c + 1] = this.getSideFacingPipeInactive(c);
        }
        return rTextures;
    }

    public ITexture[] getSideFacingActive(byte aColor) {
        return new ITexture[]{TextureFactory.of(this.mTier == 1 ? Textures.BlockIcons.MACHINE_BRONZEBRICKS_SIDE : Textures.BlockIcons.MACHINE_BRONZE_SIDE)};
    }

    public ITexture[] getSideFacingInactive(byte aColor) {
        return new ITexture[]{TextureFactory.of(this.mTier == 1 ? Textures.BlockIcons.MACHINE_BRONZEBRICKS_SIDE : Textures.BlockIcons.MACHINE_BRONZE_SIDE)};
    }

    public ITexture[] getFrontFacingActive(byte aColor) {
        return new ITexture[]{TextureFactory.of(this.mTier == 1 ? Textures.BlockIcons.MACHINE_BRONZEBRICKS_SIDE : Textures.BlockIcons.MACHINE_BRONZE_SIDE)};
    }

    public ITexture[] getFrontFacingInactive(byte aColor) {
        return new ITexture[]{TextureFactory.of(this.mTier == 1 ? Textures.BlockIcons.MACHINE_BRONZEBRICKS_SIDE : Textures.BlockIcons.MACHINE_BRONZE_SIDE)};
    }

    public ITexture[] getTopFacingActive(byte aColor) {
        return new ITexture[]{TextureFactory.of(this.mTier == 1 ? Textures.BlockIcons.MACHINE_BRONZEBRICKS_TOP : Textures.BlockIcons.MACHINE_BRONZE_TOP)};
    }

    public ITexture[] getTopFacingInactive(byte aColor) {
        return new ITexture[]{TextureFactory.of(this.mTier == 1 ? Textures.BlockIcons.MACHINE_BRONZEBRICKS_TOP : Textures.BlockIcons.MACHINE_BRONZE_TOP)};
    }

    public ITexture[] getBottomFacingActive(byte aColor) {
        return new ITexture[]{TextureFactory.of(this.mTier == 1 ? Textures.BlockIcons.MACHINE_BRONZEBRICKS_BOTTOM : Textures.BlockIcons.MACHINE_BRONZE_BOTTOM)};
    }

    public ITexture[] getBottomFacingInactive(byte aColor) {
        return new ITexture[]{TextureFactory.of(this.mTier == 1 ? Textures.BlockIcons.MACHINE_BRONZEBRICKS_BOTTOM : Textures.BlockIcons.MACHINE_BRONZE_BOTTOM)};
    }

    public ITexture[] getBottomFacingPipeActive(byte aColor) {
        return new ITexture[]{TextureFactory.of(this.mTier == 1 ? Textures.BlockIcons.MACHINE_BRONZEBRICKS_BOTTOM : Textures.BlockIcons.MACHINE_BRONZE_BOTTOM), TextureFactory.of(Textures.BlockIcons.OVERLAY_PIPE_OUT)};
    }

    public ITexture[] getBottomFacingPipeInactive(byte aColor) {
        return new ITexture[]{TextureFactory.of(this.mTier == 1 ? Textures.BlockIcons.MACHINE_BRONZEBRICKS_BOTTOM : Textures.BlockIcons.MACHINE_BRONZE_BOTTOM), TextureFactory.of(Textures.BlockIcons.OVERLAY_PIPE_OUT)};
    }

    public ITexture[] getTopFacingPipeActive(byte aColor) {
        return new ITexture[]{TextureFactory.of(this.mTier == 1 ? Textures.BlockIcons.MACHINE_BRONZEBRICKS_TOP : Textures.BlockIcons.MACHINE_BRONZE_TOP), TextureFactory.of(Textures.BlockIcons.OVERLAY_PIPE_OUT)};
    }

    public ITexture[] getTopFacingPipeInactive(byte aColor) {
        return new ITexture[]{TextureFactory.of(this.mTier == 1 ? Textures.BlockIcons.MACHINE_BRONZEBRICKS_TOP : Textures.BlockIcons.MACHINE_BRONZE_TOP), TextureFactory.of(Textures.BlockIcons.OVERLAY_PIPE_OUT)};
    }

    public ITexture[] getSideFacingPipeActive(byte aColor) {
        return new ITexture[]{TextureFactory.of(this.mTier == 1 ? Textures.BlockIcons.MACHINE_BRONZEBRICKS_SIDE : Textures.BlockIcons.MACHINE_BRONZE_SIDE), TextureFactory.of(Textures.BlockIcons.OVERLAY_PIPE_OUT)};
    }

    public ITexture[] getSideFacingPipeInactive(byte aColor) {
        return new ITexture[]{TextureFactory.of(this.mTier == 1 ? Textures.BlockIcons.MACHINE_BRONZEBRICKS_SIDE : Textures.BlockIcons.MACHINE_BRONZE_SIDE), TextureFactory.of(Textures.BlockIcons.OVERLAY_PIPE_OUT)};
    }

    @Override
    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        switch (this.mTier) {
            case 0: {
                this.getBaseMetaTileEntity().add2by2Slots(builder, new IDrawable[0]);
                break;
            }
            case 1: {
                this.getBaseMetaTileEntity().add3by3Slots(builder, new IDrawable[0]);
                break;
            }
            case 2: {
                this.getBaseMetaTileEntity().add4by4Slots(builder, new IDrawable[0]);
                break;
            }
            default: {
                this.getBaseMetaTileEntity().add1by1Slot(builder, new IDrawable[0]);
            }
        }
        if (this.acceptsItemLock()) {
            builder.widget(new PhantomItemButton(this).setPos(this.getGUIWidth() - 25, 40).setBackground(PhantomItemButton.FILTER_BACKGROUND));
        }
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        if (this.lockedItem != null) {
            aNBT.func_74782_a(LOCKED_ITEM_NBT_KEY, (NBTBase)this.lockedItem.func_77955_b(new NBTTagCompound()));
        }
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        if (aNBT.func_74764_b(LOCKED_ITEM_NBT_KEY)) {
            this.lockedItem = ItemStack.func_77949_a((NBTTagCompound)aNBT.func_74775_l(LOCKED_ITEM_NBT_KEY));
        }
    }

    @Override
    public void setLockedItem(@Nullable ItemStack itemStack) {
        if (itemStack == null) {
            this.clearLock();
        } else {
            this.lockedItem = ItemHandlerHelper.copyStackWithSize((ItemStack)itemStack, (int)1);
        }
    }

    @Override
    @Nullable
    public ItemStack getLockedItem() {
        return this.lockedItem;
    }

    @Override
    public void clearLock() {
        this.lockedItem = null;
    }

    @Override
    public boolean isLocked() {
        return this.lockedItem != null;
    }

    @Override
    public boolean acceptsItemLock() {
        return true;
    }

    public boolean storePartial(ItemStack aStack) {
        return this.storePartial(aStack, false);
    }

    public boolean storePartial(ItemStack stack, boolean simulate) {
        this.func_70296_d();
        if (this.lockedItem != null && !this.lockedItem.func_77969_a(stack)) {
            return false;
        }
        int invLength = this.mInventory.length;
        for (int i = 0; i < invLength && stack.field_77994_a > 0; ++i) {
            ItemStack slot = this.mInventory[i];
            if (!GTUtility.isStackInvalid(slot) && !GTUtility.areStacksEqual(slot, stack)) continue;
            int inSlot = slot == null ? 0 : slot.field_77994_a;
            int toInsert = Math.min(Math.min(this.func_70297_j_(), stack.func_77976_d() - inSlot), stack.field_77994_a);
            if (toInsert == 0) continue;
            if (!simulate) {
                if (GTUtility.isStackInvalid(slot)) {
                    this.mInventory[i] = slot = stack.func_77979_a(0);
                }
                slot.field_77994_a += toInsert;
            }
            stack.field_77994_a -= toInsert;
        }
        return stack.field_77994_a == 0;
    }
}

