/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.api.metatileentity.implementations;

import com.gtnewhorizons.modularui.api.forge.IItemHandlerModifiable;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import gregtech.api.enums.GTValues;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.MTEHatch;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTUtility;
import gtPlusPlus.core.lib.GTPPCore;
import gtPlusPlus.xmod.gregtech.api.gui.widget.ElectricSlotWidget;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.commons.lang3.ArrayUtils;

public class MTEHatchOutputBattery
extends MTEHatch {
    public MTEHatchOutputBattery(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, MTEHatchOutputBattery.getSlots(aTier), "Dischargeable Item Bus for Multiblocks", new ITexture[0]);
    }

    public MTEHatchOutputBattery(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, aTier < 1 ? 1 : (aTier == 1 ? 4 : (aTier == 2 ? 9 : 16)), aDescription, aTextures);
    }

    @Override
    public String[] getDescription() {
        int mSlots = 0;
        mSlots = this.mTier == 2 ? 4 : (this.mTier == 4 ? 16 : 16);
        return (String[])ArrayUtils.addAll((Object[])this.mDescriptionArray, (Object[])new String[]{"Capacity: " + mSlots + " slots", GTPPCore.GT_Tooltip.get()});
    }

    @Override
    public boolean isEnetOutput() {
        return true;
    }

    @Override
    public boolean isOutputFacing(ForgeDirection side) {
        return side == this.getBaseMetaTileEntity().getFrontFacing();
    }

    @Override
    public long getMinimumStoredEU() {
        return 0L;
    }

    @Override
    public long maxEUOutput() {
        return GTValues.V[this.mTier];
    }

    @Override
    public long maxEUStore() {
        return 512L + GTValues.V[this.mTier + 1] * 8L;
    }

    @Override
    public ITexture[] getTexturesActive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, TextureFactory.of(TexturesGtBlock.Overlay_Hatch_Discharger)};
    }

    @Override
    public ITexture[] getTexturesInactive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, TextureFactory.of(TexturesGtBlock.Overlay_Hatch_Discharger)};
    }

    @Override
    public boolean isFacingValid(ForgeDirection facing) {
        return true;
    }

    @Override
    public boolean isAccessAllowed(EntityPlayer aPlayer) {
        return true;
    }

    @Override
    public boolean isValidSlot(int aIndex) {
        return true;
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEHatchOutputBattery(this.mName, this.mTier, this.mDescriptionArray, this.mTextures);
    }

    @Override
    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        this.openGui(aPlayer);
        return true;
    }

    @Override
    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return side == aBaseMetaTileEntity.getFrontFacing();
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return side == aBaseMetaTileEntity.getFrontFacing();
    }

    public void updateSlots() {
        for (int i = 0; i < this.mInventory.length; ++i) {
            if (this.mInventory[i] == null || this.mInventory[i].field_77994_a > 0) continue;
            this.mInventory[i] = null;
        }
        this.fillStacksIntoFirstSlots();
    }

    protected void fillStacksIntoFirstSlots() {
        for (int i = 0; i < this.mInventory.length; ++i) {
            for (int j = i + 1; j < this.mInventory.length; ++j) {
                if (this.mInventory[j] == null || this.mInventory[i] != null && !GTUtility.areStacksEqual(this.mInventory[i], this.mInventory[j])) continue;
                GTUtility.moveStackFromSlotAToSlotB((IInventory)this.getBaseMetaTileEntity(), (IInventory)this.getBaseMetaTileEntity(), j, i, (byte)64, (byte)1, (byte)64, (byte)1);
            }
        }
    }

    @Override
    public int rechargerSlotStartIndex() {
        return 0;
    }

    @Override
    public int rechargerSlotCount() {
        return 0;
    }

    @Override
    public int dechargerSlotStartIndex() {
        return 0;
    }

    @Override
    public int dechargerSlotCount() {
        return this.mTier == 2 ? 4 : 16;
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTimer) {
        MetaTileEntity mMetaTileEntity;
        IMetaTileEntity iMetaTileEntity;
        if (aBaseMetaTileEntity.isServerSide() && aBaseMetaTileEntity.hasInventoryBeenModified()) {
            this.fillStacksIntoFirstSlots();
        }
        if (aBaseMetaTileEntity.isServerSide() && (iMetaTileEntity = aBaseMetaTileEntity.getMetaTileEntity()) instanceof MetaTileEntity && (mMetaTileEntity = (MetaTileEntity)iMetaTileEntity).dechargerSlotCount() > 0 && mMetaTileEntity.getEUVar() < aBaseMetaTileEntity.getEUCapacity()) {
            int i;
            int k = mMetaTileEntity.dechargerSlotCount() + i;
            for (i = mMetaTileEntity.dechargerSlotStartIndex(); i < k; ++i) {
                if (mMetaTileEntity.mInventory[i] == null || mMetaTileEntity.getEUVar() >= aBaseMetaTileEntity.getEUCapacity()) continue;
                aBaseMetaTileEntity.increaseStoredEnergyUnits(GTModHandler.dischargeElectricItem(mMetaTileEntity.mInventory[i], (int)Math.min(GTValues.V[this.mTier] * 15L, aBaseMetaTileEntity.getEUCapacity() - aBaseMetaTileEntity.getStoredEU()), (int)Math.min(Integer.MAX_VALUE, mMetaTileEntity.getInputTier()), true, false, false), true);
                if (mMetaTileEntity.mInventory[i].field_77994_a > 0) continue;
                mMetaTileEntity.mInventory[i] = null;
            }
        }
        super.onPostTick(aBaseMetaTileEntity, aTimer);
    }

    @Override
    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        if (this.mTier == 2) {
            for (int i = 0; i < 4; ++i) {
                builder.widget(new ElectricSlotWidget((IItemHandlerModifiable)this.inventoryHandler, i).setPos(70 + i % 2 * 18, 25 + i / 2 * 18));
            }
        } else {
            for (int i = 0; i < 16; ++i) {
                builder.widget(new ElectricSlotWidget((IItemHandlerModifiable)this.inventoryHandler, i).setPos(52 + i % 4 * 18, 7 + i / 4 * 18));
            }
        }
    }
}

