/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.api.metatileentity.implementations;

import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.factory.PosGuiData;
import com.cleanroommc.modularui.screen.ModularPanel;
import com.cleanroommc.modularui.utils.item.IItemHandler;
import com.cleanroommc.modularui.value.sync.PanelSyncManager;
import com.cleanroommc.modularui.widgets.ItemSlot;
import com.cleanroommc.modularui.widgets.slot.ModularSlot;
import com.gtnewhorizons.modularui.api.forge.IItemHandlerModifiable;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.common.widget.SlotGroup;
import gregtech.api.enums.ItemList;
import gregtech.api.gui.modularui.GTUITextures;
import gregtech.api.interfaces.IConfigurationCircuitSupport;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.MTEHatch;
import gregtech.api.modularui2.GTGuiTextures;
import gregtech.api.modularui2.GTGuis;
import gregtech.api.render.TextureFactory;
import gregtech.common.modularui2.util.CommonGuiComponents;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.lib.GTPPCore;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public class MTEHatchElementalDataOrbHolder
extends MTEHatch
implements IConfigurationCircuitSupport {
    public MTEHatchElementalDataOrbHolder(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, 17, new String[]{"Holds Data Orbs for the Elemental Duplicator", "Can insert/extract the circuit slot", "A circuit must be used to select a slot (1-16)", GTPPCore.GT_Tooltip.get()}, new ITexture[0]);
    }

    public MTEHatchElementalDataOrbHolder(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 17, aDescription, aTextures);
    }

    @Override
    public ITexture[] getTexturesActive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, TextureFactory.of(TexturesGtBlock.Overlay_Hatch_Data_Orb)};
    }

    @Override
    public ITexture[] getTexturesInactive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, TextureFactory.of(TexturesGtBlock.Overlay_Hatch_Data_Orb)};
    }

    @Override
    public boolean isFacingValid(ForgeDirection facing) {
        return true;
    }

    @Override
    public boolean isAccessAllowed(EntityPlayer aPlayer) {
        return true;
    }

    @Override
    public boolean isValidSlot(int aIndex) {
        return true;
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEHatchElementalDataOrbHolder(this.mName, this.mTier, this.mDescriptionArray, this.mTextures);
    }

    @Override
    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        this.openGui(aPlayer);
        return true;
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTimer) {
        if (aBaseMetaTileEntity.isServerSide() && aBaseMetaTileEntity.hasInventoryBeenModified()) {
            this.fillStacksIntoFirstSlots();
        }
    }

    public void updateSlots() {
        for (int i = 0; i < this.mInventory.length - 1; ++i) {
            if (this.mInventory[i] == null || this.mInventory[i].field_77994_a > 0) continue;
            this.mInventory[i] = null;
        }
        this.fillStacksIntoFirstSlots();
    }

    protected void fillStacksIntoFirstSlots() {
        for (int i = 0; i < this.mInventory.length - 1; ++i) {
            if (this.mInventory[i] == null || this.mInventory[i].field_77994_a > 0) continue;
            this.mInventory[i] = null;
        }
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
    }

    @Override
    public void onScrewdriverRightClick(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ) {
    }

    @Override
    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        Logger.INFO("Checking if we can pull " + aStack.func_82833_r() + " from slot " + aIndex);
        return aIndex == this.mInventory.length - 1 && ItemUtils.isControlCircuit(aStack) && side == this.getBaseMetaTileEntity().getFrontFacing();
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        Logger.INFO("Checking if we can put " + aStack.func_82833_r() + " into slot " + aIndex);
        return aIndex == this.mInventory.length - 1 && ItemUtils.isControlCircuit(aStack) && side == this.getBaseMetaTileEntity().getFrontFacing();
    }

    public ArrayList<ItemStack> getInventory() {
        ArrayList<ItemStack> aContents = new ArrayList<ItemStack>();
        for (int i = this.getBaseMetaTileEntity().func_70302_i_() - 2; i >= 0; --i) {
            if (this.getBaseMetaTileEntity().func_70301_a(i) == null) continue;
            aContents.add(this.getBaseMetaTileEntity().func_70301_a(i));
        }
        return aContents;
    }

    public ItemStack getOrbByCircuit() {
        ItemStack aCirc = this.getBaseMetaTileEntity().func_70301_a(this.getCircuitSlot());
        if (ItemUtils.isControlCircuit(aCirc)) {
            int slot = aCirc.func_77960_j() - 1;
            if (slot < this.getBaseMetaTileEntity().func_70302_i_() - 1) {
                return this.getBaseMetaTileEntity().func_70301_a(slot);
            }
            return null;
        }
        return null;
    }

    @Override
    public boolean func_102007_a(int aIndex, ItemStack aStack, int ordinalSide) {
        if (aIndex == this.mInventory.length - 1 && ItemUtils.isControlCircuit(aStack) && ordinalSide == this.getBaseMetaTileEntity().getFrontFacing().ordinal()) {
            Logger.INFO("Putting " + aStack.func_82833_r() + " into slot " + aIndex);
            return true;
        }
        return false;
    }

    @Override
    public boolean func_102008_b(int aIndex, ItemStack aStack, int ordinalSide) {
        if (aIndex == this.mInventory.length - 1 && ItemUtils.isControlCircuit(aStack)) {
            Logger.INFO("Pulling " + aStack.func_82833_r() + " from slot " + aIndex);
            return true;
        }
        return false;
    }

    @Override
    public boolean allowSelectCircuit() {
        return true;
    }

    @Override
    public int getCircuitSlot() {
        return MTEHatchElementalDataOrbHolder.getSlots(this.mTier);
    }

    @Override
    public int getCircuitSlotX() {
        return 153;
    }

    @Override
    public int getCircuitSlotY() {
        return 63;
    }

    @Override
    protected boolean useMui2() {
        return true;
    }

    @Override
    public ModularPanel buildUI(PosGuiData data, PanelSyncManager syncManager) {
        syncManager.registerSlotGroup("item_inv", 4);
        return (ModularPanel)GTGuis.mteTemplatePanelBuilder(this, data, syncManager).build().child((IWidget)CommonGuiComponents.gridTemplate4by4(index -> new ItemSlot().slot(new ModularSlot((IItemHandler)this.inventoryHandler, index).slotGroup("item_inv").filter(stack -> ItemList.Tool_DataOrb.isStackEqual(stack, false, true))).background(new IDrawable[]{GTGuiTextures.SLOT_ITEM_STANDARD, GTGuiTextures.OVERLAY_SLOT_DATA_ORB})));
    }

    @Override
    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        builder.widget(SlotGroup.ofItemHandler((IItemHandlerModifiable)this.inventoryHandler, (int)4).startFromSlot(0).endAtSlot(15).background(new com.gtnewhorizons.modularui.api.drawable.IDrawable[]{this.getGUITextureSet().getItemSlot(), GTUITextures.OVERLAY_SLOT_DATA_ORB}).applyForWidget(widget -> widget.setFilter(stack -> ItemList.Tool_DataOrb.isStackEqual(stack, false, true))).build().setPos(52, 7));
    }
}

