/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.tileentities.general;

import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.inventories.InventoryVolumetricFlaskSetter;
import gtPlusPlus.core.util.minecraft.PlayerUtils;
import gtPlusPlus.xmod.gregtech.common.helpers.VolumetricFlaskHelper;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.FluidStack;

public class TileEntityVolumetricFlaskSetter
extends TileEntity
implements ISidedInventory {
    private int tickCount = 0;
    private final InventoryVolumetricFlaskSetter inventoryContents = new InventoryVolumetricFlaskSetter();
    private String customName;
    public int locationX;
    public int locationY;
    public int locationZ;
    private int aCurrentMode = 0;
    private int aCustomValue = 1000;

    public TileEntityVolumetricFlaskSetter() {
        this.setTileLocation();
    }

    public int getCustomValue() {
        return this.aCustomValue;
    }

    public void setCustomValue(int aVal) {
        this.log("Old Value: " + this.aCustomValue);
        this.aCustomValue = aVal;
        this.log("New Value: " + this.aCustomValue);
        this.func_70296_d();
    }

    public boolean setTileLocation() {
        if (this.func_145830_o() && !this.func_145831_w().field_72995_K) {
            this.locationX = this.field_145851_c;
            this.locationY = this.field_145848_d;
            this.locationZ = this.field_145849_e;
            return true;
        }
        return false;
    }

    public final boolean hasFlask() {
        for (int i = 0; i < this.getInventory().getInventory().length - 1; ++i) {
            if (i == 8 || this.getInventory().getInventory()[i] == null) continue;
            return true;
        }
        return false;
    }

    public InventoryVolumetricFlaskSetter getInventory() {
        return this.inventoryContents;
    }

    private int getFlaskType(ItemStack aStack) {
        if (VolumetricFlaskHelper.isNormalVolumetricFlask(aStack)) {
            return 1;
        }
        if (VolumetricFlaskHelper.isLargeVolumetricFlask(aStack)) {
            return 2;
        }
        if (VolumetricFlaskHelper.isGiganticVolumetricFlask(aStack)) {
            return 3;
        }
        if (VolumetricFlaskHelper.isKleinBottle(aStack)) {
            return 4;
        }
        return 0;
    }

    private int getCapacityForSlot(int aSlot) {
        int n;
        switch (aSlot) {
            case 0: {
                n = 16;
                break;
            }
            case 1: {
                n = 36;
                break;
            }
            case 2: {
                n = 144;
                break;
            }
            case 3: {
                n = 432;
                break;
            }
            case 4: {
                n = 576;
                break;
            }
            case 5: {
                n = 720;
                break;
            }
            case 6: {
                n = 864;
                break;
            }
            case 7: {
                n = this.getCustomValue();
                break;
            }
            default: {
                n = 1000;
            }
        }
        return n;
    }

    public boolean addOutput() {
        if (!this.hasFlask()) {
            Logger.INFO("No Flasks.");
            return false;
        }
        ItemStack[] aInputs = (ItemStack[])this.getInventory().getInventory().clone();
        boolean hasOutput = false;
        if (aInputs[8] != null) {
            hasOutput = true;
            if (aInputs[8].field_77994_a >= 16) {
                return false;
            }
        }
        ArrayList<Integer> aValidSlots = new ArrayList<Integer>();
        int aSlotCount = 0;
        for (ItemStack i : aInputs) {
            if (i != null) {
                aValidSlots.add(aSlotCount);
            }
            ++aSlotCount;
        }
        Iterator iterator = aValidSlots.iterator();
        while (iterator.hasNext()) {
            Object aOutput;
            int e = (Integer)iterator.next();
            if (e == 7 && this.getCustomValue() <= 0) {
                this.log("Skipping Custom slot as value <= 0");
                continue;
            }
            if (e == 8) continue;
            boolean doAdd = false;
            ItemStack g = this.func_70301_a(e);
            FluidStack aInputFluidStack = VolumetricFlaskHelper.getFlaskFluid(g);
            int aSize = 0;
            ItemStack aInputStack = null;
            int aTypeInSlot = this.getFlaskType(g);
            if (aTypeInSlot <= 0 || g == null) continue;
            if (!hasOutput) {
                aSize = g.field_77994_a;
                doAdd = true;
            } else {
                ItemStack f = aInputs[8];
                FluidStack aFluidInCheckedSlot = VolumetricFlaskHelper.getFlaskFluid(f);
                int aTypeInCheckedSlot = this.getFlaskType(f);
                if (aTypeInCheckedSlot > 0 && aTypeInSlot == aTypeInCheckedSlot && f != null && g.func_77973_b() == f.func_77973_b() && VolumetricFlaskHelper.getFlaskCapacity(f) == this.getCapacityForSlot(e) && (aInputFluidStack == null && aFluidInCheckedSlot == null || aInputFluidStack.isFluidEqual(aFluidInCheckedSlot))) {
                    this.log("Input Slot Flask Contains: " + (aInputFluidStack != null ? aInputFluidStack.getLocalizedName() : "Empty"));
                    this.log("Output Slot Flask Contains: " + (aFluidInCheckedSlot != null ? aFluidInCheckedSlot.getLocalizedName() : "Empty"));
                    aSize = f.field_77994_a + g.field_77994_a;
                    if (aSize > 16) {
                        aInputStack = g.func_77946_l();
                        aInputStack.field_77994_a = aSize - 16;
                    }
                    doAdd = true;
                }
            }
            if (!doAdd) continue;
            FluidStack aOutputFluid = null;
            if (!VolumetricFlaskHelper.isFlaskEmpty(g)) {
                aOutputFluid = aInputFluidStack.copy();
            }
            if ((aOutput = aTypeInSlot == 1 ? VolumetricFlaskHelper.getVolumetricFlask(1) : (aTypeInSlot == 2 ? VolumetricFlaskHelper.getLargeVolumetricFlask(1) : (aTypeInSlot == 3 ? VolumetricFlaskHelper.getGiganticVolumetricFlask(1) : (aTypeInSlot == 4 ? VolumetricFlaskHelper.getKleinBottle(1) : null)))) == null) continue;
            aOutput.field_77994_a = aSize;
            int aCapacity = this.getCapacityForSlot(e);
            VolumetricFlaskHelper.setNewFlaskCapacity(aOutput, aCapacity);
            if (aOutputFluid != null) {
                if (aOutputFluid.amount > aCapacity) {
                    aOutputFluid.amount = aCapacity;
                }
                VolumetricFlaskHelper.setFluid(aOutput, aOutputFluid);
            }
            this.func_70299_a(e, aInputStack);
            this.func_70299_a(8, (ItemStack)aOutput);
            return true;
        }
        return false;
    }

    public void func_145845_h() {
        try {
            if (!this.field_145850_b.field_72995_K) {
                if (this.tickCount % 10 == 0 && this.hasFlask()) {
                    this.addOutput();
                    this.func_70296_d();
                }
                ++this.tickCount;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public boolean anyPlayerInRange() {
        return this.field_145850_b.func_72977_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, 32.0) != null;
    }

    public NBTTagCompound getTag(NBTTagCompound nbt, String tag) {
        if (!nbt.func_74764_b(tag)) {
            nbt.func_74782_a(tag, (NBTBase)new NBTTagCompound());
        }
        return nbt.func_74775_l(tag);
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        NBTTagCompound chestData = new NBTTagCompound();
        this.inventoryContents.writeToNBT(chestData);
        nbt.func_74782_a("ContentsChest", (NBTBase)chestData);
        nbt.func_74768_a("aCustomValue", this.aCustomValue);
        if (this.func_145818_k_()) {
            nbt.func_74778_a("CustomName", this.getCustomName());
        }
        nbt.func_74768_a("aCurrentMode", this.aCurrentMode);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.inventoryContents.readFromNBT(nbt.func_74775_l("ContentsChest"));
        this.aCustomValue = nbt.func_74762_e("aCustomValue");
        if (nbt.func_150297_b("CustomName", 8)) {
            this.setCustomName(nbt.func_74779_i("CustomName"));
        }
        this.aCurrentMode = nbt.func_74762_e("aCurrentMode");
    }

    public int func_70302_i_() {
        return this.getInventory().func_70302_i_();
    }

    public ItemStack func_70301_a(int slot) {
        return this.getInventory().func_70301_a(slot);
    }

    public ItemStack func_70298_a(int slot, int count) {
        return this.getInventory().func_70298_a(slot, count);
    }

    public ItemStack func_70304_b(int slot) {
        return this.getInventory().func_70304_b(slot);
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.getInventory().func_70299_a(slot, stack);
    }

    public int func_70297_j_() {
        return this.getInventory().func_70297_j_();
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return this.getInventory().func_70300_a(entityplayer);
    }

    public void func_70295_k_() {
        this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q(), 1, 1);
        this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q());
        this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e, this.func_145838_q());
        this.getInventory().func_70295_k_();
    }

    public void func_70305_f() {
        this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q(), 1, 1);
        this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q());
        this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e, this.func_145838_q());
        this.getInventory().func_70305_f();
    }

    public boolean func_94041_b(int slot, ItemStack itemstack) {
        return this.getInventory().func_94041_b(slot, itemstack);
    }

    public int[] func_94128_d(int p_94128_1_) {
        int[] accessibleSides = new int[this.func_70302_i_()];
        for (int r = 0; r < this.getInventory().func_70302_i_(); ++r) {
            accessibleSides[r] = r;
        }
        return accessibleSides;
    }

    public boolean func_102007_a(int aSlot, ItemStack p_102007_2_, int p_102007_3_) {
        return aSlot == this.aCurrentMode;
    }

    public boolean func_102008_b(int aSlot, ItemStack p_102008_2_, int p_102008_3_) {
        return aSlot == 8;
    }

    public String getCustomName() {
        return this.customName;
    }

    public void setCustomName(String customName) {
        this.customName = customName;
    }

    public String func_145825_b() {
        return this.func_145818_k_() ? this.customName : "container.VolumetricFlaskSetter";
    }

    public boolean func_145818_k_() {
        return this.customName != null && !this.customName.isEmpty();
    }

    public Packet func_145844_m() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_145841_b(tag);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145847_g, tag);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        NBTTagCompound tag = pkt.func_148857_g();
        this.func_145839_a(tag);
    }

    public boolean onScrewdriverRightClick(byte side, EntityPlayer player, int x, int y, int z) {
        if (player.func_70093_af()) {
            PlayerUtils.messagePlayer(player, "Value: " + this.getCustomValue());
        }
        try {
            this.aCurrentMode = this.aCurrentMode == 7 ? 0 : ++this.aCurrentMode;
            PlayerUtils.messagePlayer(player, "Slot " + this.aCurrentMode + " is now default.");
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public void log(String aString) {
        Logger.INFO("[Flask-Tile] " + aString);
    }
}

