/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.item.bauble;

import baubles.api.BaubleType;
import cofh.api.energy.IEnergyContainerItem;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.Mods;
import gregtech.common.config.OPStuff;
import gtPlusPlus.core.creative.AddToCreativeTab;
import gtPlusPlus.core.item.bauble.ElectricBaseBauble;
import gtPlusPlus.xmod.gregtech.common.helpers.ChargingHelper;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class BatteryPackBaseBauble
extends ElectricBaseBauble {
    public BatteryPackBaseBauble(int tier) {
        super(BaubleType.BELT, tier, GTValues.V[tier] * 20L * 300L, "GTPP.BattPack.0" + tier + ".name");
        String aUnlocalName = "GTPP.BattPack.0" + tier + ".name";
        this.func_77637_a(AddToCreativeTab.tabMachines);
        if (GameRegistry.findItem((String)Mods.GTPlusPlus.ID, (String)aUnlocalName) == null) {
            GameRegistry.registerItem((Item)this, (String)aUnlocalName);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs par2CreativeTabs, List<ItemStack> itemList) {
        ItemStack charged;
        ItemStack itemStack = new ItemStack((Item)this, 1);
        if (this.getEmptyItem(itemStack) == this) {
            charged = new ItemStack((Item)this, 1);
            ElectricItem.manager.charge(charged, 0.0, Integer.MAX_VALUE, true, false);
            itemList.add(charged);
        }
        if (this.getChargedItem(itemStack) == this) {
            charged = new ItemStack((Item)this, 1);
            ElectricItem.manager.charge(charged, Double.POSITIVE_INFINITY, Integer.MAX_VALUE, true, false);
            itemList.add(charged);
        }
    }

    @Override
    public void func_77663_a(ItemStack itemStack, World worldObj, Entity player, int p_77663_4_, boolean p_77663_5_) {
        super.func_77663_a(itemStack, worldObj, player, p_77663_4_, p_77663_5_);
    }

    @Override
    public String func_77653_i(ItemStack p_77653_1_) {
        return EnumChatFormatting.BLUE + super.func_77653_i(p_77653_1_) + EnumChatFormatting.GRAY;
    }

    @Override
    public void func_77624_a(ItemStack stack, EntityPlayer aPlayer, List<String> list, boolean bool) {
        list.add("");
        String aString1 = StatCollector.func_74838_a((String)"GTPP.battpack.tooltip.1");
        String aString2 = StatCollector.func_74838_a((String)"GTPP.battpack.tooltip.2");
        String aString3 = StatCollector.func_74838_a((String)"GTPP.battpack.tooltip.3");
        String aString4 = StatCollector.func_74838_a((String)"GTPP.battpack.tooltip.4");
        String aEU = StatCollector.func_74838_a((String)"GTPP.info.eu");
        String aEUT = aEU + "/t";
        list.add(EnumChatFormatting.GREEN + aString1 + EnumChatFormatting.GRAY);
        list.add(EnumChatFormatting.GREEN + aString2 + " " + (int)this.getTransferLimit(stack) + aEUT + " " + aString3 + EnumChatFormatting.GRAY);
        list.add(EnumChatFormatting.GREEN + aString4 + EnumChatFormatting.GRAY);
        super.func_77624_a(stack, aPlayer, list, bool);
    }

    @Override
    public String getToolTip(ItemStack stack) {
        return ElectricItem.manager.getToolTip(stack);
    }

    @Override
    public boolean canEquip(ItemStack arg0, EntityLivingBase arg1) {
        return true;
    }

    @Override
    public boolean canUnequip(ItemStack arg0, EntityLivingBase arg1) {
        return true;
    }

    @Override
    public void onEquipped(ItemStack arg0, EntityLivingBase arg1) {
    }

    @Override
    public void onUnequipped(ItemStack arg0, EntityLivingBase arg1) {
    }

    @Override
    public void onWornTick(ItemStack aBaubleStack, EntityLivingBase aLivingBase) {
        if (!aLivingBase.field_70170_p.field_72995_K) {
            try {
                if (this.getCharge(aBaubleStack) >= this.getTransferLimit(aBaubleStack) && aLivingBase instanceof EntityPlayer) {
                    EntityPlayer aPlayer = (EntityPlayer)aLivingBase;
                    ItemStack[] inv = aPlayer.field_71071_by.field_70460_b;
                    this.chargeInventory(inv, inv.length, aBaubleStack);
                    inv = aPlayer.field_71071_by.field_70462_a;
                    this.chargeInventory(inv, InventoryPlayer.func_70451_h(), aBaubleStack);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private void chargeInventory(ItemStack[] inventory, int endIndex, ItemStack aBaubleStack) {
        for (int i = 0; i < endIndex && i < inventory.length; ++i) {
            ItemStack aInvStack = inventory[i];
            if (aInvStack != null && aInvStack != aBaubleStack) {
                Item aItem = aInvStack.func_77973_b();
                if (ChargingHelper.isItemValid(aInvStack)) {
                    IElectricItem electricItem = (IElectricItem)aItem;
                    if (electricItem != null) {
                        double d;
                        double aTransferRate = electricItem.getTransferLimit(aInvStack);
                        double aItemCharge = ElectricItem.manager.getCharge(aInvStack);
                        if (aItemCharge >= 0.0 && aItemCharge != electricItem.getMaxCharge(aInvStack) && aItemCharge <= electricItem.getMaxCharge(aInvStack) - aTransferRate && ElectricItem.manager.getCharge(aBaubleStack) >= aTransferRate && ElectricItem.manager.getCharge(aInvStack) <= electricItem.getMaxCharge(aInvStack) - aTransferRate && (d = ElectricItem.manager.charge(aInvStack, aTransferRate * 16.0, this.mTier, false, true)) > 0.0) {
                            d = ElectricItem.manager.charge(aInvStack, aTransferRate * 16.0, this.mTier, false, false);
                            ElectricItem.manager.discharge(aBaubleStack, d, this.mTier, false, true, false);
                        }
                    }
                } else if (OPStuff.outputRF && aItem instanceof IEnergyContainerItem) {
                    IEnergyContainerItem energyItem = (IEnergyContainerItem)aItem;
                    int aItemCharge = energyItem.getEnergyStored(aInvStack);
                    int aItemMaxCharge = energyItem.getMaxEnergyStored(aInvStack);
                    double aBaubleCharge = ElectricItem.manager.getCharge(aBaubleStack);
                    if (aItemCharge >= 0 && aItemCharge < aItemMaxCharge && aBaubleCharge > 0.0) {
                        int aMaxChargeAmount = aItemMaxCharge - aItemCharge;
                        double aMaxChargeAmountInEU = Math.ceil((double)aMaxChargeAmount * 100.0 / (double)OPStuff.howMuchRFWith100EUInInput);
                        double aActualChargeInEU = Math.min(aBaubleCharge, aMaxChargeAmountInEU);
                        int aActualCharge = (int)Math.floor(aActualChargeInEU * (double)OPStuff.howMuchRFWith100EUInInput / 100.0);
                        int aCharged = energyItem.receiveEnergy(aInvStack, aActualCharge, false);
                        double aDischarge = Math.ceil((double)aCharged * 100.0 / (double)OPStuff.howMuchRFWith100EUInInput);
                        ElectricItem.manager.discharge(aBaubleStack, aDischarge, this.mTier, false, true, false);
                    }
                }
            }
            if (this.getCharge(aBaubleStack) <= 0.0) break;
        }
    }

    @Override
    public String getTextureNameForBauble() {
        return "chargepack/" + this.mTier;
    }
}

