/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.item.base;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.covers.CoverRegistry;
import gregtech.api.enums.Mods;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.TextureSet;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTLanguageManager;
import gregtech.api.util.GTOreDictUnificator;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.config.Configuration;
import gtPlusPlus.core.creative.AddToCreativeTab;
import gtPlusPlus.core.lib.GTPPCore;
import gtPlusPlus.core.material.Material;
import gtPlusPlus.core.util.Utils;
import gtPlusPlus.core.util.data.StringUtils;
import gtPlusPlus.core.util.math.MathUtils;
import gtPlusPlus.core.util.minecraft.EntityUtils;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.core.util.sys.KeyboardUtils;
import java.awt.Color;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class BaseItemComponent
extends Item {
    private static final Class<TextureSet> mTextureSetPreload = TextureSet.class;
    public final Material componentMaterial;
    public final String materialName;
    public final String unlocalName;
    public final String translatedMaterialName;
    public final ComponentTypes componentType;
    public final int componentColour;
    public Object extraData;
    protected IIcon base;
    protected IIcon overlay;

    public BaseItemComponent(Material material, ComponentTypes componentType) {
        this.componentMaterial = material;
        this.unlocalName = "item" + componentType.COMPONENT_NAME + material.getUnlocalizedName();
        this.materialName = material.getLocalizedName();
        this.translatedMaterialName = material.getTranslatedName();
        this.componentType = componentType;
        this.func_77637_a(AddToCreativeTab.tabMisc);
        this.func_77655_b(this.unlocalName);
        this.func_77625_d(64);
        this.componentColour = material.getRgbAsHex();
        GameRegistry.registerItem((Item)this, (String)this.unlocalName);
        GTOreDictUnificator.registerOre(componentType.getOreDictName() + material.getUnlocalizedName(), ItemUtils.getSimpleStack(this));
        if (componentType == ComponentTypes.GEAR) {
            GTOreDictUnificator.registerOre("gear" + material.getUnlocalizedName(), ItemUtils.getSimpleStack(this));
        }
        this.registerComponent();
        GTLanguageManager.addStringLocalization("gtplusplus.item." + this.unlocalName + ".name", this.getFormattedLangName());
    }

    public BaseItemComponent(String unlocalName, String localName, short[] RGBA) {
        String aFormattedNameForFluids = unlocalName.contains(".") ? StringUtils.splitAndUppercase(unlocalName, ".") : unlocalName;
        Material aTempMaterial = Material.mMaterialCache.get(localName.toLowerCase());
        Logger.INFO("Attempted to get " + localName + " cell material from cache. Valid? " + (aTempMaterial != null));
        this.componentMaterial = aTempMaterial;
        this.unlocalName = "itemCell" + aFormattedNameForFluids;
        this.materialName = localName;
        this.translatedMaterialName = this.getFluidName("fluid." + this.materialName.toLowerCase().replace(" ", ""));
        this.componentType = ComponentTypes.CELL;
        this.func_77637_a(AddToCreativeTab.tabMisc);
        this.func_77655_b(aFormattedNameForFluids);
        this.func_77625_d(64);
        this.componentColour = MathUtils.getRgbAsHex(RGBA);
        this.extraData = RGBA;
        this.func_111206_d(Mods.GTPlusPlus.ID + ":item" + ComponentTypes.CELL.COMPONENT_NAME);
        GameRegistry.registerItem((Item)this, (String)aFormattedNameForFluids);
        GTOreDictUnificator.registerOre(ComponentTypes.CELL.getOreDictName() + Utils.sanitizeStringKeepBrackets(localName), ItemUtils.getSimpleStack(this));
        this.registerComponent();
        GTLanguageManager.addStringLocalization("gtplusplus.item." + this.unlocalName + ".name", this.getFormattedLangName());
    }

    private String getFormattedLangName() {
        return this.componentType.getName().replace("@", "%material");
    }

    public boolean registerComponent() {
        String aKey;
        ItemStack x;
        if (this.componentMaterial == null) {
            return false;
        }
        Map<String, ItemStack> aMap = Material.mComponentMap.get(this.componentMaterial.getUnlocalizedName());
        if (aMap == null) {
            aMap = new HashMap<String, ItemStack>();
        }
        if ((x = aMap.get(aKey = this.componentType.getGtOrePrefix().name())) == null) {
            aMap.put(aKey, ItemUtils.getSimpleStack(this));
            Logger.MATERIALS("Registering a material component. Item: [" + this.componentMaterial.getUnlocalizedName() + "] Map: [" + aKey + "]");
            Material.mComponentMap.put(this.componentMaterial.getUnlocalizedName(), aMap);
            if (this.componentType == ComponentTypes.PLATE) {
                CoverRegistry.registerDecorativeCover(this.componentMaterial.getPlate(1), TextureFactory.of(this.componentMaterial.getTextureSet().mTextures[71], this.componentMaterial.getRGBA(), false));
            } else if (this.componentType == ComponentTypes.PLATEDOUBLE) {
                CoverRegistry.registerDecorativeCover(this.componentMaterial.getPlateDouble(1), TextureFactory.of(this.componentMaterial.getTextureSet().mTextures[72], this.componentMaterial.getRGBA(), false));
            }
            return true;
        }
        Logger.MATERIALS("Tried to double register a material component. ");
        return false;
    }

    public String getCorrectTextures() {
        TextureSet u;
        if (!Configuration.visual.useGregtechTextures) {
            return Mods.GTPlusPlus.ID + ":item" + this.componentType.COMPONENT_NAME;
        }
        String metType = "9j4852jyo3rjmh3owlhw9oe";
        if (this.componentMaterial != null && (u = this.componentMaterial.getTextureSet()) != null) {
            metType = u.mSetName;
        }
        metType = metType.equals("9j4852jyo3rjmh3owlhw9oe") ? "METALLIC" : metType;
        return Mods.GregTech.ID + ":materialicons/" + metType + "/" + this.componentType.getOreDictName();
    }

    public final String getMaterialName() {
        return this.materialName;
    }

    public String getFluidName(String aKey) {
        String trans = GTLanguageManager.getTranslation(aKey);
        if (!trans.equals(aKey)) {
            return trans;
        }
        aKey = "fluid." + aKey;
        trans = GTLanguageManager.getTranslation(aKey);
        if (!trans.equals(aKey)) {
            return trans;
        }
        return GTLanguageManager.addStringLocalization("gtplusplus.fluid." + this.materialName.toLowerCase().replace(" ", ""), this.materialName);
    }

    public String func_77653_i(ItemStack stack) {
        return GTLanguageManager.getTranslation("gtplusplus.item." + this.unlocalName + ".name").replace("%s", "%temp").replace("%material", this.translatedMaterialName).replace("%temp", "%s");
    }

    public final void func_77624_a(ItemStack stack, EntityPlayer aPlayer, List list, boolean bool) {
        try {
            if (this.componentMaterial != null || this.materialName != null) {
                // empty if block
            }
            if (this.materialName != null && !this.materialName.isEmpty() && this.componentMaterial != null) {
                if (this.componentMaterial != null) {
                    if (!this.componentMaterial.vChemicalFormula.contains("?")) {
                        list.add(Utils.sanitizeStringKeepBrackets(this.componentMaterial.vChemicalFormula));
                    } else if (this.componentMaterial.vChemicalFormula.contains("?")) {
                        String temp = this.componentMaterial.vChemicalFormula;
                        temp = temp.replace(" ", "");
                        temp = temp.replace("-", "");
                        temp = temp.replace("_", "");
                        temp = temp.replace("!", "");
                        temp = temp.replace("@", "");
                        temp = temp.replace("#", "");
                        temp = temp.replace(" ", "");
                        list.add(temp);
                    }
                    if (this.componentMaterial.isRadioactive) {
                        list.add(GTPPCore.GT_Tooltip_Radioactive.get());
                    }
                    if ((this.componentType == ComponentTypes.INGOT || this.componentType == ComponentTypes.HOTINGOT) && this.unlocalName.toLowerCase().contains("hot")) {
                        list.add(StatCollector.func_74838_a((String)"gtpp.tooltip.ingot.very_hot"));
                    }
                } else {
                    String aChemicalFormula = Material.sChemicalFormula.get(this.materialName.toLowerCase());
                    if (aChemicalFormula != null && !aChemicalFormula.isEmpty()) {
                        list.add(Utils.sanitizeStringKeepBrackets(aChemicalFormula));
                    }
                }
                if (KeyboardUtils.isCtrlKeyDown()) {
                    if (this.componentMaterial != null) {
                        String type = this.componentMaterial.getTextureSet().mSetName;
                        String output = type.substring(0, 1).toUpperCase() + type.substring(1);
                        list.add(EnumChatFormatting.GRAY + StatCollector.func_74837_a((String)"GTPP.tooltip.material.type", (Object[])new Object[]{output}));
                        list.add(EnumChatFormatting.GRAY + StatCollector.func_74837_a((String)"GTPP.tooltip.material.state", (Object[])new Object[]{this.componentMaterial.getState().name()}));
                        list.add(EnumChatFormatting.GRAY + StatCollector.func_74837_a((String)"GTPP.tooltip.material.radioactivity", (Object[])new Object[]{this.componentMaterial.vRadiationLevel}));
                    }
                } else {
                    list.add(EnumChatFormatting.DARK_GRAY + StatCollector.func_74838_a((String)"GTPP.tooltip.hold_ctrl"));
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        super.func_77624_a(stack, aPlayer, list, bool);
    }

    public void func_77663_a(ItemStack iStack, World world, Entity entityHolding, int p_77663_4_, boolean p_77663_5_) {
        if (this.componentMaterial != null && entityHolding instanceof EntityPlayer && !((EntityPlayer)entityHolding).field_71075_bZ.field_75098_d) {
            EntityUtils.applyRadiationDamageToEntity(iStack.field_77994_a, this.componentMaterial.vRadiationLevel, world, entityHolding);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return Configuration.visual.useGregtechTextures;
    }

    public int func_82790_a(ItemStack stack, int renderPass) {
        if (this.componentType == ComponentTypes.CELL || this.componentType == ComponentTypes.PLASMACELL) {
            if (renderPass == 0 && !Configuration.visual.useGregtechTextures) {
                return Utils.rgbtoHexValue(255, 255, 255);
            }
            if (renderPass == 1 && Configuration.visual.useGregtechTextures) {
                return Utils.rgbtoHexValue(255, 255, 255);
            }
        }
        try {
            if (this.componentMaterial == null) {
                if (this.extraData != null && Short.TYPE.isInstance(this.extraData)) {
                    short[] abc = (short[])this.extraData;
                    return Utils.rgbtoHexValue(abc[0], abc[1], abc[2]);
                }
                return this.componentColour;
            }
            if (this.componentMaterial.getRGBA()[3] <= 1) {
                return this.componentColour;
            }
            if (this.componentMaterial.getRGBA()[3] == 2) {
                int currentFrame = (int)(System.nanoTime() % 4000000000L / 20000000L);
                int value = currentFrame < 50 ? currentFrame + 1 : (currentFrame < 100 ? 50 : (currentFrame < 150 ? 149 - currentFrame : 0));
                return Utils.rgbtoHexValue(Math.min(255, Math.max(this.componentMaterial.getRGBA()[0] + value, 0)), Math.min(255, Math.max(this.componentMaterial.getRGBA()[1] + value, 0)), Math.min(255, Math.max(this.componentMaterial.getRGBA()[2] + value, 0)));
            }
            if (this.componentMaterial.getRGBA()[3] == 3) {
                return Color.HSBtoRGB((float)(System.nanoTime() % 8000000000L) / 8.0E9f, 1.0f, 1.0f);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return this.componentColour;
    }

    public IIcon func_77618_c(int damage, int pass) {
        if (Configuration.visual.useGregtechTextures) {
            if (pass == 0) {
                return this.base;
            }
            return this.overlay;
        }
        return this.base;
    }

    public void func_94581_a(IIconRegister i) {
        if (Configuration.visual.useGregtechTextures) {
            this.base = i.func_94245_a(this.getCorrectTextures());
            this.overlay = i.func_94245_a(this.getCorrectTextures() + "_OVERLAY");
        } else {
            this.base = i.func_94245_a(this.getCorrectTextures());
        }
    }

    public static enum ComponentTypes {
        DUST("Dust", "@ Dust", "dust", OrePrefixes.dust),
        DUSTSMALL("DustSmall", "Small Pile of @ Dust", "dustSmall", OrePrefixes.dustSmall),
        DUSTTINY("DustTiny", "Tiny Pile of @ Dust", "dustTiny", OrePrefixes.dustTiny),
        INGOT("Ingot", "@ Ingot", "ingot", OrePrefixes.ingot),
        HOTINGOT("HotIngot", "Hot @ Ingot", "ingotHot", OrePrefixes.ingotHot),
        PLATE("Plate", "@ Plate", "plate", OrePrefixes.plate),
        PLATEDOUBLE("PlateDouble", "Double @ Plate", "plateDouble", OrePrefixes.plateDouble),
        ROD("Rod", "@ Rod", "stick", OrePrefixes.stick),
        RODLONG("RodLong", "Long @ Rod", "stickLong", OrePrefixes.stickLong),
        GEAR("Gear", "@ Gear", "gearGt", OrePrefixes.gearGt),
        SMALLGEAR("SmallGear", "Small @ Gear", "gearGtSmall", OrePrefixes.gearGtSmall),
        SCREW("Screw", "@ Screw", "screw", OrePrefixes.screw),
        BOLT("Bolt", "@ Bolt", "bolt", OrePrefixes.bolt),
        ROTOR("Rotor", "@ Rotor", "rotor", OrePrefixes.rotor),
        RING("Ring", "@ Ring", "ring", OrePrefixes.ring),
        FOIL("Foil", "@ Foil", "foil", OrePrefixes.foil),
        PLASMACELL("CellPlasma", "@ Plasma Cell", "cellPlasma", OrePrefixes.cellPlasma),
        CELL("Cell", "@ Cell", "cell", OrePrefixes.cell),
        NUGGET("Nugget", "@ Nugget", "nugget", OrePrefixes.nugget),
        SPRING("Spring", "@ Spring", "spring", OrePrefixes.spring),
        SMALLSPRING("SmallSpring", "Small @ Spring", "springSmall", OrePrefixes.springSmall),
        FINEWIRE("FineWire", "Fine @ Wire", "wireFine", OrePrefixes.wireFine),
        PLATEDENSE("PlateDense", "Dense @ Plate", "plateDense", OrePrefixes.plateDense),
        PLATESUPERDENSE("PlateSuperDense", "Superdense @ Plate", "plateSuperdense", OrePrefixes.plateSuperdense);

        private final String COMPONENT_NAME;
        private final String DISPLAY_NAME;
        private final String OREDICT_NAME;
        private final OrePrefixes a_GT_EQUAL;

        private ComponentTypes(String LocalName, String DisplayName, String OreDictName, OrePrefixes aPrefix) {
            this.COMPONENT_NAME = LocalName;
            this.DISPLAY_NAME = DisplayName;
            this.OREDICT_NAME = OreDictName;
            this.a_GT_EQUAL = aPrefix;
        }

        public String getComponent() {
            return this.COMPONENT_NAME;
        }

        public String getName() {
            return this.DISPLAY_NAME;
        }

        public String getOreDictName() {
            return this.OREDICT_NAME;
        }

        public OrePrefixes getGtOrePrefix() {
            return this.a_GT_EQUAL;
        }
    }
}

