/*
 * Decompiled with CFR 0.152.
 */
package gregtech.mixin;

import bartworks.common.configs.Configuration;
import cpw.mods.fml.relauncher.FMLLaunchHandler;
import gregtech.common.config.Gregtech;
import gregtech.common.pollution.PollutionConfig;
import gregtech.mixin.TargetedMod;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public enum Mixin {
    SoundManagerMixin(new Builder("Seeking sound playback").addMixinClasses("minecraft.SoundManagerMixin", "minecraft.SoundManagerInnerMixin").addTargetedMod(TargetedMod.VANILLA).setApplyIf(() -> true).setPhase(Phase.EARLY).setSide(Side.CLIENT)),
    WorldMixin(new Builder("Block update detection").addMixinClasses("minecraft.WorldMixin").addTargetedMod(TargetedMod.VANILLA).setApplyIf(() -> true).setPhase(Phase.EARLY).setSide(Side.BOTH)),
    StringTranslateMixin(new Builder("Keep track of currently translating mods").addMixinClasses("minecraft.StringTranslateMixin", "minecraft.LanguageRegistryMixin").addTargetedMod(TargetedMod.VANILLA).setApplyIf(() -> true).setPhase(Phase.EARLY).setSide(Side.BOTH)),
    LocaleMixin(new Builder("Keep track of currently translating client mods").addMixinClasses("minecraft.LocaleMixin").addTargetedMod(TargetedMod.VANILLA).setApplyIf(() -> true).setPhase(Phase.EARLY).setSide(Side.CLIENT)),
    CacheCraftingManagerRecipes(new Builder("Cache CraftingManager recipes").addMixinClasses("minecraft.CraftingManagerMixin").addTargetedMod(TargetedMod.VANILLA).setApplyIf(() -> Configuration.mixins.enableCraftingManagerRecipeCaching).setPhase(Phase.EARLY).setSide(Side.BOTH)),
    VanillaAccessors(new Builder("Adds various accessors").addMixinClasses("minecraft.accessors.BlockStemMixin", "minecraft.accessors.ChunkCacheMixin", "minecraft.accessors.VanillaShapedRecipeMixin", "minecraft.accessors.VanillaShapelessRecipeMixin", "minecraft.accessors.ForgeShapedRecipeMixin", "minecraft.accessors.ForgeShapelessRecipeMixin", "minecraft.accessors.PotionMixin", "minecraft.accessors.EntityPlayerMPMixin").addTargetedMod(TargetedMod.VANILLA).setApplyIf(() -> true).setPhase(Phase.EARLY).setSide(Side.BOTH)),
    ItemMixinCoverFix(new Builder("Allow cover items to bypass sneak checks").addMixinClasses("minecraft.ItemMixin").addTargetedMod(TargetedMod.VANILLA).setApplyIf(() -> true).setPhase(Phase.EARLY).setSide(Side.BOTH)),
    VanillaToolChanges(new Builder("Changes wooden tools to be a little faster").addMixinClasses("minecraft.ItemToolMaterialMixin").addTargetedMod(TargetedMod.VANILLA).setApplyIf(() -> Gregtech.general.changedWoodenVanillaTools).setPhase(Phase.EARLY).setSide(Side.BOTH)),
    IC2_MACHINE_WRENCHING(new Builder("Changes the behavior of the wrenching mechanic for IC2 machines").addMixinClasses("ic2.MixinDamageDropped", "ic2.MixinHarvestTool", "ic2.MixinItemDropped").addTargetedMod(TargetedMod.IC2).setApplyIf(() -> true).setPhase(Phase.LATE).setSide(Side.BOTH)),
    IC2_HAZMAT(new Builder("Hazmat").setPhase(Phase.LATE).setSide(Side.BOTH).addMixinClasses("ic2.MixinIc2Hazmat").setApplyIf(() -> true).addTargetedMod(TargetedMod.IC2).addExcludedMod(TargetedMod.GT6)),
    POLLUTION_RENDER_BLOCKS(new Builder("Changes colors of certain blocks based on pollution levels").addMixinClasses("minecraft.pollution.MixinRenderBlocks_PollutionWithoutOptifine").addTargetedMod(TargetedMod.VANILLA).addExcludedMod(TargetedMod.OPTIFINE).setSide(Side.CLIENT).setApplyIf(() -> PollutionConfig.pollution && PollutionConfig.pollutionBlockRecolor).setPhase(Phase.EARLY)),
    POLLUTION_RENDER_BLOCKS_OPTIFINE(new Builder("Changes colors of certain blocks based on pollution levels").addMixinClasses("minecraft.pollution.MixinRenderBlocks_PollutionWithOptifine").addTargetedMod(TargetedMod.VANILLA).addTargetedMod(TargetedMod.OPTIFINE).addExcludedMod(TargetedMod.ANGELICA).setSide(Side.CLIENT).setApplyIf(() -> PollutionConfig.pollution && PollutionConfig.pollutionBlockRecolor).setPhase(Phase.EARLY)),
    POLLUTION_RENDER_BLOCKS_BOP(new Builder("Changes colors of certain blocks based on pollution levels").addMixinClasses("biomesoplenty.MixinFoliageRendererPollution").addTargetedMod(TargetedMod.BOP).setSide(Side.CLIENT).setApplyIf(() -> PollutionConfig.pollution && PollutionConfig.pollutionBlockRecolor).setPhase(Phase.LATE)),
    POLLUTION_MINECRAFT_FURNACE(new Builder("Minecraft Furnace Pollutes").setPhase(Phase.EARLY).addMixinClasses("minecraft.pollution.MixinTileEntityFurnacePollution").setSide(Side.BOTH).setApplyIf(() -> PollutionConfig.pollution && PollutionConfig.furnacesPollute).addTargetedMod(TargetedMod.VANILLA)),
    POLLUTION_MINECRAFT_EXPLOSION(new Builder("Minecraft explosions pollute").setPhase(Phase.EARLY).addMixinClasses("minecraft.pollution.MixinExplosionPollution").setSide(Side.BOTH).setApplyIf(() -> PollutionConfig.pollution && PollutionConfig.explosionPollutionAmount != 0.0f).addTargetedMod(TargetedMod.VANILLA)),
    VANILLA_TRADING(new Builder("Change Vanilla Trades").setPhase(Phase.EARLY).addMixinClasses("minecraft.VanillaTradingMixin").addTargetedMod(TargetedMod.VANILLA).setApplyIf(() -> true).setSide(Side.BOTH)),
    POLLUTION_IC2_IRON_FURNACE(new Builder("Ic2 Iron Furnace Pollutes").addMixinClasses("ic2.MixinIC2IronFurnacePollution").setPhase(Phase.LATE).setSide(Side.BOTH).setApplyIf(() -> PollutionConfig.pollution && PollutionConfig.furnacesPollute).addTargetedMod(TargetedMod.IC2)),
    POLLUTION_THAUMCRAFT_ALCHEMICAL_FURNACE(new Builder("Thaumcraft Alchemical Construct Pollutes").addMixinClasses("thaumcraft.MixinThaumcraftAlchemyFurnacePollution").setPhase(Phase.LATE).setSide(Side.BOTH).setApplyIf(() -> PollutionConfig.pollution && PollutionConfig.furnacesPollute).addTargetedMod(TargetedMod.THAUMCRAFT)),
    POLLUTION_RAILCRAFT(new Builder("Make Railcraft Pollute").addMixinClasses("railcraft.MixinRailcraftBoilerPollution", "railcraft.MixinRailcraftCokeOvenPollution", "railcraft.MixinRailcraftTunnelBorePollution").setPhase(Phase.LATE).setSide(Side.BOTH).setApplyIf(() -> PollutionConfig.pollution && PollutionConfig.railcraftPollutes).addTargetedMod(TargetedMod.RAILCRAFT)),
    POLLUTION_ROCKET(new Builder("Make Rockets Pollute").addMixinClasses("galacticraftcore.MixinGalacticraftRocketPollution").setPhase(Phase.LATE).setSide(Side.BOTH).setApplyIf(() -> PollutionConfig.pollution && PollutionConfig.rocketsPollute).addTargetedMod(TargetedMod.GALACTICRAFT_CORE)),
    FUCK_OFF_COREMOD(new Builder("Stop Coremod from removing the steam recipes").addMixinClasses("coremod.MixinRecipeRemover").setPhase(Phase.LATE).setSide(Side.BOTH).setApplyIf(() -> true).addTargetedMod(TargetedMod.NEWHORIZONSCOREMOD));

    public static final Logger LOGGER;
    private final List<String> mixinClasses;
    private final List<TargetedMod> targetedMods;
    private final List<TargetedMod> excludedMods;
    private final Supplier<Boolean> applyIf;
    private final Phase phase;
    private final Side side;

    private Mixin(Builder builder) {
        this.mixinClasses = builder.mixinClasses;
        this.targetedMods = builder.targetedMods;
        this.excludedMods = builder.excludedMods;
        this.applyIf = builder.applyIf;
        this.phase = builder.phase;
        this.side = builder.side;
        if (this.mixinClasses.isEmpty()) {
            throw new RuntimeException("No mixin class specified for Mixin : " + this.name());
        }
        if (this.targetedMods.isEmpty()) {
            throw new RuntimeException("No targeted mods specified for Mixin : " + this.name());
        }
        if (this.applyIf == null) {
            throw new RuntimeException("No ApplyIf function specified for Mixin : " + this.name());
        }
        if (this.phase == null) {
            throw new RuntimeException("No Phase specified for Mixin : " + this.name());
        }
        if (this.side == null) {
            throw new RuntimeException("No Side function specified for Mixin : " + this.name());
        }
    }

    public static List<String> getEarlyMixins(Set<String> loadedCoreMods) {
        ArrayList<String> mixins = new ArrayList<String>();
        ArrayList<String> notLoading = new ArrayList<String>();
        for (Mixin mixin : Mixin.values()) {
            if (mixin.phase != Phase.EARLY) continue;
            if (mixin.shouldLoad(loadedCoreMods, Collections.emptySet())) {
                mixins.addAll(mixin.mixinClasses);
                continue;
            }
            notLoading.addAll(mixin.mixinClasses);
        }
        LOGGER.info("Not loading the following EARLY mixins: {}", new Object[]{((Object)notLoading).toString()});
        return mixins;
    }

    public static List<String> getLateMixins(Set<String> loadedMods) {
        ArrayList<String> mixins = new ArrayList<String>();
        ArrayList<String> notLoading = new ArrayList<String>();
        for (Mixin mixin : Mixin.values()) {
            if (mixin.phase != Phase.LATE) continue;
            if (mixin.shouldLoad(Collections.emptySet(), loadedMods)) {
                mixins.addAll(mixin.mixinClasses);
                continue;
            }
            notLoading.addAll(mixin.mixinClasses);
        }
        LOGGER.info("Not loading the following LATE mixins: {}", new Object[]{((Object)notLoading).toString()});
        return mixins;
    }

    private boolean shouldLoadSide() {
        return this.side == Side.BOTH || this.side == Side.SERVER && FMLLaunchHandler.side().isServer() || this.side == Side.CLIENT && FMLLaunchHandler.side().isClient();
    }

    private boolean allModsLoaded(List<TargetedMod> targetedMods, Set<String> loadedCoreMods, Set<String> loadedMods) {
        if (targetedMods.isEmpty()) {
            return false;
        }
        for (TargetedMod target : targetedMods) {
            if (target == TargetedMod.VANILLA) continue;
            if (!loadedCoreMods.isEmpty() && target.coreModClass != null && !loadedCoreMods.contains(target.coreModClass)) {
                return false;
            }
            if (loadedMods.isEmpty() || target.modId == null || loadedMods.contains(target.modId)) continue;
            return false;
        }
        return true;
    }

    private boolean noModsLoaded(List<TargetedMod> targetedMods, Set<String> loadedCoreMods, Set<String> loadedMods) {
        if (targetedMods.isEmpty()) {
            return true;
        }
        for (TargetedMod target : targetedMods) {
            if (target == TargetedMod.VANILLA) continue;
            if (!loadedCoreMods.isEmpty() && target.coreModClass != null && loadedCoreMods.contains(target.coreModClass)) {
                return false;
            }
            if (loadedMods.isEmpty() || target.modId == null || !loadedMods.contains(target.modId)) continue;
            return false;
        }
        return true;
    }

    private boolean shouldLoad(Set<String> loadedCoreMods, Set<String> loadedMods) {
        return this.shouldLoadSide() && this.applyIf.get() != false && this.allModsLoaded(this.targetedMods, loadedCoreMods, loadedMods) && this.noModsLoaded(this.excludedMods, loadedCoreMods, loadedMods);
    }

    static {
        LOGGER = LogManager.getLogger((String)"GregTech-Mixin");
    }

    private static class Builder {
        private final String name;
        private final List<String> mixinClasses = new ArrayList<String>();
        private final List<TargetedMod> targetedMods = new ArrayList<TargetedMod>();
        private final List<TargetedMod> excludedMods = new ArrayList<TargetedMod>();
        private Supplier<Boolean> applyIf = null;
        private Phase phase = null;
        private Side side = null;

        public Builder(String name) {
            this.name = name;
        }

        public Builder addMixinClasses(String ... mixinClasses) {
            this.mixinClasses.addAll(Arrays.asList(mixinClasses));
            return this;
        }

        public Builder setPhase(Phase phase) {
            if (this.phase != null) {
                throw new RuntimeException("Trying to define Phase twice for " + this.name);
            }
            this.phase = phase;
            return this;
        }

        public Builder setSide(Side side) {
            if (this.side != null) {
                throw new RuntimeException("Trying to define Side twice for " + this.name);
            }
            this.side = side;
            return this;
        }

        public Builder setApplyIf(Supplier<Boolean> applyIf) {
            this.applyIf = applyIf;
            return this;
        }

        public Builder addTargetedMod(TargetedMod mod) {
            this.targetedMods.add(mod);
            return this;
        }

        public Builder addExcludedMod(TargetedMod mod) {
            this.excludedMods.add(mod);
            return this;
        }
    }

    private static enum Phase {
        EARLY,
        LATE;

    }

    private static enum Side {
        BOTH,
        CLIENT,
        SERVER;

    }
}

