/*
 * Decompiled with CFR 0.152.
 */
package gregtech.loaders.oreprocessing;

import gregtech.GTMod;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.SubTag;
import gregtech.api.enums.TierEU;
import gregtech.api.interfaces.IOreRecipeRegistrator;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.GTRecipeConstants;
import gregtech.api.util.GTUtility;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;

public class ProcessingOre
implements IOreRecipeRegistrator {
    private final ArrayList<Materials> mAlreadyListedOres = new ArrayList(1000);

    public ProcessingOre() {
        for (OrePrefixes tPrefix : OrePrefixes.values()) {
            if (!tPrefix.name().startsWith("ore") || tPrefix == OrePrefixes.orePoor || tPrefix == OrePrefixes.oreSmall || tPrefix == OrePrefixes.oreRich || tPrefix == OrePrefixes.oreNormal) continue;
            tPrefix.add(this);
        }
    }

    @Override
    public void registerOre(OrePrefixes aPrefix, Materials aMaterial, String aOreDictName, String aModName, ItemStack aStack) {
        if (aMaterial.contains(SubTag.NO_ORE_PROCESSING)) {
            return;
        }
        boolean tIsRich = false;
        if (GTMod.gregtechproxy.mRichOreYieldMultiplier) {
            boolean bl = tIsRich = aPrefix == OrePrefixes.oreRich || aPrefix == OrePrefixes.oreDense;
        }
        if (GTMod.gregtechproxy.mNetherOreYieldMultiplier && !tIsRich) {
            boolean bl = tIsRich = aPrefix == OrePrefixes.oreNetherrack || aPrefix == OrePrefixes.oreNether;
        }
        if (GTMod.gregtechproxy.mEndOreYieldMultiplier && !tIsRich) {
            boolean bl = tIsRich = aPrefix == OrePrefixes.oreEndstone || aPrefix == OrePrefixes.oreEnd;
        }
        if (aMaterial == Materials.Oilsands) {
            GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(1, aStack)).itemOutputs(new ItemStack((Block)Blocks.field_150354_m, 1, 0)).outputChances(tIsRich ? 2000 : 4000).fluidOutputs(Materials.OilHeavy.getFluid(tIsRich ? 4000L : 2000L)).duration(tIsRich ? 600 : 300).eut(TierEU.RECIPE_LV).addTo(RecipeMaps.centrifugeRecipes);
        } else {
            this.registerStandardOreRecipes(aPrefix, aMaterial, GTUtility.copyAmount(1, aStack), tIsRich ? 2 : 1);
        }
    }

    private boolean registerStandardOreRecipes(OrePrefixes aPrefix, Materials aMaterial, ItemStack aOreStack, int aMultiplier) {
        if (aOreStack == null || aMaterial == null) {
            return false;
        }
        Materials tMaterial = aMaterial.mOreReplacement;
        Materials tPrimaryByMaterial = null;
        aMultiplier = Math.max(1, aMultiplier);
        aOreStack = GTUtility.copyAmount(1, aOreStack);
        aOreStack.field_77994_a = 1;
        ItemStack tIngot = GTOreDictUnificator.get(OrePrefixes.ingot, aMaterial.mDirectSmelting, 1L);
        ItemStack tGem = GTOreDictUnificator.get(OrePrefixes.gem, tMaterial, 1L);
        ItemStack tSmeltInto = tIngot == null ? null : (aMaterial.contains(SubTag.SMELTING_TO_GEM) ? GTOreDictUnificator.get(OrePrefixes.gem, (Object)tMaterial.mDirectSmelting, GTOreDictUnificator.get(OrePrefixes.crystal, (Object)tMaterial.mDirectSmelting, GTOreDictUnificator.get(OrePrefixes.gem, (Object)tMaterial, GTOreDictUnificator.get(OrePrefixes.crystal, tMaterial, 1L), 1L), 1L), 1L) : tIngot);
        ItemStack tDust = GTOreDictUnificator.get(OrePrefixes.dust, (Object)tMaterial, tGem, 1L);
        ItemStack tCleaned = GTOreDictUnificator.get(OrePrefixes.crushedPurified, (Object)tMaterial, tDust, 1L);
        ItemStack tCrushed = GTOreDictUnificator.get(OrePrefixes.crushed, tMaterial, (long)aMaterial.mOreMultiplier * (long)aMultiplier);
        ItemStack tPrimaryByProduct = null;
        if (tCrushed == null) {
            tCrushed = GTOreDictUnificator.get(OrePrefixes.dustImpure, (Object)tMaterial, GTUtility.copyAmount((long)(aMaterial.mOreMultiplier * aMultiplier), tCleaned, tDust, tGem), (long)aMaterial.mOreMultiplier * (long)aMultiplier);
        }
        for (Materials tMat : aMaterial.mOreByProducts) {
            GTOreDictUnificator.get(OrePrefixes.dust, tMat, 1L);
            if (tPrimaryByProduct == null) {
                tPrimaryByMaterial = tMat;
                tPrimaryByProduct = GTOreDictUnificator.get(OrePrefixes.dust, tMat, 1L);
                if (GTOreDictUnificator.get(OrePrefixes.dustSmall, tMat, 1L) == null) {
                    GTOreDictUnificator.get(OrePrefixes.dustTiny, (Object)tMat, GTOreDictUnificator.get(OrePrefixes.nugget, tMat, 2L), 2L);
                }
            }
            GTOreDictUnificator.get(OrePrefixes.dust, tMat, 1L);
            if (GTOreDictUnificator.get(OrePrefixes.dustSmall, tMat, 1L) != null) continue;
            GTOreDictUnificator.get(OrePrefixes.dustTiny, (Object)tMat, GTOreDictUnificator.get(OrePrefixes.nugget, tMat, 2L), 2L);
        }
        if (tPrimaryByMaterial == null) {
            tPrimaryByMaterial = tMaterial;
        }
        if (tPrimaryByProduct == null) {
            tPrimaryByProduct = tDust;
        }
        boolean tHasSmelting = false;
        if (tSmeltInto != null) {
            if (aMaterial.mBlastFurnaceRequired || aMaterial.mDirectSmelting.mBlastFurnaceRequired) {
                GTModHandler.removeFurnaceSmelting(aOreStack);
            } else {
                tHasSmelting = GTModHandler.addSmeltingRecipe(aOreStack, GTUtility.copyAmount(aMultiplier * aMaterial.mSmeltingMultiplier, tSmeltInto));
            }
            if (aMaterial.contains(SubTag.BLASTFURNACE_CALCITE_TRIPLE)) {
                if (aMaterial.mAutoGenerateBlastFurnaceRecipes) {
                    GTValues.RA.stdBuilder().itemInputs(aOreStack, GTOreDictUnificator.get(OrePrefixes.dust, Materials.Calcite, (long)aMultiplier)).itemOutputs(GTUtility.mul(aMultiplier * 3 * aMaterial.mSmeltingMultiplier, tSmeltInto), GTOreDictUnificator.get(OrePrefixes.dust, Materials.DarkAsh, 1L)).outputChances(10000, 2500).duration(tSmeltInto.field_77994_a * 25 * 20).eut(TierEU.RECIPE_MV).metadata(GTRecipeConstants.COIL_HEAT, 1500).addTo(RecipeMaps.blastFurnaceRecipes);
                    GTValues.RA.stdBuilder().itemInputs(aOreStack, GTOreDictUnificator.get(OrePrefixes.dust, Materials.Quicklime, (long)aMultiplier)).itemOutputs(GTUtility.mul(aMultiplier * 3 * aMaterial.mSmeltingMultiplier, tSmeltInto), GTOreDictUnificator.get(OrePrefixes.dust, Materials.DarkAsh, 1L)).outputChances(10000, 2500).duration(tSmeltInto.field_77994_a * 25 * 20).eut(TierEU.RECIPE_MV).metadata(GTRecipeConstants.COIL_HEAT, 1500).addTo(RecipeMaps.blastFurnaceRecipes);
                }
            } else if (aMaterial.contains(SubTag.BLASTFURNACE_CALCITE_DOUBLE) && aMaterial.mAutoGenerateBlastFurnaceRecipes) {
                GTValues.RA.stdBuilder().itemInputs(aOreStack, GTOreDictUnificator.get(OrePrefixes.dust, Materials.Calcite, (long)aMultiplier)).itemOutputs(GTUtility.mul(aMultiplier * 2 * aMaterial.mSmeltingMultiplier, tSmeltInto), GTOreDictUnificator.get(OrePrefixes.dust, Materials.DarkAsh, 1L)).outputChances(10000, 2500).duration(tSmeltInto.field_77994_a * 25 * 20).eut(TierEU.RECIPE_MV).metadata(GTRecipeConstants.COIL_HEAT, 1500).addTo(RecipeMaps.blastFurnaceRecipes);
                GTValues.RA.stdBuilder().itemInputs(aOreStack, GTOreDictUnificator.get(OrePrefixes.dust, Materials.Quicklime, (long)aMultiplier)).itemOutputs(GTUtility.mul(aMultiplier * 2 * aMaterial.mSmeltingMultiplier, tSmeltInto), GTOreDictUnificator.get(OrePrefixes.dust, Materials.DarkAsh, 1L)).outputChances(10000, 2500).duration(tSmeltInto.field_77994_a * 25 * 20).eut(TierEU.RECIPE_MV).metadata(GTRecipeConstants.COIL_HEAT, 1500).addTo(RecipeMaps.blastFurnaceRecipes);
            }
        }
        if (!tHasSmelting) {
            GTModHandler.addSmeltingRecipe(aOreStack, GTOreDictUnificator.get(OrePrefixes.gem, tMaterial.mDirectSmelting, (long)Math.max(1, aMultiplier * aMaterial.mSmeltingMultiplier / 2)));
        }
        if (tCrushed != null && aMaterial != Materials.Knightmetal) {
            GTValues.RA.stdBuilder().itemInputs(aOreStack).itemOutputs(GTUtility.copy(GTUtility.copyAmount(tCrushed.field_77994_a, tGem), tCrushed)).duration(10).eut(16).addTo(RecipeMaps.hammerRecipes);
            int chanceOre2 = tPrimaryByProduct == null ? 0 : tPrimaryByProduct.field_77994_a * 10 * aMultiplier * aMaterial.mByProductMultiplier;
            chanceOre2 = 100 * chanceOre2;
            GTValues.RA.stdBuilder().itemInputs(aOreStack).itemOutputs(GTUtility.mul(2, tCrushed), tMaterial.contains(SubTag.PULVERIZING_CINNABAR) ? GTOreDictUnificator.get(OrePrefixes.crystal, (Object)Materials.Cinnabar, GTOreDictUnificator.get(OrePrefixes.gem, (Object)tPrimaryByMaterial, GTUtility.copyAmount(1, tPrimaryByProduct), 1L), 1L) : GTOreDictUnificator.get(OrePrefixes.gem, (Object)tPrimaryByMaterial, GTUtility.copyAmount(1, tPrimaryByProduct), 1L), GTOreDictUnificator.getDust(aPrefix.mSecondaryMaterial)).outputChances(10000, chanceOre2, 5000).duration(400).eut(2).addTo(RecipeMaps.maceratorRecipes);
        }
        return true;
    }
}

