/*
 * Decompiled with CFR 0.152.
 */
package gregtech.loaders.misc;

import cpw.mods.fml.common.registry.GameRegistry;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IAlleleBeeEffect;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeMutationCustom;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleFlowers;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.IMutationCondition;
import forestry.api.genetics.IMutationCustom;
import forestry.apiculture.genetics.Bee;
import forestry.apiculture.genetics.IBeeDefinition;
import forestry.apiculture.genetics.alleles.AlleleEffect;
import forestry.core.genetics.alleles.AlleleHelper;
import forestry.core.genetics.alleles.EnumAllele;
import forestry.core.genetics.alleles.IAlleleValue;
import gregtech.GTMod;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.MaterialsKevlar;
import gregtech.api.enums.Mods;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.util.GTLanguageManager;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.JubilanceMegaApiary;
import gregtech.common.bees.GTAlleleBeeSpecies;
import gregtech.common.bees.GTBeeMutation;
import gregtech.common.items.CombType;
import gregtech.common.items.DropType;
import gregtech.common.items.PropolisType;
import gregtech.loaders.misc.GTBees;
import gregtech.loaders.misc.GTBranchDefinition;
import gregtech.loaders.misc.bees.GTAlleleEffect;
import gregtech.loaders.misc.bees.GTFlowers;
import gtnhlanth.common.register.WerkstoffMaterialPool;
import java.awt.Color;
import java.util.Arrays;
import java.util.Locale;
import java.util.function.Consumer;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import org.apache.commons.lang3.text.WordUtils;

public enum GTBeeDefinition implements IBeeDefinition
{
    CLAY(GTBranchDefinition.ORGANIC, "Clay", true, new Color(13158618), new Color(255), beeSpecies -> {
        beeSpecies.addProduct(GTModHandler.getModItem(Mods.Forestry.ID, "beeCombs", 1L, 0), Float.valueOf(0.3f));
        beeSpecies.addProduct(new ItemStack(Items.field_151119_aD, 1), Float.valueOf(0.15f));
        beeSpecies.addSpecialty(GTModHandler.getModItem(Mods.BiomesOPlenty.ID, "mudball", 1L, 0), Float.valueOf(0.05f));
        beeSpecies.setHumidity(EnumHumidity.DAMP);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.SLOWER);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.NONE);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAlleleValue)EnumAllele.Flowers.VANILLA);
    }, dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(GTBeeDefinition.getSpecies((byte)0, "Industrious"), GTBeeDefinition.getSpecies((byte)0, "Diligent"), 10);
        tMutation.requireResource(Blocks.field_150435_aG, 0);
    }),
    SLIMEBALL(GTBranchDefinition.ORGANIC, "SlimeBall", true, new Color(5152341), new Color(65301), beeSpecies -> {
        beeSpecies.addProduct(GTModHandler.getModItem(Mods.Forestry.ID, "beeCombs", 1L, 15), Float.valueOf(0.3f));
        beeSpecies.addProduct(new ItemStack(Items.field_151123_aH, 1), Float.valueOf(0.15f));
        beeSpecies.addSpecialty(GTBees.combs.getStackForType(CombType.STICKY), Float.valueOf(0.05f));
        beeSpecies.setHumidity(EnumHumidity.DAMP);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
        if (Mods.TinkerConstruct.isModLoaded()) {
            beeSpecies.addProduct(GTModHandler.getModItem(Mods.TinkerConstruct.ID, "strangeFood", 1L, 0), Float.valueOf(0.1f));
            beeSpecies.addSpecialty(GTModHandler.getModItem(Mods.TinkerConstruct.ID, "slime.gel", 1L, 2), Float.valueOf(0.02f));
        }
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAlleleValue)EnumAllele.Flowers.MUSHROOMS);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.SLOWER);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAllele)GTBeeDefinition.getFlowers((byte)1, "water"));
    }, dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(GTBeeDefinition.getSpecies((byte)0, "Marshy"), CLAY, 7);
        if (Mods.TinkerConstruct.isModLoaded()) {
            tMutation.requireResource(GameRegistry.findBlock((String)Mods.TinkerConstruct.ID, (String)"slime.gel"), 1);
        }
    }),
    PEAT(GTBranchDefinition.ORGANIC, "Peat", true, new Color(9462327), new Color(5779467), beeSpecies -> {
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.LIGNIE), Float.valueOf(0.3f));
        beeSpecies.addProduct(GTModHandler.getModItem(Mods.Forestry.ID, "beeCombs", 1L, 0), Float.valueOf(0.15f));
        beeSpecies.addSpecialty(GTModHandler.getModItem(Mods.Forestry.ID, "peat", 1L, 0), Float.valueOf(0.15f));
        beeSpecies.addSpecialty(GTModHandler.getModItem(Mods.Forestry.ID, "mulch", 1L, 0), Float.valueOf(0.05f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTER);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAlleleValue)EnumAllele.Flowers.WHEAT);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.FASTER);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.NONE);
    }, dis -> dis.registerMutation(GTBeeDefinition.getSpecies((byte)0, "Rural"), CLAY, 10)),
    STICKYRESIN(GTBranchDefinition.ORGANIC, "StickyResin", true, new Color(3051355), new Color(14467721), beeSpecies -> {
        beeSpecies.addProduct(GTModHandler.getModItem(Mods.Forestry.ID, "beeCombs", 1L, 0), Float.valueOf(0.3f));
        beeSpecies.addSpecialty(GTBees.combs.getStackForType(CombType.STICKY), Float.valueOf(0.15f));
        beeSpecies.addSpecialty(ItemList.IC2_Resin.get(1L, new Object[0]), Float.valueOf(0.15f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.SLOWER);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.NONE);
    }, dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(SLIMEBALL, PEAT, 15);
        tMutation.requireResource("logRubber");
    }),
    COAL(GTBranchDefinition.ORGANIC, "Coal", true, new Color(0x666666), new Color(0x525252), beeSpecies -> {
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.LIGNIE), Float.valueOf(0.3f));
        beeSpecies.addSpecialty(GTBees.combs.getStackForType(CombType.COAL), Float.valueOf(0.15f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAlleleValue)EnumAllele.Flowers.CACTI);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWEST);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.LONGER);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.DOWN_2);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.DOWN_1);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.NOCTURNAL, true);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.EFFECT, (IAllele)AlleleEffect.effectCreeper);
    }, dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(GTBeeDefinition.getSpecies((byte)0, "Industrious"), PEAT, 9);
        tMutation.requireResource("blockCoal");
    }),
    OIL(GTBranchDefinition.ORGANIC, "Oil", true, new Color(0x4C4C4C), new Color(0x333333), beeSpecies -> {
        beeSpecies.addProduct(GTModHandler.getModItem(Mods.Forestry.ID, "beeCombs", 1L, 0), Float.valueOf(0.3f));
        beeSpecies.addSpecialty(GTBees.combs.getStackForType(CombType.OIL), Float.valueOf(0.75f));
        beeSpecies.setHumidity(EnumHumidity.DAMP);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
        beeSpecies.setHasEffect();
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.SLOWER);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.NOCTURNAL, true);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.NORMAL);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAllele)GTBeeDefinition.getFlowers((byte)1, "water"));
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.NONE);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.NONE);
    }, dis -> dis.registerMutation(COAL, STICKYRESIN, 4)),
    SANDWICH(GTBranchDefinition.ORGANIC, "Sandwich", true, new Color(3329330), new Color(14329120), beeSpecies -> {
        beeSpecies.addProduct(GTModHandler.getModItem(Mods.ExtraBees.ID, "honeyComb", 1L, 9), Float.valueOf(0.15f));
        beeSpecies.addSpecialty(ItemList.Food_Sliced_Cucumber.get(1L, new Object[0]), Float.valueOf(0.05f));
        beeSpecies.addSpecialty(ItemList.Food_Sliced_Onion.get(1L, new Object[0]), Float.valueOf(0.05f));
        beeSpecies.addSpecialty(ItemList.Food_Sliced_Tomato.get(1L, new Object[0]), Float.valueOf(0.05f));
        beeSpecies.addSpecialty(ItemList.Food_Sliced_Cheese.get(1L, new Object[0]), Float.valueOf(0.05f));
        beeSpecies.addSpecialty(new ItemStack(Items.field_151157_am, 1, 0), Float.valueOf(0.05f));
        beeSpecies.addSpecialty(new ItemStack(Items.field_151083_be, 1, 0), Float.valueOf(0.05f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOW);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_2);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.EFFECT, (IAllele)AlleleEffect.effectFertile);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TERRITORY, (IAlleleValue)EnumAllele.Territory.LARGE);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTER);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAlleleValue)EnumAllele.Flowers.WHEAT);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.FASTER);
    }, dis -> dis.registerMutation(GTBeeDefinition.getSpecies((byte)0, "Agrarian"), GTBeeDefinition.getSpecies((byte)3, "TCBatty"), 10)),
    ASH(GTBranchDefinition.ORGANIC, "Ash", true, new Color(1972760), new Color(0xC6C6C6), beeSpecies -> {
        beeSpecies.addProduct(GTModHandler.getModItem(Mods.ExtraBees.ID, "honeyComb", 1L, 9), Float.valueOf(0.15f));
        beeSpecies.addSpecialty(GTBees.combs.getStackForType(CombType.ASH), Float.valueOf(0.15f));
        beeSpecies.setHumidity(EnumHumidity.ARID);
        beeSpecies.setTemperature(EnumTemperature.HOT);
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.NORMAL);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TERRITORY, (IAlleleValue)EnumAllele.Territory.LARGE);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTER);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAlleleValue)EnumAllele.Flowers.WHEAT);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.FASTER);
    }, dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(COAL, CLAY, 10);
        tMutation.restrictTemperature(EnumTemperature.HELLISH);
    }),
    APATITE(GTBranchDefinition.ORGANIC, "Apatite", true, new Color(12698102), new Color(6776708), beeSpecies -> {
        beeSpecies.addProduct(GTModHandler.getModItem(Mods.ExtraBees.ID, "honeyComb", 1L, 9), Float.valueOf(0.15f));
        beeSpecies.addSpecialty(GTBees.combs.getStackForType(CombType.APATITE), Float.valueOf(0.15f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.WARM);
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.FASTEST);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.LONGER);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAlleleValue)EnumAllele.Flowers.WHEAT);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.FASTER);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAllele)GTBeeDefinition.getFlowers((byte)1, "rock"));
    }, dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(ASH, COAL, 10);
        tMutation.requireResource("blockApatite");
    }),
    FERTILIZER(GTBranchDefinition.ORGANIC, "Fertilizer", true, new Color(8376053), new Color(6636837), beeSpecies -> {
        beeSpecies.addProduct(GTModHandler.getModItem(Mods.ExtraBees.ID, "honeyComb", 1L, 9), Float.valueOf(0.15f));
        beeSpecies.addSpecialty(GTOreDictUnificator.get(OrePrefixes.dustTiny, Materials.Ash, 1L), Float.valueOf(0.2f));
        beeSpecies.addSpecialty(GTOreDictUnificator.get(OrePrefixes.dustTiny, Materials.DarkAsh, 1L), Float.valueOf(0.2f));
        beeSpecies.addSpecialty(ItemList.FR_Fertilizer.get(1L, new Object[0]), Float.valueOf(0.3f));
        beeSpecies.addSpecialty(ItemList.IC2_Fertilizer.get(1L, new Object[0]), Float.valueOf(0.3f));
        beeSpecies.setHumidity(EnumHumidity.DAMP);
        beeSpecies.setTemperature(EnumTemperature.WARM);
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.FASTEST);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.LONGER);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAlleleValue)EnumAllele.Flowers.WHEAT);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.FASTER);
    }, dis -> dis.registerMutation(ASH, APATITE, 8)),
    PHOSPHORUS(GTBranchDefinition.ORGANIC, "Phosphorus", false, new Color(16762918), new Color(12698102), beeSpecies -> {
        beeSpecies.addSpecialty(GTBees.combs.getStackForType(CombType.PHOSPHORUS), Float.valueOf(0.35f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.HOT);
        beeSpecies.setNocturnal();
        beeSpecies.setHasEffect();
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(APATITE, ASH, 12);
        tMutation.restrictTemperature(EnumTemperature.HOT);
        GregTechAPI.sGTCompleteLoad.add(() -> tMutation.requireResource(GregTechAPI.sBlockGem2, 8));
    }),
    TEA(GTBranchDefinition.ORGANIC, "Tea", false, new Color(6672698), new Color(10131065), beeSpecies -> {
        beeSpecies.addProduct(GTModHandler.getModItem(Mods.PamsHarvestCraft.ID, "tealeafItem", 1L, ItemList.Crop_Drop_TeaLeaf.get(1L, new Object[0])), Float.valueOf(0.1f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
        beeSpecies.setHasEffect();
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST), dis -> dis.registerMutation(FERTILIZER, ASH, 10)),
    MICA(GTBranchDefinition.ORGANIC, "Mica", false, new Color(16762918), new Color(12698102), beeSpecies -> {
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.MICA), Float.valueOf(0.25f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.HOT);
        beeSpecies.setNocturnal();
        beeSpecies.setHasEffect();
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(PEAT, GTBeeDefinition.getSpecies((byte)3, "Silicon"), 15);
        GregTechAPI.sGTCompleteLoad.add(() -> tMutation.requireResource(GregTechAPI.sBlockCasings5, 0));
    }),
    REDSTONE(GTBranchDefinition.GEM, "Redstone", true, new Color(8195855), new Color(0xD11919), beeSpecies -> {
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.STONE), Float.valueOf(0.3f));
        beeSpecies.addSpecialty(GTBees.combs.getStackForType(CombType.REDSTONE), Float.valueOf(0.15f));
        beeSpecies.addSpecialty(GTBees.combs.getStackForType(CombType.RAREEARTH), Float.valueOf(0.15f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(GTBeeDefinition.getSpecies((byte)0, "Industrious"), GTBeeDefinition.getSpecies((byte)0, "Demonic"), 10);
        tMutation.requireResource("blockRedstone");
    }),
    LAPIS(GTBranchDefinition.GEM, "Lapis", true, new Color(1656785), new Color(4680922), beeSpecies -> {
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.STONE), Float.valueOf(0.3f));
        beeSpecies.addSpecialty(GTBees.combs.getStackForType(CombType.LAPIS), Float.valueOf(0.15f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(GTBeeDefinition.getSpecies((byte)0, "Demonic"), GTBeeDefinition.getSpecies((byte)0, "Imperial"), 10);
        tMutation.requireResource("blockLapis");
    }),
    CERTUS(GTBranchDefinition.GEM, "CertusQuartz", true, new Color(5754875), new Color(0xBBEEFF), beeSpecies -> {
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.STONE), Float.valueOf(0.3f));
        beeSpecies.addSpecialty(GTBees.combs.getStackForType(CombType.CERTUS), Float.valueOf(0.15f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(GTBeeDefinition.getSpecies((byte)0, "Hermitic"), LAPIS, 10);
        tMutation.requireResource(GameRegistry.findBlock((String)Mods.AppliedEnergistics2.ID, (String)"tile.BlockQuartz"), 0);
    }),
    FLUIX(GTBranchDefinition.GEM, "FluixDust", true, new Color(10712575), new Color(11899391), beeSpecies -> {
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.STONE), Float.valueOf(0.3f));
        beeSpecies.addSpecialty(GTBees.combs.getStackForType(CombType.FLUIX), Float.valueOf(0.15f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(REDSTONE, LAPIS, 7);
        tMutation.requireResource(GameRegistry.findBlock((String)Mods.AppliedEnergistics2.ID, (String)"tile.BlockFluix"), 0);
    }),
    DIAMOND(GTBranchDefinition.GEM, "Diamond", false, new Color(0xCCFFFF), new Color(0xA3CCCC), beeSpecies -> {
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.STONE), Float.valueOf(0.3f));
        beeSpecies.addSpecialty(GTBees.combs.getStackForType(CombType.DIAMOND), Float.valueOf(0.15f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.HOT);
        beeSpecies.setHasEffect();
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(CERTUS, COAL, 3);
        tMutation.requireResource("blockDiamond");
    }),
    RUBY(GTBranchDefinition.GEM, "Ruby", false, new Color(15073372), new Color(13369426), beeSpecies -> {
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.STONE), Float.valueOf(0.3f));
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.RUBY), Float.valueOf(0.15f));
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.REDGARNET), Float.valueOf(0.05f));
        beeSpecies.setHumidity(EnumHumidity.DAMP);
        beeSpecies.setTemperature(EnumTemperature.HOT);
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(REDSTONE, DIAMOND, 5);
        tMutation.requireResource("blockRuby");
    }),
    SAPPHIRE(GTBranchDefinition.GEM, "Sapphire", true, new Color(13260), new Color(9359), beeSpecies -> {
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.STONE), Float.valueOf(0.3f));
        beeSpecies.addSpecialty(GTBees.combs.getStackForType(CombType.SAPPHIRE), Float.valueOf(0.15f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(CERTUS, LAPIS, 5);
        tMutation.requireResource(GregTechAPI.sBlockGem2, 12);
    }),
    OLIVINE(GTBranchDefinition.GEM, "Olivine", true, new Color(2395940), new Color(0xCCFFCC), beeSpecies -> {
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.STONE), Float.valueOf(0.3f));
        beeSpecies.addSpecialty(GTBees.combs.getStackForType(CombType.OLIVINE), Float.valueOf(0.15f));
        beeSpecies.addSpecialty(GTBees.combs.getStackForType(CombType.MAGNESIUM), Float.valueOf(0.05f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER), dis -> dis.registerMutation(CERTUS, GTBeeDefinition.getSpecies((byte)0, "Ended"), 5)),
    EMERALD(GTBranchDefinition.GEM, "Emerald", false, new Color(2395940), new Color(3061806), beeSpecies -> {
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.STONE), Float.valueOf(0.3f));
        beeSpecies.addSpecialty(GTBees.combs.getStackForType(CombType.EMERALD), Float.valueOf(0.15f));
        beeSpecies.addSpecialty(GTBees.combs.getStackForType(CombType.ALUMINIUM), Float.valueOf(0.05f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.COLD);
        beeSpecies.setHasEffect();
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(OLIVINE, DIAMOND, 4);
        tMutation.requireResource("blockEmerald");
    }),
    REDGARNET(GTBranchDefinition.GEM, "RedGarnet", false, new Color(12405836), new Color(0xECCECE), beeSpecies -> {
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.STONE), Float.valueOf(0.3f));
        beeSpecies.addSpecialty(GTBees.combs.getStackForType(CombType.REDGARNET), Float.valueOf(0.15f));
        beeSpecies.addSpecialty(GTBees.combs.getStackForType(CombType.PYROPE), Float.valueOf(0.05f));
        beeSpecies.setHumidity(EnumHumidity.DAMP);
        beeSpecies.setTemperature(EnumTemperature.WARM);
        beeSpecies.setHasEffect();
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.FAST);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST);
    }, dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(DIAMOND, RUBY, 4);
        tMutation.requireResource("blockGarnetRed");
    }),
    YELLOWGARNET(GTBranchDefinition.GEM, "YellowGarnet", false, new Color(10724161), new Color(0xEDEDCE), beeSpecies -> {
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.STONE), Float.valueOf(0.3f));
        beeSpecies.addSpecialty(GTBees.combs.getStackForType(CombType.YELLOWGARNET), Float.valueOf(0.15f));
        beeSpecies.addSpecialty(GTBees.combs.getStackForType(CombType.GROSSULAR), Float.valueOf(0.05f));
        beeSpecies.setHumidity(EnumHumidity.DAMP);
        beeSpecies.setTemperature(EnumTemperature.WARM);
        beeSpecies.setHasEffect();
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.FAST);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST);
    }, dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(EMERALD, REDGARNET, 3);
        tMutation.requireResource("blockGarnetYellow");
    }),
    FIRESTONE(GTBranchDefinition.GEM, "Firestone", false, new Color(0xC00000), new Color(0xFF0000), beeSpecies -> {
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.STONE), Float.valueOf(0.3f));
        beeSpecies.addSpecialty(GTBees.combs.getStackForType(CombType.FIRESTONE), Float.valueOf(0.15f));
        beeSpecies.setHumidity(EnumHumidity.DAMP);
        beeSpecies.setTemperature(EnumTemperature.WARM);
        beeSpecies.setHasEffect();
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.FAST);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.NOCTURNAL, true);
    }, dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(REDSTONE, RUBY, 4);
        tMutation.requireResource("blockFirestone");
    }),
    COPPER(GTBranchDefinition.METAL, "Copper", true, new Color(0xFF6600), new Color(15096832), beeSpecies -> {
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.SLAG), Float.valueOf(0.3f));
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.COPPER), Float.valueOf(0.15f));
        beeSpecies.addSpecialty(GTBees.combs.getStackForType(CombType.GOLD), Float.valueOf(0.05f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(GTBeeDefinition.getSpecies((byte)0, "Majestic"), CLAY, 13);
        tMutation.requireResource("blockCopper");
    }),
    TIN(GTBranchDefinition.METAL, "Tin", true, new Color(0xD4D4D4), new Color(0xDDDDDD), beeSpecies -> {
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.SLAG), Float.valueOf(0.3f));
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.TIN), Float.valueOf(0.15f));
        beeSpecies.addSpecialty(GTBees.combs.getStackForType(CombType.ZINC), Float.valueOf(0.05f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(CLAY, GTBeeDefinition.getSpecies((byte)0, "Diligent"), 13);
        tMutation.requireResource("blockTin");
    }),
    LEAD(GTBranchDefinition.METAL, "Lead", true, new Color(0x666699), new Color(0xA3A3CC), beeSpecies -> {
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.SLAG), Float.valueOf(0.3f));
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.LEAD), Float.valueOf(0.15f));
        beeSpecies.addSpecialty(GTBees.combs.getStackForType(CombType.SULFUR), Float.valueOf(0.05f));
        beeSpecies.setHumidity(EnumHumidity.DAMP);
        beeSpecies.setTemperature(EnumTemperature.WARM);
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(COAL, COPPER, 13);
        tMutation.requireResource("blockLead");
    }),
    IRON(GTBranchDefinition.METAL, "Iron", true, new Color(14324039), new Color(14589017), beeSpecies -> {
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.SLAG), Float.valueOf(0.3f));
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.IRON), Float.valueOf(0.15f));
        beeSpecies.addSpecialty(GTBees.combs.getStackForType(CombType.TIN), Float.valueOf(0.05f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(TIN, COPPER, 13);
        tMutation.requireResource("blockIron");
    }),
    STEEL(GTBranchDefinition.METAL, "Steel", true, new Color(0x808080), new Color(0x999999), beeSpecies -> {
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.SLAG), Float.valueOf(0.3f));
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.STEEL), Float.valueOf(0.15f));
        beeSpecies.addSpecialty(GTBees.combs.getStackForType(CombType.IRON), Float.valueOf(0.05f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.WARM);
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(IRON, COAL, 10);
        tMutation.requireResource(GregTechAPI.sBlockMetal6, 13);
    }),
    NICKEL(GTBranchDefinition.METAL, "Nickel", true, new Color(8750509), new Color(8750509), beeSpecies -> {
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.SLAG), Float.valueOf(0.3f));
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.NICKEL), Float.valueOf(0.15f));
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.PLATINUM), Float.valueOf(0.02f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(IRON, COPPER, 13);
        tMutation.requireResource("blockNickel");
    }),
    ZINC(GTBranchDefinition.METAL, "Zinc", true, new Color(15785712), new Color(15917554), beeSpecies -> {
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.SLAG), Float.valueOf(0.3f));
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.ZINC), Float.valueOf(0.15f));
        beeSpecies.addSpecialty(GTBees.combs.getStackForType(CombType.GALLIUM), Float.valueOf(0.05f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(IRON, TIN, 13);
        tMutation.requireResource("blockZinc");
    }),
    SILVER(GTBranchDefinition.METAL, "Silver", true, new Color(12763862), new Color(0xCECEDE), beeSpecies -> {
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.SLAG), Float.valueOf(0.3f));
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.SILVER), Float.valueOf(0.15f));
        beeSpecies.addSpecialty(GTBees.combs.getStackForType(CombType.SULFUR), Float.valueOf(0.05f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.COLD);
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(LEAD, TIN, 10);
        tMutation.requireResource("blockSilver");
    }),
    CRYOLITE(GTBranchDefinition.METAL, "Cryolite", true, new Color(0xBFEFFF), new Color(7584208), beeSpecies -> {
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.SLAG), Float.valueOf(0.3f));
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.CRYOLITE), Float.valueOf(0.15f));
        beeSpecies.addSpecialty(GTBees.combs.getStackForType(CombType.SILVER), Float.valueOf(0.05f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.WARM);
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.FASTEST), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(LEAD, SILVER, 9);
        tMutation.requireResource("blockCryolite");
    }),
    GOLD(GTBranchDefinition.METAL, "Gold", true, new Color(15451699), new Color(15584327), beeSpecies -> {
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.SLAG), Float.valueOf(0.3f));
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.GOLD), Float.valueOf(0.15f));
        beeSpecies.addSpecialty(GTBees.combs.getStackForType(CombType.NICKEL), Float.valueOf(0.05f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.WARM);
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(LEAD, COPPER, 13);
        tMutation.requireResource("blockGold");
        tMutation.restrictTemperature(EnumTemperature.HOT);
    }),
    ARSENIC(GTBranchDefinition.METAL, "Arsenic", true, new Color(7564370), new Color(2696210), beeSpecies -> {
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.SLAG), Float.valueOf(0.3f));
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.ARSENIC), Float.valueOf(0.15f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.WARM);
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(ZINC, SILVER, 10);
        tMutation.requireResource("blockArsenic");
    }),
    ALUMINIUM(GTBranchDefinition.RAREMETAL, "Aluminium", true, new Color(0xB8B8FF), new Color(0xD6D6FF), beeSpecies -> {
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.SLAG), Float.valueOf(0.3f));
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.ALUMINIUM), Float.valueOf(0.15f));
        beeSpecies.addSpecialty(GTBees.combs.getStackForType(CombType.BAUXITE), Float.valueOf(0.05f));
        beeSpecies.setHumidity(EnumHumidity.ARID);
        beeSpecies.setTemperature(EnumTemperature.HOT);
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(NICKEL, ZINC, 9);
        tMutation.requireResource("blockAluminium");
    }),
    TITANIUM(GTBranchDefinition.RAREMETAL, "Titanium", true, new Color(0xCC99FF), new Color(14399743), beeSpecies -> {
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.SLAG), Float.valueOf(0.3f));
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.TITANIUM), Float.valueOf(0.15f));
        beeSpecies.addSpecialty(GTBees.combs.getStackForType(CombType.ALMANDINE), Float.valueOf(0.05f));
        beeSpecies.setHumidity(EnumHumidity.ARID);
        beeSpecies.setTemperature(EnumTemperature.HOT);
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(REDSTONE, ALUMINIUM, 5);
        tMutation.requireResource(GregTechAPI.sBlockMetal7, 9);
    }),
    GLOWSTONE(GTBranchDefinition.RAREMETAL, "Glowstone", false, new Color(15059498), new Color(16759902), beeSpecies -> {
        beeSpecies.addSpecialty(Materials.Glowstone.getDust(1), Float.valueOf(0.2f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setNocturnal();
        beeSpecies.setHasEffect();
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.NORMAL), dis -> dis.registerMutation(REDSTONE, GOLD, 10)),
    SUNNARIUM(GTBranchDefinition.RAREMETAL, "Sunnarium", false, new Color(16759902), new Color(15059498), beeSpecies -> {
        beeSpecies.addProduct(Materials.Glowstone.getDust(1), Float.valueOf(0.3f));
        beeSpecies.addSpecialty(Materials.Sunnarium.getDust(1), Float.valueOf(0.05f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setNocturnal();
        beeSpecies.setHasEffect();
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.LONGEST), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(GLOWSTONE, GOLD, 5);
        GregTechAPI.sGTCompleteLoad.add(() -> tMutation.requireResource(GregTechAPI.sBlockCasings1, 15));
    }),
    CHROME(GTBranchDefinition.RAREMETAL, "Chrome", true, new Color(15442411), new Color(15909874), beeSpecies -> {
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.SLAG), Float.valueOf(0.3f));
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.CHROME), Float.valueOf(0.15f));
        beeSpecies.addSpecialty(GTBees.combs.getStackForType(CombType.MAGNESIUM), Float.valueOf(0.05f));
        beeSpecies.setHumidity(EnumHumidity.ARID);
        beeSpecies.setTemperature(EnumTemperature.HOT);
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(TITANIUM, RUBY, 5);
        tMutation.requireResource(GregTechAPI.sBlockMetal2, 3);
    }),
    MANGANESE(GTBranchDefinition.RAREMETAL, "Manganese", true, new Color(0xD5D5D5), new Color(0xAAAAAA), beeSpecies -> {
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.SLAG), Float.valueOf(0.3f));
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.MANGANESE), Float.valueOf(0.15f));
        beeSpecies.addSpecialty(GTBees.combs.getStackForType(CombType.IRON), Float.valueOf(0.05f));
        beeSpecies.setHumidity(EnumHumidity.ARID);
        beeSpecies.setTemperature(EnumTemperature.HOT);
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(TITANIUM, ALUMINIUM, 5);
        tMutation.requireResource(GregTechAPI.sBlockMetal4, 6);
    }),
    TUNGSTEN(GTBranchDefinition.RAREMETAL, "Tungsten", false, new Color(6053002), new Color(8224161), beeSpecies -> {
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.SLAG), Float.valueOf(0.3f));
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.TUNGSTEN), Float.valueOf(0.15f));
        beeSpecies.addSpecialty(GTBees.combs.getStackForType(CombType.MOLYBDENUM), Float.valueOf(0.05f));
        beeSpecies.setHumidity(EnumHumidity.ARID);
        beeSpecies.setTemperature(EnumTemperature.HOT);
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(GTBeeDefinition.getSpecies((byte)0, "Heroic"), MANGANESE, 5);
        tMutation.requireResource(GregTechAPI.sBlockMetal7, 11);
    }),
    PLATINUM(GTBranchDefinition.RAREMETAL, "Platinum", false, new Color(0xE6E6E6), new Color(0xFFFFCC), beeSpecies -> {
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.SLAG), Float.valueOf(0.3f));
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.PLATINUM), Float.valueOf(0.3f));
        beeSpecies.addSpecialty(GTBees.combs.getStackForType(CombType.IRIDIUM), Float.valueOf(0.02f));
        beeSpecies.setHumidity(EnumHumidity.ARID);
        beeSpecies.setTemperature(EnumTemperature.HOT);
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(DIAMOND, CHROME, 5);
        tMutation.requireResource("blockNickel");
    }),
    IRIDIUM(GTBranchDefinition.RAREMETAL, "Iridium", false, new Color(0xDADADA), new Color(13750752), beeSpecies -> {
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.SLAG), Float.valueOf(0.3f));
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.IRIDIUM), Float.valueOf(0.3f));
        beeSpecies.addSpecialty(GTBees.combs.getStackForType(CombType.OSMIUM), Float.valueOf(0.05f));
        beeSpecies.addSpecialty(GTBees.combs.getStackForType(CombType.PALLADIUM), Float.valueOf(0.3f));
        beeSpecies.setHumidity(EnumHumidity.ARID);
        beeSpecies.setTemperature(EnumTemperature.HELLISH);
        beeSpecies.setHasEffect();
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(TUNGSTEN, PLATINUM, 5);
        tMutation.requireResource(GregTechAPI.sBlockMetal3, 12);
    }),
    OSMIUM(GTBranchDefinition.RAREMETAL, "Osmium", false, new Color(2829274), new Color(0x8B8B8B), beeSpecies -> {
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.SLAG), Float.valueOf(0.3f));
        beeSpecies.addSpecialty(GTBees.combs.getStackForType(CombType.OSMIUM), Float.valueOf(0.3f));
        beeSpecies.addSpecialty(GTBees.combs.getStackForType(CombType.IRIDIUM), Float.valueOf(0.05f));
        beeSpecies.setHumidity(EnumHumidity.ARID);
        beeSpecies.setTemperature(EnumTemperature.COLD);
        beeSpecies.setHasEffect();
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(TUNGSTEN, PLATINUM, 5);
        tMutation.requireResource(GregTechAPI.sBlockMetal5, 9);
    }),
    SALTY(GTBranchDefinition.RAREMETAL, "Salt", true, new Color(15780040), new Color(0xFAFAFA), beeSpecies -> {
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.SLAG), Float.valueOf(0.3f));
        beeSpecies.addSpecialty(GTBees.combs.getStackForType(CombType.SALT), Float.valueOf(0.35f));
        beeSpecies.addSpecialty(GTBees.combs.getStackForType(CombType.LITHIUM), Float.valueOf(0.05f));
        beeSpecies.addSpecialty(GTOreDictUnificator.get(OrePrefixes.dust, Materials.Borax, 1L), Float.valueOf(0.1f));
        beeSpecies.setHumidity(EnumHumidity.ARID);
        beeSpecies.setTemperature(EnumTemperature.WARM);
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(CLAY, ALUMINIUM, 5);
        tMutation.requireResource("blockSalt");
    }),
    LITHIUM(GTBranchDefinition.RAREMETAL, "Lithium", false, new Color(15741580), new Color(14802175), beeSpecies -> {
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.SLAG), Float.valueOf(0.3f));
        beeSpecies.addSpecialty(GTBees.combs.getStackForType(CombType.LITHIUM), Float.valueOf(0.15f));
        beeSpecies.addSpecialty(GTBees.combs.getStackForType(CombType.SALT), Float.valueOf(0.05f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.COLD);
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(SALTY, ALUMINIUM, 5);
        tMutation.requireResource("frameGtLithium");
    }),
    ELECTROTINE(GTBranchDefinition.RAREMETAL, "Electrotine", false, new Color(2003199), new Color(3978440), beeSpecies -> {
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.SLAG), Float.valueOf(0.3f));
        beeSpecies.addSpecialty(GTBees.combs.getStackForType(CombType.ELECTROTINE), Float.valueOf(0.15f));
        beeSpecies.addSpecialty(GTBees.combs.getStackForType(CombType.REDSTONE), Float.valueOf(0.05f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.HOT);
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(REDSTONE, GOLD, 5);
        tMutation.requireResource("blockElectrotine");
    }),
    SULFUR(GTBranchDefinition.RAREMETAL, "Sulfur", false, new Color(2003199), new Color(3978440), beeSpecies -> {
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.SULFUR), Float.valueOf(0.7f));
        beeSpecies.addSpecialty(GTBees.combs.getStackForType(CombType.FIRESTONE), Float.valueOf(0.15f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.HOT);
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.NORMAL), dis -> dis.registerMutation(ASH, PEAT, 15)),
    INDIUM(GTBranchDefinition.RAREMETAL, "Indium", false, new Color(0xFFA9FF), new Color(9395609), beeSpecies -> {
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.INDIUM), Float.valueOf(0.05f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.HOT);
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWEST), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(LEAD, OSMIUM, 1);
        tMutation.requireResource("blockIndium");
        tMutation.addMutationCondition((IMutationCondition)new GTBees.DimensionMutationCondition(39, "Venus"));
        tMutation = dis.registerMutation(SILVER, OSMIUM, 1);
        tMutation.requireResource("blockArcanite");
        tMutation.addMutationCondition((IMutationCondition)new GTBees.DimensionMutationCondition(60, "Bedrock"));
    }),
    COOLANT(GTBranchDefinition.IC2, "Coolant", false, new Color(1331034), new Color(2397346), beeSpecies -> {
        beeSpecies.addProduct(GTModHandler.getModItem(Mods.Forestry.ID, "beeCombs", 1L, 4), Float.valueOf(0.3f));
        beeSpecies.addSpecialty(GTBees.combs.getStackForType(CombType.COOLANT), Float.valueOf(0.15f));
        beeSpecies.setHumidity(EnumHumidity.ARID);
        beeSpecies.setTemperature(EnumTemperature.COLD);
        beeSpecies.setHasEffect();
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOW);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORT);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_1);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAlleleValue)EnumAllele.Flowers.SNOW);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.EFFECT, (IAllele)AlleleEffect.effectGlacial);
    }, dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(GTBeeDefinition.getSpecies((byte)0, "Icy"), GTBeeDefinition.getSpecies((byte)0, "Glacial"), 10);
        tMutation.requireResource(Block.func_149634_a((Item)GTModHandler.getModItem(Mods.IndustrialCraft2.ID, "fluidCoolant", 1L).func_77973_b()), 0);
        tMutation.restrictTemperature(EnumTemperature.ICY);
    }),
    ENERGY(GTBranchDefinition.IC2, "Energy", false, new Color(0xC11F1F), new Color(0xEBB9B9), beeSpecies -> {
        beeSpecies.addProduct(GTModHandler.getModItem(Mods.ExtraBees.ID, "honeyComb", 1L, 12), Float.valueOf(0.3f));
        beeSpecies.addSpecialty(GTBees.combs.getStackForType(CombType.ENERGY), Float.valueOf(0.15f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.WARM);
        beeSpecies.setHasEffect();
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.LONGER);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.EFFECT, (IAllele)AlleleEffect.effectIgnition);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.DOWN_2);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.NOCTURNAL, true);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAlleleValue)EnumAllele.Flowers.NETHER);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.AVERAGE);
    }, dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(GTBeeDefinition.getSpecies((byte)0, "Demonic"), GTBeeDefinition.getSpecies((byte)1, "volcanic"), 10);
        tMutation.requireResource(Block.func_149634_a((Item)GTModHandler.getModItem(Mods.IndustrialCraft2.ID, "fluidHotCoolant", 1L).func_77973_b()), 0);
        tMutation.addMutationCondition((IMutationCondition)new GTBees.BiomeIDMutationCondition(128, "Boneyard Biome"));
    }),
    LAPOTRON(GTBranchDefinition.IC2, "Lapotron", false, new Color(6584575), new Color(0x1414FF), beeSpecies -> {
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.LAPIS), Float.valueOf(0.2f));
        beeSpecies.addSpecialty(GTBees.combs.getStackForType(CombType.ENERGY), Float.valueOf(0.15f));
        beeSpecies.addSpecialty(GTBees.combs.getStackForType(CombType.LAPOTRON), Float.valueOf(0.1f));
        beeSpecies.setHumidity(EnumHumidity.DAMP);
        beeSpecies.setTemperature(EnumTemperature.ICY);
        beeSpecies.setHasEffect();
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.LONGER);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.EFFECT, (IAllele)AlleleEffect.effectIgnition);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_1);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.NOCTURNAL, true);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAlleleValue)EnumAllele.Flowers.SNOW);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.AVERAGE);
    }, dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(LAPIS, ENERGY, 6);
        tMutation.requireResource("blockLapis");
        tMutation.restrictTemperature(EnumTemperature.ICY);
        tMutation.addMutationCondition((IMutationCondition)new GTBees.DimensionMutationCondition(28, "Moon"));
    }),
    PYROTHEUM(GTBranchDefinition.IC2, "Pyrotheum", false, new Color(16772036), new Color(14902272), beeSpecies -> {
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.ENERGY), Float.valueOf(0.2f));
        beeSpecies.addSpecialty(GTBees.combs.getStackForType(CombType.PYROTHEUM), Float.valueOf(0.15f));
        beeSpecies.setHumidity(EnumHumidity.ARID);
        beeSpecies.setTemperature(EnumTemperature.HELLISH);
        beeSpecies.setHasEffect();
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.FASTEST);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.EFFECT, (IAllele)AlleleEffect.effectIgnition);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.NONE);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.NOCTURNAL, true);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAlleleValue)EnumAllele.Flowers.NETHER);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.AVERAGE);
    }, dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(REDSTONE, ENERGY, 4);
        tMutation.restrictTemperature(EnumTemperature.HELLISH);
    }),
    CRYOTHEUM(GTBranchDefinition.IC2, "Cryotheum", false, new Color(2515199), new Color(5961727), beeSpecies -> {
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.BLIZZ), Float.valueOf(0.15f));
        beeSpecies.addSpecialty(GTBees.combs.getStackForType(CombType.CRYOTHEUM), Float.valueOf(0.2f));
        beeSpecies.setHumidity(EnumHumidity.ARID);
        beeSpecies.setTemperature(EnumTemperature.ICY);
        beeSpecies.setHasEffect();
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWEST);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.LONGEST);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.EFFECT, (IAllele)AlleleEffect.effectSnowing);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.NONE);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.NOCTURNAL, true);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAlleleValue)EnumAllele.Flowers.SNOW);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.AVERAGE);
    }, dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(REDSTONE, COOLANT, 4);
        tMutation.restrictTemperature(EnumTemperature.ICY);
    }),
    Explosive(GTBranchDefinition.IC2, "explosive", false, new Color(8267535), new Color(0x747474), beeSpecies -> {
        beeSpecies.addProduct(GTModHandler.getIC2Item("industrialTnt", 1L), Float.valueOf(0.2f));
        beeSpecies.setHumidity(EnumHumidity.ARID);
        beeSpecies.setTemperature(EnumTemperature.HELLISH);
        beeSpecies.setHasEffect();
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWEST);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.LONGEST);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.EFFECT, (IAllele)AlleleEffect.effectSnowing);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.NONE);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.NOCTURNAL, true);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAlleleValue)EnumAllele.Flowers.SNOW);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.AVERAGE);
    }, dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(FIRESTONE, COAL, 4);
        tMutation.requireResource(GameRegistry.findBlock((String)Mods.IndustrialCraft2.ID, (String)"blockITNT"), 0);
    }),
    REDALLOY(GTBranchDefinition.GTALLOY, "RedAlloy", false, new Color(0xE60000), new Color(0xB80000), beeSpecies -> {
        beeSpecies.addProduct(GTModHandler.getModItem(Mods.Forestry.ID, "beeCombs", 1L, 7), Float.valueOf(0.3f));
        beeSpecies.addSpecialty(GTBees.combs.getStackForType(CombType.REDALLOY), Float.valueOf(0.15f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTER);
    }, dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(COPPER, REDSTONE, 10);
        tMutation.requireResource("blockRedAlloy");
    }),
    REDSTONEALLOY(GTBranchDefinition.GTALLOY, "RedStoneAlloy", false, new Color(10815496), new Color(0xE80000), beeSpecies -> {
        beeSpecies.addProduct(GTModHandler.getModItem(Mods.Forestry.ID, "beeCombs", 1L, 7), Float.valueOf(0.3f));
        beeSpecies.addSpecialty(GTBees.combs.getStackForType(CombType.REDSTONEALLOY), Float.valueOf(0.15f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTER);
    }, dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(REDSTONE, REDALLOY, 8);
        tMutation.requireResource("blockRedstoneAlloy");
    }),
    CONDUCTIVEIRON(GTBranchDefinition.GTALLOY, "ConductiveIron", false, new Color(13544867), new Color(8484465), beeSpecies -> {
        beeSpecies.addProduct(GTModHandler.getModItem(Mods.Forestry.ID, "beeCombs", 1L, 7), Float.valueOf(0.3f));
        beeSpecies.addSpecialty(GTBees.combs.getStackForType(CombType.CONDUCTIVEIRON), Float.valueOf(0.15f));
        beeSpecies.setHumidity(EnumHumidity.DAMP);
        beeSpecies.setTemperature(EnumTemperature.WARM);
        beeSpecies.setHasEffect();
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.FAST);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST);
    }, dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(REDSTONEALLOY, IRON, 8);
        tMutation.requireResource("blockConductiveIron");
    }),
    ENERGETICALLOY(GTBranchDefinition.GTALLOY, "EnergeticAlloy", false, new Color(0xFF9933), new Color(16756060), beeSpecies -> {
        beeSpecies.addProduct(GTModHandler.getModItem(Mods.Forestry.ID, "beeCombs", 1L, 7), Float.valueOf(0.3f));
        beeSpecies.addSpecialty(GTBees.combs.getStackForType(CombType.ENERGETICALLOY), Float.valueOf(0.15f));
        beeSpecies.setHumidity(EnumHumidity.DAMP);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.FAST);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST);
    }, dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(REDSTONEALLOY, GTBeeDefinition.getSpecies((byte)0, "Demonic"), 9);
        tMutation.requireResource("blockEnergeticAlloy");
    }),
    VIBRANTALLOY(GTBranchDefinition.GTALLOY, "VibrantAlloy", false, new Color(8823085), new Color(12907182), beeSpecies -> {
        beeSpecies.addProduct(GTModHandler.getModItem(Mods.Forestry.ID, "beeCombs", 1L, 7), Float.valueOf(0.3f));
        beeSpecies.addSpecialty(GTBees.combs.getStackForType(CombType.VIBRANTALLOY), Float.valueOf(0.15f));
        beeSpecies.setHumidity(EnumHumidity.DAMP);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
        beeSpecies.setHasEffect();
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.FAST);
    }, dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(ENERGETICALLOY, GTBeeDefinition.getSpecies((byte)0, "Phantasmal"), 6);
        tMutation.requireResource("blockVibrantAlloy");
        tMutation.restrictTemperature(EnumTemperature.HOT, EnumTemperature.HELLISH);
    }),
    ELECTRICALSTEEL(GTBranchDefinition.GTALLOY, "ElectricalSteel", false, new Color(0x787878), new Color(0xD8D8D8), beeSpecies -> {
        beeSpecies.addProduct(GTModHandler.getModItem(Mods.Forestry.ID, "beeCombs", 1L, 7), Float.valueOf(0.3f));
        beeSpecies.addSpecialty(GTBees.combs.getStackForType(CombType.ELECTRICALSTEEL), Float.valueOf(0.15f));
        beeSpecies.setHumidity(EnumHumidity.DAMP);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTER);
    }, dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(STEEL, GTBeeDefinition.getSpecies((byte)0, "Demonic"), 9);
        tMutation.requireResource("blockElectricalSteel");
    }),
    DARKSTEEL(GTBranchDefinition.GTALLOY, "DarkSteel", false, new Color(0x252525), new Color(0x443B44), beeSpecies -> {
        beeSpecies.addProduct(GTModHandler.getModItem(Mods.Forestry.ID, "beeCombs", 1L, 7), Float.valueOf(0.3f));
        beeSpecies.addSpecialty(GTBees.combs.getStackForType(CombType.DARKSTEEL), Float.valueOf(0.15f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.COLD);
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.FAST);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST);
    }, dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(ELECTRICALSTEEL, GTBeeDefinition.getSpecies((byte)0, "Demonic"), 7);
        tMutation.requireResource("blockDarkSteel");
    }),
    PULSATINGIRON(GTBranchDefinition.GTALLOY, "PulsatingIron", false, new Color(7197316), new Color(26112), beeSpecies -> {
        beeSpecies.addProduct(GTModHandler.getModItem(Mods.Forestry.ID, "beeCombs", 1L, 7), Float.valueOf(0.3f));
        beeSpecies.addSpecialty(GTBees.combs.getStackForType(CombType.PULSATINGIRON), Float.valueOf(0.15f));
        beeSpecies.setHumidity(EnumHumidity.DAMP);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.FAST);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST);
    }, dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(REDALLOY, GTBeeDefinition.getSpecies((byte)0, "Ended"), 9);
        tMutation.requireResource("blockPulsatingIron");
    }),
    STAINLESSSTEEL(GTBranchDefinition.GTALLOY, "StainlessSteel", false, new Color(0xC8C8DC), new Color(0x778899), beeSpecies -> {
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.SLAG), Float.valueOf(0.3f));
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.STEEL), Float.valueOf(0.1f));
        beeSpecies.addSpecialty(GTBees.combs.getStackForType(CombType.STAINLESSSTEEL), Float.valueOf(0.15f));
        beeSpecies.addSpecialty(GTBees.combs.getStackForType(CombType.CHROME), Float.valueOf(0.05f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.HOT);
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.FAST);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.EFFECT, (IAllele)AlleleEffect.effectIgnition);
    }, dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(CHROME, STEEL, 9);
        tMutation.requireResource("blockStainlessSteel");
    }),
    ENDERIUM(GTBranchDefinition.GTALLOY, "Enderium", false, new Color(5869703), new Color(3050327), beeSpecies -> {
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.SLAG), Float.valueOf(0.3f));
        beeSpecies.addSpecialty(GTBees.combs.getStackForType(CombType.ENDERIUM), Float.valueOf(0.15f));
        beeSpecies.addSpecialty(GTBees.combs.getStackForType(CombType.CHROME), Float.valueOf(0.05f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.HOT);
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAllele)GTBees.speedBlinding);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.EFFECT, (IAllele)GTBeeDefinition.getEffect((byte)1, "teleport"));
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST);
    }, dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(PLATINUM, GTBeeDefinition.getSpecies((byte)0, "Phantasmal"), 3);
        tMutation.requireResource("blockEnderium");
    }),
    BEDROCKIUM(GTBranchDefinition.GTALLOY, "Bedrockium", false, new Color(789516), new Color(0xC6C6C6), beeSpecies -> {
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.SLAG), Float.valueOf(0.2f));
        beeSpecies.addSpecialty(GTBees.combs.getStackForType(CombType.BEDROCKIUM), Float.valueOf(0.55f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.HOT);
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOW);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.EFFECT, (IAllele)GTBeeDefinition.getEffect((byte)1, "gravity"));
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST);
    }, dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(Explosive, DIAMOND, 2);
        if (Mods.ExtraUtilities.isModLoaded()) {
            tMutation.requireResource(GameRegistry.findBlock((String)Mods.ExtraUtilities.ID, (String)"block_bedrockium"), 0);
        }
    }),
    THAUMIUMDUST(GTBranchDefinition.THAUMIC, "ThaumiumDust", true, new Color(0x7A007A), new Color(0x5C005C), beeSpecies -> {
        beeSpecies.addProduct(GTModHandler.getModItem(Mods.Forestry.ID, "beeCombs", 1L, 3), Float.valueOf(0.3f));
        beeSpecies.addSpecialty(GTBees.combs.getStackForType(CombType.THAUMIUMDUST), Float.valueOf(0.2f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWEST);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.LONGER);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_2);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.EFFECT, (IAllele)AlleleEffect.effectExploration);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_1);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAlleleValue)EnumAllele.Flowers.JUNGLE);
    }, dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(GTBeeDefinition.getSpecies((byte)3, "TCFire"), GTBeeDefinition.getSpecies((byte)0, "Edenic"), 10);
        tMutation.requireResource("blockThaumium");
        tMutation.addMutationCondition((IMutationCondition)new GTBees.BiomeIDMutationCondition(192, "Magical Forest"));
    }),
    THAUMIUMSHARD(GTBranchDefinition.THAUMIC, "ThaumiumShard", true, new Color(0x9966FF), new Color(11372031), beeSpecies -> {
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.THAUMIUMDUST), Float.valueOf(0.3f));
        beeSpecies.addSpecialty(GTBees.combs.getStackForType(CombType.THAUMIUMSHARD), Float.valueOf(0.2f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
        beeSpecies.setHasEffect();
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORT);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_1);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAlleleValue)EnumAllele.Flowers.SNOW);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.EFFECT, (IAllele)AlleleEffect.effectGlacial);
    }, dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(THAUMIUMDUST, GTBeeDefinition.getSpecies((byte)3, "TCWater"), 10);
        tMutation.addMutationCondition((IMutationCondition)new GTBees.BiomeIDMutationCondition(192, "Magical Forest"));
    }),
    AMBER(GTBranchDefinition.THAUMIC, "Amber", true, new Color(0xEE7700), new Color(7818005), beeSpecies -> {
        beeSpecies.addProduct(GTModHandler.getModItem(Mods.Forestry.ID, "beeCombs", 1L, 3), Float.valueOf(0.3f));
        beeSpecies.addSpecialty(GTBees.combs.getStackForType(CombType.AMBER), Float.valueOf(0.2f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
        beeSpecies.setHasEffect();
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.NONE);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.NONE);
    }, dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(THAUMIUMDUST, STICKYRESIN, 10);
        tMutation.requireResource("blockAmber");
    }),
    QUICKSILVER(GTBranchDefinition.THAUMIC, "Quicksilver", true, new Color(0x7A007A), new Color(0x5C005C), beeSpecies -> {
        beeSpecies.addProduct(GTModHandler.getModItem(Mods.Forestry.ID, "beeCombs", 1L, 3), Float.valueOf(0.3f));
        beeSpecies.addSpecialty(GTBees.combs.getStackForType(CombType.QUICKSILVER), Float.valueOf(0.2f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
        beeSpecies.setHasEffect();
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_1);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_1);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAlleleValue)EnumAllele.Flowers.JUNGLE);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.EFFECT, (IAllele)AlleleEffect.effectMiasmic);
    }, dis -> dis.registerMutation(THAUMIUMDUST, SILVER, 10)),
    SALISMUNDUS(GTBranchDefinition.THAUMIC, "SalisMundus", true, new Color(16231902), new Color(5842306), beeSpecies -> {
        beeSpecies.addProduct(GTModHandler.getModItem(Mods.Forestry.ID, "beeCombs", 1L, 3), Float.valueOf(0.3f));
        beeSpecies.addSpecialty(GTBees.combs.getStackForType(CombType.SALISMUNDUS), Float.valueOf(0.2f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
        beeSpecies.setHasEffect();
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_1);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_1);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAlleleValue)EnumAllele.Flowers.JUNGLE);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.EFFECT, (IAllele)AlleleEffect.effectMiasmic);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORT);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER);
    }, dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(THAUMIUMDUST, THAUMIUMSHARD, 8);
        tMutation.addMutationCondition((IMutationCondition)new GTBees.BiomeIDMutationCondition(192, "Magical Forest"));
    }),
    TAINTED(GTBranchDefinition.THAUMIC, "Tainted", true, new Color(9456568), new Color(15204607), beeSpecies -> {
        beeSpecies.addProduct(GTModHandler.getModItem(Mods.Forestry.ID, "beeCombs", 1L, 3), Float.valueOf(0.3f));
        beeSpecies.addSpecialty(GTBees.combs.getStackForType(CombType.TAINTED), Float.valueOf(0.2f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
        beeSpecies.setHasEffect();
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.NOCTURNAL, true);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.CAVE_DWELLING, true);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TOLERANT_FLYER, true);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.LOW);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORT);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAllele)GTBeeDefinition.getFlowers((byte)1, "rock"));
    }, dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(THAUMIUMDUST, THAUMIUMSHARD, 7);
        tMutation.addMutationCondition((IMutationCondition)new GTBees.BiomeIDMutationCondition(193, "Tainted Land"));
    }),
    MITHRIL(GTBranchDefinition.THAUMIC, "Mithril", true, new Color(15787660), new Color(0xFFFFD2), beeSpecies -> {
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.PLATINUM), Float.valueOf(0.2f));
        beeSpecies.addSpecialty(GTBees.combs.getStackForType(CombType.MITHRIL), Float.valueOf(0.125f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.NOCTURNAL, true);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.CAVE_DWELLING, true);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TOLERANT_FLYER, true);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.LOW);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORT);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAllele)GTBeeDefinition.getFlowers((byte)1, "rock"));
    }, new Consumer<GTBeeDefinition>(){

        @Override
        public void accept(GTBeeDefinition dis) {
            IBeeMutationCustom tMutation = dis.registerMutation(IO, PLATINUM, 7);
            tMutation.requireResource(GregTechAPI.sBlockMetal4, 10);
            tMutation.addMutationCondition((IMutationCondition)new GTBees.DimensionMutationCondition(36, "IO"));
        }
    }),
    ASTRALSILVER(GTBranchDefinition.THAUMIC, "AstralSilver", true, new Color(0xAFEEEE), new Color(0xE6E6FF), beeSpecies -> {
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.SILVER), Float.valueOf(0.2f));
        beeSpecies.addSpecialty(GTBees.combs.getStackForType(CombType.ASTRALSILVER), Float.valueOf(0.125f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.NOCTURNAL, true);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.CAVE_DWELLING, true);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TOLERANT_FLYER, true);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.LOW);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORT);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAllele)GTBeeDefinition.getFlowers((byte)1, "rock"));
    }, dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(SILVER, IRON, 3);
        tMutation.requireResource(GregTechAPI.sBlockMetal1, 6);
    }),
    THAUMINITE(GTBranchDefinition.THAUMIC, "Thauminite", true, new Color(3026297), new Color(7700960), beeSpecies -> {
        beeSpecies.addProduct(GTModHandler.getModItem(Mods.MagicBees.ID, "comb", 1L, 19), Float.valueOf(0.2f));
        beeSpecies.addSpecialty(GTBees.combs.getStackForType(CombType.THAUMINITE), Float.valueOf(0.125f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
        beeSpecies.setHasEffect();
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORT);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.SLOW);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.NOCTURNAL, true);
    }, dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(GTBeeDefinition.getSpecies((byte)3, "TCOrder"), THAUMIUMDUST, 8);
        if (Mods.ThaumicBases.isModLoaded()) {
            tMutation.requireResource(GameRegistry.findBlock((String)Mods.ThaumicBases.ID, (String)"thauminiteBlock"), 0);
        }
    }),
    SHADOWMETAL(GTBranchDefinition.THAUMIC, "ShadowMetal", true, new Color(1049378), new Color(1049410), beeSpecies -> {
        beeSpecies.addProduct(GTModHandler.getModItem(Mods.MagicBees.ID, "comb", 1L, 20), Float.valueOf(0.2f));
        beeSpecies.addSpecialty(GTBees.combs.getStackForType(CombType.SHADOWMETAL), Float.valueOf(0.125f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
        beeSpecies.setHasEffect();
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORT);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.SLOW);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.NONE);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.NONE);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.NOCTURNAL, true);
    }, dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(GTBeeDefinition.getSpecies((byte)3, "TCChaos"), GTBeeDefinition.getSpecies((byte)3, "TCVoid"), 6);
        if (Mods.TaintedMagic.isModLoaded()) {
            tMutation.requireResource("blockShadow");
        }
    }),
    DIVIDED(GTBranchDefinition.THAUMIC, "Unstable", true, new Color(0xF0F0F0), new Color(0xDCDCDC), beeSpecies -> {
        beeSpecies.addProduct(GTModHandler.getModItem(Mods.ExtraBees.ID, "honeyComb", 1L, 61), Float.valueOf(0.2f));
        beeSpecies.addSpecialty(GTBees.combs.getStackForType(CombType.DIVIDED), Float.valueOf(0.125f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
        beeSpecies.setHasEffect();
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORT);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.SLOW);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.NOCTURNAL, true);
    }, dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(DIAMOND, IRON, 3);
        if (Mods.ExtraUtilities.isModLoaded()) {
            tMutation.requireResource(GameRegistry.findBlock((String)Mods.ExtraUtilities.ID, (String)"decorativeBlock1"), 5);
        }
    }),
    CAELESTIS(GTBranchDefinition.THAUMIC, "Caelestis", true, new Color(0xF0F0F0), new Color(0xDCDCDC), beeSpecies -> {
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.CAELESTISRED), Float.valueOf(0.6f));
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.CAELESTISBLUE), Float.valueOf(0.6f));
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.CAELESTISGREEN), Float.valueOf(0.6f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
        beeSpecies.setHasEffect();
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORT);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.SLOW);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.NOCTURNAL, true);
    }, dis -> dis.registerMutation(DIAMOND, DIVIDED, 10)),
    SPARKELING(GTBranchDefinition.THAUMIC, "NetherStar", true, new Color(0x7A007A), new Color(0xFFFFFF), beeSpecies -> {
        beeSpecies.addProduct(GTModHandler.getModItem(Mods.MagicBees.ID, "miscResources", 1L, 3), Float.valueOf(0.2f));
        beeSpecies.addSpecialty(GTBees.combs.getStackForType(CombType.SPARKLING), Float.valueOf(0.125f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.DOWN_2);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.NOCTURNAL, true);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.CAVE_DWELLING, true);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAlleleValue)EnumAllele.Flowers.NETHER);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORT);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.EFFECT, (IAllele)AlleleEffect.effectAggressive);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.AVERAGE);
    }, dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(GTBeeDefinition.getSpecies((byte)3, "Withering"), GTBeeDefinition.getSpecies((byte)3, "Draconic"), 1);
        tMutation.requireResource(GregTechAPI.sBlockGem3, 3);
        tMutation.addMutationCondition((IMutationCondition)new GTBees.BiomeIDMutationCondition(9, "END Biome"));
    }),
    ESSENTIA(GTBranchDefinition.THAUMIC, "Essentia", true, new Color(0x7A007A), new Color(0xFFFFFF), beeSpecies -> {
        beeSpecies.addProduct(GTModHandler.getModItem(Mods.MagicBees.ID, "miscResources", 1L, 3), Float.valueOf(0.2f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.DOWN_2);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.CAVE_DWELLING, true);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAlleleValue)EnumAllele.Flowers.VANILLA);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.EFFECT, (IAllele)AlleleEffect.effectReanimation);
    }, dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(SHADOWMETAL, SPARKELING, 5);
        if (Mods.Thaumcraft.isModLoaded()) {
            tMutation.requireResource(GameRegistry.findBlock((String)Mods.Thaumcraft.ID, (String)"blockCrystal"), 6);
        }
    }),
    DRAKE(GTBranchDefinition.THAUMIC, "Drake", true, new Color(1049378), new Color(0x7A007A), beeSpecies -> {
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.DRACONIC), Float.valueOf(0.3f));
        beeSpecies.addSpecialty(GTBees.combs.getStackForType(CombType.AWAKENEDDRACONIUM), Float.valueOf(0.2f));
        beeSpecies.setHumidity(EnumHumidity.DAMP);
        beeSpecies.setTemperature(EnumTemperature.HELLISH);
        beeSpecies.setJubilanceProvider(JubilanceMegaApiary.instance);
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.DOWN_3);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.CAVE_DWELLING, false);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAlleleValue)EnumAllele.Flowers.END);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.EFFECT, (IAllele)AlleleEffect.effectDrunkard);
    }, dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(ESSENTIA, THAUMINITE, 5);
        GregTechAPI.sGTCompleteLoad.add(() -> tMutation.requireResource(GregTechAPI.sBlockCasings5, 8));
    }),
    URANIUM(GTBranchDefinition.RADIOACTIVE, "Uranium", true, new Color(1683225), new Color(1482262), beeSpecies -> {
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.SLAG), Float.valueOf(0.3f));
        beeSpecies.addSpecialty(GTBees.combs.getStackForType(CombType.URANIUM), Float.valueOf(0.15f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.COLD);
        beeSpecies.setNocturnal();
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWEST);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.LONGEST);
    }, dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(GTBeeDefinition.getSpecies((byte)0, "Avenging"), PLATINUM, 3);
        tMutation.requireResource(GregTechAPI.sBlockMetal7, 14);
    }),
    PLUTONIUM(GTBranchDefinition.RADIOACTIVE, "Plutonium", true, new Color(0x570000), new Color(0x240000), beeSpecies -> {
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.SLAG), Float.valueOf(0.3f));
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.LEAD), Float.valueOf(0.15f));
        beeSpecies.addSpecialty(GTBees.combs.getStackForType(CombType.PLUTONIUM), Float.valueOf(0.15f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.ICY);
        beeSpecies.setNocturnal();
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWEST);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.LONGEST);
    }, dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(URANIUM, EMERALD, 3);
        tMutation.requireResource(GregTechAPI.sBlockMetal5, 13);
    }),
    NAQUADAH(GTBranchDefinition.RADIOACTIVE, "Naquadah", false, new Color(13056), new Color(9216), beeSpecies -> {
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.SLAG), Float.valueOf(0.3f));
        beeSpecies.addSpecialty(GTBees.combs.getStackForType(CombType.NAQUADAH), Float.valueOf(0.15f));
        beeSpecies.setHumidity(EnumHumidity.ARID);
        beeSpecies.setTemperature(EnumTemperature.ICY);
        beeSpecies.setNocturnal();
        beeSpecies.setHasEffect();
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWEST);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.LONGEST);
    }, dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(PLUTONIUM, IRIDIUM, 3);
        tMutation.requireResource(GregTechAPI.sBlockMetal4, 12);
    }),
    NAQUADRIA(GTBranchDefinition.RADIOACTIVE, "Naquadria", false, new Color(0), new Color(9216), beeSpecies -> {
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.SLAG), Float.valueOf(0.3f));
        beeSpecies.addSpecialty(GTBees.combs.getStackForType(CombType.NAQUADAH), Float.valueOf(0.2f));
        beeSpecies.addSpecialty(GTBees.combs.getStackForType(CombType.NAQUADRIA), Float.valueOf(0.15f));
        beeSpecies.setHumidity(EnumHumidity.ARID);
        beeSpecies.setTemperature(EnumTemperature.ICY);
        beeSpecies.setNocturnal();
        beeSpecies.setHasEffect();
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWEST);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.LONGEST);
    }, dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(PLUTONIUM, IRIDIUM, 8, 10.0f);
        tMutation.requireResource(GregTechAPI.sBlockMetal4, 15);
    }),
    DOB(GTBranchDefinition.RADIOACTIVE, "DOB", false, new Color(13056), new Color(9216), beeSpecies -> {
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.DOB), Float.valueOf(0.75f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
        beeSpecies.setNocturnal();
        beeSpecies.setHasEffect();
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.FAST);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST);
    }, dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(NAQUADAH, THAUMIUMSHARD, 2);
        if (Mods.AdvancedSolarPanel.isModLoaded()) {
            tMutation.requireResource(GameRegistry.findBlock((String)Mods.AdvancedSolarPanel.ID, (String)"BlockAdvSolarPanel"), 2);
        }
        tMutation.addMutationCondition((IMutationCondition)new GTBees.BiomeIDMutationCondition(9, "END Biome"));
    }),
    THORIUM(GTBranchDefinition.RADIOACTIVE, "Thorium", false, new Color(20480), new Color(7680), beeSpecies -> {
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.THORIUM), Float.valueOf(0.75f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.COLD);
        beeSpecies.setNocturnal();
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWEST);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.LONGEST);
    }, dis -> {
        IMutationCustom tMutation = dis.registerMutation(COAL, URANIUM, 3).setIsSecret();
        tMutation.requireResource(GregTechAPI.sBlockMetal7, 5);
    }),
    LUTETIUM(GTBranchDefinition.RADIOACTIVE, "Lutetium", false, new Color(0xE6FFE6), new Color(0xFFFFFF), beeSpecies -> {
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.LUTETIUM), Float.valueOf(0.15f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
        beeSpecies.setNocturnal();
        beeSpecies.setHasEffect();
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWEST);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.LONGEST);
    }, dis -> {
        IMutationCustom tMutation = dis.registerMutation(THORIUM, GTBeeDefinition.getSpecies((byte)1, "rotten"), 1).setIsSecret();
        tMutation.requireResource(GregTechAPI.sBlockMetal4, 3);
    }),
    AMERICIUM(GTBranchDefinition.RADIOACTIVE, "Americium", false, new Color(0xE6E6FF), new Color(0xC8C8C8), beeSpecies -> {
        beeSpecies.addSpecialty(GTBees.combs.getStackForType(CombType.AMERICIUM), Float.valueOf(0.075f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
        beeSpecies.setNocturnal();
        beeSpecies.setHasEffect();
        beeSpecies.setJubilanceProvider(JubilanceMegaApiary.instance);
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWEST);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.LONGEST);
    }, dis -> {
        IMutationCustom tMutation = dis.registerMutation(LUTETIUM, CHROME, 5, 4.0f).setIsSecret();
        tMutation.requireResource(GregTechAPI.sBlockMetal1, 2);
    }),
    NEUTRONIUM(GTBranchDefinition.RADIOACTIVE, "Neutronium", false, new Color(0xFFF0F0), new Color(0xFAFAFA), beeSpecies -> {
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.NEUTRONIUM), Float.valueOf(0.02f));
        beeSpecies.setHumidity(EnumHumidity.DAMP);
        beeSpecies.setTemperature(EnumTemperature.HELLISH);
        beeSpecies.setHasEffect();
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWEST);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.LONGEST);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.NOCTURNAL, true);
    }, dis -> {
        IMutationCustom tMutation = dis.registerMutation(NAQUADRIA, AMERICIUM, 2, 2.0f).setIsSecret();
        tMutation.requireResource(GregTechAPI.sBlockMetal5, 2);
    }),
    NAGA(GTBranchDefinition.TWILIGHT, "Naga", true, new Color(875021), new Color(2656075), beeSpecies -> {
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.SALISMUNDUS), Float.valueOf(0.02f));
        beeSpecies.addSpecialty(GTBees.combs.getStackForType(CombType.NAGA), Float.valueOf(0.1f));
        beeSpecies.setHumidity(EnumHumidity.DAMP);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
        beeSpecies.setHasEffect();
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.FAST);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST);
    }, dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(GTBeeDefinition.getSpecies((byte)3, "Eldritch"), GTBeeDefinition.getSpecies((byte)0, "Imperial"), 8);
        tMutation.restrictHumidity(EnumHumidity.DAMP);
    }),
    LICH(GTBranchDefinition.TWILIGHT, "Lich", true, new Color(0xC5C5C5), new Color(6053982), beeSpecies -> {
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.SALISMUNDUS), Float.valueOf(0.04f));
        beeSpecies.addSpecialty(GTBees.combs.getStackForType(CombType.LICH), Float.valueOf(0.1f));
        beeSpecies.setHumidity(EnumHumidity.ARID);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
        beeSpecies.setHasEffect();
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.FAST);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST);
    }, dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(GTBeeDefinition.getSpecies((byte)3, "Supernatural"), NAGA, 7);
        tMutation.restrictHumidity(EnumHumidity.ARID);
    }),
    HYDRA(GTBranchDefinition.TWILIGHT, "Hydra", true, new Color(8857654), new Color(12063532), beeSpecies -> {
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.SALISMUNDUS), Float.valueOf(0.06f));
        beeSpecies.addSpecialty(GTBees.combs.getStackForType(CombType.HYDRA), Float.valueOf(0.1f));
        beeSpecies.setHumidity(EnumHumidity.ARID);
        beeSpecies.setTemperature(EnumTemperature.HELLISH);
        beeSpecies.setHasEffect();
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.FAST);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST);
    }, dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(LICH, GTBeeDefinition.getSpecies((byte)3, "TCFire"), 6);
        tMutation.addMutationCondition((IMutationCondition)new GTBees.BiomeIDMutationCondition(138, "Undergarden"));
    }),
    URGHAST(GTBranchDefinition.TWILIGHT, "UrGhast", true, new Color(10945564), new Color(8128024), beeSpecies -> {
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.SALISMUNDUS), Float.valueOf(0.08f));
        beeSpecies.addSpecialty(GTBees.combs.getStackForType(CombType.URGHAST), Float.valueOf(0.1f));
        beeSpecies.setHumidity(EnumHumidity.ARID);
        beeSpecies.setTemperature(EnumTemperature.HELLISH);
        beeSpecies.setHasEffect();
        beeSpecies.setNocturnal();
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.FAST);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST);
    }, dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(HYDRA, THAUMIUMDUST, 5);
        if (Mods.Thaumcraft.isModLoaded()) {
            tMutation.requireResource(GameRegistry.findBlock((String)Mods.Thaumcraft.ID, (String)"blockCosmeticSolid"), 4);
        }
        tMutation.restrictTemperature(EnumTemperature.HELLISH);
    }),
    SNOWQUEEN(GTBranchDefinition.TWILIGHT, "SnowQueen", true, new Color(13639681), new Color(10223640), beeSpecies -> {
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.SALISMUNDUS), Float.valueOf(0.15f));
        beeSpecies.addSpecialty(GTBees.combs.getStackForType(CombType.SNOWQUEEN), Float.valueOf(0.1f));
        beeSpecies.setHumidity(EnumHumidity.ARID);
        beeSpecies.setTemperature(EnumTemperature.ICY);
        beeSpecies.setHasEffect();
        beeSpecies.setNocturnal();
    }, template -> {}, dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(URGHAST, SALISMUNDUS, 4);
        if (Mods.ThaumicBases.isModLoaded()) {
            tMutation.requireResource(GameRegistry.findBlock((String)Mods.ThaumicBases.ID, (String)"blockSalisMundus"), 0);
        }
        tMutation.restrictTemperature(EnumTemperature.ICY);
    }),
    ENDDUST(GTBranchDefinition.HEE, "End Dust", true, new Color(13369594), new Color(14973), beeSpecies -> {
        beeSpecies.addProduct(GTModHandler.getModItem(Mods.Forestry.ID, "beeCombs", 1L, 8), Float.valueOf(0.3f));
        beeSpecies.addSpecialty(GTBees.combs.getStackForType(CombType.ENDDUST), Float.valueOf(0.1f));
        beeSpecies.setHumidity(EnumHumidity.ARID);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
        beeSpecies.setHasEffect();
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.NORMAL), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(GTBeeDefinition.getSpecies((byte)0, "Ended"), STAINLESSSTEEL, 8);
        tMutation.restrictHumidity(EnumHumidity.ARID);
        if (Mods.HardcoreEnderExpansion.isModLoaded()) {
            tMutation.requireResource(GameRegistry.findBlock((String)Mods.HardcoreEnderExpansion.ID, (String)"end_powder_ore"), 0);
        }
        tMutation.addMutationCondition((IMutationCondition)new GTBees.DimensionMutationCondition(1, "End"));
    }),
    ENDIUM(GTBranchDefinition.HEE, "Endium", true, new Color(0xA0FFFF), new Color(3103340), beeSpecies -> {
        beeSpecies.addProduct(GTModHandler.getModItem(Mods.Forestry.ID, "beeCombs", 1L, 8), Float.valueOf(0.3f));
        beeSpecies.addSpecialty(GTBees.combs.getStackForType(CombType.ENDIUM), Float.valueOf(0.1f));
        beeSpecies.addSpecialty(GTBees.propolis.getStackForType(PropolisType.Endium), Float.valueOf(0.15f));
        beeSpecies.addSpecialty(GTBees.drop.getStackForType(DropType.ENDERGOO), Float.valueOf(0.1f));
        beeSpecies.setHumidity(EnumHumidity.ARID);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
        beeSpecies.setHasEffect();
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.NORMAL), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(GTBeeDefinition.getSpecies((byte)0, "Ended"), THAUMIUMDUST, 8);
        tMutation.restrictHumidity(EnumHumidity.ARID);
        if (Mods.HardcoreEnderExpansion.isModLoaded()) {
            tMutation.requireResource("blockHeeEndium");
        }
        tMutation.addMutationCondition((IMutationCondition)new GTBees.DimensionMutationCondition(1, "End"));
    }),
    STARDUST(GTBranchDefinition.HEE, "Star Dust", true, new Color(0xFFFF00), new Color(14466579), beeSpecies -> {
        beeSpecies.addProduct(GTModHandler.getModItem(Mods.Forestry.ID, "beeCombs", 1L, 8), Float.valueOf(0.3f));
        beeSpecies.addSpecialty(GTBees.combs.getStackForType(CombType.STARDUST), Float.valueOf(0.1f));
        beeSpecies.setHumidity(EnumHumidity.ARID);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
        beeSpecies.setHasEffect();
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAllele)GTBees.speedBlinding);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.SLOWER);
    }, dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(GTBeeDefinition.getSpecies((byte)0, "Ended"), ZINC, 8);
        tMutation.restrictHumidity(EnumHumidity.ARID);
        if (Mods.HardcoreEnderExpansion.isModLoaded()) {
            tMutation.requireResource(GameRegistry.findBlock((String)Mods.HardcoreEnderExpansion.ID, (String)"stardust_ore"), 0);
        }
        tMutation.addMutationCondition((IMutationCondition)new GTBees.DimensionMutationCondition(1, "End"));
    }),
    ECTOPLASMA(GTBranchDefinition.HEE, "Ectoplasma", true, new Color(14463205), new Color(3677248), beeSpecies -> {
        beeSpecies.addProduct(GTModHandler.getModItem(Mods.Forestry.ID, "beeCombs", 1L, 8), Float.valueOf(0.3f));
        beeSpecies.addSpecialty(GTBees.combs.getStackForType(CombType.ECTOPLASMA), Float.valueOf(0.1f));
        beeSpecies.setHumidity(EnumHumidity.ARID);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
        beeSpecies.setHasEffect();
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORT);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
    }, dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(GTBeeDefinition.getSpecies((byte)0, "Ended"), ENDDUST, 5);
        tMutation.restrictHumidity(EnumHumidity.ARID);
        if (Mods.HardcoreEnderExpansion.isModLoaded()) {
            tMutation.requireResource(GameRegistry.findBlock((String)Mods.HardcoreEnderExpansion.ID, (String)"spooky_log"), 0);
        }
        tMutation.addMutationCondition((IMutationCondition)new GTBees.DimensionMutationCondition(1, "End"));
    }),
    ARCANESHARDS(GTBranchDefinition.HEE, "Arcane Shards", true, new Color(9441453), new Color(3358082), beeSpecies -> {
        beeSpecies.addProduct(GTModHandler.getModItem(Mods.Forestry.ID, "beeCombs", 1L, 8), Float.valueOf(0.3f));
        beeSpecies.addSpecialty(GTBees.combs.getStackForType(CombType.ARCANESHARD), Float.valueOf(0.1f));
        beeSpecies.setHumidity(EnumHumidity.ARID);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
        beeSpecies.setHasEffect();
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.LONG);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
    }, dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(THAUMIUMSHARD, ENDDUST, 5);
        tMutation.restrictHumidity(EnumHumidity.ARID);
        if (Mods.HardcoreEnderExpansion.isModLoaded()) {
            tMutation.requireResource(GameRegistry.findBlock((String)Mods.HardcoreEnderExpansion.ID, (String)"laboratory_floor"), 0);
        }
        tMutation.addMutationCondition((IMutationCondition)new GTBees.DimensionMutationCondition(1, "End"));
    }),
    DRAGONESSENCE(GTBranchDefinition.HEE, "Dragonessence", true, new Color(16752939), new Color(9510606), beeSpecies -> {
        beeSpecies.addProduct(GTModHandler.getModItem(Mods.Forestry.ID, "beeCombs", 1L, 8), Float.valueOf(0.3f));
        beeSpecies.addSpecialty(GTBees.combs.getStackForType(CombType.DRAGONESSENCE), Float.valueOf(0.1f));
        beeSpecies.setHumidity(EnumHumidity.ARID);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
        beeSpecies.setHasEffect();
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.LONGER);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.EFFECT, (IAllele)AlleleEffect.effectBeatific);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_3);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_3);
    }, dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(ECTOPLASMA, ARCANESHARDS, 4);
        tMutation.restrictHumidity(EnumHumidity.ARID);
        if (Mods.HardcoreEnderExpansion.isModLoaded()) {
            tMutation.requireResource(GameRegistry.findBlock((String)Mods.HardcoreEnderExpansion.ID, (String)"essence_altar"), 1);
        }
        tMutation.addMutationCondition((IMutationCondition)new GTBees.DimensionMutationCondition(1, "End"));
    }),
    FIREESSENCE(GTBranchDefinition.HEE, "Fireessence", true, new Color(13898296), new Color(16752983), beeSpecies -> {
        beeSpecies.addProduct(GTModHandler.getModItem(Mods.Forestry.ID, "beeCombs", 1L, 8), Float.valueOf(0.3f));
        beeSpecies.addSpecialty(GTBees.combs.getStackForType(CombType.FIREESSENSE), Float.valueOf(0.1f));
        beeSpecies.setHumidity(EnumHumidity.ARID);
        beeSpecies.setTemperature(EnumTemperature.HELLISH);
        beeSpecies.setHasEffect();
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.ELONGATED);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.EFFECT, (IAllele)AlleleEffect.effectIgnition);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_3);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.DOWN_3);
    }, dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(FIRESTONE, ARCANESHARDS, 4);
        tMutation.restrictHumidity(EnumHumidity.ARID);
        if (Mods.HardcoreEnderExpansion.isModLoaded()) {
            tMutation.requireResource(GameRegistry.findBlock((String)Mods.HardcoreEnderExpansion.ID, (String)"essence_altar"), 2);
        }
        tMutation.addMutationCondition((IMutationCondition)new GTBees.DimensionMutationCondition(1, "End"));
    }),
    ENDERMANHEAD(GTBranchDefinition.HEE, "EndermanHead", true, new Color(0x161616), new Color(6422759), beeSpecies -> {
        beeSpecies.addProduct(GTModHandler.getModItem(Mods.Forestry.ID, "beeCombs", 1L, 8), Float.valueOf(0.3f));
        beeSpecies.addSpecialty(GTBees.combs.getStackForType(CombType.ENDERMAN), Float.valueOf(0.1f));
        beeSpecies.setHumidity(EnumHumidity.ARID);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
        beeSpecies.setHasEffect();
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.LONGER);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.EFFECT, (IAllele)GTBeeDefinition.getEffect((byte)1, "teleport"));
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_1);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_1);
    }, dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(ENDERIUM, STARDUST, 4);
        tMutation.restrictHumidity(EnumHumidity.ARID);
        if (Mods.HardcoreEnderExpansion.isModLoaded()) {
            tMutation.requireResource(GameRegistry.findBlock((String)Mods.HardcoreEnderExpansion.ID, (String)"ender_goo"), 0);
        }
        tMutation.addMutationCondition((IMutationCondition)new GTBees.DimensionMutationCondition(1, "End"));
    }),
    SILVERFISH(GTBranchDefinition.HEE, "Silverfisch", true, new Color(15598909), new Color(0), beeSpecies -> {
        beeSpecies.addProduct(GTModHandler.getModItem(Mods.Forestry.ID, "beeCombs", 1L, 8), Float.valueOf(0.3f));
        beeSpecies.addSpecialty(GTBees.combs.getStackForType(CombType.SILVERFISH), Float.valueOf(0.1f));
        beeSpecies.setHumidity(EnumHumidity.ARID);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
        beeSpecies.setHasEffect();
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.LONGER);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.EFFECT, (IAllele)GTBeeDefinition.getEffect((byte)3, "SlowSpeed"));
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.DOWN_1);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.DOWN_1);
    }, dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(ECTOPLASMA, STARDUST, 5);
        tMutation.restrictHumidity(EnumHumidity.ARID);
        if (Mods.HardcoreEnderExpansion.isModLoaded()) {
            tMutation.requireResource(GameRegistry.findBlock((String)Mods.HardcoreEnderExpansion.ID, (String)"ender_goo"), 0);
        }
        tMutation.addMutationCondition((IMutationCondition)new GTBees.DimensionMutationCondition(1, "End"));
    }),
    RUNE(GTBranchDefinition.HEE, "Rune", true, new Color(14880784), new Color(66777), beeSpecies -> {
        beeSpecies.addProduct(GTModHandler.getModItem(Mods.Forestry.ID, "beeCombs", 1L, 8), Float.valueOf(0.3f));
        beeSpecies.addSpecialty(GTBees.combs.getStackForType(CombType.RUNEI), Float.valueOf(0.025f));
        beeSpecies.addSpecialty(GTBees.combs.getStackForType(CombType.RUNEII), Float.valueOf(0.0125f));
        beeSpecies.setHumidity(EnumHumidity.ARID);
        beeSpecies.setTemperature(EnumTemperature.HELLISH);
        beeSpecies.setHasEffect();
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAllele)GTBees.superLife);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.EFFECT, (IAllele)GTBeeDefinition.getEffect((byte)3, "SlowSpeed"));
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.NONE);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.NONE);
    }, dis -> {
        IMutationCustom tMutation = dis.registerMutation(DRAGONESSENCE, STARDUST, 2).setIsSecret();
        tMutation.restrictHumidity(EnumHumidity.ARID);
        if (Mods.EnderStorage.isModLoaded()) {
            tMutation.requireResource(GameRegistry.findBlock((String)Mods.EnderStorage.ID, (String)"enderChest"), 0);
        }
        tMutation.addMutationCondition((IMutationCondition)new GTBees.DimensionMutationCondition(1, "End"));
    }),
    WALRUS(GTBranchDefinition.PLANET, "Walrus", true, new Color(14079360), new Color(11915209), beeSpecies -> {
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.WALRUS), Float.valueOf(1.0f));
        beeSpecies.setHumidity(EnumHumidity.DAMP);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
        beeSpecies.setHasEffect();
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.FASTEST);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.LONGER);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.NOCTURNAL, true);
    }, dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(GTBeeDefinition.getSpecies((byte)3, "Watery"), GTBeeDefinition.getSpecies((byte)3, "Catty"), 45, 2.0f);
        if (Mods.ExtraCells2.isModLoaded()) {
            tMutation.requireResource(GameRegistry.findBlock((String)Mods.ExtraCells2.ID, (String)"walrus"), 0);
        }
    }),
    MACHINIST(GTBranchDefinition.ORGANIC, "Machinist", true, new Color(85, 37, 130), new Color(253, 185, 39), beeSpecies -> {
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.MACHINIST), Float.valueOf(0.2f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
        beeSpecies.setHasEffect();
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.FASTEST);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.LONGEST);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.NOCTURNAL, true);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAllele)GTFlowers.FLAMING);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.MAXIMUM);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.EFFECT, (IAllele)GTBeeDefinition.getEffect((byte)4, "MachineBoost"));
    }, dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(GTBeeDefinition.getSpecies((byte)0, "Industrious"), GTBeeDefinition.getSpecies((byte)0, "Imperial"), 1);
        tMutation.addMutationCondition((IMutationCondition)new GTBees.ActiveGTMachineMutationCondition());
    }),
    SPACE(GTBranchDefinition.SPACE, "Space", true, new Color(13158), new Color(0xC0C0C0), beeSpecies -> {
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.SPACE), Float.valueOf(0.02f));
        beeSpecies.setHumidity(EnumHumidity.ARID);
        beeSpecies.setTemperature(EnumTemperature.ICY);
        beeSpecies.setNocturnal();
    }, template -> {}, dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(GTBeeDefinition.getSpecies((byte)0, "Industrious"), GTBeeDefinition.getSpecies((byte)0, "Heroic"), 10);
        tMutation.restrictTemperature(EnumTemperature.ICY);
    }),
    METEORICIRON(GTBranchDefinition.SPACE, "MeteoricIron", true, new Color(3283240), new Color(6566480), beeSpecies -> {
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.SPACE), Float.valueOf(0.04f));
        beeSpecies.addSpecialty(GTBees.combs.getStackForType(CombType.METEORICIRON), Float.valueOf(0.1f));
        beeSpecies.setHumidity(EnumHumidity.ARID);
        beeSpecies.setTemperature(EnumTemperature.HOT);
        beeSpecies.setNocturnal();
    }, template -> {}, dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(SPACE, IRON, 9);
        tMutation.requireResource(GregTechAPI.sBlockMetal4, 7);
        tMutation.addMutationCondition((IMutationCondition)new GTBees.DimensionMutationCondition(28, "Moon"));
    }),
    DESH(GTBranchDefinition.SPACE, "Desh", false, new Color(0x323232), new Color(0x282828), beeSpecies -> {
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.SPACE), Float.valueOf(0.06f));
        beeSpecies.addSpecialty(GTBees.combs.getStackForType(CombType.DESH), Float.valueOf(0.1f));
        beeSpecies.setHumidity(EnumHumidity.ARID);
        beeSpecies.setTemperature(EnumTemperature.HOT);
        beeSpecies.setNocturnal();
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.EFFECT, (IAllele)AlleleEffect.effectIgnition), new Consumer<GTBeeDefinition>(){

        @Override
        public void accept(GTBeeDefinition dis) {
            IBeeMutationCustom tMutation = dis.registerMutation(MARS, TITANIUM, 9);
            tMutation.requireResource(GregTechAPI.sBlockMetal2, 12);
            tMutation.addMutationCondition((IMutationCondition)new GTBees.DimensionMutationCondition(29, "Mars"));
        }
    }),
    LEDOX(GTBranchDefinition.SPACE, "Ledox", false, new Color(205), new Color(29951), beeSpecies -> {
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.SPACE), Float.valueOf(0.1f));
        beeSpecies.addSpecialty(GTBees.combs.getStackForType(CombType.LEDOX), Float.valueOf(0.1f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.COLD);
        beeSpecies.setHasEffect();
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.EFFECT, (IAllele)GTBeeDefinition.getEffect((byte)0, "Glacial")), new Consumer<GTBeeDefinition>(){

        @Override
        public void accept(GTBeeDefinition dis) {
            IBeeMutationCustom tMutation = dis.registerMutation(CALLISTO, LEAD, 7);
            if (Mods.NewHorizonsCoreMod.isModLoaded()) {
                tMutation.requireResource(GameRegistry.findBlock((String)Mods.NewHorizonsCoreMod.ID, (String)"tile.Ledox"), 0);
            }
            tMutation.addMutationCondition((IMutationCondition)new GTBees.DimensionMutationCondition(35, "Europa"));
        }
    }),
    CALLISTOICE(GTBranchDefinition.SPACE, "CallistoIce", false, new Color(29951), new Color(2011647), beeSpecies -> {
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.SPACE), Float.valueOf(0.1f));
        beeSpecies.addSpecialty(GTBees.combs.getStackForType(CombType.CALLISTOICE), Float.valueOf(0.1f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.ICY);
        beeSpecies.setHasEffect();
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.EFFECT, (IAllele)GTBeeDefinition.getEffect((byte)0, "Glacial")), new Consumer<GTBeeDefinition>(){

        @Override
        public void accept(GTBeeDefinition dis) {
            IBeeMutationCustom tMutation = dis.registerMutation(CALLISTO, GTBeeDefinition.getSpecies((byte)1, "freezing"), 7);
            if (Mods.NewHorizonsCoreMod.isModLoaded()) {
                tMutation.requireResource(GameRegistry.findBlock((String)Mods.NewHorizonsCoreMod.ID, (String)"tile.CallistoColdIce"), 0);
            }
            tMutation.addMutationCondition((IMutationCondition)new GTBees.DimensionMutationCondition(45, "Callisto"));
        }
    }),
    MYTRYL(GTBranchDefinition.SPACE, "Mytryl", false, new Color(14329120), new Color(15885316), beeSpecies -> {
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.SPACE), Float.valueOf(0.16f));
        beeSpecies.addSpecialty(GTBees.combs.getStackForType(CombType.MYTRYL), Float.valueOf(0.1f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
        beeSpecies.setNocturnal();
        beeSpecies.setHasEffect();
    }, template -> {}, new Consumer<GTBeeDefinition>(){

        @Override
        public void accept(GTBeeDefinition dis) {
            IBeeMutationCustom tMutation = dis.registerMutation(IO, MITHRIL, 6);
            if (Mods.NewHorizonsCoreMod.isModLoaded()) {
                tMutation.requireResource(GameRegistry.findBlock((String)Mods.NewHorizonsCoreMod.ID, (String)"tile.Mytryl"), 0);
            }
            tMutation.addMutationCondition((IMutationCondition)new GTBees.DimensionMutationCondition(36, "IO"));
        }
    }),
    QUANTIUM(GTBranchDefinition.SPACE, "Quantium", false, new Color(65280), new Color(53515), beeSpecies -> {
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.SPACE), Float.valueOf(0.16f));
        beeSpecies.addSpecialty(GTBees.combs.getStackForType(CombType.QUANTIUM), Float.valueOf(0.1f));
        beeSpecies.setHumidity(EnumHumidity.ARID);
        beeSpecies.setTemperature(EnumTemperature.HOT);
        beeSpecies.setNocturnal();
        beeSpecies.setHasEffect();
    }, template -> {}, new Consumer<GTBeeDefinition>(){

        @Override
        public void accept(GTBeeDefinition dis) {
            IBeeMutationCustom tMutation = dis.registerMutation(VENUS, OSMIUM, 6);
            if (Mods.NewHorizonsCoreMod.isModLoaded()) {
                tMutation.requireResource(GameRegistry.findBlock((String)Mods.NewHorizonsCoreMod.ID, (String)"tile.Quantinum"), 0);
            }
            tMutation.addMutationCondition((IMutationCondition)new GTBees.DimensionMutationCondition(39, "Venus"));
        }
    }),
    ORIHARUKON(GTBranchDefinition.SPACE, "Oriharukon", false, new Color(0x228B22), new Color(6782312), beeSpecies -> {
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.SPACE), Float.valueOf(0.26f));
        beeSpecies.addSpecialty(GTBees.combs.getStackForType(CombType.ORIHARUKON), Float.valueOf(0.1f));
        beeSpecies.setHumidity(EnumHumidity.DAMP);
        beeSpecies.setTemperature(EnumTemperature.COLD);
        beeSpecies.setHasEffect();
    }, template -> {}, new Consumer<GTBeeDefinition>(){

        @Override
        public void accept(GTBeeDefinition dis) {
            IBeeMutationCustom tMutation = dis.registerMutation(LEAD, OBERON, 5);
            if (Mods.GalaxySpace.isModLoaded()) {
                tMutation.requireResource(GameRegistry.findBlock((String)Mods.GalaxySpace.ID, (String)"metalsblock"), 6);
            }
            tMutation.addMutationCondition((IMutationCondition)new GTBees.DimensionMutationCondition(46, "Oberon"));
        }
    }),
    INFUSEDGOLD(GTBranchDefinition.SPACE, "Infused Gold", false, new Color(8414238), new Color(16762940), beeSpecies -> {
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.GOLD), Float.valueOf(0.2f));
        beeSpecies.addSpecialty(GTBees.combs.getStackForType(CombType.INFUSEDGOLD), Float.valueOf(0.3f));
        beeSpecies.setHumidity(EnumHumidity.DAMP);
        beeSpecies.setTemperature(EnumTemperature.ICY);
        beeSpecies.setNocturnal();
        beeSpecies.setHasEffect();
    }, template -> {}, new Consumer<GTBeeDefinition>(){

        @Override
        public void accept(GTBeeDefinition dis) {
            IBeeMutationCustom tMutation = dis.registerMutation(GOLD, HAUMEA, 5);
            tMutation.requireResource(GregTechAPI.sBlockMetal3, 10);
            tMutation.addMutationCondition((IMutationCondition)new GTBees.DimensionMutationCondition(83, "Haumea"));
        }
    }),
    MYSTERIOUSCRYSTAL(GTBranchDefinition.SPACE, "MysteriousCrystal", false, new Color(3978097), new Color(1475948), beeSpecies -> {
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.SPACE), Float.valueOf(0.42f));
        beeSpecies.addSpecialty(GTBees.combs.getStackForType(CombType.MYSTERIOUSCRYSTAL), Float.valueOf(0.3f));
        beeSpecies.setHumidity(EnumHumidity.ARID);
        beeSpecies.setTemperature(EnumTemperature.ICY);
        beeSpecies.setNocturnal();
        beeSpecies.setHasEffect();
    }, template -> {}, new Consumer<GTBeeDefinition>(){

        @Override
        public void accept(GTBeeDefinition dis) {
            IBeeMutationCustom tMutation = dis.registerMutation(ENCELADUS, EMERALD, 3);
            if (Mods.NewHorizonsCoreMod.isModLoaded()) {
                tMutation.requireResource(GameRegistry.findBlock((String)Mods.NewHorizonsCoreMod.ID, (String)"tile.MysteriousCrystal"), 0);
            }
            tMutation.addMutationCondition((IMutationCondition)new GTBees.DimensionMutationCondition(41, "Enceladus"));
        }
    }),
    BLACKPLUTONIUM(GTBranchDefinition.SPACE, "BlackPlutonium", false, new Color(0), new Color(0x323232), beeSpecies -> {
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.SPACE), Float.valueOf(0.68f));
        beeSpecies.addSpecialty(GTBees.combs.getStackForType(CombType.BLACKPLUTONIUM), Float.valueOf(0.1f));
        beeSpecies.setHumidity(EnumHumidity.ARID);
        beeSpecies.setTemperature(EnumTemperature.HELLISH);
        beeSpecies.setNocturnal();
        beeSpecies.setHasEffect();
    }, template -> {}, new Consumer<GTBeeDefinition>(){

        @Override
        public void accept(GTBeeDefinition dis) {
            IBeeMutationCustom tMutation = dis.registerMutation(PLUTO, PLUTONIUM, 2);
            if (Mods.NewHorizonsCoreMod.isModLoaded()) {
                tMutation.requireResource(GameRegistry.findBlock((String)Mods.NewHorizonsCoreMod.ID, (String)"tile.BlackPlutonium"), 0);
            }
            tMutation.addMutationCondition((IMutationCondition)new GTBees.DimensionMutationCondition(49, "Pluto"));
        }
    }),
    TRINIUM(GTBranchDefinition.SPACE, "Trinium", false, new Color(11591910), new Color(13158610), beeSpecies -> {
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.TRINIUM), Float.valueOf(0.75f));
        beeSpecies.addSpecialty(GTBees.combs.getStackForType(CombType.QUANTIUM), Float.valueOf(0.1f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.COLD);
        beeSpecies.setNocturnal();
        beeSpecies.setHasEffect();
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAllele)GTBees.speedBlinding), new Consumer<GTBeeDefinition>(){

        @Override
        public void accept(GTBeeDefinition dis) {
            IBeeMutationCustom tMutation = dis.registerMutation(ENCELADUS, IRIDIUM, 4);
            tMutation.requireResource(GregTechAPI.sBlockMetal4, 9);
            tMutation.addMutationCondition((IMutationCondition)new GTBees.DimensionMutationCondition(41, "Enceladus"));
        }
    }),
    MOON(GTBranchDefinition.PLANET, "Moon", false, new Color(0x373735), new Color(0x7E7E78), beeSpecies -> {
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.MOON), Float.valueOf(0.35f));
        if (Mods.NewHorizonsCoreMod.isModLoaded()) {
            beeSpecies.addSpecialty(GTModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.MoonStoneDust", 1L, 0), Float.valueOf(0.1f));
        }
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.COLD);
        beeSpecies.setNocturnal();
        beeSpecies.setHasEffect();
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(SPACE, CLAY, 25);
        if (Mods.GalacticraftCore.isModLoaded()) {
            tMutation.requireResource(GameRegistry.findBlock((String)Mods.GalacticraftCore.ID, (String)"tile.moonBlock"), 4);
        }
        tMutation.addMutationCondition((IMutationCondition)new GTBees.DimensionMutationCondition(28, "Moon"));
    }),
    MARS(GTBranchDefinition.PLANET, "Mars", false, new Color(2231557), new Color(3806469), beeSpecies -> {
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.MARS), Float.valueOf(0.35f));
        beeSpecies.addSpecialty(GTModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.MarsStoneDust", 1L, 0), Float.valueOf(0.1f));
        beeSpecies.setHumidity(EnumHumidity.ARID);
        beeSpecies.setTemperature(EnumTemperature.HOT);
        beeSpecies.setNocturnal();
        beeSpecies.setHasEffect();
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(MOON, IRON, 20);
        if (Mods.GalacticraftMars.isModLoaded()) {
            tMutation.requireResource(GameRegistry.findBlock((String)Mods.GalacticraftMars.ID, (String)"tile.mars"), 5);
        }
        tMutation.addMutationCondition((IMutationCondition)new GTBees.DimensionMutationCondition(29, "Mars"));
    }),
    PHOBOS(GTBranchDefinition.PLANET, "Phobos", true, new Color(2231557), new Color(8017670), beeSpecies -> {
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.MARS), Float.valueOf(0.25f));
        if (Mods.NewHorizonsCoreMod.isModLoaded()) {
            beeSpecies.addSpecialty(GTModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.PhobosStoneDust", 1L, 0), Float.valueOf(0.1f));
        }
        beeSpecies.setHumidity(EnumHumidity.ARID);
        beeSpecies.setTemperature(EnumTemperature.HOT);
        beeSpecies.setNocturnal();
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(MARS, MOON, 20);
        if (Mods.GalaxySpace.isModLoaded()) {
            tMutation.requireResource(GameRegistry.findBlock((String)Mods.GalaxySpace.ID, (String)"phobosblocks"), 2);
        }
        tMutation.addMutationCondition((IMutationCondition)new GTBees.DimensionMutationCondition(38, "Phobos"));
    }),
    DEIMOS(GTBranchDefinition.PLANET, "Deimos", true, new Color(2231557), new Color(8008198), beeSpecies -> {
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.MARS), Float.valueOf(0.25f));
        beeSpecies.addSpecialty(GTModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.DeimosStoneDust", 1L, 0), Float.valueOf(0.1f));
        beeSpecies.setHumidity(EnumHumidity.DAMP);
        beeSpecies.setTemperature(EnumTemperature.HOT);
        beeSpecies.setNocturnal();
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(MARS, SPACE, 20);
        if (Mods.GalaxySpace.isModLoaded()) {
            tMutation.requireResource(GameRegistry.findBlock((String)Mods.GalaxySpace.ID, (String)"deimosblocks"), 1);
        }
        tMutation.addMutationCondition((IMutationCondition)new GTBees.DimensionMutationCondition(40, "Deimos"));
    }),
    CERES(GTBranchDefinition.PLANET, "Ceres", true, new Color(3974583), new Color(1995367), beeSpecies -> {
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.JUPITER), Float.valueOf(0.25f));
        beeSpecies.addSpecialty(GTModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.CeresStoneDust", 1L, 0), Float.valueOf(0.1f));
        beeSpecies.setHumidity(EnumHumidity.ARID);
        beeSpecies.setTemperature(EnumTemperature.HOT);
        beeSpecies.setNocturnal();
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(MARS, METEORICIRON, 20);
        if (Mods.GalaxySpace.isModLoaded()) {
            tMutation.requireResource(GameRegistry.findBlock((String)Mods.GalaxySpace.ID, (String)"ceresblocks"), 1);
        }
        tMutation.addMutationCondition((IMutationCondition)new GTBees.DimensionMutationCondition(42, "Ceres"));
    }),
    JUPITER(GTBranchDefinition.PLANET, "Jupiter", false, new Color(7555886), new Color(13683652), beeSpecies -> {
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.JUPITER), Float.valueOf(0.35f));
        beeSpecies.addSpecialty(GTModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.CallistoStoneDust", 1L, 0), Float.valueOf(0.05f));
        beeSpecies.addSpecialty(Materials.CallistoIce.getDust(1), Float.valueOf(0.05f));
        beeSpecies.addSpecialty(GTModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.IoStoneDust", 1L, 0), Float.valueOf(0.05f));
        beeSpecies.addSpecialty(GTModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.EuropaStoneDust", 1L, 0), Float.valueOf(0.05f));
        beeSpecies.addSpecialty(GTModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.EuropaIceDust", 1L, 0), Float.valueOf(0.05f));
        beeSpecies.addSpecialty(GTModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.GanymedeStoneDust", 1L, 0), Float.valueOf(0.05f));
        beeSpecies.setHumidity(EnumHumidity.ARID);
        beeSpecies.setTemperature(EnumTemperature.HOT);
        beeSpecies.setNocturnal();
        beeSpecies.setHasEffect();
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(MARS, DESH, 15);
        if (Mods.NewHorizonsCoreMod.isModLoaded()) {
            tMutation.requireResource(GameRegistry.findBlock((String)Mods.NewHorizonsCoreMod.ID, (String)"tile.Ledox"), 0);
        }
        tMutation.addMutationCondition((IMutationCondition)new GTBees.DimensionMutationCondition(30, "Asteroids"));
    }),
    IO(GTBranchDefinition.PLANET, "IO", true, new Color(7555886), new Color(15036443), beeSpecies -> {
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.JUPITER), Float.valueOf(0.25f));
        beeSpecies.addSpecialty(GTModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.IoStoneDust", 1L, 0), Float.valueOf(0.1f));
        beeSpecies.setHumidity(EnumHumidity.ARID);
        beeSpecies.setTemperature(EnumTemperature.HELLISH);
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(JUPITER, GTBeeDefinition.getSpecies((byte)1, "volcanic"), 15);
        tMutation.restrictTemperature(EnumTemperature.HELLISH);
        if (Mods.GalaxySpace.isModLoaded()) {
            tMutation.requireResource(GameRegistry.findBlock((String)Mods.GalaxySpace.ID, (String)"ioblocks"), 0);
        }
        tMutation.addMutationCondition((IMutationCondition)new GTBees.DimensionMutationCondition(36, "IO"));
    }),
    EUROPA(GTBranchDefinition.PLANET, "Europa", true, new Color(5866218), new Color(734883), beeSpecies -> {
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.JUPITER), Float.valueOf(0.25f));
        beeSpecies.addSpecialty(GTModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.EuropaStoneDust", 1L, 0), Float.valueOf(0.1f));
        beeSpecies.addSpecialty(GTModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.EuropaIceDust", 1L, 0), Float.valueOf(0.1f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.ICY);
        beeSpecies.setNocturnal();
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(JUPITER, IRON, 15);
        tMutation.restrictTemperature(EnumTemperature.ICY);
        if (Mods.GalaxySpace.isModLoaded()) {
            tMutation.requireResource(GameRegistry.findBlock((String)Mods.GalaxySpace.ID, (String)"europagrunt"), 0);
        }
        tMutation.addMutationCondition((IMutationCondition)new GTBees.DimensionMutationCondition(35, "Europa"));
    }),
    GANYMEDE(GTBranchDefinition.PLANET, "Ganymede", true, new Color(4004624), new Color(1641479), beeSpecies -> {
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.JUPITER), Float.valueOf(0.25f));
        beeSpecies.addSpecialty(GTModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.GanymedeStoneDust", 1L, 0), Float.valueOf(0.1f));
        beeSpecies.setHumidity(EnumHumidity.ARID);
        beeSpecies.setTemperature(EnumTemperature.COLD);
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(JUPITER, TITANIUM, 15);
        if (Mods.GalaxySpace.isModLoaded()) {
            tMutation.requireResource(GameRegistry.findBlock((String)Mods.GalaxySpace.ID, (String)"ganymedeblocks"), 0);
        }
        tMutation.addMutationCondition((IMutationCondition)new GTBees.DimensionMutationCondition(43, "Ganymede"));
    }),
    CALLISTO(GTBranchDefinition.PLANET, "Callisto", true, new Color(996157), new Color(885925), beeSpecies -> {
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.JUPITER), Float.valueOf(0.25f));
        beeSpecies.addSpecialty(GTModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.CallistoStoneDust", 1L, 0), Float.valueOf(0.1f));
        beeSpecies.addSpecialty(Materials.CallistoIce.getDust(1), Float.valueOf(0.1f));
        beeSpecies.setHumidity(EnumHumidity.DAMP);
        beeSpecies.setTemperature(EnumTemperature.ICY);
        beeSpecies.setNocturnal();
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(JUPITER, GTBeeDefinition.getSpecies((byte)1, "artic"), 15);
        if (Mods.GalaxySpace.isModLoaded()) {
            tMutation.requireResource(GameRegistry.findBlock((String)Mods.GalaxySpace.ID, (String)"callistoblocks"), 0);
        }
        tMutation.addMutationCondition((IMutationCondition)new GTBees.DimensionMutationCondition(45, "Callisto"));
    }),
    SATURN(GTBranchDefinition.PLANET, "Saturn", false, new Color(13804658), new Color(16302971), beeSpecies -> {
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.SATURN), Float.valueOf(0.35f));
        beeSpecies.addSpecialty(GTModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.TitanStoneDust", 1L, 0), Float.valueOf(0.05f));
        beeSpecies.addSpecialty(GTModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.EnceladusStoneDust", 1L, 0), Float.valueOf(0.05f));
        beeSpecies.addSpecialty(GTModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.EnceladusIceDust", 1L, 0), Float.valueOf(0.05f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.COLD);
        beeSpecies.setHasEffect();
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(JUPITER, LEDOX, 25, 2.0f);
        if (Mods.NewHorizonsCoreMod.isModLoaded()) {
            tMutation.requireResource(GameRegistry.findBlock((String)Mods.NewHorizonsCoreMod.ID, (String)"tile.Quantinum"), 0);
        }
        tMutation.addMutationCondition((IMutationCondition)new GTBees.DimensionMutationCondition(30, "Asteriods"));
    }),
    ENCELADUS(GTBranchDefinition.PLANET, "Enceladus", true, new Color(13804658), new Color(1654688), beeSpecies -> {
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.SATURN), Float.valueOf(0.25f));
        beeSpecies.addSpecialty(GTModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.EnceladusStoneDust", 1L, 0), Float.valueOf(0.1f));
        beeSpecies.addSpecialty(GTModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.EnceladusIceDust", 1L, 0), Float.valueOf(0.1f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.ICY);
        beeSpecies.setHasEffect();
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(SATURN, CHROME, 25, 2.0f);
        if (Mods.GalaxySpace.isModLoaded()) {
            tMutation.requireResource(GameRegistry.findBlock((String)Mods.GalaxySpace.ID, (String)"enceladusblocks"), 0);
        }
        tMutation.addMutationCondition((IMutationCondition)new GTBees.DimensionMutationCondition(41, "Enceladus"));
    }),
    TITAN(GTBranchDefinition.PLANET, "Titan", true, new Color(10511387), new Color(8130596), beeSpecies -> {
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.SATURN), Float.valueOf(0.25f));
        beeSpecies.addSpecialty(GTModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.TitanStoneDust", 1L, 0), Float.valueOf(0.1f));
        beeSpecies.setHumidity(EnumHumidity.ARID);
        beeSpecies.setTemperature(EnumTemperature.HOT);
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(SATURN, NICKEL, 25, 2.0f);
        if (Mods.GalaxySpace.isModLoaded()) {
            tMutation.requireResource(GameRegistry.findBlock((String)Mods.GalaxySpace.ID, (String)"titanblocks"), 0);
        }
        tMutation.addMutationCondition((IMutationCondition)new GTBees.DimensionMutationCondition(44, "Titan"));
    }),
    URANUS(GTBranchDefinition.PLANET, "Uranus", false, new Color(7717065), new Color(8706284), beeSpecies -> {
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.URANUS), Float.valueOf(0.35f));
        beeSpecies.addSpecialty(GTModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.MirandaStoneDust", 1L, 0), Float.valueOf(0.05f));
        beeSpecies.addSpecialty(GTModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.OberonStoneDust", 1L, 0), Float.valueOf(0.05f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.ICY);
        beeSpecies.setHasEffect();
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(SATURN, TRINIUM, 10);
        if (Mods.GalaxySpace.isModLoaded()) {
            tMutation.requireResource(GameRegistry.findBlock((String)Mods.GalaxySpace.ID, (String)"metalsblock"), 6);
        }
        tMutation.addMutationCondition((IMutationCondition)new GTBees.DimensionMutationCondition(30, "Asteroids"));
    }),
    MIRANDA(GTBranchDefinition.PLANET, "Miranda", true, new Color(7717065), new Color(860444), beeSpecies -> {
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.URANUS), Float.valueOf(0.25f));
        beeSpecies.addSpecialty(GTModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.MirandaStoneDust", 1L, 0), Float.valueOf(0.1f));
        beeSpecies.setHumidity(EnumHumidity.ARID);
        beeSpecies.setTemperature(EnumTemperature.ICY);
        beeSpecies.setNocturnal();
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(URANUS, TIN, 10);
        if (Mods.GalaxySpace.isModLoaded()) {
            tMutation.requireResource(GameRegistry.findBlock((String)Mods.GalaxySpace.ID, (String)"mirandablocks"), 0);
        }
        tMutation.addMutationCondition((IMutationCondition)new GTBees.DimensionMutationCondition(86, "Miranda"));
    }),
    OBERON(GTBranchDefinition.PLANET, "Oberon", true, new Color(4866099), new Color(11903624), beeSpecies -> {
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.URANUS), Float.valueOf(0.25f));
        beeSpecies.addSpecialty(GTModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.OberonStoneDust", 1L, 0), Float.valueOf(0.1f));
        beeSpecies.setHumidity(EnumHumidity.ARID);
        beeSpecies.setTemperature(EnumTemperature.ICY);
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(URANUS, IRIDIUM, 10);
        if (Mods.GalaxySpace.isModLoaded()) {
            tMutation.requireResource(GameRegistry.findBlock((String)Mods.GalaxySpace.ID, (String)"oberonblocks"), 0);
        }
        tMutation.addMutationCondition((IMutationCondition)new GTBees.DimensionMutationCondition(46, "Oberon"));
    }),
    NEPTUNE(GTBranchDefinition.PLANET, "Neptune", false, new Color(3362047), new Color(5729791), beeSpecies -> {
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.NEPTUNE), Float.valueOf(0.35f));
        beeSpecies.addSpecialty(GTModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.ProteusStoneDust", 1L, 0), Float.valueOf(0.05f));
        beeSpecies.addSpecialty(GTModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.TritonStoneDust", 1L, 0), Float.valueOf(0.05f));
        beeSpecies.setHumidity(EnumHumidity.DAMP);
        beeSpecies.setTemperature(EnumTemperature.COLD);
        beeSpecies.setNocturnal();
        beeSpecies.setHasEffect();
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(URANUS, ORIHARUKON, 7);
        if (Mods.NewHorizonsCoreMod.isModLoaded()) {
            tMutation.requireResource(GameRegistry.findBlock((String)Mods.NewHorizonsCoreMod.ID, (String)"tile.MysteriousCrystal"), 0);
        }
        tMutation.addMutationCondition((IMutationCondition)new GTBees.DimensionMutationCondition(30, "Asteroids"));
    }),
    PROTEUS(GTBranchDefinition.PLANET, "Proteus", true, new Color(3362047), new Color(5842448), beeSpecies -> {
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.NEPTUNE), Float.valueOf(0.25f));
        beeSpecies.addSpecialty(GTModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.ProteusStoneDust", 1L, 0), Float.valueOf(0.1f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.COLD);
        beeSpecies.setNocturnal();
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(NEPTUNE, COPPER, 7);
        if (Mods.GalaxySpace.isModLoaded()) {
            tMutation.requireResource(GameRegistry.findBlock((String)Mods.GalaxySpace.ID, (String)"proteusblocks"), 0);
        }
        tMutation.addMutationCondition((IMutationCondition)new GTBees.DimensionMutationCondition(47, "Proteus"));
    }),
    TRITON(GTBranchDefinition.PLANET, "Triton", true, new Color(3362047), new Color(4329752), beeSpecies -> {
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.NEPTUNE), Float.valueOf(0.25f));
        beeSpecies.addSpecialty(GTModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.TritonStoneDust", 1L, 0), Float.valueOf(0.1f));
        beeSpecies.setHumidity(EnumHumidity.DAMP);
        beeSpecies.setTemperature(EnumTemperature.ICY);
        beeSpecies.setNocturnal();
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(NEPTUNE, GOLD, 7);
        if (Mods.GalaxySpace.isModLoaded()) {
            tMutation.requireResource(GameRegistry.findBlock((String)Mods.GalaxySpace.ID, (String)"tritonblocks"), 0);
        }
        tMutation.addMutationCondition((IMutationCondition)new GTBees.DimensionMutationCondition(48, "Triton"));
    }),
    PLUTO(GTBranchDefinition.PLANET, "Pluto", false, new Color(3417886), new Color(6901821), beeSpecies -> {
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.PLUTO), Float.valueOf(0.35f));
        beeSpecies.addSpecialty(GTModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.PlutoStoneDust", 1L, 0), Float.valueOf(0.1f));
        beeSpecies.addSpecialty(GTModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.PlutoIceDust", 1L, 0), Float.valueOf(0.1f));
        beeSpecies.setHumidity(EnumHumidity.ARID);
        beeSpecies.setTemperature(EnumTemperature.ICY);
        beeSpecies.setNocturnal();
        beeSpecies.setHasEffect();
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(NEPTUNE, PLUTONIUM, 5);
        if (Mods.GalaxySpace.isModLoaded()) {
            tMutation.requireResource(GameRegistry.findBlock((String)Mods.GalaxySpace.ID, (String)"plutoblocks"), 0);
        }
        tMutation.addMutationCondition((IMutationCondition)new GTBees.DimensionMutationCondition(49, "Pluto"));
    }),
    HAUMEA(GTBranchDefinition.PLANET, "Haumea", false, new Color(1840147), new Color(3746600), beeSpecies -> {
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.HAUMEA), Float.valueOf(0.35f));
        beeSpecies.addSpecialty(GTModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.HaumeaStoneDust", 1L, 0), Float.valueOf(0.1f));
        beeSpecies.setHumidity(EnumHumidity.ARID);
        beeSpecies.setTemperature(EnumTemperature.ICY);
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(PLUTO, NAQUADAH, 7, 2.0f);
        if (Mods.GalaxySpace.isModLoaded()) {
            tMutation.requireResource(GameRegistry.findBlock((String)Mods.GalaxySpace.ID, (String)"haumeablocks"), 0);
        }
        tMutation.addMutationCondition((IMutationCondition)new GTBees.DimensionMutationCondition(83, "Haumea"));
    }),
    MAKEMAKE(GTBranchDefinition.PLANET, "MakeMake", false, new Color(3151889), new Color(1182215), beeSpecies -> {
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.MAKEMAKE), Float.valueOf(0.35f));
        beeSpecies.addSpecialty(GTModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.MakeMakeStoneDust", 1L, 0), Float.valueOf(0.1f));
        beeSpecies.setHumidity(EnumHumidity.ARID);
        beeSpecies.setTemperature(EnumTemperature.HOT);
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(PLUTO, NAQUADRIA, 7, 2.0f);
        if (Mods.GalaxySpace.isModLoaded()) {
            tMutation.requireResource(GameRegistry.findBlock((String)Mods.GalaxySpace.ID, (String)"makemakegrunt"), 0);
        }
        tMutation.addMutationCondition((IMutationCondition)new GTBees.DimensionMutationCondition(25, "MakeMake"));
    }),
    CENTAURI(GTBranchDefinition.PLANET, "Centauri", false, new Color(3090964), new Color(11561778), beeSpecies -> {
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.CENTAURI), Float.valueOf(0.35f));
        beeSpecies.addSpecialty(GTModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.CentauriASurfaceDust", 1L, 0), Float.valueOf(0.05f));
        beeSpecies.setHumidity(EnumHumidity.ARID);
        beeSpecies.setTemperature(EnumTemperature.HELLISH);
        beeSpecies.setHasEffect();
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(MAKEMAKE, DESH, 3);
        if (Mods.GalaxySpace.isModLoaded()) {
            tMutation.requireResource(GameRegistry.findBlock((String)Mods.GalaxySpace.ID, (String)"acentauribbgrunt"), 0);
        }
        tMutation.addMutationCondition((IMutationCondition)new GTBees.DimensionMutationCondition(33, "Kuiper Belt"));
    }),
    ACENTAURI(GTBranchDefinition.PLANET, "aCentauri", false, new Color(3090964), new Color(10493460), beeSpecies -> {
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.CENTAURI), Float.valueOf(0.25f));
        beeSpecies.addSpecialty(GTModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.CentauriASurfaceDust", 1L, 0), Float.valueOf(0.1f));
        beeSpecies.setHumidity(EnumHumidity.ARID);
        beeSpecies.setTemperature(EnumTemperature.HELLISH);
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST), new Consumer<GTBeeDefinition>(){

        @Override
        public void accept(GTBeeDefinition dis) {
            IBeeMutationCustom tMutation = dis.registerMutation(CENTAURI, INFINITYCATALYST, 3);
            if (Mods.GalaxySpace.isModLoaded()) {
                tMutation.requireResource(GameRegistry.findBlock((String)Mods.GalaxySpace.ID, (String)"acentauribbgrunt"), 0);
            }
            tMutation.addMutationCondition((IMutationCondition)new GTBees.DimensionMutationCondition(31, "aCentauri"));
        }
    }),
    TCETI(GTBranchDefinition.PLANET, "tCeti", false, new Color(4596762), new Color(8077615), beeSpecies -> {
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.TCETI), Float.valueOf(0.35f));
        beeSpecies.addSpecialty(GTModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.TCetiEStoneDust", 1L, 0), Float.valueOf(0.05f));
        beeSpecies.setHumidity(EnumHumidity.DAMP);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
        beeSpecies.setNocturnal();
        beeSpecies.setHasEffect();
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(MAKEMAKE, HAUMEA, 5, 2.0f);
        if (Mods.GalaxySpace.isModLoaded()) {
            tMutation.requireResource(GameRegistry.findBlock((String)Mods.GalaxySpace.ID, (String)"tcetieblocks"), 0);
        }
        tMutation.addMutationCondition((IMutationCondition)new GTBees.DimensionMutationCondition(33, "Kuiper Belt"));
    }),
    TCETIE(GTBranchDefinition.PLANET, "tCetiE", false, new Color(2971163), new Color(790368), beeSpecies -> {
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.TCETI), Float.valueOf(0.25f));
        beeSpecies.addSpecialty(GTModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.TCetiEStoneDust", 1L, 0), Float.valueOf(0.1f));
        beeSpecies.setHumidity(EnumHumidity.DAMP);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
        beeSpecies.setHasEffect();
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(TCETI, GTBeeDefinition.getSpecies((byte)3, "TCWater"), 5, 2.0f);
        if (Mods.GalaxySpace.isModLoaded()) {
            tMutation.requireResource(GameRegistry.findBlock((String)Mods.GalaxySpace.ID, (String)"tcetieblocks"), 0);
        }
        tMutation.addMutationCondition((IMutationCondition)new GTBees.DimensionMutationCondition(85, "tCeti E"));
    }),
    SEAWEED(GTBranchDefinition.PLANET, "SeaWeed", true, new Color(0xCBCBCB), new Color(0x83FF83), beeSpecies -> {
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.SEAWEED), Float.valueOf(0.25f));
        beeSpecies.addSpecialty(GTModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.TCetiEStoneDust", 1L, 0), Float.valueOf(0.15f));
        beeSpecies.setHumidity(EnumHumidity.DAMP);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
        beeSpecies.setHasEffect();
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWEST);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.LONGER);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.DOWN_1);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.DOWN_1);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.NOCTURNAL, true);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.EFFECT, (IAllele)AlleleEffect.effectMycophilic);
    }, dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(TCETI, TCETIE, 5, 2.0f);
        if (Mods.GalaxySpace.isModLoaded()) {
            tMutation.requireResource(GameRegistry.findBlock((String)Mods.GalaxySpace.ID, (String)"tcetieblocks"), 0);
        }
        tMutation.addMutationCondition((IMutationCondition)new GTBees.DimensionMutationCondition(85, "tCeti E"));
    }),
    BARNARDA(GTBranchDefinition.PLANET, "Barnarda", false, new Color(875021), new Color(15122829), beeSpecies -> {
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.BARNARDA), Float.valueOf(0.35f));
        beeSpecies.addSpecialty(GTModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.BarnardaEStoneDust", 1L, 0), Float.valueOf(0.05f));
        beeSpecies.addSpecialty(GTModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.BarnardaFStoneDust", 1L, 0), Float.valueOf(0.05f));
        beeSpecies.setHumidity(EnumHumidity.ARID);
        beeSpecies.setTemperature(EnumTemperature.HOT);
        beeSpecies.setHasEffect();
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(MAKEMAKE, THORIUM, 3, 2.0f);
        if (Mods.GalaxySpace.isModLoaded()) {
            tMutation.requireResource(GameRegistry.findBlock((String)Mods.GalaxySpace.ID, (String)"barnardaEgrunt"), 0);
        }
        tMutation.addMutationCondition((IMutationCondition)new GTBees.DimensionMutationCondition(33, "Kuiper Belt"));
    }),
    BARNARDAC(GTBranchDefinition.PLANET, "BarnardaC", false, new Color(875021), new Color(4669194), beeSpecies -> {
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.BARNARDA), Float.valueOf(0.25f));
        beeSpecies.setHumidity(EnumHumidity.ARID);
        beeSpecies.setTemperature(EnumTemperature.HOT);
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.EFFECT, (IAllele)GTBeeDefinition.getEffect((byte)4, "Treetwister"));
    }, dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(BARNARDA, AMERICIUM, 3, 2.0f);
        if (Mods.GalaxySpace.isModLoaded()) {
            tMutation.requireResource(GameRegistry.findBlock((String)Mods.GalaxySpace.ID, (String)"barnardaEgrunt"), 0);
            tMutation.addMutationCondition((IMutationCondition)new GTBees.DimensionMutationCondition(32, "Barnarda C"));
        }
    }),
    BARNARDAE(GTBranchDefinition.PLANET, "BarnardaE", false, new Color(875021), new Color(4988682), beeSpecies -> {
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.BARNARDA), Float.valueOf(0.25f));
        beeSpecies.addSpecialty(GTModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.BarnardaEStoneDust", 1L, 0), Float.valueOf(0.1f));
        beeSpecies.setHumidity(EnumHumidity.ARID);
        beeSpecies.setTemperature(EnumTemperature.HOT);
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(BARNARDA, DIVIDED, 3, 2.0f);
        if (Mods.GalaxySpace.isModLoaded()) {
            tMutation.requireResource(GameRegistry.findBlock((String)Mods.GalaxySpace.ID, (String)"barnardaEgrunt"), 0);
            tMutation.addMutationCondition((IMutationCondition)new GTBees.DimensionMutationCondition(81, "Barnard E"));
        }
    }),
    BARNARDAF(GTBranchDefinition.PLANET, "BarnardaF", false, new Color(875021), new Color(1968969), beeSpecies -> {
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.BARNARDA), Float.valueOf(0.25f));
        beeSpecies.addSpecialty(GTModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.BarnardaFStoneDust", 1L, 0), Float.valueOf(0.1f));
        beeSpecies.setHumidity(EnumHumidity.ARID);
        beeSpecies.setTemperature(EnumTemperature.HOT);
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(BARNARDA, NEUTRONIUM, 3, 2.0f);
        if (Mods.GalaxySpace.isModLoaded()) {
            tMutation.requireResource(GameRegistry.findBlock((String)Mods.GalaxySpace.ID, (String)"barnardaFgrunt"), 0);
            tMutation.addMutationCondition((IMutationCondition)new GTBees.DimensionMutationCondition(82, "Barnard F"));
        }
    }),
    VEGA(GTBranchDefinition.PLANET, "Vega", false, new Color(1712182), new Color(11911390), beeSpecies -> {
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.VEGA), Float.valueOf(0.35f));
        beeSpecies.addSpecialty(GTModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.VegaBStoneDust", 1L, 0), Float.valueOf(0.05f));
        beeSpecies.setHumidity(EnumHumidity.ARID);
        beeSpecies.setTemperature(EnumTemperature.COLD);
        beeSpecies.setHasEffect();
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(MAKEMAKE, NAQUADAH, 2);
        if (Mods.GalaxySpace.isModLoaded()) {
            tMutation.requireResource(GameRegistry.findBlock((String)Mods.GalaxySpace.ID, (String)"vegabgrunt"), 0);
            tMutation.addMutationCondition((IMutationCondition)new GTBees.DimensionMutationCondition(33, "Kuiper Belt"));
        }
    }),
    VEGAB(GTBranchDefinition.PLANET, "VegaB", false, new Color(1712182), new Color(8512097), beeSpecies -> {
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.VEGA), Float.valueOf(0.35f));
        if (Mods.NewHorizonsCoreMod.isModLoaded()) {
            beeSpecies.addSpecialty(GTModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.VegaBStoneDust", 1L, 0), Float.valueOf(0.1f));
        }
        beeSpecies.setHumidity(EnumHumidity.ARID);
        beeSpecies.setTemperature(EnumTemperature.COLD);
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(VEGA, NAQUADRIA, 2);
        if (Mods.GalaxySpace.isModLoaded()) {
            tMutation.requireResource(GameRegistry.findBlock((String)Mods.GalaxySpace.ID, (String)"vegabgrunt"), 0);
            tMutation.addMutationCondition((IMutationCondition)new GTBees.DimensionMutationCondition(84, "VegaB"));
        }
    }),
    MERCURY(GTBranchDefinition.PLANET, "Mercury", false, new Color(4866099), new Color(11903624), beeSpecies -> {
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.MERCURY), Float.valueOf(0.35f));
        beeSpecies.setHumidity(EnumHumidity.ARID);
        beeSpecies.setTemperature(EnumTemperature.HELLISH);
        beeSpecies.setHasEffect();
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(JUPITER, TUNGSTEN, 25, 2.0f);
        if (Mods.GalaxySpace.isModLoaded()) {
            tMutation.requireResource(GameRegistry.findBlock((String)Mods.GalaxySpace.ID, (String)"mercuryblocks"), 0);
        }
        tMutation.addMutationCondition((IMutationCondition)new GTBees.DimensionMutationCondition(37, "Mercury"));
    }),
    VENUS(GTBranchDefinition.PLANET, "Venus", false, new Color(4866099), new Color(11903624), beeSpecies -> {
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.VENUS), Float.valueOf(0.35f));
        beeSpecies.setHumidity(EnumHumidity.ARID);
        beeSpecies.setTemperature(EnumTemperature.HELLISH);
        beeSpecies.setHasEffect();
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(JUPITER, MITHRIL, 25, 2.0f);
        if (Mods.GalaxySpace.isModLoaded()) {
            tMutation.requireResource(GameRegistry.findBlock((String)Mods.GalaxySpace.ID, (String)"venusblocks"), 0);
        }
        tMutation.addMutationCondition((IMutationCondition)new GTBees.DimensionMutationCondition(39, "Venus"));
    }),
    COSMICNEUTRONIUM(GTBranchDefinition.PLANET, "CosmicNeutronium", false, new Color(0x484848), new Color(0x323232), beeSpecies -> {
        beeSpecies.addSpecialty(GTBees.combs.getStackForType(CombType.COSMICNEUTRONIUM), Float.valueOf(0.375f));
        beeSpecies.setHumidity(EnumHumidity.DAMP);
        beeSpecies.setTemperature(EnumTemperature.ICY);
        beeSpecies.setNocturnal();
        beeSpecies.setHasEffect();
        beeSpecies.setJubilanceProvider(JubilanceMegaApiary.instance);
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(NEUTRONIUM, BARNARDAF, 7, 10.0f);
        if (Mods.Avaritia.isModLoaded()) {
            tMutation.requireResource(GameRegistry.findBlock((String)Mods.Avaritia.ID, (String)"Resource_Block"), 0);
        }
    }),
    INFINITYCATALYST(GTBranchDefinition.PLANET, "InfinityCatalyst", false, new Color(0xFFFFFF), new Color(0xFFFFFF), beeSpecies -> {
        beeSpecies.addSpecialty(GTBees.combs.getStackForType(CombType.INFINITYCATALYST), Float.valueOf(0.015f));
        beeSpecies.setHumidity(EnumHumidity.DAMP);
        beeSpecies.setTemperature(EnumTemperature.HELLISH);
        beeSpecies.setNocturnal();
        beeSpecies.setHasEffect();
        beeSpecies.setJubilanceProvider(JubilanceMegaApiary.instance);
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.EFFECT, (IAllele)GTBeeDefinition.getEffect((byte)1, "blindness"));
    }, dis -> {
        IMutationCustom tMutation = dis.registerMutation(DOB, COSMICNEUTRONIUM, 3, 10.0f).setIsSecret();
        if (Mods.Avaritia.isModLoaded()) {
            tMutation.requireResource(GameRegistry.findBlock((String)Mods.Avaritia.ID, (String)"Resource_Block"), 1);
        }
    }),
    INFINITY(GTBranchDefinition.PLANET, "Infinity", false, new Color(0xFFFFFF), new Color(0xFFFFFF), beeSpecies -> {
        beeSpecies.addSpecialty(GTBees.combs.getStackForType(CombType.INFINITY), Float.valueOf(0.015f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.ICY);
        beeSpecies.setNocturnal();
        beeSpecies.setHasEffect();
        beeSpecies.setJubilanceProvider(JubilanceMegaApiary.instance);
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(INFINITYCATALYST, COSMICNEUTRONIUM, 1, 10.0f);
        if (Mods.AvaritiaAddons.isModLoaded()) {
            tMutation.requireResource(GameRegistry.findBlock((String)Mods.AvaritiaAddons.ID, (String)"InfinityChest"), 0);
        }
    }),
    KEVLAR(GTBranchDefinition.IC2, "Kevlar", false, new Color(2970671), new Color(10664611), beeSpecies -> {
        beeSpecies.addSpecialty(GTBees.combs.getStackForType(CombType.KEVLAR), Float.valueOf(0.075f));
        beeSpecies.addSpecialty(MaterialsKevlar.Kevlar.getNuggets(1), Float.valueOf(0.01f));
        beeSpecies.setHumidity(EnumHumidity.DAMP);
        beeSpecies.setTemperature(EnumTemperature.COLD);
        beeSpecies.setHasEffect();
        beeSpecies.setJubilanceProvider(JubilanceMegaApiary.instance);
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWEST);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.LONGEST);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.EFFECT, (IAllele)AlleleEffect.effectSnowing);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.NONE);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.NOCTURNAL, true);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAlleleValue)EnumAllele.Flowers.SNOW);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.AVERAGE);
    }, dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(OIL, INFINITYCATALYST, 4);
        GregTechAPI.sGTCompleteLoad.add(() -> tMutation.requireResource(GregTechAPI.sBlockMachines, 11003));
    }),
    HELIUM(GTBranchDefinition.NOBLEGAS, "Helium", false, new Color(0xFFA9FF), new Color(13154484), beeSpecies -> {
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.HELIUM), Float.valueOf(0.35f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.ICY);
        beeSpecies.setNocturnal();
        beeSpecies.setHasEffect();
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(GTBeeDefinition.getSpecies((byte)3, "Watery"), ENDDUST, 10);
        tMutation.restrictTemperature(EnumTemperature.ICY);
    }),
    ARGON(GTBranchDefinition.NOBLEGAS, "Argon", false, new Color(9034209), new Color(12428738), beeSpecies -> {
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.ARGON), Float.valueOf(0.35f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.ICY);
        beeSpecies.setNocturnal();
        beeSpecies.setHasEffect();
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(HELIUM, LICH, 8);
        tMutation.restrictTemperature(EnumTemperature.ICY);
    }),
    NEON(GTBranchDefinition.NOBLEGAS, "Neon", false, new Color(16762918), new Color(16740864), beeSpecies -> {
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.NEON), Float.valueOf(0.35f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.ICY);
        beeSpecies.setNocturnal();
        beeSpecies.setHasEffect();
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(ARGON, HYDRA, 6);
        tMutation.restrictTemperature(EnumTemperature.ICY);
    }),
    KRYPTON(GTBranchDefinition.NOBLEGAS, "Krypton", false, new Color(9082800), new Color(1443874), beeSpecies -> {
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.KRYPTON), Float.valueOf(0.35f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.ICY);
        beeSpecies.setNocturnal();
        beeSpecies.setHasEffect();
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(NEON, URGHAST, 4);
        tMutation.restrictTemperature(EnumTemperature.ICY);
    }),
    XENON(GTBranchDefinition.NOBLEGAS, "Xenon", false, new Color(9082800), new Color(1443874), beeSpecies -> {
        beeSpecies.addSpecialty(GTBees.combs.getStackForType(CombType.XENON), Float.valueOf(0.525f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.ICY);
        beeSpecies.setNocturnal();
        beeSpecies.setHasEffect();
        beeSpecies.setJubilanceProvider(JubilanceMegaApiary.instance);
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(KRYPTON, SNOWQUEEN, 2);
        tMutation.restrictTemperature(EnumTemperature.ICY);
    }),
    OXYGEN(GTBranchDefinition.NOBLEGAS, "Oxygen", false, new Color(0xFFFFFF), new Color(0x8F8FFF), beeSpecies -> {
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.OXYGEN), Float.valueOf(0.45f));
        beeSpecies.addSpecialty(GTBees.combs.getStackForType(CombType.HYDROGEN), Float.valueOf(0.2f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.ICY);
        beeSpecies.setNocturnal();
        beeSpecies.setHasEffect();
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(HELIUM, DRAGONESSENCE, 15);
        tMutation.restrictTemperature(EnumTemperature.ICY);
    }),
    HYDROGEN(GTBranchDefinition.NOBLEGAS, "Oxygen", false, new Color(0xFFFFFF), new Color(16716947), beeSpecies -> {
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.HYDROGEN), Float.valueOf(0.45f));
        beeSpecies.addSpecialty(GTBees.combs.getStackForType(CombType.NITROGEN), Float.valueOf(0.2f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.ICY);
        beeSpecies.setNocturnal();
        beeSpecies.setHasEffect();
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(OXYGEN, GTBeeDefinition.getSpecies((byte)3, "Watery"), 15);
        tMutation.restrictTemperature(EnumTemperature.ICY);
    }),
    NITROGEN(GTBranchDefinition.NOBLEGAS, "Nitrogen", false, new Color(16762930), new Color(0xA52A2A), beeSpecies -> {
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.NITROGEN), Float.valueOf(0.45f));
        beeSpecies.addSpecialty(GTBees.combs.getStackForType(CombType.FLUORINE), Float.valueOf(0.2f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.ICY);
        beeSpecies.setNocturnal();
        beeSpecies.setHasEffect();
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(OXYGEN, HYDROGEN, 15);
        tMutation.restrictTemperature(EnumTemperature.ICY);
    }),
    FLUORINE(GTBranchDefinition.NOBLEGAS, "Fluorine", false, new Color(8826864), new Color(16739584), beeSpecies -> {
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.FLUORINE), Float.valueOf(0.45f));
        beeSpecies.addSpecialty(GTBees.combs.getStackForType(CombType.OXYGEN), Float.valueOf(0.2f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.ICY);
        beeSpecies.setNocturnal();
        beeSpecies.setHasEffect();
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(NITROGEN, HYDROGEN, 15);
        tMutation.restrictTemperature(EnumTemperature.ICY);
    }),
    RAREEARTH(GTBranchDefinition.RAREMETAL, "RareEarth", false, new Color(5592643), new Color(3421224), beeSpecies -> {
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.RAREEARTH), Float.valueOf(0.2f));
        beeSpecies.addSpecialty(GTBees.combs.getStackForType(CombType.NEODYMIUM), Float.valueOf(0.05f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWEST), dis -> dis.registerMutation(FLUORINE, REDSTONE, 10)),
    NEODYMIUM(GTBranchDefinition.RAREMETAL, "Neodymium", false, new Color(0x555555), new Color(0x4F4F4F), beeSpecies -> {
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.RAREEARTH), Float.valueOf(0.15f));
        beeSpecies.addSpecialty(GTBees.combs.getStackForType(CombType.NEODYMIUM), Float.valueOf(0.15f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.HOT);
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWEST);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.LONGEST);
    }, dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(RAREEARTH, IRON, 10);
        tMutation.requireResource(GregTechAPI.sBlockMetal5, 0);
    }),
    EUROPIUM(GTBranchDefinition.RAREMETAL, "Europium", false, new Color(14328034), new Color(11239089), beeSpecies -> {
        beeSpecies.addProduct(WerkstoffMaterialPool.EuropiumIIIOxide.get(OrePrefixes.dust, 1), Float.valueOf(0.1f));
        beeSpecies.addSpecialty(GTBees.combs.getStackForType(CombType.EUROPIUM), Float.valueOf(0.075f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.HOT);
        beeSpecies.setNocturnal();
        beeSpecies.setJubilanceProvider(JubilanceMegaApiary.instance);
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWEST);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.LONGEST);
    }, dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(NEODYMIUM, HYDROGEN, 5, 4.0f);
        tMutation.requireResource(GregTechAPI.sBlockMetal3, 3);
    }),
    AIR(GTBranchDefinition.INFUSEDSHARD, "Air", false, new Color(0xFFFF7E), new Color(6316079), beeSpecies -> {
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.INFUSEDAER), Float.valueOf(0.3f));
        beeSpecies.setHumidity(EnumHumidity.DAMP);
        beeSpecies.setHasEffect();
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(GTBeeDefinition.getSpecies((byte)3, "Supernatural"), GTBeeDefinition.getSpecies((byte)3, "Windy"), 15);
        tMutation.restrictTemperature(EnumTemperature.HOT);
        if (Mods.Thaumcraft.isModLoaded()) {
            tMutation.requireResource(GameRegistry.findBlock((String)Mods.Thaumcraft.ID, (String)"blockCrystal"), 0);
        }
    }),
    FIRE(GTBranchDefinition.INFUSEDSHARD, "Fire", false, new Color(15546369), new Color(3870208), beeSpecies -> {
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.INFUSEDIGNIS), Float.valueOf(0.3f));
        beeSpecies.setHumidity(EnumHumidity.ARID);
        beeSpecies.setHasEffect();
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(GTBeeDefinition.getSpecies((byte)3, "Supernatural"), AIR, 15);
        tMutation.restrictTemperature(EnumTemperature.HELLISH);
        if (Mods.Thaumcraft.isModLoaded()) {
            tMutation.requireResource(GameRegistry.findBlock((String)Mods.Thaumcraft.ID, (String)"blockCrystal"), 1);
        }
    }),
    WATER(GTBranchDefinition.INFUSEDSHARD, "Water", false, new Color(37119), new Color(9538), beeSpecies -> {
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.INFUSEDAQUA), Float.valueOf(0.3f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setHasEffect();
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(FIRE, AIR, 15);
        tMutation.restrictTemperature(EnumTemperature.ICY);
        if (Mods.Thaumcraft.isModLoaded()) {
            tMutation.requireResource(GameRegistry.findBlock((String)Mods.Thaumcraft.ID, (String)"blockCrystal"), 2);
        }
    }),
    EARTH(GTBranchDefinition.INFUSEDSHARD, "Earth", false, new Color(34304), new Color(13056), beeSpecies -> {
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.INFUSEDTERRA), Float.valueOf(0.3f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setHasEffect();
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(WATER, FIRE, 15);
        tMutation.restrictTemperature(EnumTemperature.WARM);
        if (Mods.Thaumcraft.isModLoaded()) {
            tMutation.requireResource(GameRegistry.findBlock((String)Mods.Thaumcraft.ID, (String)"blockCrystal"), 3);
        }
    }),
    ORDER(GTBranchDefinition.INFUSEDSHARD, "Order", false, new Color(9082800), new Color(6053730), beeSpecies -> {
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.INFUSEDORDO), Float.valueOf(0.3f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setHasEffect();
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(EARTH, FIRE, 15);
        tMutation.restrictTemperature(EnumTemperature.ICY);
        if (Mods.Thaumcraft.isModLoaded()) {
            tMutation.requireResource(GameRegistry.findBlock((String)Mods.Thaumcraft.ID, (String)"blockCrystal"), 4);
        }
    }),
    CHAOS(GTBranchDefinition.INFUSEDSHARD, "Chaos", false, new Color(3026497), new Color(2302249), beeSpecies -> {
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.INFUSEDPERDITIO), Float.valueOf(0.3f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setHasEffect();
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(ORDER, FIRE, 15);
        tMutation.restrictTemperature(EnumTemperature.ICY);
        if (Mods.Thaumcraft.isModLoaded()) {
            tMutation.requireResource(GameRegistry.findBlock((String)Mods.Thaumcraft.ID, (String)"blockCrystal"), 5);
        }
    }),
    NETHERSHARD(GTBranchDefinition.INFUSEDSHARD, "NetherShard", false, new Color(12452149), new Color(3473937), beeSpecies -> {
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.NETHERSHARD), Float.valueOf(0.3f));
        beeSpecies.setHumidity(EnumHumidity.ARID);
        beeSpecies.setTemperature(EnumTemperature.HOT);
        beeSpecies.setHasEffect();
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(CHAOS, FIRE, 15);
        GregTechAPI.sGTCompleteLoad.add(() -> tMutation.requireResource(GregTechAPI.sBlockGem3, 3));
    }),
    ENDSHARD(GTBranchDefinition.INFUSEDSHARD, "EnderShard", false, new Color(3026497), new Color(2302249), beeSpecies -> {
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.ENDERSHARD), Float.valueOf(0.3f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setNocturnal();
        beeSpecies.setHasEffect();
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(NETHERSHARD, ENDDUST, 15);
        tMutation.restrictTemperature(EnumTemperature.ICY);
        GregTechAPI.sGTCompleteLoad.add(() -> tMutation.requireResource(GregTechAPI.sBlockGem1, 7));
    }),
    UNKNOWNWATER(GTBranchDefinition.ORGANIC, "UnknownLiquid", false, new Color(4404133), new Color(3582975), beeSpecies -> {
        beeSpecies.addProduct(GTBees.combs.getStackForType(CombType.UNKNOWNLIQUID), Float.valueOf(0.2f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setNocturnal();
        beeSpecies.setHasEffect();
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST), dis -> dis.registerMutation(INFINITYCATALYST, MYSTERIOUSCRYSTAL, 5)),
    JAEGERMEISTER(GTBranchDefinition.ENDGAME, "JaegerMeister", false, new Color(371992), new Color(15194819), beeSpecies -> {
        beeSpecies.addProduct(GTModHandler.getModItem(Mods.CropsPlusPlus.ID, "BppPotions", 1L, 8), Float.valueOf(0.01f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setNocturnal();
        beeSpecies.setHasEffect();
    }, template -> AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST), dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation(INFINITYCATALYST, NAQUADRIA, 5);
        tMutation.requireResource(GregTechAPI.sBlockMachines, 4684);
        tMutation.addMutationCondition((IMutationCondition)new GTBees.DimensionMutationCondition(100, "Deep Dark"));
    });

    private final GTBranchDefinition branch;
    private final GTAlleleBeeSpecies species;
    private final Consumer<GTAlleleBeeSpecies> mSpeciesProperties;
    private final Consumer<IAllele[]> mAlleles;
    private final Consumer<GTBeeDefinition> mMutations;
    private IAllele[] template;
    private IBeeGenome genome;

    private GTBeeDefinition(GTBranchDefinition branch, String binomial, boolean dominant, Color primary, Color secondary, Consumer<GTAlleleBeeSpecies> aSpeciesProperties, Consumer<IAllele[]> aAlleles, Consumer<GTBeeDefinition> aMutations) {
        this.mAlleles = aAlleles;
        this.mMutations = aMutations;
        this.mSpeciesProperties = aSpeciesProperties;
        String lowercaseName = this.toString().toLowerCase(Locale.ENGLISH);
        String species = WordUtils.capitalize((String)lowercaseName);
        String uid = "gregtech.bee.species" + species;
        String description = "for.description." + lowercaseName;
        String name = "for.bees.species." + lowercaseName;
        GTLanguageManager.addStringLocalization("for.bees.species." + lowercaseName, species);
        String authority = GTLanguageManager.getTranslation("for.bees.authority." + lowercaseName);
        if (authority.equals("for.bees.authority." + lowercaseName)) {
            authority = "GTNH";
        }
        this.branch = branch;
        this.species = new GTAlleleBeeSpecies(uid, dominant, name, authority, description, branch.getBranch(), binomial, primary, secondary);
    }

    public static void initBees() {
        for (GTBeeDefinition bee : GTBeeDefinition.values()) {
            bee.init();
        }
        for (GTBeeDefinition bee : GTBeeDefinition.values()) {
            bee.registerMutations();
        }
    }

    static IAlleleBeeEffect getEffect(byte modid, String name) {
        String string;
        switch (modid) {
            case 1: {
                string = "extrabees.effect." + name;
                break;
            }
            case 2: {
                string = "gendustry.effect." + name;
                break;
            }
            case 3: {
                string = "magicbees.effect" + name;
                break;
            }
            case 4: {
                string = "gregtech.effect" + name;
                break;
            }
            default: {
                string = "forestry.effect" + name;
            }
        }
        String s = string;
        IAlleleBeeEffect allele = (IAlleleBeeEffect)AlleleManager.alleleRegistry.getAllele(s);
        if (allele == null) {
            GTMod.GT_FML_LOGGER.warn("Attempted to get unknown bee effect: " + s);
            allele = GTAlleleEffect.FORESTRY_BASE_EFFECT;
        }
        return allele;
    }

    static IAlleleFlowers getFlowers(byte modid, String name) {
        String string;
        switch (modid) {
            case 1: {
                string = "extrabees.flower." + name;
                break;
            }
            case 2: {
                string = "gendustry.flower." + name;
                break;
            }
            case 3: {
                string = "magicbees.flower" + name;
                break;
            }
            case 4: {
                string = "gregtech.flower" + name;
                break;
            }
            default: {
                string = "forestry.flowers" + name;
            }
        }
        String s = string;
        IAlleleFlowers allele = (IAlleleFlowers)AlleleManager.alleleRegistry.getAllele(s);
        if (allele == null) {
            GTMod.GT_FML_LOGGER.warn("Attempted to get unknown bee flower: " + s);
        }
        return allele;
    }

    private static IAlleleBeeSpecies getSpecies(byte modid, String name) {
        String string;
        switch (modid) {
            case 1: {
                string = "extrabees.species." + name;
                break;
            }
            case 2: {
                string = "gendustry.bee." + name;
                break;
            }
            case 3: {
                string = "magicbees.species" + name;
                break;
            }
            case 4: {
                string = "gregtech.species" + name;
                break;
            }
            default: {
                string = "forestry.species" + name;
            }
        }
        String s = string;
        Object ret = (IAlleleBeeSpecies)AlleleManager.alleleRegistry.getAllele(s);
        if (ret == null) {
            GTMod.GT_FML_LOGGER.warn("Attempted to get unknown bee species: " + s);
            ret = GTBeeDefinition.NAQUADRIA.species;
        }
        return ret;
    }

    private void setSpeciesProperties(GTAlleleBeeSpecies beeSpecies) {
        this.mSpeciesProperties.accept(beeSpecies);
    }

    private void setAlleles(IAllele[] template) {
        this.mAlleles.accept(template);
    }

    private void registerMutations() {
        this.mMutations.accept(this);
    }

    private void init() {
        this.setSpeciesProperties(this.species);
        this.template = this.branch.getTemplate();
        AlleleHelper.instance.set(this.template, (Enum)EnumBeeChromosome.SPECIES, (IAllele)this.species);
        this.setAlleles(this.template);
        this.genome = BeeManager.beeRoot.templateAsGenome(this.template);
        BeeManager.beeRoot.registerTemplate(this.template);
    }

    private IBeeMutationCustom registerMutation(IAlleleBeeSpecies parent1, IAlleleBeeSpecies parent2, int chance) {
        return this.registerMutation(parent1, parent2, chance, 1.0f);
    }

    private IBeeMutationCustom registerMutation(GTBeeDefinition parent1, IAlleleBeeSpecies parent2, int chance) {
        return this.registerMutation(parent1, parent2, chance, 1.0f);
    }

    private IBeeMutationCustom registerMutation(IAlleleBeeSpecies parent1, GTBeeDefinition parent2, int chance) {
        return this.registerMutation(parent1, parent2, chance, 1.0f);
    }

    private IBeeMutationCustom registerMutation(GTBeeDefinition parent1, GTBeeDefinition parent2, int chance) {
        return this.registerMutation(parent1, parent2, chance, 1.0f);
    }

    private IBeeMutationCustom registerMutation(IAlleleBeeSpecies parent1, IAlleleBeeSpecies parent2, int chance, float chanceDivider) {
        return new GTBeeMutation(parent1, parent2, this.getTemplate(), chance, chanceDivider);
    }

    private IBeeMutationCustom registerMutation(GTBeeDefinition parent1, IAlleleBeeSpecies parent2, int chance, float chanceDivider) {
        return this.registerMutation((IAlleleBeeSpecies)parent1.species, parent2, chance, chanceDivider);
    }

    private IBeeMutationCustom registerMutation(IAlleleBeeSpecies parent1, GTBeeDefinition parent2, int chance, float chanceDivider) {
        return this.registerMutation(parent1, (IAlleleBeeSpecies)parent2.species, chance, chanceDivider);
    }

    private IBeeMutationCustom registerMutation(GTBeeDefinition parent1, GTBeeDefinition parent2, int chance, float chanceDivider) {
        return this.registerMutation((IAlleleBeeSpecies)parent1.species, parent2, chance, chanceDivider);
    }

    public final IAllele[] getTemplate() {
        return Arrays.copyOf(this.template, this.template.length);
    }

    public final IBeeGenome getGenome() {
        return this.genome;
    }

    public final IBee getIndividual() {
        return new Bee(this.genome);
    }

    public final ItemStack getMemberStack(EnumBeeType beeType) {
        return BeeManager.beeRoot.getMemberStack((IIndividual)this.getIndividual(), beeType.ordinal());
    }

    public GTAlleleBeeSpecies getSpecies() {
        return this.species;
    }
}

