/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi.purification;

import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.math.Alignment;
import com.gtnewhorizons.modularui.api.math.Color;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import com.gtnewhorizons.modularui.common.widget.textfield.NumericWidget;
import gregtech.api.enums.Textures;
import gregtech.api.gui.modularui.GTUITextures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.MTEHatch;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTUtility;
import gregtech.common.gui.modularui.widget.CoverCycleButtonWidget;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;

public class MTEHatchPHSensor
extends MTEHatch {
    protected float threshold = 0.0f;
    protected boolean inverted = false;
    private boolean isOn = false;
    private static final IIconContainer textureFont = Textures.BlockIcons.OVERLAY_HATCH_PH_SENSOR;
    private static final IIconContainer textureFont_Glow = Textures.BlockIcons.OVERLAY_HATCH_PH_SENSOR_GLOW;

    public MTEHatchPHSensor(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, 0, "Detects pH value.", new ITexture[0]);
    }

    public MTEHatchPHSensor(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 0, aDescription, aTextures);
    }

    @Override
    public boolean isValidSlot(int aIndex) {
        return false;
    }

    @Override
    public boolean isFacingValid(ForgeDirection facing) {
        return true;
    }

    @Override
    public boolean isAccessAllowed(EntityPlayer aPlayer) {
        return true;
    }

    @Override
    public boolean allowGeneralRedstoneOutput() {
        return true;
    }

    @Override
    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection Side2, ItemStack aStack) {
        return false;
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return false;
    }

    @Override
    public void initDefaultModes(NBTTagCompound aNBT) {
        this.getBaseMetaTileEntity().setActive(true);
    }

    @Override
    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer, ForgeDirection side, float aX, float aY, float aZ) {
        this.openGui(aPlayer);
        return true;
    }

    @Override
    public String[] getDescription() {
        return new String[]{"Can be installed in the pH Neutralization Purification Unit.", "Outputs Redstone Signal according to the current pH value.", "Right click to open the GUI and change settings."};
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        this.threshold = aNBT.func_74760_g("mThreshold");
        this.inverted = aNBT.func_74767_n("mInverted");
        super.loadNBTData(aNBT);
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.func_74776_a("mThreshold", this.threshold);
        aNBT.func_74757_a("mInverted", this.inverted);
        super.saveNBTData(aNBT);
    }

    public void updateRedstoneOutput(float pH) {
        this.isOn = pH > this.threshold ^ this.inverted;
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (this.isOn) {
            for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
                aBaseMetaTileEntity.setStrongOutputRedstoneSignal(side, (byte)15);
            }
        } else {
            for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
                aBaseMetaTileEntity.setStrongOutputRedstoneSignal(side, (byte)0);
            }
        }
        super.onPostTick(aBaseMetaTileEntity, aTick);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEHatchPHSensor(this.mName, this.mTier, this.mDescriptionArray, this.mTextures);
    }

    @Override
    public ITexture[] getTexturesActive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, TextureFactory.of(textureFont), TextureFactory.builder().addIcon(textureFont_Glow).glow().build()};
    }

    @Override
    public ITexture[] getTexturesInactive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, TextureFactory.of(textureFont)};
    }

    @Override
    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        String INVERTED = GTUtility.trans("INVERTED", "Inverted");
        String NORMAL = GTUtility.trans("NORMAL", "Normal");
        ((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(new CoverCycleButtonWidget().setToggle(() -> this.inverted, val -> {
            this.inverted = val;
        }).setTextureGetter(state -> state == 1 ? GTUITextures.OVERLAY_BUTTON_REDSTONE_ON : GTUITextures.OVERLAY_BUTTON_REDSTONE_OFF).addTooltip(0, NORMAL).addTooltip(1, INVERTED).setPos(10, 8))).widget(new TextWidget().setStringSupplier(() -> this.inverted ? INVERTED : NORMAL).setDefaultColor(((Integer)this.COLOR_TEXT_GRAY.get()).intValue()).setTextAlignment(Alignment.CenterLeft).setPos(28, 12))).widget(new NumericWidget().setBounds(0.0, 14.0).setIntegerOnly(false).setGetter(() -> this.threshold).setSetter(value -> {
            this.threshold = (float)Math.round(value * 100.0) / 100.0f;
        }).setScrollValues(0.1, 0.01, 1.0).setMaximumFractionDigits(2).setTextColor(Color.WHITE.dark(1)).setTextAlignment(Alignment.CenterLeft).setFocusOnGuiOpen(true).setBackground(new IDrawable[]{GTUITextures.BACKGROUND_TEXT_FIELD.withOffset(-1.0f, -1.0f, 2.0f, 2.0f)}).setPos(10, 28).setSize(77, 12))).widget(new TextWidget(StatCollector.func_74838_a((String)"GT5U.gui.text.ph_sensor")).setDefaultColor(((Integer)this.COLOR_TEXT_GRAY.get()).intValue()).setTextAlignment(Alignment.CenterLeft).setPos(90, 30));
    }
}

