/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi;

import com.google.common.collect.ImmutableList;
import com.gtnewhorizons.modularui.api.NumberFormatMUI;
import com.gtnewhorizons.modularui.api.math.Alignment;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.Column;
import com.gtnewhorizons.modularui.common.widget.DynamicPositionedColumn;
import com.gtnewhorizons.modularui.common.widget.FakeSyncWidget;
import com.gtnewhorizons.modularui.common.widget.SlotWidget;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.SoundResource;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetricsExporter;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.objects.GTChunkManager;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTLog;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.api.util.ValidationResult;
import gregtech.api.util.ValidationType;
import gregtech.common.UndergroundOil;
import gregtech.common.tileentities.machines.multi.MTEDrillerBase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnegative;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public abstract class MTEOilDrillBase
extends MTEDrillerBase
implements IMetricsExporter {
    private final ArrayList<Chunk> mOilFieldChunks = new ArrayList();
    private Fluid mOil = null;
    private int mOilFlow = 0;
    private int chunkRangeConfig = this.getRangeInChunks();
    @NotNull
    private String clientFluidType = "";
    private int clientFlowPerTick = 0;
    private int clientFlowPerOperation = 0;
    protected static final NumberFormatMUI numberFormat = new NumberFormatMUI();

    public MTEOilDrillBase(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public MTEOilDrillBase(String aName) {
        super(aName);
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection aFacing, int colorIndex, boolean aActive, boolean redstoneLevel) {
        if (side == aFacing) {
            if (aActive) {
                return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(this.casingTextureIndex), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_OIL_DRILL_ACTIVE).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_OIL_DRILL_ACTIVE_GLOW).extFacing().glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(this.casingTextureIndex), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_OIL_DRILL).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_OIL_DRILL_GLOW).extFacing().glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(this.casingTextureIndex)};
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74768_a("chunkRangeConfig", this.chunkRangeConfig);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        if (aNBT.func_74764_b("chunkRangeConfig")) {
            this.chunkRangeConfig = aNBT.func_74762_e("chunkRangeConfig");
        }
    }

    protected MultiblockTooltipBuilder createTooltip(String tierSuffix) {
        String casings = this.getCasingBlockItem().get(0L, new Object[0]).func_82833_r();
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        int baseCycleTime = this.calculateMaxProgressTime(this.getMinTier(), true);
        tt.addMachineType("Pump, FDP").addInfo("Works on " + this.getRangeInChunks() + "x" + this.getRangeInChunks() + " chunks").addInfo("Use a Screwdriver to configure range").addInfo("Use Programmed Circuits to ignore near exhausted oil field").addInfo("If total circuit # is greater than output amount it will halt. If it worked right.").addInfo("Minimum energy hatch tier: " + GTUtility.getColoredTierNameFromTier((byte)this.getMinTier())).addInfo("Base cycle time: " + (baseCycleTime < 20 ? GTUtility.formatNumbers(baseCycleTime) + " ticks" : GTUtility.formatNumbers((double)baseCycleTime / 20.0) + " seconds")).beginStructureBlock(3, 7, 3, false).addController("Front bottom").addOtherStructurePart(casings, "form the 3x1x3 Base").addOtherStructurePart(casings, "1x3x1 pillar above the center of the base (2 minimum total)").addOtherStructurePart(this.getFrameMaterial().mName + " Frame Boxes", "Each pillar's side and 1x3x1 on top").addEnergyHatch("1x " + GTValues.VN[this.getMinTier()] + "+, Any base casing", 1).addMaintenanceHatch("Any base casing", 1).addInputBus("Mining Pipes or Circuits, optional, any base casing", 1).addOutputHatch("Any base casing", 1).toolTipFinisher(new String[0]);
        return tt;
    }

    protected abstract int getRangeInChunks();

    @Override
    public void onScrewdriverRightClick(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        super.onScrewdriverRightClick(side, aPlayer, aX, aY, aZ);
        int oldChunkRange = this.chunkRangeConfig;
        if (aPlayer.func_70093_af()) {
            if (this.chunkRangeConfig > 0) {
                --this.chunkRangeConfig;
            }
            if (this.chunkRangeConfig == 0) {
                this.chunkRangeConfig = this.getRangeInChunks();
            }
        } else {
            if (this.chunkRangeConfig <= this.getRangeInChunks()) {
                ++this.chunkRangeConfig;
            }
            if (this.chunkRangeConfig > this.getRangeInChunks()) {
                this.chunkRangeConfig = 1;
            }
        }
        if (oldChunkRange != this.chunkRangeConfig) {
            this.mOilFieldChunks.clear();
        }
        GTUtility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)"GT5U.machines.workareaset") + " " + this.chunkRangeConfig + "x" + this.chunkRangeConfig + StatCollector.func_74838_a((String)"GT5U.machines.chunks"));
    }

    @Override
    protected boolean checkHatches() {
        return !this.mMaintenanceHatches.isEmpty() && !this.mOutputHatches.isEmpty() && this.mEnergyHatches.size() == 1;
    }

    @Override
    protected List<IHatchElement<? super MTEDrillerBase>> getAllowedHatches() {
        return ImmutableList.of((Object)HatchElement.InputBus, (Object)HatchElement.OutputHatch, (Object)HatchElement.Maintenance, (Object)HatchElement.Energy);
    }

    @Override
    protected void setElectricityStats() {
        this.mEfficiency = this.getCurrentEfficiency(null);
        this.mEfficiencyIncrease = 10000;
        int tier = Math.max(0, GTUtility.getTier(this.getMaxInputVoltage()));
        this.mEUt = -7 << (tier << 1);
        this.mMaxProgresstime = this.calculateMaxProgressTime(tier);
    }

    @Override
    public int calculateMaxProgressTime(int tier, boolean simulateWorking) {
        return (int)Math.max(1.0, (double)(this.workState == 1 || simulateWorking ? 64 * (this.chunkRangeConfig * this.chunkRangeConfig) >> this.getMinTier() - 1 : 120) / Math.pow(2.0, tier));
    }

    protected float computeSpeed() {
        return 0.5f + (float)(GTUtility.getTier(this.getMaxInputVoltage()) - this.getMinTier()) * 0.25f;
    }

    @Override
    protected boolean workingAtBottom(ItemStack aStack, int xDrill, int yDrill, int zDrill, int xPipe, int zPipe, int yHead, int oldYHead) {
        switch (this.tryLowerPipeState(true)) {
            case 0: {
                this.workState = 0;
                this.setElectricityStats();
                return true;
            }
            case 3: {
                this.workState = 2;
                return true;
            }
        }
        if (this.reachingVoidOrBedrock() && this.tryFillChunkList()) {
            float speed;
            ValidationResult<FluidStack> pumpResult;
            if (this.mWorkChunkNeedsReload) {
                this.mCurrentChunk = new ChunkCoordIntPair(xDrill >> 4, zDrill >> 4);
                GTChunkManager.requestChunkLoad((TileEntity)this.getBaseMetaTileEntity(), null);
                this.mWorkChunkNeedsReload = false;
            }
            if ((pumpResult = this.tryPumpOil(speed = this.computeSpeed())).getType() != ValidationType.VALID) {
                this.mEUt = 0;
                this.mMaxProgresstime = 0;
                this.setRuntimeFailureReason(CheckRecipeResultRegistry.FLUID_OUTPUT_FULL);
                return false;
            }
            FluidStack tFluid = pumpResult.getResult();
            if (tFluid != null && tFluid.amount > this.getTotalConfigValue()) {
                this.mOutputFluids = new FluidStack[]{tFluid};
                return true;
            }
        }
        GTChunkManager.releaseTicket((TileEntity)this.getBaseMetaTileEntity());
        this.workState = 2;
        this.setShutdownReason(StatCollector.func_74838_a((String)"GT5U.gui.text.drill_exhausted"));
        return true;
    }

    private boolean tryFillChunkList() {
        FluidStack tFluid;
        if (this.mOil == null) {
            tFluid = UndergroundOil.undergroundOilReadInformation(this.getBaseMetaTileEntity());
            if (tFluid == null) {
                return false;
            }
            this.mOil = tFluid.getFluid();
        }
        if (GTValues.debugDriller) {
            GTLog.out.println(" Driller on  fluid = " + this.mOil == null ? null : this.mOil.getName());
        }
        FluidStack tOil = new FluidStack(this.mOil, 0);
        if (this.mOilFieldChunks.isEmpty()) {
            Chunk tChunk = this.getBaseMetaTileEntity().getWorld().func_72938_d(this.getBaseMetaTileEntity().getXCoord(), this.getBaseMetaTileEntity().getZCoord());
            int range = this.chunkRangeConfig;
            int xChunk = Math.floorDiv(tChunk.field_76635_g, range) * range;
            int zChunk = Math.floorDiv(tChunk.field_76647_h, range) * range;
            if (GTValues.debugDriller) {
                GTLog.out.println("tChunk.xPosition = " + tChunk.field_76635_g + " tChunk.zPosition = " + tChunk.field_76647_h + " xChunk = " + xChunk + " zChunk = " + zChunk);
            }
            for (int i = 0; i < range; ++i) {
                for (int j = 0; j < range; ++j) {
                    if (GTValues.debugDriller) {
                        GTLog.out.println(" getChunkX = " + (xChunk + i) + " getChunkZ = " + (zChunk + j));
                    }
                    tChunk = this.getBaseMetaTileEntity().getWorld().func_72964_e(xChunk + i, zChunk + j);
                    tFluid = UndergroundOil.undergroundOilReadInformation(tChunk);
                    if (GTValues.debugDriller) {
                        GTLog.out.println(" Fluid in chunk = " + tFluid.getFluid().getID());
                    }
                    if (!tOil.isFluidEqual(tFluid) || tFluid.amount <= 0) continue;
                    this.mOilFieldChunks.add(tChunk);
                    if (!GTValues.debugDriller) continue;
                    GTLog.out.println(" Matching fluid, quantity = " + tFluid.amount);
                }
            }
        }
        if (GTValues.debugDriller) {
            GTLog.out.println("mOilFieldChunks.size = " + this.mOilFieldChunks.size());
        }
        return !this.mOilFieldChunks.isEmpty();
    }

    protected ValidationResult<FluidStack> tryPumpOil(float speed) {
        FluidStack simulatedOil;
        if (this.mOil == null) {
            return null;
        }
        if (GTValues.debugDriller) {
            GTLog.out.println(" pump speed = " + speed);
        }
        if (this.protectsExcessFluid() && !this.canOutputAll(new FluidStack[]{simulatedOil = this.pumpOil(speed, true)})) {
            return ValidationResult.of(ValidationType.INVALID, null);
        }
        FluidStack pumpedOil = this.pumpOil(speed, false);
        this.mOilFlow = pumpedOil.amount;
        return ValidationResult.of(ValidationType.VALID, pumpedOil.amount == 0 ? null : pumpedOil);
    }

    protected FluidStack pumpOil(@Nonnegative float speed, boolean simulate) {
        if (speed < 0.0f) {
            throw new IllegalArgumentException("Don't pass negative speed");
        }
        ArrayList<Chunk> emptyChunks = new ArrayList<Chunk>();
        FluidStack returnOil = new FluidStack(this.mOil, 0);
        for (Chunk tChunk : this.mOilFieldChunks) {
            FluidStack pumped = UndergroundOil.undergroundOil(tChunk, simulate ? -speed : speed);
            if (GTValues.debugDriller) {
                GTLog.out.println(" chunkX = " + tChunk.func_76632_l().field_77276_a + " chunkZ = " + tChunk.func_76632_l().field_77275_b);
                if (pumped != null) {
                    GTLog.out.println("     Fluid pumped = " + pumped.amount);
                } else {
                    GTLog.out.println("     No fluid pumped ");
                }
            }
            if (pumped == null || pumped.amount < 1) {
                emptyChunks.add(tChunk);
                continue;
            }
            if (!returnOil.isFluidEqual(pumped)) continue;
            returnOil.amount += pumped.amount;
        }
        for (Chunk tChunk : emptyChunks) {
            this.mOilFieldChunks.remove(tChunk);
        }
        return returnOil;
    }

    @Override
    protected SoundResource getProcessStartSound() {
        return SoundResource.IC2_MACHINES_PUMP_OP;
    }

    @Override
    public String[] getInfoData() {
        ArrayList<String> l = new ArrayList<String>(Arrays.asList(EnumChatFormatting.BLUE + StatCollector.func_74838_a((String)"GT5U.machines.oilfluidpump") + EnumChatFormatting.RESET, StatCollector.func_74838_a((String)"GT5U.machines.workarea") + ": " + EnumChatFormatting.GREEN + GTUtility.formatNumbers(this.chunkRangeConfig) + " x " + GTUtility.formatNumbers(this.chunkRangeConfig) + EnumChatFormatting.RESET + " " + StatCollector.func_74838_a((String)"GT5U.machines.chunks"), StatCollector.func_74837_a((String)"GT5U.infodata.oil_drill.drilling_fluid", (Object[])new Object[]{EnumChatFormatting.GREEN + this.getFluidName() + EnumChatFormatting.RESET}), StatCollector.func_74837_a((String)"GT5U.infodata.oil_drill.drilling_flow", (Object[])new Object[]{EnumChatFormatting.GREEN + GTUtility.formatNumbers(this.getFlowRatePerTick()) + EnumChatFormatting.RESET})));
        l.addAll(Arrays.asList(super.getInfoData()));
        return l.toArray(new String[0]);
    }

    @Override
    @NotNull
    public List<String> reportMetrics() {
        boolean machineIsActive = this.getBaseMetaTileEntity().isActive();
        String failureReason = this.getFailureReason().map(reason -> StatCollector.func_74837_a((String)"GT5U.gui.text.drill_offline_reason", (Object[])new Object[]{reason})).orElseGet(() -> StatCollector.func_74837_a((String)"GT5U.gui.text.drill_offline_generic", (Object[])new Object[0]));
        if (this.workState == 1) {
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.add((Object)StatCollector.func_74837_a((String)"GT5U.gui.text.pump_fluid_type", (Object[])new Object[]{this.getFluidName()}));
            if (machineIsActive) {
                builder.add((Object[])new String[]{StatCollector.func_74837_a((String)"GT5U.gui.text.pump_rate.1", (Object[])new Object[]{EnumChatFormatting.AQUA + numberFormat.format((long)this.getFlowRatePerTick())}) + StatCollector.func_74838_a((String)"GT5U.gui.text.pump_rate.2"), this.mOilFlow + StatCollector.func_74838_a((String)"GT5U.gui.text.pump_recovery.2")});
            } else {
                builder.add((Object)failureReason);
            }
            return builder.build();
        }
        if (machineIsActive) {
            ImmutableList immutableList;
            switch (this.workState) {
                case 0: {
                    immutableList = ImmutableList.of((Object)StatCollector.func_74838_a((String)"GT5U.gui.text.deploying_pipe"));
                    break;
                }
                case 2: 
                case 3: {
                    immutableList = ImmutableList.of((Object)StatCollector.func_74838_a((String)"GT5U.gui.text.retracting_pipe"));
                    break;
                }
                default: {
                    immutableList = ImmutableList.of();
                }
            }
            return immutableList;
        }
        return ImmutableList.of((Object)failureReason);
    }

    protected int getFlowRatePerTick() {
        return this.mMaxProgresstime > 0 ? this.mOilFlow / this.mMaxProgresstime : 0;
    }

    @NotNull
    private String getFluidName() {
        if (this.mOil != null) {
            return this.mOil.getLocalizedName(new FluidStack(this.mOil, 0));
        }
        return "None";
    }

    @Override
    protected void drawTexts(DynamicPositionedColumn screenElements, SlotWidget inventorySlot) {
        super.drawTexts(screenElements, inventorySlot);
        ((Column)((Column)((Column)((Column)((Column)((Column)screenElements.widget(new TextWidget().setStringSupplier(() -> EnumChatFormatting.GRAY + StatCollector.func_74837_a((String)"GT5U.gui.text.pump_fluid_type", (Object[])new Object[]{this.clientFluidType})).setTextAlignment(Alignment.CenterLeft).setEnabled(widget -> this.getBaseMetaTileEntity().isActive() && this.workState == 1))).widget(new TextWidget().setStringSupplier(() -> EnumChatFormatting.GRAY + StatCollector.func_74837_a((String)"GT5U.gui.text.pump_rate.1", (Object[])new Object[]{EnumChatFormatting.AQUA + numberFormat.format((long)this.clientFlowPerTick)}) + EnumChatFormatting.GRAY + StatCollector.func_74838_a((String)"GT5U.gui.text.pump_rate.2")).setTextAlignment(Alignment.CenterLeft).setEnabled(widget -> this.getBaseMetaTileEntity().isActive() && this.workState == 1))).widget(new TextWidget().setStringSupplier(() -> EnumChatFormatting.GRAY + StatCollector.func_74837_a((String)"GT5U.gui.text.pump_recovery.1", (Object[])new Object[]{EnumChatFormatting.AQUA + numberFormat.format((long)this.clientFlowPerOperation)}) + EnumChatFormatting.GRAY + StatCollector.func_74838_a((String)"GT5U.gui.text.pump_recovery.2")).setTextAlignment(Alignment.CenterLeft).setEnabled(widget -> this.getBaseMetaTileEntity().isActive() && this.workState == 1))).widget((Widget)new FakeSyncWidget.IntegerSyncer(() -> this.workState, newInt -> {
            this.workState = newInt;
        }))).widget((Widget)new FakeSyncWidget.StringSyncer(this::getFluidName, newString -> {
            this.clientFluidType = newString;
        }))).widget((Widget)new FakeSyncWidget.IntegerSyncer(this::getFlowRatePerTick, newInt -> {
            this.clientFlowPerTick = newInt;
        }))).widget((Widget)new FakeSyncWidget.IntegerSyncer(() -> this.mOilFlow, newInt -> {
            this.clientFlowPerOperation = newInt;
        }));
    }

    @Override
    public boolean supportsVoidProtection() {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected SoundResource getActivitySoundLoop() {
        return SoundResource.GT_MACHINES_OIL_DRILL_LOOP;
    }
}

