/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi;

import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.HeatingCoilLevel;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.metatileentity.implementations.MTEEnhancedMultiBlockBase;
import gregtech.api.metatileentity.implementations.MTEHatchInput;
import gregtech.api.metatileentity.implementations.MTEHatchMultiInput;
import gregtech.api.metatileentity.implementations.MTEHatchOutput;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.maps.OilCrackerBackend;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.common.tileentities.machines.IRecipeProcessingAwareHatch;
import gregtech.common.tileentities.machines.MTEHatchInputME;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class MTEOilCracker
extends MTEEnhancedMultiBlockBase<MTEOilCracker>
implements ISurvivalConstructable {
    private static final byte CASING_INDEX = 49;
    private static final String STRUCTURE_PIECE_MAIN = "main";
    private static final IStructureDefinition<MTEOilCracker> STRUCTURE_DEFINITION = StructureDefinition.builder().addShape("main", StructureUtility.transpose((String[][])new String[][]{{"lcmcr", "lcmcr", "lcmcr"}, {"lc~cr", "l---r", "lcmcr"}, {"lcmcr", "lcmcr", "lcmcr"}})).addElement('c', GTStructureUtility.activeCoils(GTStructureUtility.ofCoil(MTEOilCracker::setCoilLevel, MTEOilCracker::getCoilLevel))).addElement('l', GTStructureUtility.buildHatchAdder(MTEOilCracker.class).atLeast(HatchElement.InputHatch.withAdder(MTEOilCracker::addLeftHatchToMachineList), HatchElement.Energy, HatchElement.Maintenance).dot(2).casingIndex(49).buildAndChain(StructureUtility.onElementPass(MTEOilCracker::onCasingAdded, (IStructureElement)StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings4, (int)1)))).addElement('r', GTStructureUtility.buildHatchAdder(MTEOilCracker.class).atLeast(HatchElement.OutputHatch.withAdder(MTEOilCracker::addRightHatchToMachineList), HatchElement.Energy, HatchElement.Maintenance).dot(3).casingIndex(49).buildAndChain(StructureUtility.onElementPass(MTEOilCracker::onCasingAdded, (IStructureElement)StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings4, (int)1)))).addElement('m', GTStructureUtility.buildHatchAdder(MTEOilCracker.class).atLeast(HatchElement.InputHatch.withAdder(MTEOilCracker::addMiddleInputToMachineList).withCount(t -> t.mMiddleInputHatches.size()), HatchElement.InputBus, HatchElement.Energy, HatchElement.Maintenance).dot(1).casingIndex(49).buildAndChain(StructureUtility.onElementPass(MTEOilCracker::onCasingAdded, (IStructureElement)StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings4, (int)1)))).build();
    private HeatingCoilLevel heatLevel;
    protected final List<MTEHatchInput> mMiddleInputHatches = new ArrayList<MTEHatchInput>();
    protected int mInputOnSide;
    protected int mOutputOnSide;
    protected int mCasingAmount;

    public MTEOilCracker(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public MTEOilCracker(String aName) {
        super(aName);
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType("Cracker").addInfo("Thermally cracks heavy hydrocarbons into lighter fractions").addInfo("More efficient than the Chemical Reactor").addInfo("Gives different benefits whether it hydro or steam-cracks:").addInfo("Hydro - Consumes 20% less Hydrogen and outputs 25% more cracked fluid").addInfo("Steam - Outputs 50% more cracked fluid").addInfo("(Values compared to cracking in the Chemical Reactor)").addInfo("Place the appropriate circuit in the controller or an input bus").beginStructureBlock(5, 3, 3, true).addController("Front center").addCasingInfoRange("Clean Stainless Steel Machine Casing", 18, 21, false).addOtherStructurePart("2 Rings of 8 Coils", "Each side of the controller").addInfo("Gets 10% EU/t reduction per coil tier, up to a maximum of 50%").addEnergyHatch("Any casing", 1, 2, 3).addMaintenanceHatch("Any casing", 1, 2, 3).addInputHatch("For cracking fluid (Steam/Hydrogen/etc.) ONLY, Any middle ring casing", 1).addInputHatch("Any left/right side casing", 2, 3).addOutputHatch("Any right/left side casing", 2, 3).addStructureInfo("Input/Output Hatches must be on opposite sides!").addInputBus("Any middle ring casing, optional for programmed circuit automation").addStructureHint("GT5U.cracker.io_side").toolTipFinisher(new String[0]);
        return tt;
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity baseMetaTileEntity, ForgeDirection sideDirection, ForgeDirection facingDirection, int colorIndex, boolean active, boolean redstoneLevel) {
        if (sideDirection == facingDirection) {
            if (active) {
                return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][49], TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_OIL_CRACKER_ACTIVE).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_OIL_CRACKER_ACTIVE_GLOW).extFacing().glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][49], TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_OIL_CRACKER).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_OIL_CRACKER_GLOW).extFacing().glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][49]};
    }

    public RecipeMap<OilCrackerBackend> getRecipeMap() {
        return RecipeMaps.crackingRecipes;
    }

    @Override
    protected ProcessingLogic createProcessingLogic() {
        return new ProcessingLogic(){

            @Override
            @Nonnull
            public CheckRecipeResult process() {
                this.setEuModifier(1.0f - Math.min(0.1f * (float)(MTEOilCracker.this.heatLevel.getTier() + 1), 0.5f));
                return super.process();
            }
        };
    }

    @Override
    public IStructureDefinition<MTEOilCracker> getStructureDefinition() {
        return STRUCTURE_DEFINITION;
    }

    public HeatingCoilLevel getCoilLevel() {
        return this.heatLevel;
    }

    public void setCoilLevel(HeatingCoilLevel aCoilLevel) {
        this.heatLevel = aCoilLevel;
    }

    private boolean addMiddleInputToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof MTEHatchInput) {
            MTEHatchInput tHatch = (MTEHatchInput)aMetaTileEntity;
            tHatch.updateTexture(aBaseCasingIndex);
            tHatch.mRecipeMap = this.getRecipeMap();
            return this.mMiddleInputHatches.add(tHatch);
        }
        return false;
    }

    private boolean addLeftHatchToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof MTEHatchInput) {
            MTEHatchInput tHatch = (MTEHatchInput)aMetaTileEntity;
            if (this.mInputOnSide == 1) {
                return false;
            }
            this.mInputOnSide = 0;
            this.mOutputOnSide = 1;
            tHatch.updateTexture(aBaseCasingIndex);
            tHatch.mRecipeMap = this.getRecipeMap();
            return this.mInputHatches.add(tHatch);
        }
        if (aMetaTileEntity instanceof MTEHatchOutput) {
            MTEHatchOutput tHatch = (MTEHatchOutput)aMetaTileEntity;
            if (this.mOutputOnSide == 1) {
                return false;
            }
            this.mInputOnSide = 1;
            this.mOutputOnSide = 0;
            tHatch.updateTexture(aBaseCasingIndex);
            return this.mOutputHatches.add(tHatch);
        }
        return false;
    }

    private boolean addRightHatchToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof MTEHatchInput) {
            MTEHatchInput tHatch = (MTEHatchInput)aMetaTileEntity;
            if (this.mInputOnSide == 0) {
                return false;
            }
            this.mInputOnSide = 1;
            this.mOutputOnSide = 0;
            tHatch.updateTexture(aBaseCasingIndex);
            tHatch.mRecipeMap = this.getRecipeMap();
            return this.mInputHatches.add(tHatch);
        }
        if (aMetaTileEntity instanceof MTEHatchOutput) {
            MTEHatchOutput tHatch = (MTEHatchOutput)aMetaTileEntity;
            if (this.mOutputOnSide == 0) {
                return false;
            }
            this.mInputOnSide = 0;
            this.mOutputOnSide = 1;
            tHatch.updateTexture(aBaseCasingIndex);
            return this.mOutputHatches.add(tHatch);
        }
        return false;
    }

    private void onCasingAdded() {
        ++this.mCasingAmount;
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.setCoilLevel(HeatingCoilLevel.None);
        this.mCasingAmount = 0;
        this.mMiddleInputHatches.clear();
        this.mInputOnSide = -1;
        this.mOutputOnSide = -1;
        this.replaceDeprecatedCoils(aBaseMetaTileEntity);
        return this.checkPiece(STRUCTURE_PIECE_MAIN, 2, 1, 0) && this.mInputOnSide != -1 && this.mOutputOnSide != -1 && this.mCasingAmount >= 18 && this.mMaintenanceHatches.size() == 1 && !this.mMiddleInputHatches.isEmpty();
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    @Override
    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEOilCracker(this.mName);
    }

    private void replaceDeprecatedCoils(IGregTechTileEntity aBaseMetaTileEntity) {
        int xDir = aBaseMetaTileEntity.getBackFacing().offsetX;
        int zDir = aBaseMetaTileEntity.getBackFacing().offsetZ;
        int tX = aBaseMetaTileEntity.getXCoord() + xDir;
        short tY = aBaseMetaTileEntity.getYCoord();
        int tZ = aBaseMetaTileEntity.getZCoord() + zDir;
        for (int xPos = tX - 1; xPos <= tX + 1; xPos += xDir != 0 ? 1 : 2) {
            for (int yPos = tY - 1; yPos <= tY + 1; ++yPos) {
                for (int zPos = tZ - 1; zPos <= tZ + 1; zPos += xDir != 0 ? 2 : 1) {
                    int tUsedMeta;
                    if (yPos == tY && (xPos == tX || zPos == tZ) || (tUsedMeta = aBaseMetaTileEntity.getMetaID(xPos, yPos, zPos)) < 12 || tUsedMeta > 14 || aBaseMetaTileEntity.getBlock(xPos, yPos, zPos) != GregTechAPI.sBlockCasings1) continue;
                    aBaseMetaTileEntity.getWorld().func_147465_d(xPos, yPos, zPos, GregTechAPI.sBlockCasings5, tUsedMeta - 12, 3);
                }
            }
        }
    }

    @Override
    public ArrayList<FluidStack> getStoredFluids() {
        MTEHatchInputME meHatch;
        ArrayList<FluidStack> rList = new ArrayList<FluidStack>();
        HashMap<Fluid, FluidStack> inputsFromME = new HashMap<Fluid, FluidStack>();
        for (MTEHatchInput tHatch : GTUtility.validMTEList(this.mInputHatches)) {
            tHatch.mRecipeMap = this.getRecipeMap();
            if (tHatch instanceof MTEHatchInputME) {
                meHatch = (MTEHatchInputME)tHatch;
                for (FluidStack tFluid : meHatch.getStoredFluids()) {
                    if (tFluid == null || this.getRecipeMap().getBackend().isValidCatalystFluid(tFluid)) continue;
                    inputsFromME.put(tFluid.getFluid(), tFluid);
                }
                continue;
            }
            if (tHatch instanceof MTEHatchMultiInput) {
                for (FluidStack tFluid : ((MTEHatchMultiInput)tHatch).getStoredFluid()) {
                    if (tFluid == null || this.getRecipeMap().getBackend().isValidCatalystFluid(tFluid)) continue;
                    rList.add(tFluid);
                }
                continue;
            }
            if (tHatch.getFillableStack() == null || this.getRecipeMap().getBackend().isValidCatalystFluid(tHatch.getFillableStack())) continue;
            rList.add(tHatch.getFillableStack());
        }
        for (MTEHatchInput tHatch : GTUtility.validMTEList(this.mMiddleInputHatches)) {
            tHatch.mRecipeMap = this.getRecipeMap();
            if (tHatch instanceof MTEHatchInputME) {
                meHatch = (MTEHatchInputME)tHatch;
                for (FluidStack tFluid : meHatch.getStoredFluids()) {
                    if (tFluid == null || !this.getRecipeMap().getBackend().isValidCatalystFluid(tFluid)) continue;
                    inputsFromME.put(tFluid.getFluid(), tFluid);
                }
                continue;
            }
            if (tHatch instanceof MTEHatchMultiInput) {
                for (FluidStack tFluid : ((MTEHatchMultiInput)tHatch).getStoredFluid()) {
                    if (tFluid == null || !this.getRecipeMap().getBackend().isValidCatalystFluid(tFluid)) continue;
                    rList.add(tFluid);
                }
                continue;
            }
            if (tHatch.getFillableStack() == null) continue;
            FluidStack tStack = tHatch.getFillableStack();
            if (!this.getRecipeMap().getBackend().isValidCatalystFluid(tStack)) continue;
            rList.add(tStack);
        }
        if (!inputsFromME.isEmpty()) {
            rList.addAll(inputsFromME.values());
        }
        return rList;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(STRUCTURE_PIECE_MAIN, stackSize, hintsOnly, 2, 1, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivialBuildPiece(STRUCTURE_PIECE_MAIN, stackSize, 2, 1, 0, elementBudget, env, false, true);
    }

    @Override
    public boolean supportsVoidProtection() {
        return true;
    }

    @Override
    public boolean supportsBatchMode() {
        return true;
    }

    @Override
    protected void startRecipeProcessing() {
        for (MTEHatchInput hatch : GTUtility.validMTEList(this.mMiddleInputHatches)) {
            if (!(hatch instanceof IRecipeProcessingAwareHatch)) continue;
            IRecipeProcessingAwareHatch aware = (IRecipeProcessingAwareHatch)((Object)hatch);
            aware.startRecipeProcessing();
        }
        super.startRecipeProcessing();
    }

    @Override
    protected void endRecipeProcessing() {
        super.endRecipeProcessing();
        for (MTEHatchInput hatch : GTUtility.validMTEList(this.mMiddleInputHatches)) {
            if (!(hatch instanceof IRecipeProcessingAwareHatch)) continue;
            IRecipeProcessingAwareHatch aware = (IRecipeProcessingAwareHatch)((Object)hatch);
            this.setResultIfFailure(aware.endRecipeProcessing(this));
        }
    }
}

