/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi;

import com.google.common.collect.ImmutableList;
import com.gtnewhorizons.modularui.api.NumberFormatMUI;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.math.Alignment;
import com.gtnewhorizons.modularui.api.math.Pos2d;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.api.widget.IWidgetBuilder;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.ButtonWidget;
import com.gtnewhorizons.modularui.common.widget.Column;
import com.gtnewhorizons.modularui.common.widget.DynamicPositionedColumn;
import com.gtnewhorizons.modularui.common.widget.FakeSyncWidget;
import com.gtnewhorizons.modularui.common.widget.SlotWidget;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.Materials;
import gregtech.api.gui.modularui.GTUITextures;
import gregtech.api.gui.widgets.LockedWhileActiveButton;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.api.util.shutdown.ShutDownReasonRegistry;
import gregtech.common.tileentities.machines.multi.MTEDrillerBase;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fluids.IFluidBlock;

public abstract class MTEConcreteBackfillerBase
extends MTEDrillerBase {
    private int mLastXOff = 0;
    private int mLastZOff = 0;
    private int clientYHead;
    protected boolean mLiquidEnabled = true;
    protected static final NumberFormatMUI numberFormat = new NumberFormatMUI();

    private static boolean isWater(Block aBlock) {
        return aBlock == Blocks.field_150355_j || aBlock == Blocks.field_150358_i;
    }

    private static boolean isLava(Block aBlock) {
        return aBlock == Blocks.field_150353_l || aBlock == Blocks.field_150356_k;
    }

    private static boolean isFluid(Block aBlock) {
        return MTEConcreteBackfillerBase.isWater(aBlock) || MTEConcreteBackfillerBase.isLava(aBlock) || aBlock instanceof IFluidBlock;
    }

    public MTEConcreteBackfillerBase(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
        this.initRecipeResults();
    }

    public MTEConcreteBackfillerBase(String aName) {
        super(aName);
        this.initRecipeResults();
    }

    private void initRecipeResults() {
        this.addResultMessage(2, true, "backfiller_working");
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74757_a("liquidenabled", this.mLiquidEnabled);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        if (aNBT.func_74764_b("liquidenabled")) {
            this.mLiquidEnabled = aNBT.func_74767_n("liquidenabled");
        }
    }

    protected MultiblockTooltipBuilder createTooltip(String aStructureName) {
        String casings = this.getCasingBlockItem().get(0L, new Object[0]).func_82833_r();
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        int baseCycleTime = this.calculateMaxProgressTime(this.getMinTier(), true);
        tt.addMachineType("Concrete Backfiller").addInfo("Will fill in areas below it with light concrete. This goes through walls").addInfo("Use it to remove any spawning locations beneath your base to reduce lag").addInfo("Will pull back the pipes after it finishes that layer").addInfo("Radius is " + this.getRadius() + " blocks").addInfo("Minimum energy hatch tier: " + GTUtility.getColoredTierNameFromTier((byte)this.getMinTier())).addInfo("Base cycle time: " + (baseCycleTime < 20 ? GTUtility.formatNumbers(baseCycleTime) + " ticks" : GTUtility.formatNumbers((double)baseCycleTime / 20.0) + " seconds")).beginStructureBlock(3, 7, 3, false).addController("Front bottom").addOtherStructurePart(casings, "form the 3x1x3 Base").addOtherStructurePart(casings, "1x3x1 pillar above the center of the base (2 minimum total)").addOtherStructurePart(this.getFrameMaterial().mName + " Frame Boxes", "Each pillar's side and 1x3x1 on top").addEnergyHatch("1x " + GTValues.VN[this.getMinTier()] + "+, Any base casing", 1).addMaintenanceHatch("Any base casing", 1).addInputBus("Mining Pipes, optional, any base casing", 1).addInputHatch("GT Concrete, any base casing", 1).addOutputBus("Mining Pipes, optional, any base casing", 1).toolTipFinisher(new String[0]);
        return tt;
    }

    protected abstract int getRadius();

    @Override
    protected boolean checkHatches() {
        return !this.mMaintenanceHatches.isEmpty() && !this.mInputHatches.isEmpty() && this.mEnergyHatches.size() == 1;
    }

    @Override
    protected List<IHatchElement<? super MTEDrillerBase>> getAllowedHatches() {
        return ImmutableList.of((Object)HatchElement.InputHatch, (Object)HatchElement.InputBus, (Object)HatchElement.OutputBus, (Object)HatchElement.Maintenance, (Object)HatchElement.Energy);
    }

    @Override
    protected void setElectricityStats() {
        this.mEfficiency = this.getCurrentEfficiency(null);
        this.mEfficiencyIncrease = 10000;
        int tier = Math.max(1, GTUtility.getTier(this.getMaxInputVoltage()));
        this.mEUt = -6 * (1 << (tier << 1));
        this.mMaxProgresstime = this.calculateMaxProgressTime(tier);
        this.mMaxProgresstime = Math.max(1, this.mMaxProgresstime);
    }

    @Override
    public int calculateMaxProgressTime(int tier, boolean simulateWorking) {
        return (int)Math.max(1.0, (double)(this.workState == 2 || simulateWorking ? 240 : 80) / Math.pow(2.0, tier));
    }

    @Override
    protected boolean workingUpward(ItemStack aStack, int xDrill, int yDrill, int zDrill, int xPipe, int zPipe, int yHead, int oldYHead) {
        if (this.isRefillableBlock(xPipe, yHead - 1, zPipe)) {
            return this.tryRefillBlock(xPipe, yHead - 1, zPipe);
        }
        int radius = this.getRadius();
        if (this.mLastXOff == 0 && this.mLastZOff == 0) {
            this.mLastXOff = -radius;
            this.mLastZOff = -radius;
        }
        if (yHead != yDrill) {
            for (int i = this.mLastXOff; i <= radius; ++i) {
                int j;
                int n = j = i == this.mLastXOff ? this.mLastZOff : -radius;
                while (j <= radius) {
                    if (this.isRefillableBlock(xPipe + i, yHead, zPipe + j)) {
                        this.mLastXOff = i;
                        this.mLastZOff = j;
                        return this.tryRefillBlock(xPipe + i, yHead, zPipe + j);
                    }
                    ++j;
                }
            }
        }
        if (this.tryPickPipe()) {
            this.mLastXOff = 0;
            this.mLastZOff = 0;
            return true;
        }
        this.workState = 0;
        this.stopMachine(ShutDownReasonRegistry.NONE);
        this.setShutdownReason(StatCollector.func_74838_a((String)"GT5U.gui.text.backfiller_finished"));
        return false;
    }

    private boolean isRefillableBlock(int aX, int aY, int aZ) {
        IGregTechTileEntity aBaseTile = this.getBaseMetaTileEntity();
        Block aBlock = aBaseTile.getBlock(aX, aY, aZ);
        if (!aBlock.isAir((IBlockAccess)aBaseTile.getWorld(), aX, aY, aZ)) {
            if (this.mLiquidEnabled) {
                if (!MTEConcreteBackfillerBase.isFluid(aBlock)) {
                    return false;
                }
            } else {
                return false;
            }
        }
        if (aBlock.func_149688_o().func_76220_a()) {
            return false;
        }
        return GTUtility.setBlockByFakePlayer(this.getFakePlayer(aBaseTile), aX, aY, aZ, GregTechAPI.sBlockConcretes, 8, true);
    }

    private boolean tryRefillBlock(int aX, int aY, int aZ) {
        if (!this.tryConsumeFluid()) {
            this.setRuntimeFailureReason(CheckRecipeResultRegistry.BACKFILLER_NO_CONCRETE);
            return false;
        }
        this.getBaseMetaTileEntity().getWorld().func_147465_d(aX, aY, aZ, GregTechAPI.sBlockConcretes, 8, 3);
        return true;
    }

    private boolean tryConsumeFluid() {
        if (!this.depleteInput(Materials.Concrete.getMolten(144L))) {
            this.mMaxProgresstime = 0;
            return false;
        }
        return true;
    }

    @Override
    protected void drawTexts(DynamicPositionedColumn screenElements, SlotWidget inventorySlot) {
        super.drawTexts(screenElements, inventorySlot);
        ((Column)((Column)screenElements.widget(TextWidget.dynamicString(() -> StatCollector.func_74837_a((String)"GT5U.gui.text.backfiller_current_area", (Object[])new Object[]{numberFormat.format((long)this.clientYHead)})).setSynced(false).setTextAlignment(Alignment.CenterLeft).setEnabled(widget -> this.getBaseMetaTileEntity().isActive() && this.workState == 2))).widget((Widget)new FakeSyncWidget.IntegerSyncer(this::getYHead, newInt -> {
            this.clientYHead = newInt;
        }))).widget((Widget)new FakeSyncWidget.IntegerSyncer(() -> this.workState, newInt -> {
            this.workState = newInt;
        }));
    }

    @Override
    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        super.addUIWidgets(builder, buildContext);
        int BUTTON_Y_LEVEL = 91;
        builder.widget(new LockedWhileActiveButton(this.getBaseMetaTileEntity(), builder).setOnClick((clickData, widget) -> {
            this.mLiquidEnabled = !this.mLiquidEnabled;
        }).setPlayClickSound(true).setBackground(() -> {
            if (this.mLiquidEnabled) {
                return new IDrawable[]{GTUITextures.BUTTON_STANDARD_PRESSED, GTUITextures.OVERLAY_BUTTON_LIQUIDMODE};
            }
            return new IDrawable[]{GTUITextures.BUTTON_STANDARD, GTUITextures.OVERLAY_BUTTON_LIQUIDMODE_OFF};
        }).attachSyncer((FakeSyncWidget)new FakeSyncWidget.BooleanSyncer(() -> this.mLiquidEnabled, newBoolean -> {
            this.mLiquidEnabled = newBoolean;
        }), (IWidgetBuilder)builder, (widget, val) -> widget.notifyTooltipChange()).dynamicTooltip(() -> ImmutableList.of((Object)StatCollector.func_74838_a((String)(this.mLiquidEnabled ? "GT5U.gui.button.liquid_filling_ON" : "GT5U.gui.button.liquid_filling_OFF")))).setTooltipShowUpDelay(5).setPos(new Pos2d(100, 91)).setSize(16, 16));
        int left = 98;
        for (ButtonWidget button : this.getAdditionalButtons(builder, buildContext)) {
            button.setPos(new Pos2d(left, 91)).setSize(16, 16);
            builder.widget((Widget)button);
            left += 18;
        }
    }
}

