/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi;

import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import com.gtnewhorizons.modularui.api.math.Alignment;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.Column;
import com.gtnewhorizons.modularui.common.widget.DynamicPositionedColumn;
import com.gtnewhorizons.modularui.common.widget.FakeSyncWidget;
import com.gtnewhorizons.modularui.common.widget.SlotWidget;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.MTEExtendedPowerMultiBlockBase;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.common.blocks.BlockCasings1;
import gtPlusPlus.core.util.minecraft.FluidUtils;
import gtPlusPlus.xmod.gregtech.api.enums.GregtechItemList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidRegistry;

public class MTECactusWonder
extends MTEExtendedPowerMultiBlockBase<MTECactusWonder>
implements ISurvivalConstructable {
    private int currentSteam;
    private ItemStack currentOffer;
    private long fueledAmount = 0L;
    private static ItemStack[] possibleInputs = new ItemStack[]{GregtechItemList.CactusCharcoal.get(1L, new Object[0]), GregtechItemList.BlockCactusCharcoal.get(1L, new Object[0]), GregtechItemList.CompressedCactusCharcoal.get(1L, new Object[0]), GregtechItemList.DoubleCompressedCactusCharcoal.get(1L, new Object[0]), GregtechItemList.TripleCompressedCactusCharcoal.get(1L, new Object[0]), GregtechItemList.QuadrupleCompressedCactusCharcoal.get(1L, new Object[0]), GregtechItemList.QuintupleCompressedCactusCharcoal.get(1L, new Object[0]), GregtechItemList.CactusCoke.get(1L, new Object[0]), GregtechItemList.BlockCactusCoke.get(1L, new Object[0]), GregtechItemList.CompressedCactusCoke.get(1L, new Object[0]), GregtechItemList.DoubleCompressedCactusCoke.get(1L, new Object[0]), GregtechItemList.TripleCompressedCactusCoke.get(1L, new Object[0]), GregtechItemList.QuadrupleCompressedCactusCoke.get(1L, new Object[0]), GregtechItemList.QuintupleCompressedCactusCoke.get(1L, new Object[0])};
    private static long[] totalValue = new long[]{8000L, 90000L, 1012500L, 11390625L, 128144531L, 1441625977L, 16218292236L, 16000L, 180000L, 2025000L, 22781250L, 256289063L, 2883251953L, 32436584473L};
    private static int[] steamType = new int[]{1, 1, 1, 2, 2, 3, 3, 1, 1, 1, 2, 2, 3, 3};
    private static final String STRUCTURE_PIECE_MAIN = "main";
    private static final String STRUCTURE_PIECE_MAIN_SURVIVAL = "nei";
    private static final String[][] structure = StructureUtility.transpose((String[][])new String[][]{{"         ", "         ", "   CCC   ", "  CCCCC  ", "  CCCCC  ", "  CCCCC  ", "   CCC   ", "         ", "         "}, {"         ", "  E   E  ", " E AAA E ", "  A   A  ", "  A   A  ", "  A   A  ", " E AAA E ", "  E   E  ", "         "}, {"         ", "  E   E  ", " E AAA E ", "  ABBBA  ", "  ABBBA  ", "  ABBBA  ", " E AAA E ", "  E   E  ", "         "}, {"         ", "  E   E  ", " E AAA E ", "  A   A  ", "  A   A  ", "  A   A  ", " E AAA E ", "  E   E  ", "         "}, {"         ", "  E   E  ", " E CCC E ", "  C   C  ", "  C   C  ", "  C   C  ", " E CCC E ", "  E   E  ", "         "}, {" DDD DDD ", "DDFDDDFDD", "DFDCCCDFD", "DDC   CDD", " DC   CD ", "DDC   CDD", "DFDCCCDFD", "DDFDDDFDD", " DDD DDD "}, {"         ", "  E   E  ", " E AAA E ", "  A   A  ", "  A   A  ", "  A   A  ", " E AAA E ", "  E   E  ", "         "}, {"         ", "  E   E  ", " E AAA E ", "  ABBBA  ", "  ABBBA  ", "  ABBBA  ", " E AAA E ", "  E   E  ", "         "}, {"         ", "  E   E  ", " E A~A E ", "  A   A  ", "  A   A  ", "  A   A  ", " E AAA E ", "  E   E  ", "         "}, {"         ", "  E   E  ", " E CCC E ", "  CCCCC  ", "  CCCCC  ", "  CCCCC  ", " E CCC E ", "  E   E  ", "         "}, {"  CCCCC  ", " CFCCCFC ", "CFCCCCCFC", "CCCCCCCCC", "CCCCCCCCC", "CCCCCCCCC", "CFCCCCCFC", " CFCCCFC ", "  CCCCC  "}});
    private static final IStructureDefinition<MTECactusWonder> STRUCTURE_DEFINITION = StructureDefinition.builder().addShape("main", structure).addShape("nei", (String[][])Arrays.stream(structure).map(sa -> (String[])Arrays.stream(sa).map(s -> s.replaceAll("E", " ")).toArray(String[]::new)).toArray(x$0 -> new String[x$0][])).addElement('A', GTStructureUtility.buildHatchAdder(MTECactusWonder.class).atLeast(HatchElement.InputBus, HatchElement.OutputHatch).casingIndex(((BlockCasings1)GregTechAPI.sBlockCasings1).getTextureIndex(10)).dot(1).buildAndChain(StructureUtility.onElementPass(MTECactusWonder::onCasingAdded, (IStructureElement)StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings1, (int)10)))).addElement('B', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings2, (int)12)).addElement('C', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings3, (int)13)).addElement('D', GTStructureUtility.ofFrame(Materials.Breel)).addElement('E', StructureUtility.ofBlock((Block)Blocks.field_150434_aF, (int)0)).addElement('F', StructureUtility.ofBlock((Block)Blocks.field_150354_m, (int)0)).build();
    private int mCasingAmount;

    public MTECactusWonder(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public MTECactusWonder(String aName) {
        super(aName);
    }

    @Override
    protected boolean explodesImmediately() {
        return false;
    }

    @Override
    public IStructureDefinition<MTECactusWonder> getStructureDefinition() {
        return STRUCTURE_DEFINITION;
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTECactusWonder(this.mName);
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity baseMetaTileEntity, ForgeDirection side, ForgeDirection aFacing, int colorIndex, boolean aActive, boolean redstoneLevel) {
        ITexture[] rTexture = side == aFacing ? (aActive ? new ITexture[]{Textures.BlockIcons.getCasingTextureForId(GTUtility.getCasingTextureIndex(GregTechAPI.sBlockCasings1, 10)), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_INDUSTRIAL_EXTRACTOR_ACTIVE).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_INDUSTRIAL_EXTRACTOR_ACTIVE_GLOW).extFacing().glow().build()} : new ITexture[]{Textures.BlockIcons.getCasingTextureForId(GTUtility.getCasingTextureIndex(GregTechAPI.sBlockCasings1, 10)), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_INDUSTRIAL_EXTRACTOR).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_INDUSTRIAL_EXTRACTOR_GLOW).extFacing().glow().build()}) : new ITexture[]{Textures.BlockIcons.getCasingTextureForId(GTUtility.getCasingTextureIndex(GregTechAPI.sBlockCasings1, 10))};
        return rTexture;
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType("Temple of Cacti Blessing").addInfo("Burns Cactus Coke and Charcoal for increasingly efficient amounts of steam.").addInfo("Every second the cactus wonder will consume all offers stored").addInfo("The god of cacti will save their value and return it as steam blessings to her faithful zealots.").addInfo("Can only take one type of offer at once.").addInfo(EnumChatFormatting.AQUA + "" + EnumChatFormatting.ITALIC + "Cactus").toolTipFinisher(new String[0]);
        return tt;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(STRUCTURE_PIECE_MAIN, stackSize, hintsOnly, 4, 8, 2);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivialBuildPiece(STRUCTURE_PIECE_MAIN_SURVIVAL, stackSize, 4, 8, 2, elementBudget, env, false, true);
    }

    private void onCasingAdded() {
        ++this.mCasingAmount;
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        if (!this.checkPiece(STRUCTURE_PIECE_MAIN, 4, 8, 2)) {
            return false;
        }
        return this.mCasingAmount >= 15;
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (aTick % 20L == 0L) {
            this.addFuel();
        }
        this.outputSteam();
    }

    private void addFuel() {
        ArrayList<ItemStack> storedInputs = this.getStoredInputs();
        for (ItemStack stack : storedInputs) {
            for (int i = 0; i < 14; ++i) {
                if (!stack.func_77969_a(possibleInputs[i])) continue;
                if (this.currentOffer == null) {
                    this.currentOffer = stack;
                    this.fueledAmount += totalValue[i] * (long)stack.field_77994_a;
                    this.currentSteam = steamType[i];
                    this.depleteInput(stack);
                    continue;
                }
                if (!stack.func_77969_a(this.currentOffer)) continue;
                this.fueledAmount += totalValue[i] * (long)stack.field_77994_a;
                this.depleteInput(stack);
            }
        }
    }

    private void outputSteam() {
        if (this.fueledAmount > 0L) {
            if (this.currentSteam == 1) {
                this.addOutput(FluidUtils.getSteam((int)Math.min(3200L, this.fueledAmount)));
                this.fueledAmount -= (long)((int)Math.min(3200L, this.fueledAmount));
            } else if (this.currentSteam == 2) {
                this.addOutput(FluidUtils.getSuperHeatedSteam((int)Math.min(6400L, this.fueledAmount)));
                this.fueledAmount -= (long)((int)Math.min(6400L, this.fueledAmount));
            } else if (this.currentSteam == 3) {
                this.addOutput(FluidRegistry.getFluidStack((String)"supercriticalsteam", (int)((int)Math.min(12800L, this.fueledAmount))));
                this.fueledAmount -= (long)((int)Math.min(12800L, this.fueledAmount));
            }
            if (this.fueledAmount <= 0L) {
                this.fueledAmount = 0L;
                this.currentOffer = null;
            }
        }
    }

    @Override
    protected void drawTexts(DynamicPositionedColumn screenElements, SlotWidget inventorySlot) {
        super.drawTexts(screenElements, inventorySlot);
        ((Column)screenElements.widget((Widget)new TextWidget().setStringSupplier(() -> EnumChatFormatting.WHITE + "Offer Value: " + EnumChatFormatting.YELLOW + this.numberFormat.format(this.fueledAmount)).setTextAlignment(Alignment.CenterLeft))).widget((Widget)new FakeSyncWidget.LongSyncer(() -> this.fueledAmount, val -> {
            this.fueledAmount = val;
        }));
    }

    @Override
    public void getWailaNBTData(EntityPlayerMP player, TileEntity tile, NBTTagCompound tag, World world, int x, int y, int z) {
        super.getWailaNBTData(player, tile, tag, world, x, y, z);
    }

    @Override
    public void getWailaBody(ItemStack itemStack, List<String> currentTip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.getWailaBody(itemStack, currentTip, accessor, config);
        NBTTagCompound tag = accessor.getNBTData();
    }

    @Override
    public RecipeMap<?> getRecipeMap() {
        return RecipeMaps.cactusWonderFakeRecipes;
    }

    @Override
    public int getRecipeCatalystPriority() {
        return -10;
    }

    @Override
    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    @Override
    public boolean supportsVoidProtection() {
        return true;
    }

    @Override
    public boolean supportsBatchMode() {
        return true;
    }

    @Override
    public boolean supportsInputSeparation() {
        return true;
    }

    @Override
    public boolean supportsSingleRecipeLocking() {
        return true;
    }

    @Override
    public boolean getDefaultHasMaintenanceChecks() {
        return false;
    }
}

