/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.boilers;

import com.cleanroommc.modularui.api.value.IDoubleValue;
import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.factory.PosGuiData;
import com.cleanroommc.modularui.screen.ModularPanel;
import com.cleanroommc.modularui.utils.Alignment;
import com.cleanroommc.modularui.utils.fluid.FluidStackTank;
import com.cleanroommc.modularui.utils.item.IItemHandler;
import com.cleanroommc.modularui.value.sync.DoubleSyncValue;
import com.cleanroommc.modularui.value.sync.FluidSlotSyncHandler;
import com.cleanroommc.modularui.value.sync.PanelSyncManager;
import com.cleanroommc.modularui.widget.Widget;
import com.cleanroommc.modularui.widgets.FluidSlot;
import com.cleanroommc.modularui.widgets.ItemSlot;
import com.cleanroommc.modularui.widgets.ProgressWidget;
import com.cleanroommc.modularui.widgets.layout.Flow;
import com.cleanroommc.modularui.widgets.slot.ModularSlot;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.drawable.UITexture;
import com.gtnewhorizons.modularui.api.forge.IItemHandlerModifiable;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.common.widget.DrawableWidget;
import com.gtnewhorizons.modularui.common.widget.ProgressBar;
import com.gtnewhorizons.modularui.common.widget.SlotWidget;
import gregtech.GTMod;
import gregtech.api.covers.CoverRegistry;
import gregtech.api.enums.Materials;
import gregtech.api.enums.ParticleFX;
import gregtech.api.enums.SoundResource;
import gregtech.api.enums.SteamVariant;
import gregtech.api.gui.modularui.GTUITextures;
import gregtech.api.gui.modularui.GUITextureSet;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.modularui.IAddUIWidgets;
import gregtech.api.interfaces.modularui.IGetTitleColor;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.MTEBasicTank;
import gregtech.api.modularui2.GTGuiTheme;
import gregtech.api.modularui2.GTGuis;
import gregtech.api.objects.XSTR;
import gregtech.api.util.GTLog;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTUtility;
import gregtech.api.util.WorldSpawnedEventBuilder;
import gregtech.common.modularui2.widget.GTProgressWidget;
import gregtech.common.pollution.Pollution;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;
import org.jetbrains.annotations.NotNull;

public abstract class MTEBoiler
extends MTEBasicTank
implements IGetTitleColor,
IAddUIWidgets {
    public static final byte SOUND_EVENT_LET_OFF_EXCESS_STEAM = 1;
    public int mTemperature = 20;
    public int mProcessingEnergy = 0;
    public int mLossTimer = 0;
    public FluidStack mSteam = null;
    protected final FluidStackTank steamTank = new FluidStackTank(() -> this.mSteam, fluidStack -> {
        this.mSteam = fluidStack;
    }, this::getSteamCapacity);
    public boolean mHadNoWater = false;
    private int mExcessWater = 0;

    public MTEBoiler(int aID, String aName, String aNameRegional, String aDescription, ITexture ... aTextures) {
        super(aID, aName, aNameRegional, 0, 4, aDescription, aTextures);
    }

    public MTEBoiler(int aID, String aName, String aNameRegional, String[] aDescription, ITexture ... aTextures) {
        super(aID, aName, aNameRegional, 0, 4, aDescription, aTextures);
    }

    public MTEBoiler(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 4, aDescription, aTextures);
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity baseMetaTileEntity, ForgeDirection sideDirection, ForgeDirection facingDirection, int colorIndex, boolean active, boolean redstoneLevel) {
        ITexture[] tmp = (sideDirection.flag & (ForgeDirection.UP.flag | ForgeDirection.DOWN.flag)) == 0 ? (sideDirection != facingDirection ? this.mTextures[2][colorIndex + 1] : this.mTextures[(byte)(active ? 4 : 3)][colorIndex + 1]) : this.mTextures[sideDirection.ordinal()][colorIndex + 1];
        if (sideDirection != facingDirection && tmp.length == 2) {
            tmp = new ITexture[]{tmp[0]};
        }
        return tmp;
    }

    @Override
    public boolean isElectric() {
        return false;
    }

    @Override
    public boolean isFacingValid(ForgeDirection facingDirection) {
        return (facingDirection.flag & (ForgeDirection.UP.flag | ForgeDirection.DOWN.flag)) == 0;
    }

    @Override
    public boolean isAccessAllowed(EntityPlayer aPlayer) {
        return true;
    }

    @Override
    public boolean isValidSlot(int aIndex) {
        return true;
    }

    @Override
    public int getProgresstime() {
        return this.mTemperature;
    }

    @Override
    public int maxProgresstime() {
        return 500;
    }

    @Override
    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        if (aBaseMetaTileEntity.isClientSide()) {
            return true;
        }
        if (aPlayer != null) {
            if (GTUtility.areStacksEqual(aPlayer.func_71045_bC(), new ItemStack(Items.field_151131_as, 1))) {
                this.fill(Materials.Water.getFluid(1000L * (long)aPlayer.func_71045_bC().field_77994_a), true);
                if (!aPlayer.field_71075_bZ.field_75098_d) {
                    aPlayer.func_71045_bC().func_150996_a(Items.field_151133_ar);
                }
            } else {
                this.openGui(aPlayer);
            }
        }
        return true;
    }

    @Override
    public boolean doesFillContainers() {
        return true;
    }

    @Override
    public boolean doesEmptyContainers() {
        return true;
    }

    @Override
    public boolean canTankBeFilled() {
        return true;
    }

    @Override
    public boolean canTankBeEmptied() {
        return true;
    }

    @Override
    public boolean isFluidInputAllowed(FluidStack aFluid) {
        return GTModHandler.isWater(aFluid);
    }

    @Override
    public FluidStack getDrainableStack() {
        return this.mSteam;
    }

    @Override
    public FluidStack setDrainableStack(FluidStack aFluid) {
        this.mSteam = aFluid;
        return this.mSteam;
    }

    @Override
    public boolean isDrainableStackSeparate() {
        return true;
    }

    @Override
    public boolean allowCoverOnSide(ForgeDirection side, ItemStack coverItem) {
        return CoverRegistry.getCoverPlacer(coverItem).allowOnPrimitiveBlock();
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74768_a("mLossTimer", this.mLossTimer);
        aNBT.func_74768_a("mTemperature", this.mTemperature);
        aNBT.func_74768_a("mProcessingEnergy", this.mProcessingEnergy);
        aNBT.func_74768_a("mExcessWater", this.mExcessWater);
        if (this.mSteam != null) {
            aNBT.func_74782_a("mSteam", (NBTBase)this.mSteam.writeToNBT(new NBTTagCompound()));
        }
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.mLossTimer = aNBT.func_74762_e("mLossTimer");
        this.mTemperature = aNBT.func_74762_e("mTemperature");
        this.mProcessingEnergy = aNBT.func_74762_e("mProcessingEnergy");
        this.mExcessWater = aNBT.func_74762_e("mExcessWater");
        this.mSteam = FluidStack.loadFluidStackFromNBT((NBTTagCompound)aNBT.func_74775_l("mSteam"));
    }

    protected void produceSteam(int aAmount) {
        this.mExcessWater -= aAmount;
        if (this.mExcessWater < 0) {
            int tWaterToConsume = -this.mExcessWater / 160;
            this.mFluid.amount -= tWaterToConsume;
            this.mExcessWater += 160 * tWaterToConsume;
        }
        if (GTModHandler.isSteam(this.mSteam)) {
            this.mSteam.amount += aAmount;
        } else {
            this.mSteam = GTModHandler.getSteam(aAmount);
        }
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        this.pollute(aTick);
        if (this.isNotAllowedToWork(aBaseMetaTileEntity, aTick)) {
            return;
        }
        this.calculateCooldown();
        this.pushSteamToInventories(aBaseMetaTileEntity);
        if (this.canNotCreateSteam(aBaseMetaTileEntity, aTick)) {
            this.pollute(aTick);
            return;
        }
        this.ventSteamIfTankIsFull();
        this.updateFuelTimed(aBaseMetaTileEntity, aTick);
        this.calculateHeatUp(aBaseMetaTileEntity, aTick);
    }

    private boolean isNotAllowedToWork(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        return !aBaseMetaTileEntity.isServerSide() || aTick <= 20L;
    }

    private void pollute(long aTick) {
        if (this.mProcessingEnergy > 0 && aTick % 20L == 0L) {
            Pollution.addPollution(this.getBaseMetaTileEntity(), this.getPollution());
        }
    }

    private void calculateHeatUp(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (this.mTemperature < this.getMaxTemperature() && this.mProcessingEnergy > 0 && aTick % (long)this.getHeatUpRate() == 0L) {
            this.mProcessingEnergy -= this.getEnergyConsumption();
            this.mTemperature += this.getHeatUpAmount();
        }
        aBaseMetaTileEntity.setActive(this.mProcessingEnergy > 0);
    }

    private void updateFuelTimed(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (this.mProcessingEnergy <= 0 && aBaseMetaTileEntity.isAllowedToWork()) {
            this.updateFuel(aBaseMetaTileEntity, aTick);
        }
    }

    protected void ventSteamIfTankIsFull() {
        if (this.mSteam != null && this.mSteam.amount > this.getSteamCapacity()) {
            this.sendSound((byte)1);
            this.mSteam.amount = this.getSteamCapacity() * 3 / 4;
        }
    }

    private boolean canNotCreateSteam(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aTick % 10L != 0L) {
            return false;
        }
        if (this.mTemperature > 100) {
            if (!GTModHandler.isWater(this.mFluid) || this.mFluid.amount <= 0) {
                this.mHadNoWater = true;
            } else {
                if (this.mHadNoWater) {
                    GTLog.exp.println("Boiler " + this.mName + " had no Water!");
                    this.onDangerousWaterLack(aBaseMetaTileEntity, aTick);
                    return true;
                }
                this.produceSteam(this.getProductionPerSecond() / 2);
            }
        } else {
            this.mHadNoWater = false;
        }
        return false;
    }

    protected void onDangerousWaterLack(IGregTechTileEntity tile, long ignoredTicks) {
        tile.doExplosion(2048L);
    }

    protected final void pushSteamToSide(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side) {
        if (this.mSteam == null || this.mSteam.amount == 0) {
            return;
        }
        IFluidHandler tTileEntity = aBaseMetaTileEntity.getITankContainerAtSide(side);
        if (tTileEntity == null) {
            return;
        }
        GTUtility.moveFluid(aBaseMetaTileEntity, tTileEntity, side, Math.max(1, this.mSteam.amount / 2), null);
    }

    protected void pushSteamToInventories(IGregTechTileEntity aBaseMetaTileEntity) {
        if (this.mSteam == null || this.mSteam.amount == 0) {
            return;
        }
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            if (direction == aBaseMetaTileEntity.getFrontFacing() || direction == ForgeDirection.DOWN) continue;
            if (this.mSteam == null) break;
            this.pushSteamToSide(aBaseMetaTileEntity, direction);
        }
    }

    private void calculateCooldown() {
        if (this.mTemperature <= 20) {
            this.mTemperature = 20;
            this.mLossTimer = 0;
        } else if (++this.mLossTimer > this.getCooldownInterval()) {
            --this.mTemperature;
            this.mLossTimer = 0;
        }
    }

    protected boolean isAutomatable() {
        return GTMod.gregtechproxy.mAllowSmallBoilerAutomation;
    }

    @Override
    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return this.isAutomatable() && aIndex == 1 || aIndex == 3;
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return this.isAutomatable() && aIndex == 0 && this.isValidFluidInputSlotItem(aStack) || aIndex == 2 && this.isItemValidFuel(aStack);
    }

    @Override
    public void doSound(byte aIndex, double aX, double aY, double aZ) {
        if (aIndex == 1) {
            GTUtility.doSoundAtClient(SoundResource.RANDOM_FIZZ, 2, 1.0f, aX, aY, aZ);
            ((WorldSpawnedEventBuilder.ParticleEventBuilder)new WorldSpawnedEventBuilder.ParticleEventBuilder().setIdentifier((Enum)ParticleFX.CLOUD)).setWorld(this.getBaseMetaTileEntity().getWorld()).setMotion(0.0, 0.0, 0.0).times(8, x -> x.setPosition(aX - 0.5 + (double)XSTR.XSTR_INSTANCE.nextFloat(), aY, aZ - 0.5 + (double)XSTR.XSTR_INSTANCE.nextFloat()).run());
        }
    }

    protected abstract int getPollution();

    @Override
    public int getCapacity() {
        return 16000;
    }

    protected int getSteamCapacity() {
        return this.getCapacity();
    }

    protected abstract int getProductionPerSecond();

    protected abstract int getMaxTemperature();

    protected abstract int getEnergyConsumption();

    protected abstract int getCooldownInterval();

    protected int getHeatUpRate() {
        return 12;
    }

    protected int getHeatUpAmount() {
        return 1;
    }

    protected abstract void updateFuel(IGregTechTileEntity var1, long var2);

    @Override
    protected boolean useMui2() {
        return true;
    }

    @Override
    protected abstract GTGuiTheme getGuiTheme();

    @Override
    public ModularPanel buildUI(PosGuiData data, PanelSyncManager syncManager) {
        syncManager.registerSlotGroup("item_inv", 0);
        IWidget waterSlots = (IWidget)((Flow)((Flow)((Flow)Flow.column().coverChildren()).child((IWidget)new ItemSlot().slot(new ModularSlot((IItemHandler)this.inventoryHandler, 0).slotGroup("item_inv").filter(this::isValidFluidInputSlotItem)).widgetTheme("overlayItemSlotIn"))).child((IWidget)new Widget().widgetTheme("pictureCanister").size(18))).child((IWidget)new ItemSlot().slot(new ModularSlot((IItemHandler)this.inventoryHandler, 1).slotGroup("item_inv").accessibility(false, true)).widgetTheme("overlayItemSlotOut"));
        IWidget indicators = (IWidget)((Flow)((Flow)((Flow)Flow.row().coverChildren()).crossAxisAlignment(Alignment.CrossAxis.CENTER).childPadding(3).child((IWidget)new FluidSlot().syncHandler(new FluidSlotSyncHandler((IFluidTank)this.steamTank).canDrainSlot(false).canFillSlot(false).controlsAmount(false)).alwaysShowFull(false).size(10, 54))).child((IWidget)new FluidSlot().syncHandler(new FluidSlotSyncHandler((IFluidTank)this.fluidTank).canDrainSlot(false).canFillSlot(false).controlsAmount(false)).alwaysShowFull(false).size(10, 54))).child((IWidget)((ProgressWidget)new GTProgressWidget().value((IDoubleValue)new DoubleSyncValue(() -> (float)this.mTemperature / (float)this.maxProgresstime())).direction(ProgressWidget.Direction.UP).widgetTheme("progressbarBoilerHeat")).size(10, 54));
        IWidget fuelSlots = (IWidget)((Flow)((Flow)((Flow)Flow.column().coverChildren()).childIf(this.doesAddAshSlot(), this.createAshSlot())).child((IWidget)((ProgressWidget)((ProgressWidget)new GTProgressWidget().value((IDoubleValue)new DoubleSyncValue(() -> this.mProcessingEnergy > 0 ? (double)Math.max((float)this.mProcessingEnergy / 1000.0f, 0.2f) : 0.0)).direction(ProgressWidget.Direction.UP).widgetTheme("progressbarFuel")).size(14)).margin(2))).childIf(this.doesAddFuelSlot(), this.createFuelSlot());
        return (ModularPanel)GTGuis.mteTemplatePanelBuilder(this, data, syncManager).build().child((IWidget)((Flow)((Flow)((Flow)((Flow)((Flow)Flow.row().alignX(0.5f)).top(25)).coverChildren()).childPadding(9).child(waterSlots)).child(indicators)).child(fuelSlots));
    }

    protected boolean doesAddFuelSlot() {
        return true;
    }

    protected Widget<?> createFuelSlot() {
        return new ItemSlot().slot(new ModularSlot((IItemHandler)this.inventoryHandler, 2).slotGroup("item_inv").filter(this::isItemValidFuel)).widgetTheme("overlayItemSlotCoal");
    }

    protected boolean doesAddAshSlot() {
        return true;
    }

    protected Widget<?> createAshSlot() {
        return new ItemSlot().slot(new ModularSlot((IItemHandler)this.inventoryHandler, 3).slotGroup("item_inv").accessibility(false, true)).widgetTheme("overlayItemSlotDust");
    }

    @Override
    public SteamVariant getSteamVariant() {
        return SteamVariant.BRONZE;
    }

    protected IDrawable[] getFuelSlotBackground() {
        return new IDrawable[]{this.getGUITextureSet().getItemSlot(), GTUITextures.OVERLAY_SLOT_COAL_STEAM.get(this.getSteamVariant())};
    }

    protected IDrawable[] getAshSlotBackground() {
        return new IDrawable[]{this.getGUITextureSet().getItemSlot(), GTUITextures.OVERLAY_SLOT_DUST_STEAM.get(this.getSteamVariant())};
    }

    @Override
    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        ((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(new SlotWidget((IItemHandlerModifiable)this.inventoryHandler, 0).setFilter(this::isValidFluidInputSlotItem).setPos(43, 25).setBackground(new IDrawable[]{this.getGUITextureSet().getItemSlot(), this.getOverlaySlotIn()}))).widget(new SlotWidget((IItemHandlerModifiable)this.inventoryHandler, 1).setAccess(true, false).setPos(43, 61).setBackground(new IDrawable[]{this.getGUITextureSet().getItemSlot(), this.getOverlaySlotOut()}))).widget(this.createFuelSlotMui1())).widget((com.gtnewhorizons.modularui.api.widget.Widget)this.createAshSlotMui1())).widget(new ProgressBar().setProgress(() -> Float.valueOf(this.mSteam == null ? 0.0f : (float)this.mSteam.amount / (float)this.getSteamCapacity())).setTexture(this.getProgressbarEmpty(), GTUITextures.PROGRESSBAR_BOILER_STEAM, 10).setDirection(ProgressBar.Direction.UP).setPos(70, 25).setSize(10, 54))).widget(new ProgressBar().setProgress(() -> Float.valueOf(this.mFluid == null ? 0.0f : (float)this.mFluid.amount / (float)this.getCapacity())).setTexture(this.getProgressbarEmpty(), GTUITextures.PROGRESSBAR_BOILER_WATER, 10).setDirection(ProgressBar.Direction.UP).setPos(83, 25).setSize(10, 54))).widget(new ProgressBar().setProgress(() -> Float.valueOf((float)this.mTemperature / (float)this.maxProgresstime())).setTexture(this.getProgressbarEmpty(), GTUITextures.PROGRESSBAR_BOILER_HEAT, 10).setDirection(ProgressBar.Direction.UP).setPos(96, 25).setSize(10, 54))).widget(new ProgressBar().setProgress(() -> Float.valueOf(this.mProcessingEnergy > 0 ? Math.max((float)this.mProcessingEnergy / 1000.0f, 0.2f) : 0.0f)).setTexture(this.getProgressbarFuel(), 14).setDirection(ProgressBar.Direction.UP).setPos(116, 45).setSize(14, 14))).widget(new DrawableWidget().setDrawable(this.getOverlaySlotCanister()).setPos(43, 43).setSize(18, 18));
    }

    private boolean isValidFluidInputSlotItem(@NotNull ItemStack stack) {
        return GTUtility.fillFluidContainer(GTModHandler.getSteam(this.getSteamCapacity()), stack, false, true) != null || this.isFluidInputAllowed(GTUtility.getFluidForFilledItem(stack, true));
    }

    protected com.gtnewhorizons.modularui.api.widget.Widget createFuelSlotMui1() {
        return new SlotWidget((IItemHandlerModifiable)this.inventoryHandler, 2).setFilter(this::isItemValidFuel).setPos(115, 61).setBackground(this.getFuelSlotBackground());
    }

    protected boolean isItemValidFuel(@NotNull ItemStack stack) {
        return true;
    }

    protected SlotWidget createAshSlotMui1() {
        return (SlotWidget)new SlotWidget((IItemHandlerModifiable)this.inventoryHandler, 3).setAccess(true, false).setPos(115, 25).setBackground(this.getAshSlotBackground());
    }

    @Override
    public GUITextureSet getGUITextureSet() {
        return GUITextureSet.STEAM.apply(this.getSteamVariant());
    }

    @Override
    public int getTitleColor() {
        return this.getSteamVariant() == SteamVariant.BRONZE ? (Integer)this.COLOR_TITLE.get() : (Integer)this.COLOR_TITLE_WHITE.get();
    }

    protected IDrawable getOverlaySlotIn() {
        return GTUITextures.OVERLAY_SLOT_IN_STEAM.get(this.getSteamVariant());
    }

    protected IDrawable getOverlaySlotOut() {
        return GTUITextures.OVERLAY_SLOT_OUT_STEAM.get(this.getSteamVariant());
    }

    protected IDrawable getOverlaySlotCanister() {
        return GTUITextures.OVERLAY_SLOT_CANISTER_STEAM.get(this.getSteamVariant());
    }

    protected UITexture getProgressbarEmpty() {
        return GTUITextures.PROGRESSBAR_BOILER_EMPTY_STEAM.get(this.getSteamVariant());
    }

    protected UITexture getProgressbarFuel() {
        return GTUITextures.PROGRESSBAR_FUEL_STEAM.get(this.getSteamVariant());
    }
}

