/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.render;

import gregtech.GTMod;
import gregtech.api.enums.Dyes;
import gregtech.api.enums.GTValues;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.ITextureBuilder;
import gregtech.common.render.GTCopiedBlockTextureRender;
import gregtech.common.render.GTCopiedCTMBlockTexture;
import gregtech.common.render.GTMultiTextureRender;
import gregtech.common.render.GTRenderedTexture;
import gregtech.common.render.GTSidedTextureRender;
import gregtech.common.render.GTTextureBase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraftforge.common.util.ForgeDirection;

public class GTTextureBuilder
implements ITextureBuilder {
    private final List<IIconContainer> iconContainerList;
    private final List<ITexture> textureLayers = new ArrayList<ITexture>();
    private Block fromBlock;
    private int fromMeta;
    private ForgeDirection fromSide;
    private short[] rgba;
    private boolean allowAlpha;
    private boolean stdOrient;
    private boolean extFacing;
    private boolean glow;
    private Block matBlock;
    private int matMeta;
    private Boolean worldCoord = null;

    public GTTextureBuilder() {
        this.iconContainerList = new ArrayList<IIconContainer>();
        this.rgba = Dyes._NULL.mRGBa;
        this.allowAlpha = true;
        this.stdOrient = false;
        this.glow = false;
    }

    @Override
    public ITextureBuilder setFromBlock(Block block, int meta) {
        this.fromBlock = block;
        this.fromMeta = meta;
        this.fromSide = ForgeDirection.UNKNOWN;
        return this;
    }

    @Override
    public ITextureBuilder setFromSide(ForgeDirection side) {
        this.fromSide = side;
        return this;
    }

    @Override
    public ITextureBuilder addIcon(IIconContainer ... iconContainers) {
        this.iconContainerList.addAll(Arrays.asList(iconContainers));
        return this;
    }

    @Override
    public ITextureBuilder setRGBA(short[] rgba) {
        this.rgba = rgba;
        return this;
    }

    @Override
    public ITextureBuilder addLayer(ITexture ... iTextures) {
        this.textureLayers.addAll(Arrays.asList(iTextures));
        return this;
    }

    @Override
    public ITextureBuilder setAllowAlpha(boolean allowAlpha) {
        this.allowAlpha = allowAlpha;
        return this;
    }

    @Override
    public ITextureBuilder stdOrient() {
        this.stdOrient = true;
        return this;
    }

    @Override
    public ITextureBuilder useWorldCoord() {
        this.worldCoord = true;
        return this;
    }

    @Override
    public ITextureBuilder noWorldCoord() {
        this.worldCoord = false;
        return this;
    }

    @Override
    public ITextureBuilder extFacing() {
        this.extFacing = true;
        return this;
    }

    @Override
    public ITextureBuilder glow() {
        this.glow = true;
        return this;
    }

    @Override
    public ITextureBuilder material(Block block, int meta) {
        this.matBlock = block;
        this.matMeta = meta;
        return this;
    }

    @Override
    public ITexture build() {
        GTTextureBase gTTextureBase;
        if (this.fromBlock != null) {
            if (this.worldCoord == Boolean.TRUE || this.worldCoord == null && this.isCTMBlock(this.fromBlock, this.fromMeta)) {
                return new GTCopiedCTMBlockTexture(this.fromBlock, this.fromSide.ordinal(), this.fromMeta, this.rgba, this.allowAlpha);
            }
            return new GTCopiedBlockTextureRender(this.fromBlock, this.fromSide.ordinal(), this.fromMeta, this.rgba, this.allowAlpha);
        }
        if (this.worldCoord != null) {
            throw new IllegalStateException("worldCoord without from block");
        }
        if (!this.textureLayers.isEmpty()) {
            return new GTMultiTextureRender(this.textureLayers.toArray(new ITexture[0]));
        }
        switch (this.iconContainerList.size()) {
            case 1: {
                gTTextureBase = new GTRenderedTexture(this.iconContainerList.get(0), this.rgba, this.allowAlpha, this.glow, this.stdOrient, this.extFacing, this.matBlock, this.matMeta);
                break;
            }
            case 6: {
                gTTextureBase = new GTSidedTextureRender(this.iconContainerList.get(ForgeDirection.DOWN.ordinal()), this.iconContainerList.get(ForgeDirection.UP.ordinal()), this.iconContainerList.get(ForgeDirection.NORTH.ordinal()), this.iconContainerList.get(ForgeDirection.SOUTH.ordinal()), this.iconContainerList.get(ForgeDirection.WEST.ordinal()), this.iconContainerList.get(ForgeDirection.EAST.ordinal()), this.rgba, this.allowAlpha);
                break;
            }
            default: {
                throw new IllegalStateException("Invalid sideIconContainer count");
            }
        }
        return gTTextureBase;
    }

    private boolean isCTMBlock(Block fromBlock, int fromMeta) {
        return GTMod.gregtechproxy.mCTMBlockCache.computeIfAbsent(fromBlock, fromMeta, GTTextureBuilder::apply);
    }

    private static Boolean apply(Block b, int m) {
        for (Class<?> clazz = b.getClass(); clazz != Block.class; clazz = clazz.getSuperclass()) {
            String className = clazz.getName();
            if (GTValues.mCTMDisabledBlock.contains(className)) {
                return false;
            }
            if (!GTValues.mCTMEnabledBlock.contains(className)) continue;
            return true;
        }
        return false;
    }
}

