/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.pollution;

import com.gtnewhorizon.gtnhlib.config.Config;

@Config(modid="gregtech", category="Pollution", configSubDirectory="GregTech", filename="Pollution")
public class PollutionConfig {
    @Config.Name(value="Activate Pollution")
    @Config.Comment(value={"if true, enables pollution in the game."})
    @Config.DefaultBoolean(value=true)
    @Config.RequiresMcRestart
    public static boolean pollution;
    @Config.Comment(value={"Controls the threshold starting from which you can see fog."})
    @Config.DefaultInt(value=550000)
    @Config.RequiresMcRestart
    public static int pollutionSmogLimit;
    @Config.Comment(value={"Controls the threshold starting from which players get poison effect."})
    @Config.DefaultInt(value=750000)
    @Config.RequiresMcRestart
    public static int pollutionPoisonLimit;
    @Config.Comment(value={"Controls the threshold starting from which vegetation starts to be killed."})
    @Config.DefaultInt(value=1000000)
    @Config.RequiresMcRestart
    public static int pollutionVegetationLimit;
    @Config.Comment(value={"Controls the threshold starting from which if it rains, will turn cobblestone into gravel and gravel into sand."})
    @Config.DefaultInt(value=2000000)
    @Config.RequiresMcRestart
    public static int pollutionSourRainLimit;
    @Config.Comment(value={"Controls the pollution released by an explosion."})
    @Config.DefaultInt(value=100000)
    @Config.RequiresMcRestart
    public static int pollutionOnExplosion;
    @Config.Comment(value={"Controls the pollution released per second by the bricked blast furnace."})
    @Config.DefaultInt(value=200)
    @Config.RequiresMcRestart
    public static int pollutionPrimitveBlastFurnacePerSecond;
    @Config.Comment(value={"Controls the pollution released per second by the charcoal pile igniter."})
    @Config.DefaultInt(value=100)
    @Config.RequiresMcRestart
    public static int pollutionCharcoalPitPerSecond;
    @Config.Comment(value={"Controls the pollution released per second by the EBF."})
    @Config.DefaultInt(value=400)
    @Config.RequiresMcRestart
    public static int pollutionEBFPerSecond;
    @Config.Comment(value={"Controls the pollution released per second by the large combustion engine."})
    @Config.DefaultInt(value=480)
    @Config.RequiresMcRestart
    public static int pollutionLargeCombustionEnginePerSecond;
    @Config.Comment(value={"Controls the pollution released per second by the extreme combustion engine."})
    @Config.DefaultInt(value=3840)
    @Config.RequiresMcRestart
    public static int pollutionExtremeCombustionEnginePerSecond;
    @Config.Comment(value={"Controls the pollution released per second by the implosion compressor."})
    @Config.DefaultInt(value=10000)
    @Config.RequiresMcRestart
    public static int pollutionImplosionCompressorPerSecond;
    @Config.Comment(value={"Controls the pollution released per second by the large bronze boiler."})
    @Config.DefaultInt(value=200)
    @Config.RequiresMcRestart
    public static int pollutionLargeBronzeBoilerPerSecond;
    @Config.Comment(value={"Controls the pollution released per second by the large steel boiler."})
    @Config.DefaultInt(value=400)
    @Config.RequiresMcRestart
    public static int pollutionLargeSteelBoilerPerSecond;
    @Config.Comment(value={"Controls the pollution released per second by the large titanium boiler."})
    @Config.DefaultInt(value=800)
    @Config.RequiresMcRestart
    public static int pollutionLargeTitaniumBoilerPerSecond;
    @Config.Comment(value={"Controls the pollution released per second by the large tungstensteel boiler."})
    @Config.DefaultInt(value=1600)
    @Config.RequiresMcRestart
    public static int pollutionLargeTungstenSteelBoilerPerSecond;
    @Config.Comment(value={"Controls the pollution reduction obtained with each increment of the circuit when throttling large boilers."})
    @Config.DefaultFloat(value=0.041666668f)
    @Config.RequiresMcRestart
    public static float pollutionReleasedByThrottle;
    @Config.Comment(value={"Controls the pollution released per second by the large gas turbine."})
    @Config.DefaultInt(value=300)
    @Config.RequiresMcRestart
    public static int pollutionLargeGasTurbinePerSecond;
    @Config.Comment(value={"Controls the pollution released per second by the multi smelter."})
    @Config.DefaultInt(value=400)
    @Config.RequiresMcRestart
    public static int pollutionMultiSmelterPerSecond;
    @Config.Comment(value={"Controls the pollution released per second by the pyrolyse oven."})
    @Config.DefaultInt(value=300)
    @Config.RequiresMcRestart
    public static int pollutionPyrolyseOvenPerSecond;
    @Config.Comment(value={"Controls the pollution released per second by the small coil boiler."})
    @Config.DefaultInt(value=20)
    @Config.RequiresMcRestart
    public static int pollutionSmallCoalBoilerPerSecond;
    @Config.Comment(value={"Controls the pollution released per second by the high pressure lava boiler."})
    @Config.DefaultInt(value=20)
    @Config.RequiresMcRestart
    public static int pollutionHighPressureLavaBoilerPerSecond;
    @Config.Comment(value={"Controls the pollution released per second by the high pressure coil boiler."})
    @Config.DefaultInt(value=30)
    @Config.RequiresMcRestart
    public static int pollutionHighPressureCoalBoilerPerSecond;
    @Config.Comment(value={"Controls the pollution released per second by the base diesel generator."})
    @Config.DefaultInt(value=40)
    @Config.RequiresMcRestart
    public static int pollutionBaseDieselGeneratorPerSecond;
    @Config.Comment(value={"Pollution released by tier, with the following formula: PollutionBaseDieselGeneratorPerSecond * PollutionDieselGeneratorReleasedByTier[Tier]", "The first entry has meaning as it is here to since machine tier with array index: LV is 1, etc."})
    @Config.DefaultDoubleList(value={0.1, 1.0, 0.9, 0.8})
    @Config.RequiresMcRestart
    public static double[] pollutionDieselGeneratorReleasedByTier;
    @Config.Comment(value={"Controls the pollution released per second by the base gas turbine."})
    @Config.DefaultInt(value=40)
    @Config.RequiresMcRestart
    public static int pollutionBaseGasTurbinePerSecond;
    @Config.Comment(value={"Pollution released by tier, with the following formula: PollutionBaseGasTurbinePerSecond * PollutionGasTurbineReleasedByTier[Tier]", "The first entry has meaning as it is here to since machine tier with array index: LV is 1, etc."})
    @Config.DefaultDoubleList(value={0.1, 1.0, 0.9, 0.8, 0.7, 0.6})
    @Config.RequiresMcRestart
    public static double[] pollutionGasTurbineReleasedByTier;
    @Config.Comment(value={"Explosion pollution"})
    @Config.DefaultFloat(value=333.34f)
    public static float explosionPollutionAmount;
    @Config.Comment(value={"Make furnaces Pollute"})
    @Config.DefaultBoolean(value=true)
    @Config.RequiresMcRestart
    public static boolean furnacesPollute;
    @Config.Comment(value={"Furnace pollution per second, min 1!"})
    @Config.DefaultInt(value=20)
    public static int furnacePollutionAmount;
    @Config.Comment(value={"Pollution Amount for Rockets"})
    @Config.DefaultInt(value=10000)
    public static int rocketPollutionAmount;
    @Config.Comment(value={"Make rockets Pollute"})
    @Config.DefaultBoolean(value=true)
    @Config.RequiresMcRestart
    public static boolean rocketsPollute;
    @Config.Comment(value={"Pollution Amount for Advanced Coke Ovens"})
    @Config.DefaultInt(value=80)
    public static int advancedCokeOvenPollutionAmount;
    @Config.Comment(value={"Pollution Amount for Coke Ovens"})
    @Config.DefaultInt(value=10)
    public static int cokeOvenPollutionAmount;
    @Config.Comment(value={"Pollution Amount for RC Firebox"})
    @Config.DefaultInt(value=20)
    public static int fireboxPollutionAmount;
    @Config.Comment(value={"Pollution Amount for hobbyist steam engine"})
    @Config.DefaultInt(value=20)
    public static int hobbyistEnginePollutionAmount;
    @Config.Comment(value={"Make Railcraft Pollute"})
    @Config.DefaultBoolean(value=true)
    @Config.RequiresMcRestart
    public static boolean railcraftPollutes;
    @Config.Comment(value={"Pollution Amount for tunnel bore"})
    @Config.DefaultInt(value=2)
    public static int tunnelBorePollutionAmount;
    @Config.Comment(value={"How much should the Simple Stirling Water Pump produce pollution per second"})
    @Config.DefaultInt(value=5)
    public static int pollutionHeatedWaterPumpSecond;
    @Config.Comment(value={"How much should the MBF produce pollution per tick per ingot. Then it'll be multiplied by the amount of ingots done in parallel"})
    @Config.DefaultInt(value=400)
    public static int basePollutionMBFSecond;
    @Config.Comment(value={"Changes colors of certain blocks based on pollution levels"})
    @Config.DefaultBoolean(value=true)
    @Config.RequiresMcRestart
    public static boolean pollutionBlockRecolor;
    @Config.Comment(value={"Double Plant Blocks - Recolor Block List"})
    @Config.DefaultStringList(value={"net.minecraft.block.BlockDoublePlant:FLOWER"})
    @Config.RequiresMcRestart
    public static String[] renderBlockDoublePlant;
    @Config.Comment(value={"Liquid Blocks - Recolor Block List"})
    @Config.DefaultStringList(value={"net.minecraft.block.BlockLiquid:LIQUID"})
    @Config.RequiresMcRestart
    public static String[] renderBlockLiquid;
    @Config.Comment(value={"Block Vine - Recolor Block List"})
    @Config.DefaultStringList(value={"net.minecraft.block.BlockVine:FLOWER"})
    @Config.RequiresMcRestart
    public static String[] renderblockVine;
    @Config.Comment(value={"Crossed Squares - Recolor Block List"})
    @Config.DefaultStringList(value={"net.minecraft.block.BlockTallGrass:FLOWER", "net.minecraft.block.BlockFlower:FLOWER", "biomesoplenty.common.blocks.BlockBOPFlower:FLOWER", "biomesoplenty.common.blocks.BlockBOPFlower2:FLOWER", "biomesoplenty.common.blocks.BlockBOPFoliage:FLOWER"})
    @Config.RequiresMcRestart
    public static String[] renderCrossedSquares;
    @Config.Comment(value={"Standard Blocks - Recolor Block List"})
    @Config.DefaultStringList(value={"net.minecraft.block.BlockGrass:GRASS", "net.minecraft.block.BlockLeavesBase:LEAVES", "biomesoplenty.common.blocks.BlockOriginGrass:GRASS", "biomesoplenty.common.blocks.BlockLongGrass:GRASS", "biomesoplenty.common.blocks.BlockNewGrass:GRASS", "tconstruct.blocks.slime.SlimeGrass:GRASS", "thaumcraft.common.blocks.BlockMagicalLeaves:LEAVES"})
    @Config.RequiresMcRestart
    public static String[] renderStandardBlock;
    @Config.Comment(value={"pollution rate in gibbl/s for the Amazon warehousing depot"})
    @Config.DefaultInt(value=40)
    public static int pollutionPerSecondMultiPackager;
    @Config.Comment(value={"pollution rate in gibbl/s for the Alloy blast smelter"})
    @Config.DefaultInt(value=300)
    public static int pollutionPerSecondMultiIndustrialAlloySmelter;
    @Config.Comment(value={"pollution rate in gibbl/s for the High current arc furnace"})
    @Config.DefaultInt(value=2400)
    public static int pollutionPerSecondMultiIndustrialArcFurnace;
    @Config.Comment(value={"pollution rate in gibbl/s for the Industrial centrifuge"})
    @Config.DefaultInt(value=300)
    public static int pollutionPerSecondMultiIndustrialCentrifuge;
    @Config.Comment(value={"pollution rate in gibbl/s for the Industrial coke oven"})
    @Config.DefaultInt(value=80)
    public static int pollutionPerSecondMultiIndustrialCokeOven;
    @Config.Comment(value={"pollution rate in gibbl/s for the Cutting factory"})
    @Config.DefaultInt(value=160)
    public static int pollutionPerSecondMultiIndustrialCuttingMachine;
    @Config.Comment(value={"pollution rate in gibbl/s for the Utupu-Tanuri"})
    @Config.DefaultInt(value=500)
    public static int pollutionPerSecondMultiIndustrialDehydrator;
    @Config.Comment(value={"pollution rate in gibbl/s for the Industrial electrolyzer"})
    @Config.DefaultInt(value=300)
    public static int pollutionPerSecondMultiIndustrialElectrolyzer;
    @Config.Comment(value={"pollution rate in gibbl/s for the Industrial extrusion machine"})
    @Config.DefaultInt(value=1000)
    public static int pollutionPerSecondMultiIndustrialExtruder;
    @Config.Comment(value={"pollution rate in gibbl/s for the Maceration stack"})
    @Config.DefaultInt(value=400)
    public static int pollutionPerSecondMultiIndustrialMacerator;
    @Config.Comment(value={"pollution rate in gibbl/s for the Industrial mixing machine"})
    @Config.DefaultInt(value=800)
    public static int pollutionPerSecondMultiIndustrialMixer;
    @Config.Comment(value={"pollution rate in gibbl/s for the Large processing factory in metal mode"})
    @Config.DefaultInt(value=400)
    public static int pollutionPerSecondMultiIndustrialMultiMachine_ModeMetal;
    @Config.Comment(value={"pollution rate in gibbl/s for the Large processing factory in fluid mode"})
    @Config.DefaultInt(value=400)
    public static int pollutionPerSecondMultiIndustrialMultiMachine_ModeFluid;
    @Config.Comment(value={"pollution rate in gibbl/s for the Large processing factory in misc mode"})
    @Config.DefaultInt(value=600)
    public static int pollutionPerSecondMultiIndustrialMultiMachine_ModeMisc;
    @Config.Comment(value={"pollution rate in gibbl/s for the Industrial material press in forming mode"})
    @Config.DefaultInt(value=240)
    public static int pollutionPerSecondMultiIndustrialPlatePress_ModeForming;
    @Config.Comment(value={"pollution rate in gibbl/s for the Industrial material press in bending mode"})
    @Config.DefaultInt(value=480)
    public static int pollutionPerSecondMultiIndustrialPlatePress_ModeBending;
    @Config.Comment(value={"pollution rate in gibbl/s for the Industrial Forge Hammer"})
    @Config.DefaultInt(value=250)
    public static int pollutionPerSecondMultiIndustrialForgeHammer;
    @Config.Comment(value={"pollution rate in gibbl/s for the Large Sifter"})
    @Config.DefaultInt(value=40)
    public static int pollutionPerSecondMultiIndustrialSifter;
    @Config.Comment(value={"pollution rate in gibbl/s for the Large thermal refinery"})
    @Config.DefaultInt(value=1000)
    public static int pollutionPerSecondMultiIndustrialThermalCentrifuge;
    @Config.Comment(value={"pollution rate in gibbl/s for the Industrial fluid heater"})
    @Config.DefaultInt(value=1000)
    public static int pollutionPerSecondMultiIndustrialFluidHeater;
    @Config.Comment(value={"pollution rate in gibbl/s for the Cryogenic freezer"})
    @Config.DefaultInt(value=500)
    public static int pollutionPerSecondMultiIndustrialVacuumFreezer;
    @Config.Comment(value={"pollution rate in gibbl/s for the Ore washing plant in chemical bath mode"})
    @Config.DefaultInt(value=400)
    public static int pollutionPerSecondMultiIndustrialWashPlant_ModeChemBath;
    @Config.Comment(value={"pollution rate in gibbl/s for the Ore washing plant in ore washer mode"})
    @Config.DefaultInt(value=100)
    public static int pollutionPerSecondMultiIndustrialWashPlant_ModeWasher;
    @Config.Comment(value={"pollution rate in gibbl/s for the Wire factory"})
    @Config.DefaultInt(value=100)
    public static int pollutionPerSecondMultiIndustrialWireMill;
    @Config.Comment(value={"pollution rate in gibbl/s for the IsaMill grinding machine"})
    @Config.DefaultInt(value=1280)
    public static int pollutionPerSecondMultiIsaMill;
    @Config.Comment(value={"pollution rate in gibbl/s for the Dangote distillus in distillery mode"})
    @Config.DefaultInt(value=240)
    public static int pollutionPerSecondMultiAdvDistillationTower_ModeDistillery;
    @Config.Comment(value={"pollution rate in gibbl/s for the Dangote distillus in distillation tower mode"})
    @Config.DefaultInt(value=480)
    public static int pollutionPerSecondMultiAdvDistillationTower_ModeDT;
    @Config.Comment(value={"pollution rate in gibbl/s for the Volcanus"})
    @Config.DefaultInt(value=500)
    public static int pollutionPerSecondMultiAdvEBF;
    @Config.Comment(value={"pollution rate in gibbl/s for the Density^2"})
    @Config.DefaultInt(value=5000)
    public static int pollutionPerSecondMultiAdvImplosion;
    @Config.Comment(value={"pollution rate in gibbl/s for the Alloy blast furnace"})
    @Config.DefaultInt(value=200)
    public static int pollutionPerSecondMultiABS;
    @Config.Comment(value={"pollution rate in gibbl/s for the Zuhai - fishing port"})
    @Config.DefaultInt(value=20)
    public static int pollutionPerSecondMultiIndustrialFishingPond;
    @Config.Comment(value={"pollution rate in gibbl/s for the Large semifluid burner"})
    @Config.DefaultInt(value=1280)
    public static int pollutionPerSecondMultiLargeSemiFluidGenerator;
    @Config.Comment(value={"pollution rate in gibbl/s for the Matter fabrication CPU"})
    @Config.DefaultInt(value=40)
    public static int pollutionPerSecondMultiMassFabricator;
    @Config.Comment(value={"pollution rate in gibbl/s for the Reactor fuel processing plant"})
    @Config.DefaultInt(value=4000)
    public static int pollutionPerSecondMultiRefinery;
    @Config.Comment(value={"pollution rate in gibbl/s for the Industrial Rock Breaker"})
    @Config.DefaultInt(value=100)
    public static int pollutionPerSecondMultiIndustrialRockBreaker;
    @Config.Comment(value={"pollution rate in gibbl/s for the Industrial Chisel"})
    @Config.DefaultInt(value=50)
    public static int pollutionPerSecondMultiIndustrialChisel;
    @Config.Comment(value={"pollution rate in gibbl/s for the Tree growth simulator"})
    @Config.DefaultInt(value=100)
    public static int pollutionPerSecondMultiTreeFarm;
    @Config.Comment(value={"pollution rate in gibbl/s for the Flotation cell regulator"})
    @Config.DefaultInt(value=0)
    public static int pollutionPerSecondMultiFrothFlotationCell;
    @Config.Comment(value={"pollution rate in gibbl/s for the Large-Scale auto assembler v1.01"})
    @Config.DefaultInt(value=500)
    public static int pollutionPerSecondMultiAutoCrafter;
    @Config.Comment(value={"pollution rate in gibbl/s for the Nuclear salt processing plant"})
    @Config.DefaultInt(value=500)
    public static int pollutionPerSecondNuclearSaltProcessingPlant;
    @Config.Comment(value={"pollution rate in gibbl/s for the Multiblock Molecular Transformer"})
    @Config.DefaultInt(value=1000)
    public static int pollutionPerSecondMultiMolecularTransformer;
    @Config.Comment(value={"pollution rate in gibbl/s for the Elemental Duplicator"})
    @Config.DefaultInt(value=1000)
    public static int pollutionPerSecondElementalDuplicator;
    @Config.Comment(value={"pollution rate in gibbl/s for the Thermal boiler"})
    @Config.DefaultInt(value=700)
    public static int pollutionPerSecondMultiThermalBoiler;
    @Config.Comment(value={"pollution rate in gibbl/s for the Algae farm"})
    @Config.DefaultInt(value=0)
    public static int pollutionPerSecondMultiAlgaePond;
    @Config.Comment(value={"base pollution rate in gibbl/s for the single block semi fluid generators"})
    @Config.DefaultInt(value=40)
    public static int basePollutionPerSecondSemiFluidGenerator;
    @Config.Comment(value={"coefficient applied to the base rate of the single block semi fluid generators based on its tier (first is tier 0 aka ULV)"})
    @Config.DefaultDoubleList(value={0.0, 2.0, 4.0, 8.0, 12.0, 16.0})
    public static double[] pollutionReleasedByTierSemiFluidGenerator;
    @Config.Comment(value={"base pollution rate in gibbl/s for the single block boilers"})
    @Config.DefaultInt(value=35)
    public static int basePollutionPerSecondBoiler;
    @Config.Comment(value={"coefficient applied to the base rate of the single block boilers based on its tier (first is tier 0 aka ULV)"})
    @Config.DefaultDoubleList(value={0.0, 1.0, 1.43, 1.86})
    public static double[] pollutionReleasedByTierBoiler;
    @Config.Comment(value={"minimum base pollution rate in gibbl/s for the single block rocket engines"})
    @Config.DefaultInt(value=250)
    public static int baseMinPollutionPerSecondRocketFuelGenerator;
    @Config.Comment(value={"maximum base pollution rate in gibbl/s for the single block rocket engines"})
    @Config.DefaultInt(value=2000)
    public static int baseMaxPollutionPerSecondRocketFuelGenerator;
    @Config.Comment(value={"coefficient applied to the base rate of the single block rocket engines based on its tier (first is tier 0 aka ULV)"})
    @Config.DefaultDoubleList(value={0.0, 0.0, 0.0, 0.0, 1.0, 2.0, 3.0})
    public static double[] pollutionReleasedByTierRocketFuelGenerator;
    @Config.Comment(value={"base pollution rate in gibbl/s for the geothermal engines"})
    @Config.DefaultInt(value=100)
    public static int basePollutionPerSecondGeothermalGenerator;
    @Config.Comment(value={"coefficient applied to the base rate of the single block geothermal engines based on its tier (first is tier 0 aka ULV)"})
    @Config.DefaultDoubleList(value={0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0})
    public static double[] pollutionReleasedByTierGeothermalGenerator;
}

