/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.misc.teams;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import gregtech.common.misc.teams.GTTeam;
import gregtech.common.misc.teams.GTTeamManager;
import gregtech.common.misc.teams.ITeamData;
import gregtech.common.misc.teams.TeamDataTypes;
import java.util.UUID;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.storage.MapStorage;
import net.minecraftforge.event.world.WorldEvent;

public class TeamWorldSavedData
extends WorldSavedData {
    public static TeamWorldSavedData INSTANCE;
    private static final String DATA_NAME = "GT_TeamWorldSavedData";

    private static void loadInstance(World world) {
        MapStorage storage = world.field_72988_C;
        INSTANCE = (TeamWorldSavedData)storage.func_75742_a(TeamWorldSavedData.class, DATA_NAME);
        if (INSTANCE == null) {
            INSTANCE = new TeamWorldSavedData();
            storage.func_75745_a(DATA_NAME, (WorldSavedData)INSTANCE);
        }
        INSTANCE.func_76185_a();
    }

    public static void markForSaving() {
        if (INSTANCE != null) {
            INSTANCE.func_76185_a();
        }
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        if (!event.world.field_72995_K && event.world.field_73011_w.field_76574_g == 0) {
            TeamWorldSavedData.loadInstance(event.world);
        }
    }

    public TeamWorldSavedData() {
        super(DATA_NAME);
    }

    public TeamWorldSavedData(String name) {
        super(name);
    }

    public void func_76184_a(NBTTagCompound NBT2) {
        NBTTagList teamList = NBT2.func_150295_c("TeamList", 10);
        for (int i = 0; i < teamList.func_74745_c(); ++i) {
            NBTTagCompound teamTag = teamList.func_150305_b(i);
            String teamName = teamTag.func_74779_i("TeamName");
            GTTeam team = new GTTeam(teamName);
            team.initializeData(TeamDataTypes.values());
            NBTTagList ownersList = teamTag.func_150295_c("Owners", 8);
            for (int j = 0; j < ownersList.func_74745_c(); ++j) {
                team.addOwner(UUID.fromString(ownersList.func_150307_f(j)));
            }
            NBTTagList membersList = teamTag.func_150295_c("Members", 8);
            for (int j = 0; j < membersList.func_74745_c(); ++j) {
                team.addMember(UUID.fromString(membersList.func_150307_f(j)));
            }
            NBTTagCompound teamData = teamTag.func_74775_l("TeamData");
            for (ITeamData data : team.getAllData()) {
                data.readFromNBT(teamData);
            }
            GTTeamManager.TEAMS.add(team);
        }
    }

    public void func_76187_b(NBTTagCompound NBT2) {
        NBTTagList teamList = new NBTTagList();
        for (GTTeam team : GTTeamManager.TEAMS) {
            if (team.getMembers().isEmpty() && team.getOwners().isEmpty()) continue;
            NBTTagCompound teamTag = new NBTTagCompound();
            teamTag.func_74778_a("TeamName", team.getTeamName());
            NBTTagList ownersList = new NBTTagList();
            for (UUID uUID : team.getOwners()) {
                ownersList.func_74742_a((NBTBase)new NBTTagString(uUID.toString()));
            }
            teamTag.func_74782_a("Owners", (NBTBase)ownersList);
            NBTTagList membersList = new NBTTagList();
            for (UUID member : team.getMembers()) {
                membersList.func_74742_a((NBTBase)new NBTTagString(member.toString()));
            }
            teamTag.func_74782_a("Members", (NBTBase)membersList);
            NBTTagCompound nBTTagCompound = new NBTTagCompound();
            for (ITeamData data : team.getAllData()) {
                data.writeToNBT(nBTTagCompound);
            }
            teamTag.func_74782_a("TeamData", (NBTBase)nBTTagCompound);
            teamList.func_74742_a((NBTBase)teamTag);
        }
        NBT2.func_74782_a("TeamList", (NBTBase)teamList);
    }
}

