/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.misc.teams;

import gregtech.common.misc.teams.GTTeam;
import gregtech.common.misc.teams.PipelessSteamManager;
import gregtech.common.misc.teams.TeamDataTypes;
import gregtech.common.misc.teams.TeamWorldSavedData;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class GTTeamManager {
    protected static final List<GTTeam> TEAMS = new ArrayList<GTTeam>();

    public static boolean isTeamNameValid(String name) {
        if (name == null || name.isEmpty()) {
            return false;
        }
        for (GTTeam team : TEAMS) {
            if (!team.getTeamName().equals(name)) continue;
            return false;
        }
        return true;
    }

    public static boolean isInTeam(UUID playerUuid) {
        for (GTTeam team : TEAMS) {
            if (!team.isTeamMember(playerUuid)) continue;
            return true;
        }
        return false;
    }

    public static GTTeam getTeam(String playerName, UUID playerUuid) {
        for (GTTeam team : TEAMS) {
            if (!team.isTeamMember(playerUuid)) continue;
            return team;
        }
        GTTeam team = new GTTeam(playerName + "'s Team");
        team.initializeData(TeamDataTypes.values());
        team.addOwner(playerUuid);
        TeamWorldSavedData.markForSaving();
        return team;
    }

    public static PipelessSteamManager getSteamData(GTTeam team) {
        return (PipelessSteamManager)team.getData(TeamDataTypes.PIPELESS);
    }

    public static void clear() {
        TEAMS.clear();
    }
}

