/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.misc.teams;

import gregtech.common.misc.teams.GTTeamManager;
import gregtech.common.misc.teams.ITeamData;
import gregtech.common.misc.teams.TeamDataTypes;
import gregtech.common.misc.teams.TeamWorldSavedData;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectLists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class GTTeam {
    private String teamName;
    private final ObjectList<UUID> owners = new ObjectArrayList();
    private final ObjectList<UUID> members = new ObjectArrayList();
    private final Map<TeamDataTypes, ITeamData> teamData = new HashMap<TeamDataTypes, ITeamData>();

    public GTTeam(String teamName) {
        this.teamName = teamName;
        GTTeamManager.TEAMS.add(this);
        TeamWorldSavedData.markForSaving();
    }

    public String getTeamName() {
        return this.teamName;
    }

    public boolean renameTeam(String newName) {
        if (GTTeamManager.isTeamNameValid(newName)) {
            this.teamName = newName;
            TeamWorldSavedData.markForSaving();
            return true;
        }
        return false;
    }

    public boolean isTeamMember(UUID player) {
        return this.members.contains((Object)player);
    }

    public void addMember(UUID uuid) {
        this.members.add((Object)uuid);
        TeamWorldSavedData.markForSaving();
    }

    public void removeMember(UUID uuid) {
        this.members.remove((Object)uuid);
        this.owners.remove((Object)uuid);
        TeamWorldSavedData.markForSaving();
    }

    public List<UUID> getMembers() {
        return ObjectLists.unmodifiable(this.members);
    }

    public boolean isTeamOwner(UUID player) {
        return this.owners.contains((Object)player);
    }

    public void addOwner(UUID uuid) {
        this.owners.add((Object)uuid);
        this.members.add((Object)uuid);
        TeamWorldSavedData.markForSaving();
    }

    public List<UUID> getOwners() {
        return ObjectLists.unmodifiable(this.owners);
    }

    public void initializeData(TeamDataTypes ... types) {
        for (TeamDataTypes type : types) {
            if (this.teamData.containsKey((Object)type)) continue;
            this.teamData.put(type, type.construct());
        }
    }

    public ITeamData getData(TeamDataTypes type) {
        return this.teamData.get((Object)type);
    }

    public List<ITeamData> getAllData() {
        return new ArrayList<ITeamData>(this.teamData.values());
    }
}

