/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.items;

import bartworks.common.items.ItemCircuitProgrammer;
import com.gtnewhorizons.modularui.api.UIInfos;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ggfab.GGItemList;
import gregtech.GTMod;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Mods;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.interfaces.INetworkUpdatableItem;
import gregtech.api.items.GTGenericItem;
import gregtech.api.net.GTPacketUpdateItem;
import gregtech.api.objects.XSTR;
import gregtech.api.util.GTConfig;
import gregtech.api.util.GTLanguageManager;
import gregtech.api.util.GTLog;
import gregtech.api.util.GTModHandler;
import gregtech.common.gui.modularui.uifactory.SelectItemUIFactory;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.item.ItemToolbox;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.oredict.OreDictionary;

public class ItemIntegratedCircuit
extends GTGenericItem
implements INetworkUpdatableItem {
    public static final int MAX_CIRCUIT_NUMBER = 24;
    public static final List<ItemStack> NON_ZERO_VARIANTS = new ArrayList<ItemStack>(24);
    private static final String aTextEmptyRow = "   ";
    private static final List<ItemStack> ALL_VARIANTS = new ArrayList<ItemStack>(25);
    protected final IIcon[] mIconDamage = new IIcon[25];
    private static final int screwdriverOreId = OreDictionary.getOreID((String)"craftingToolScrewdriver");

    public ItemIntegratedCircuit() {
        super("integrated_circuit", "Adjustable Cog", "");
        this.func_77627_a(true);
        this.func_77656_e(0);
        ItemList.Circuit_Integrated.set(this);
        ALL_VARIANTS.add(new ItemStack((Item)this, 0, 0));
        for (int i = 1; i <= 24; ++i) {
            ItemStack aStack = new ItemStack((Item)this, 0, i);
            NON_ZERO_VARIANTS.add(aStack);
            ALL_VARIANTS.add(aStack);
        }
        GTModHandler.addShapelessCraftingRecipe(ItemList.Circuit_Integrated.getWithDamage(1L, 0L, new Object[0]), GTModHandler.RecipeBits.NOT_REMOVABLE, new Object[]{OrePrefixes.gearGt.get(Materials.Bronze)});
        long bits = GTModHandler.RecipeBits.BUFFERED | GTModHandler.RecipeBits.NOT_REMOVABLE;
        GTModHandler.addCraftingRecipe(ItemList.Circuit_Integrated.getWithDamage(1L, 1L, new Object[0]), bits, new Object[]{"d  ", " P ", aTextEmptyRow, Character.valueOf('P'), ItemList.Circuit_Integrated.getWildcard(1L, new Object[0])});
        GTModHandler.addCraftingRecipe(ItemList.Circuit_Integrated.getWithDamage(1L, 2L, new Object[0]), bits, new Object[]{" d ", " P ", aTextEmptyRow, Character.valueOf('P'), ItemList.Circuit_Integrated.getWildcard(1L, new Object[0])});
        GTModHandler.addCraftingRecipe(ItemList.Circuit_Integrated.getWithDamage(1L, 3L, new Object[0]), bits, new Object[]{"  d", " P ", aTextEmptyRow, Character.valueOf('P'), ItemList.Circuit_Integrated.getWildcard(1L, new Object[0])});
        GTModHandler.addCraftingRecipe(ItemList.Circuit_Integrated.getWithDamage(1L, 4L, new Object[0]), bits, new Object[]{aTextEmptyRow, " Pd", aTextEmptyRow, Character.valueOf('P'), ItemList.Circuit_Integrated.getWildcard(1L, new Object[0])});
        GTModHandler.addCraftingRecipe(ItemList.Circuit_Integrated.getWithDamage(1L, 5L, new Object[0]), bits, new Object[]{aTextEmptyRow, " P ", "  d", Character.valueOf('P'), ItemList.Circuit_Integrated.getWildcard(1L, new Object[0])});
        GTModHandler.addCraftingRecipe(ItemList.Circuit_Integrated.getWithDamage(1L, 6L, new Object[0]), bits, new Object[]{aTextEmptyRow, " P ", " d ", Character.valueOf('P'), ItemList.Circuit_Integrated.getWildcard(1L, new Object[0])});
        GTModHandler.addCraftingRecipe(ItemList.Circuit_Integrated.getWithDamage(1L, 7L, new Object[0]), bits, new Object[]{aTextEmptyRow, " P ", "d  ", Character.valueOf('P'), ItemList.Circuit_Integrated.getWildcard(1L, new Object[0])});
        GTModHandler.addCraftingRecipe(ItemList.Circuit_Integrated.getWithDamage(1L, 8L, new Object[0]), bits, new Object[]{aTextEmptyRow, "dP ", aTextEmptyRow, Character.valueOf('P'), ItemList.Circuit_Integrated.getWildcard(1L, new Object[0])});
        GTModHandler.addCraftingRecipe(ItemList.Circuit_Integrated.getWithDamage(1L, 9L, new Object[0]), bits, new Object[]{"P d", aTextEmptyRow, aTextEmptyRow, Character.valueOf('P'), ItemList.Circuit_Integrated.getWildcard(1L, new Object[0])});
        GTModHandler.addCraftingRecipe(ItemList.Circuit_Integrated.getWithDamage(1L, 10L, new Object[0]), bits, new Object[]{"P  ", "  d", aTextEmptyRow, Character.valueOf('P'), ItemList.Circuit_Integrated.getWildcard(1L, new Object[0])});
        GTModHandler.addCraftingRecipe(ItemList.Circuit_Integrated.getWithDamage(1L, 11L, new Object[0]), bits, new Object[]{"P  ", aTextEmptyRow, "  d", Character.valueOf('P'), ItemList.Circuit_Integrated.getWildcard(1L, new Object[0])});
        GTModHandler.addCraftingRecipe(ItemList.Circuit_Integrated.getWithDamage(1L, 12L, new Object[0]), bits, new Object[]{"P  ", aTextEmptyRow, " d ", Character.valueOf('P'), ItemList.Circuit_Integrated.getWildcard(1L, new Object[0])});
        GTModHandler.addCraftingRecipe(ItemList.Circuit_Integrated.getWithDamage(1L, 13L, new Object[0]), bits, new Object[]{"  P", aTextEmptyRow, "  d", Character.valueOf('P'), ItemList.Circuit_Integrated.getWildcard(1L, new Object[0])});
        GTModHandler.addCraftingRecipe(ItemList.Circuit_Integrated.getWithDamage(1L, 14L, new Object[0]), bits, new Object[]{"  P", aTextEmptyRow, " d ", Character.valueOf('P'), ItemList.Circuit_Integrated.getWildcard(1L, new Object[0])});
        GTModHandler.addCraftingRecipe(ItemList.Circuit_Integrated.getWithDamage(1L, 15L, new Object[0]), bits, new Object[]{"  P", aTextEmptyRow, "d  ", Character.valueOf('P'), ItemList.Circuit_Integrated.getWildcard(1L, new Object[0])});
        GTModHandler.addCraftingRecipe(ItemList.Circuit_Integrated.getWithDamage(1L, 16L, new Object[0]), bits, new Object[]{"  P", "d  ", aTextEmptyRow, Character.valueOf('P'), ItemList.Circuit_Integrated.getWildcard(1L, new Object[0])});
        GTModHandler.addCraftingRecipe(ItemList.Circuit_Integrated.getWithDamage(1L, 17L, new Object[0]), bits, new Object[]{aTextEmptyRow, aTextEmptyRow, "d P", Character.valueOf('P'), ItemList.Circuit_Integrated.getWildcard(1L, new Object[0])});
        GTModHandler.addCraftingRecipe(ItemList.Circuit_Integrated.getWithDamage(1L, 18L, new Object[0]), bits, new Object[]{aTextEmptyRow, "d  ", "  P", Character.valueOf('P'), ItemList.Circuit_Integrated.getWildcard(1L, new Object[0])});
        GTModHandler.addCraftingRecipe(ItemList.Circuit_Integrated.getWithDamage(1L, 19L, new Object[0]), bits, new Object[]{"d  ", aTextEmptyRow, "  P", Character.valueOf('P'), ItemList.Circuit_Integrated.getWildcard(1L, new Object[0])});
        GTModHandler.addCraftingRecipe(ItemList.Circuit_Integrated.getWithDamage(1L, 20L, new Object[0]), bits, new Object[]{" d ", aTextEmptyRow, "  P", Character.valueOf('P'), ItemList.Circuit_Integrated.getWildcard(1L, new Object[0])});
        GTModHandler.addCraftingRecipe(ItemList.Circuit_Integrated.getWithDamage(1L, 21L, new Object[0]), bits, new Object[]{"d  ", aTextEmptyRow, "P  ", Character.valueOf('P'), ItemList.Circuit_Integrated.getWildcard(1L, new Object[0])});
        GTModHandler.addCraftingRecipe(ItemList.Circuit_Integrated.getWithDamage(1L, 22L, new Object[0]), bits, new Object[]{" d ", aTextEmptyRow, "P  ", Character.valueOf('P'), ItemList.Circuit_Integrated.getWildcard(1L, new Object[0])});
        GTModHandler.addCraftingRecipe(ItemList.Circuit_Integrated.getWithDamage(1L, 23L, new Object[0]), bits, new Object[]{"  d", aTextEmptyRow, "P  ", Character.valueOf('P'), ItemList.Circuit_Integrated.getWildcard(1L, new Object[0])});
        GTModHandler.addCraftingRecipe(ItemList.Circuit_Integrated.getWithDamage(1L, 24L, new Object[0]), bits, new Object[]{aTextEmptyRow, "  d", "P  ", Character.valueOf('P'), ItemList.Circuit_Integrated.getWildcard(1L, new Object[0])});
    }

    private static String getModeString(int aMetaData) {
        String string;
        switch ((byte)(aMetaData >>> 8)) {
            case 0: {
                string = "==";
                break;
            }
            case 1: {
                string = "<=";
                break;
            }
            case 2: {
                string = ">=";
                break;
            }
            case 3: {
                string = "<";
                break;
            }
            case 4: {
                string = ">";
                break;
            }
            default: {
                string = "";
            }
        }
        return string;
    }

    private static String getConfigurationString(int aMetaData) {
        return ItemIntegratedCircuit.getModeString(aMetaData) + " " + (byte)(aMetaData & 0xFF);
    }

    @Override
    public void addAdditionalToolTips(List<String> aList, ItemStack aStack, EntityPlayer aPlayer) {
        super.addAdditionalToolTips(aList, aStack, aPlayer);
        aList.add(GTLanguageManager.addStringLocalization(this.func_77658_a() + ".configuration", "Configuration: ") + ItemIntegratedCircuit.getConfigurationString(this.getDamage(aStack)));
        aList.add(GTLanguageManager.addStringLocalization(this.func_77658_a() + ".tooltip.0", "Right click to reconfigure"));
        aList.add(GTLanguageManager.addStringLocalization(this.func_77658_a() + ".tooltip.1", "Needs a screwdriver"));
    }

    @Override
    public String func_77667_c(ItemStack aStack) {
        return this.func_77658_a();
    }

    @SideOnly(value=Side.CLIENT)
    public final void func_150895_a(Item aItem, CreativeTabs aCreativeTab, List<ItemStack> aList) {
        aList.add(new ItemStack((Item)this, 1, 0));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister aIconRegister) {
        super.func_94581_a(aIconRegister);
        for (int i = 0; i < this.mIconDamage.length; ++i) {
            this.mIconDamage[i] = aIconRegister.func_94245_a(Mods.GregTech.getResourcePath(GTConfig.troll ? "troll" : this.func_77658_a() + "/" + i));
        }
        if (GregTechAPI.sPostloadFinished) {
            GTLog.out.println("GTMod: Starting Item Icon Load Phase");
            GTMod.GT_FML_LOGGER.info("GTMod: Starting Item Icon Load Phase");
            GregTechAPI.sItemIcons = aIconRegister;
            for (Runnable tRunnable : GregTechAPI.sGTItemIconload) {
                try {
                    tRunnable.run();
                }
                catch (Throwable e) {
                    GTMod.GT_FML_LOGGER.error("Error registering icons", e);
                }
            }
            GTLog.out.println("GTMod: Finished Item Icon Load Phase");
            GTMod.GT_FML_LOGGER.info("GTMod: Finished Item Icon Load Phase");
        }
    }

    @Override
    public IIcon func_77617_a(int aMetaData) {
        byte circuitMode = (byte)(aMetaData & 0xFF);
        return this.mIconDamage[circuitMode < this.mIconDamage.length ? circuitMode : (byte)0];
    }

    @Override
    public boolean receive(ItemStack stack, EntityPlayerMP player, NBTTagCompound tag) {
        int meta;
        int n = meta = tag.func_150297_b("meta", 1) ? (int)tag.func_74771_c("meta") : -1;
        if (meta < 0 || meta > 24) {
            return true;
        }
        if (!player.field_71075_bZ.field_75098_d) {
            ItemIntegratedCircuit.findConfiguratorInInv((EntityPlayer)player, true);
        }
        stack.func_77964_b(meta);
        return true;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        ItemStack configuratorStack;
        if (player instanceof FakePlayer || !world.field_72995_K) {
            return stack;
        }
        if (player.field_71075_bZ.field_75098_d) {
            configuratorStack = null;
        } else {
            configuratorStack = ItemIntegratedCircuit.findConfiguratorInInv(player, false);
            if (configuratorStack == null) {
                int count;
                try {
                    count = Integer.parseInt(StatCollector.func_74838_a((String)"GT5U.item.programmed_circuit.no_screwdriver.count"));
                }
                catch (NumberFormatException e) {
                    player.func_146105_b((IChatComponent)new ChatComponentText("Error in translation GT5U.item.programmed_circuit.no_screwdriver.count: " + e.getMessage()));
                    count = 1;
                }
                player.func_146105_b((IChatComponent)new ChatComponentTranslation("GT5U.item.programmed_circuit.no_screwdriver." + XSTR.XSTR_INSTANCE.nextInt(count), new Object[0]));
                return stack;
            }
        }
        this.openSelectorGui(configuratorStack, stack.func_77960_j(), player);
        return stack;
    }

    private void openSelectorGui(ItemStack configurator, int meta, EntityPlayer player) {
        UIInfos.openClientUI((EntityPlayer)player, buildContext -> new SelectItemUIFactory(StatCollector.func_74838_a((String)"GT5U.item.programmed_circuit.select.header"), configurator, ItemIntegratedCircuit::onConfigured, ALL_VARIANTS, meta, true).createWindow((UIBuildContext)buildContext));
    }

    private static void onConfigured(ItemStack stack) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74774_a("meta", (byte)stack.func_77960_j());
        GTValues.NW.sendToServer(new GTPacketUpdateItem(tag));
    }

    public static ItemStack findConfiguratorInInv(EntityPlayer player, boolean doDamage) {
        ItemStack[] mainInventory = player.field_71071_by.field_70462_a;
        for (int i = 0; i < mainInventory.length; ++i) {
            ItemStack potentialStack = mainInventory[i];
            if (potentialStack == null || potentialStack.func_77973_b() == null || potentialStack.field_77994_a <= 0) continue;
            Item item = potentialStack.func_77973_b();
            if (item instanceof ItemCircuitProgrammer) {
                ItemCircuitProgrammer programmer = (ItemCircuitProgrammer)item;
                if (doDamage) {
                    programmer.useItem(potentialStack, player);
                }
                return potentialStack;
            }
            item = potentialStack.func_77973_b();
            if (item instanceof ItemToolbox) {
                ItemToolbox toolbox = (ItemToolbox)item;
                IHasGui toolboxInventory = toolbox.getInventory(player, potentialStack);
                if (!IC2.platform.isSimulating()) {
                    ItemIntegratedCircuit.populateToolboxInventory(toolboxInventory, potentialStack);
                }
                for (int j = 0; j < toolboxInventory.func_70302_i_(); ++j) {
                    ItemStack toolboxStack = toolboxInventory.func_70301_a(j);
                    if (toolboxStack == null || toolboxStack.func_77973_b() == null || toolboxStack.field_77994_a <= 0) continue;
                    for (int id : OreDictionary.getOreIDs((ItemStack)toolboxStack)) {
                        if (id != screwdriverOreId) continue;
                        if (doDamage) {
                            if ((toolboxStack = toolboxStack.func_77973_b().getContainerItem(toolboxStack)) != null && toolboxStack.field_77994_a <= 0) {
                                toolboxInventory.func_70299_a(j, null);
                            } else {
                                toolboxInventory.func_70299_a(j, toolboxStack);
                            }
                        }
                        return potentialStack;
                    }
                }
            }
            for (int id : OreDictionary.getOreIDs((ItemStack)potentialStack)) {
                if (id != screwdriverOreId) continue;
                if (doDamage) {
                    if (potentialStack.func_77973_b().equals(GGItemList.One_Use_craftingToolScrewdriver.getItem())) {
                        --potentialStack.field_77994_a;
                    } else {
                        potentialStack = potentialStack.func_77973_b().getContainerItem(potentialStack);
                    }
                    mainInventory[i] = potentialStack != null && potentialStack.field_77994_a <= 0 ? null : potentialStack;
                }
                return potentialStack;
            }
        }
        return null;
    }

    private static void populateToolboxInventory(IHasGui toolboxInventory, ItemStack toolbox) {
        NBTTagCompound nbt = toolbox.func_77978_p();
        if (nbt == null) {
            return;
        }
        NBTTagList stacks = nbt.func_150295_c("Items", 10);
        for (int i = 0; i < stacks.func_74745_c(); ++i) {
            NBTTagCompound slotNbt = stacks.func_150305_b(i);
            byte slot = slotNbt.func_74771_c("Slot");
            if (slot < 0 || slot >= toolboxInventory.func_70302_i_()) continue;
            toolboxInventory.func_70299_a(i, ItemStack.func_77949_a((NBTTagCompound)slotNbt));
        }
    }
}

