/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.gui.mui1.cover;

import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import gregtech.api.gui.modularui.CoverUIBuildContext;
import gregtech.api.gui.modularui.GTUITextures;
import gregtech.api.util.GTUtility;
import gregtech.common.covers.CoverLegacyData;
import gregtech.common.gui.modularui.widget.CoverDataControllerWidget;
import gregtech.common.gui.modularui.widget.CoverDataFollowerToggleButtonWidget;
import gregtech.common.gui.mui1.cover.CoverLegacyDataUIFactory;
import java.util.Collections;

public class PumpUIFactory
extends CoverLegacyDataUIFactory {
    private static final int startX = 10;
    private static final int startY = 25;
    private static final int spaceX = 18;
    private static final int spaceY = 18;
    private CoverDataFollowerToggleButtonWidget<CoverLegacyData> mBlockWidget = null;
    private CoverDataFollowerToggleButtonWidget<CoverLegacyData> mAllowWidget = null;

    public PumpUIFactory(CoverUIBuildContext buildContext) {
        super(buildContext);
    }

    @Override
    protected void addUIWidgets(ModularWindow.Builder builder) {
        ((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(new CoverDataControllerWidget.CoverDataIndexedControllerWidget_ToggleButtons<CoverLegacyData>(this::getCover, (id, coverData) -> !this.getClickable((int)id, coverData.getVariable()), (id, coverData) -> coverData.setVariable(this.getNewCoverVariable((int)id, coverData.getVariable())), this.getUIBuildContext()).addToggleButton(0, CoverDataFollowerToggleButtonWidget.ofDisableable(), widget -> widget.setStaticTexture((IDrawable)GTUITextures.OVERLAY_BUTTON_EXPORT).addTooltip(GTUtility.trans("006", "Export")).setPos(0, 0)).addToggleButton(1, CoverDataFollowerToggleButtonWidget.ofDisableable(), widget -> widget.setStaticTexture((IDrawable)GTUITextures.OVERLAY_BUTTON_IMPORT).addTooltip(GTUtility.trans("007", "Import")).setPos(18, 0)).addToggleButton(2, CoverDataFollowerToggleButtonWidget.ofDisableable(), widget -> widget.setStaticTexture((IDrawable)GTUITextures.OVERLAY_BUTTON_CHECKMARK).addTooltip(GTUtility.trans("224", "Always On")).setPos(0, 18)).addToggleButton(3, CoverDataFollowerToggleButtonWidget.ofDisableable(), widget -> widget.setStaticTexture((IDrawable)GTUITextures.OVERLAY_BUTTON_USE_PROCESSING_STATE).addTooltip(GTUtility.trans("343", "Use Machine Processing State")).setPos(18, 18)).addToggleButton(4, CoverDataFollowerToggleButtonWidget.ofDisableable(), widget -> widget.setStaticTexture((IDrawable)GTUITextures.OVERLAY_BUTTON_USE_INVERTED_PROCESSING_STATE).addTooltip(GTUtility.trans("343.1", "Use Inverted Machine Processing State")).setPos(36, 18)).addToggleButton(5, CoverDataFollowerToggleButtonWidget.ofDisableable(), widget -> {
            this.mAllowWidget = widget;
            widget.setTextureGetter(i -> this.coverMatches(PumpUIFactory::isExportModeSelected) ? GTUITextures.OVERLAY_BUTTON_ALLOW_INPUT : GTUITextures.OVERLAY_BUTTON_ALLOW_OUTPUT).dynamicTooltip(() -> {
                CoverLegacyData cover = (CoverLegacyData)this.getCover();
                return Collections.singletonList(cover == null || cover.getVariable() % 2 == 0 ? GTUtility.trans("314", "Allow Input") : GTUtility.trans("312", "Allow Output"));
            }).setPos(0, 36);
        }).addToggleButton(6, CoverDataFollowerToggleButtonWidget.ofDisableable(), widget -> {
            this.mBlockWidget = widget;
            widget.setTextureGetter(i -> this.coverMatches(PumpUIFactory::isExportModeSelected) ? GTUITextures.OVERLAY_BUTTON_BLOCK_INPUT : GTUITextures.OVERLAY_BUTTON_BLOCK_OUTPUT).dynamicTooltip(() -> Collections.singletonList(this.coverMatches(PumpUIFactory::isExportModeSelected) ? GTUtility.trans("313", "Block Input") : GTUtility.trans("311", "Block Output"))).setPos(18, 36);
        }).setPos(10, 25))).widget(new TextWidget(GTUtility.trans("229", "Export/Import")).setDefaultColor(((Integer)this.COLOR_TEXT_GRAY.get()).intValue()).setPos(67, 29))).widget(new TextWidget(GTUtility.trans("230", "Conditional")).setDefaultColor(((Integer)this.COLOR_TEXT_GRAY.get()).intValue()).setPos(67, 47))).widget(TextWidget.dynamicString(() -> this.coverMatches(PumpUIFactory::isExportModeSelected) ? GTUtility.trans("344", "Input Blocking") : GTUtility.trans("344.1", "Output Blocking")).setSynced(false).setDefaultColor(((Integer)this.COLOR_TEXT_GRAY.get()).intValue()).setPos(67, 65));
    }

    private static boolean isExportModeSelected(CoverLegacyData cover) {
        return cover.getVariable() % 2 == 0;
    }

    private int getNewCoverVariable(int id, int coverVariable) {
        switch (id) {
            case 0: {
                if (this.mBlockWidget != null) {
                    this.mBlockWidget.notifyTooltipChange();
                }
                if (this.mAllowWidget != null) {
                    this.mAllowWidget.notifyTooltipChange();
                }
                return coverVariable & 0xFFFFFFFE;
            }
            case 1: {
                if (this.mBlockWidget != null) {
                    this.mBlockWidget.notifyTooltipChange();
                }
                if (this.mAllowWidget != null) {
                    this.mAllowWidget.notifyTooltipChange();
                }
                return coverVariable | 1;
            }
            case 2: {
                if (coverVariable > 5) {
                    return 6 | coverVariable & 0xFFFFFFF1;
                }
                return coverVariable & 0xFFFFFFF1;
            }
            case 3: {
                if (coverVariable > 5) {
                    return 8 | coverVariable & 0xFFFFFFF1;
                }
                return 2 | coverVariable & 0xFFFFFFF1;
            }
            case 4: {
                if (coverVariable > 5) {
                    return 0xA | coverVariable & 0xFFFFFFF1;
                }
                return 4 | coverVariable & 0xFFFFFFF1;
            }
            case 5: {
                if (coverVariable > 5) break;
                return coverVariable + 6;
            }
            case 6: {
                if (coverVariable <= 5) break;
                return coverVariable - 6;
            }
        }
        return coverVariable;
    }

    private boolean getClickable(int id, int coverVariable) {
        boolean bl;
        if (coverVariable < 0 | 11 < coverVariable) {
            return false;
        }
        switch (id) {
            case 0: 
            case 1: {
                if ((1 & coverVariable) != id) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 2: {
                if (coverVariable % 6 >= 2) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 3: {
                bl = coverVariable % 6 < 2 | 4 <= coverVariable % 6;
                break;
            }
            case 4: {
                if (coverVariable % 6 < 4) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 5: {
                if (coverVariable < 6) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 6: {
                if (coverVariable >= 6) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }
}

