/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.gui.mui1.cover;

import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import gregtech.api.gui.modularui.CoverUIBuildContext;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.util.GTUtility;
import gregtech.common.covers.Cover;
import gregtech.common.covers.CoverLiquidMeter;
import gregtech.common.gui.modularui.widget.CoverDataControllerWidget;
import gregtech.common.gui.modularui.widget.CoverDataFollowerNumericWidget;
import gregtech.common.gui.modularui.widget.CoverDataFollowerToggleButtonWidget;
import gregtech.common.gui.mui1.cover.CoverUiFactory;
import java.util.Arrays;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class LiquidMeterUIFactory
extends CoverUiFactory<CoverLiquidMeter> {
    private static final int startX = 10;
    private static final int startY = 25;
    private static final int spaceX = 18;
    private static final int spaceY = 18;
    private int maxCapacity;

    public LiquidMeterUIFactory(CoverUIBuildContext buildContext) {
        super(buildContext);
    }

    @Override
    protected CoverLiquidMeter adaptCover(Cover cover) {
        if (cover instanceof CoverLiquidMeter) {
            CoverLiquidMeter adapterCover = (CoverLiquidMeter)cover;
            return adapterCover;
        }
        return null;
    }

    @Override
    protected void addUIWidgets(ModularWindow.Builder builder) {
        String INVERTED = GTUtility.trans("INVERTED", "Inverted");
        String NORMAL = GTUtility.trans("NORMAL", "Normal");
        this.setMaxCapacity();
        ((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(new CoverDataControllerWidget<CoverLiquidMeter>(this::getCover, this.getUIBuildContext()).addFollower(CoverDataFollowerToggleButtonWidget.ofRedstone(), CoverLiquidMeter::isInverted, CoverLiquidMeter::setInverted, widget -> widget.addTooltip(0, NORMAL).addTooltip(1, INVERTED).setPos(0, 0)).addFollower(new CoverDataFollowerNumericWidget(), coverData -> coverData.getThreshold(), (coverData, state) -> coverData.setThresdhold(state.intValue()), widget -> widget.setBounds(0.0, this.maxCapacity > 0 ? (double)this.maxCapacity : 2.147483647E9).setScrollValues(1000.0, 144.0, 100000.0).setFocusOnGuiOpen(true).setPos(0, 20).setSize(77, 12)).setPos(10, 25))).widget(new TextWidget().setStringSupplier(this.getCoverString(c -> c.isInverted() ? INVERTED : NORMAL)).setDefaultColor(((Integer)this.COLOR_TEXT_GRAY.get()).intValue()).setPos(28, 29))).widget(new TextWidget(GTUtility.trans("222", "Fluid threshold")).setDefaultColor(((Integer)this.COLOR_TEXT_GRAY.get()).intValue()).setPos(90, 47));
    }

    private void setMaxCapacity() {
        ICoverable tile = this.getUIBuildContext().getTile();
        if (!tile.isDead() && tile instanceof IFluidHandler) {
            FluidTankInfo[] tanks = ((IFluidHandler)tile).getTankInfo(ForgeDirection.UNKNOWN);
            this.maxCapacity = Arrays.stream(tanks).mapToInt(tank -> tank.capacity).sum();
        } else {
            this.maxCapacity = -1;
        }
    }
}

