/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.gui.mui1.cover;

import com.gtnewhorizons.modularui.api.ModularUITextures;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.drawable.ItemDrawable;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.widget.IWidgetBuilder;
import com.gtnewhorizons.modularui.common.widget.ButtonWidget;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import gregtech.api.covers.CoverRegistry;
import gregtech.api.gui.modularui.CoverUIBuildContext;
import gregtech.api.gui.modularui.GUITextureSet;
import gregtech.api.gui.widgets.CoverTickRateButton;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.util.GTUtility;
import gregtech.common.covers.Cover;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class CoverUiFactory<C> {
    private final CoverUIBuildContext uiBuildContext;
    protected final Supplier<Integer> COLOR_TITLE = () -> CoverRegistry.getTextColorOrDefault("title", 0x222222);
    protected final Supplier<Integer> COLOR_TEXT_GRAY = () -> CoverRegistry.getTextColorOrDefault("text_gray", 0x555555);
    protected final Supplier<Integer> COLOR_TEXT_WARN = () -> CoverRegistry.getTextColorOrDefault("text_warn", 0xFF0000);

    public CoverUiFactory(CoverUIBuildContext buildContext) {
        this.uiBuildContext = buildContext;
    }

    public ModularWindow createWindow() {
        Cover cover;
        ModularWindow.Builder builder = ModularWindow.builder((int)this.getGUIWidth(), (int)this.getGUIHeight());
        builder.setBackground(new IDrawable[]{ModularUITextures.VANILLA_BACKGROUND});
        builder.setGuiTint(this.getUIBuildContext().getGuiColorization());
        this.maybeBindPlayerInventory(builder);
        this.addTitleToUI(builder);
        this.addUIWidgets(builder);
        if (this.getUIBuildContext().isAnotherWindow()) {
            builder.widget(ButtonWidget.closeWindowButton((boolean)true).setPos(this.getGUIWidth() - 15, 3));
        }
        if ((cover = this.uiBuildContext.getTile().getCoverAtSide(this.uiBuildContext.getCoverSide())).getMinimumTickRate() > 0 && cover.allowsTickRateAddition()) {
            builder.widget(new CoverTickRateButton(cover, (IWidgetBuilder<?>)builder).setPos(this.getGUIWidth() - 24, this.getGUIHeight() - 24));
        }
        return builder.build();
    }

    protected void maybeBindPlayerInventory(ModularWindow.Builder builder) {
        if (this.doesBindPlayerInventory() && !this.getUIBuildContext().isAnotherWindow()) {
            builder.bindPlayerInventory(this.getUIBuildContext().getPlayer(), 7, (IDrawable)GUITextureSet.DEFAULT.getItemSlot());
        }
    }

    protected void addUIWidgets(ModularWindow.Builder builder) {
    }

    protected CoverUIBuildContext getUIBuildContext() {
        return this.uiBuildContext;
    }

    @Nullable
    protected C getCover() {
        if (this.isCoverValid()) {
            return this.adaptCover(this.getUIBuildContext().getTile().getCoverAtSide(this.getUIBuildContext().getCoverSide()));
        }
        return null;
    }

    @Nullable
    protected C adaptCover(Cover cover) {
        return null;
    }

    @NotNull
    protected Supplier<String> getCoverString(Function<C, String> toString) {
        return () -> {
            C cover = this.getCover();
            if (cover == null) {
                return "";
            }
            return (String)toString.apply(cover);
        };
    }

    protected boolean coverMatches(Predicate<C> predicate) {
        C cover = this.getCover();
        if (cover == null) {
            return false;
        }
        return predicate.test(cover);
    }

    protected void ifCoverValid(Consumer<C> coverConsumer) {
        Optional.ofNullable(this.getCover()).ifPresent(coverConsumer);
    }

    private boolean isCoverValid() {
        ICoverable tile = this.getUIBuildContext().getTile();
        return !tile.isDead() && tile.getCoverAtSide(this.getUIBuildContext().getCoverSide()).isValid();
    }

    protected void addTitleToUI(ModularWindow.Builder builder) {
        ItemStack coverItem = GTUtility.intToStack(this.getUIBuildContext().getCoverID());
        if (coverItem != null) {
            ((ModularWindow.Builder)builder.widget(new ItemDrawable(coverItem).asWidget().setPos(5, 5).setSize(16, 16))).widget(new TextWidget(coverItem.func_82833_r()).setDefaultColor(this.COLOR_TITLE.get().intValue()).setPos(25, 9));
        }
    }

    protected int getGUIWidth() {
        return 176;
    }

    protected int getGUIHeight() {
        return 107;
    }

    protected boolean doesBindPlayerInventory() {
        return false;
    }
}

