/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.gui.mui1.cover;

import com.gtnewhorizons.modularui.api.forge.IItemHandlerModifiable;
import com.gtnewhorizons.modularui.api.math.Alignment;
import com.gtnewhorizons.modularui.api.math.Size;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.SlotGroup;
import gregtech.api.gui.modularui.CoverUIBuildContext;
import gregtech.common.covers.Cover;
import gregtech.common.covers.CoverChest;
import gregtech.common.gui.modularui.widget.CoverDataControllerWidget;
import gregtech.common.gui.mui1.cover.CoverUiFactory;

public class ChestUIFactory
extends CoverUiFactory<CoverChest> {
    private static final int spaceX = 18;
    private static final int spaceY = 18;

    public ChestUIFactory(CoverUIBuildContext buildContext) {
        super(buildContext);
    }

    @Override
    protected int getGUIHeight() {
        CoverChest cover = (CoverChest)this.getCover();
        int slotCount = 0;
        if (cover != null) {
            slotCount = cover.getSlotCount();
        }
        int height = slotCount / 3 * 18 + 8;
        if (!this.getUIBuildContext().isAnotherWindow()) {
            return height + 72 + 14;
        }
        return height;
    }

    @Override
    protected void addTitleToUI(ModularWindow.Builder builder) {
    }

    @Override
    protected int getGUIWidth() {
        if (this.getUIBuildContext().isAnotherWindow()) {
            return 74;
        }
        return 182;
    }

    @Override
    protected CoverChest adaptCover(Cover cover) {
        if (cover instanceof CoverChest) {
            CoverChest adapterCover = (CoverChest)cover;
            return adapterCover;
        }
        return null;
    }

    @Override
    protected void addUIWidgets(ModularWindow.Builder builder) {
        CoverDataControllerWidget<CoverChest> w = new CoverDataControllerWidget<CoverChest>(this::getCover, this.getUIBuildContext());
        CoverChest cover = (CoverChest)this.getCover();
        if (cover == null) {
            return;
        }
        IItemHandlerModifiable h = cover.getItems();
        SlotGroup slotGroup = SlotGroup.ofItemHandler((IItemHandlerModifiable)h, (int)3).build();
        if (this.getUIBuildContext().isAnotherWindow()) {
            slotGroup.setPos(4, 4);
        } else {
            slotGroup.setPos(this.getGUIWidth() / 2 - 27, 6);
        }
        w.addChild((Widget)slotGroup);
        builder.widget(w);
        builder.setPos((size, mainWindow) -> Alignment.Center.getAlignedPos(size, new Size(this.getGUIWidth(), this.getGUIHeight())).subtract(this.getUIBuildContext().isAnotherWindow() ? this.getGUIWidth() + 80 : 0, 0));
    }

    @Override
    protected boolean doesBindPlayerInventory() {
        return true;
    }
}

