/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.data;

import com.google.common.collect.MapMaker;
import com.gtnewhorizon.gtnhlib.eventbus.EventBusSubscriber;
import com.gtnewhorizon.gtnhlib.util.CoordinatePacker;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import gregtech.api.enums.GTValues;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.MTEMultiBlockBase;
import gregtech.api.net.GTCoilStatus;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectFunction;
import it.unimi.dsi.fastutil.longs.Long2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongList;
import it.unimi.dsi.fastutil.longs.LongListIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.world.World;
import net.minecraftforge.event.world.ChunkWatchEvent;

@EventBusSubscriber
public class GTCoilTracker {
    private static final Map<World, GTCoilTracker> TRACKERS = new MapMaker().weakKeys().makeMap();
    private final WeakReference<World> world;
    private final WeakReference<GTCoilTracker> self;
    private final Long2IntOpenHashMap activeBlocks = new Long2IntOpenHashMap();
    private final Long2ReferenceOpenHashMap<LongSet> activeBlocksByChunk = new Long2ReferenceOpenHashMap();
    private LongSet pendingActivations = new LongOpenHashSet();
    private LongSet pendingDeactivations = new LongOpenHashSet();
    private final Reference2ReferenceMap<MTEMultiBlockBase, MultiCoilLease> leasesByMulti = new Reference2ReferenceOpenHashMap();
    private static final Long2ObjectFunction<LongSet> CHUNK_LIST_CTOR = ignored -> new LongOpenHashSet();
    private static final Function<World, GTCoilTracker> TRACKER_CTOR = GTCoilTracker::new;

    private GTCoilTracker(World world) {
        this.self = new WeakReference<GTCoilTracker>(this);
        this.world = new WeakReference<World>(world);
    }

    private MultiCoilLease activateImpl(MTEMultiBlockBase multi, LongList coils) {
        MultiCoilLease lease = new MultiCoilLease(this.self, multi, (LongList)new LongArrayList(coils));
        MultiCoilLease existing = (MultiCoilLease)this.leasesByMulti.put((Object)multi, (Object)lease);
        if (existing != null) {
            this.deactivateImpl(existing);
        }
        LongListIterator longListIterator = coils.iterator();
        while (longListIterator.hasNext()) {
            long coil = (Long)longListIterator.next();
            this.activate(coil);
        }
        return lease;
    }

    private void deactivateImpl(MultiCoilLease lease) {
        LongListIterator longListIterator = lease.coils.iterator();
        while (longListIterator.hasNext()) {
            long coil = (Long)longListIterator.next();
            this.deactivate(coil);
        }
        lease.coils.clear();
        MTEMultiBlockBase multi = (MTEMultiBlockBase)lease.multi.get();
        if (multi != null) {
            this.leasesByMulti.remove((Object)multi);
        }
    }

    private void activate(long coil) {
        int old = this.activeBlocks.addTo(coil, 1);
        if (old == 0) {
            this.pendingActivations.add(coil);
            this.pendingDeactivations.remove(coil);
            long chunk = CoordinatePacker.pack((int)(CoordinatePacker.unpackX((long)coil) >> 4), (int)0, (int)(CoordinatePacker.unpackZ((long)coil) >> 4));
            ((LongSet)this.activeBlocksByChunk.computeIfAbsent(chunk, CHUNK_LIST_CTOR)).add(coil);
        }
    }

    private void deactivate(long coil) {
        int old = this.activeBlocks.addTo(coil, -1);
        if (old == 1) {
            this.pendingDeactivations.add(coil);
            this.pendingActivations.remove(coil);
            long chunk = CoordinatePacker.pack((int)(CoordinatePacker.unpackX((long)coil) >> 4), (int)0, (int)(CoordinatePacker.unpackZ((long)coil) >> 4));
            LongSet list = (LongSet)this.activeBlocksByChunk.computeIfAbsent(chunk, CHUNK_LIST_CTOR);
            list.remove(coil);
            if (list.isEmpty()) {
                this.activeBlocksByChunk.remove(chunk);
            }
        }
    }

    @SubscribeEvent
    public static void onTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (event.side != Side.SERVER) {
            return;
        }
        TRACKERS.forEach((world, tracker) -> {
            GTCoilStatus packet;
            if (!tracker.pendingActivations.isEmpty()) {
                packet = new GTCoilStatus(world.field_73011_w.field_76574_g, true, (LongCollection)tracker.pendingActivations);
                tracker.pendingActivations = new LongOpenHashSet();
                GTValues.NW.sendToWorld((World)world, packet);
            }
            if (!tracker.pendingDeactivations.isEmpty()) {
                packet = new GTCoilStatus(world.field_73011_w.field_76574_g, false, (LongCollection)tracker.pendingDeactivations);
                tracker.pendingDeactivations = new LongOpenHashSet();
                GTValues.NW.sendToWorld((World)world, packet);
            }
        });
    }

    @SubscribeEvent
    public static void sendChunkStatus(ChunkWatchEvent.Watch event) {
        GTCoilTracker tracker = TRACKERS.get(event.player.field_70170_p);
        if (tracker == null) {
            return;
        }
        long chunk = CoordinatePacker.pack((int)event.chunk.field_77276_a, (int)0, (int)event.chunk.field_77275_b);
        LongSet active = (LongSet)tracker.activeBlocksByChunk.get(chunk);
        if (active != null && !active.isEmpty()) {
            GTCoilStatus packet = new GTCoilStatus(event.player.field_70170_p.field_73011_w.field_76574_g, true, (LongCollection)active);
            GTValues.NW.sendToPlayer(packet, event.player);
        }
    }

    public static MultiCoilLease activate(MTEMultiBlockBase multi, LongList coils) {
        IGregTechTileEntity base = multi.getBaseMetaTileEntity();
        if (base == null || base.isDead()) {
            return null;
        }
        return TRACKERS.computeIfAbsent(base.getWorld(), TRACKER_CTOR).activateImpl(multi, coils);
    }

    public static void deactivate(MultiCoilLease lease) {
        GTCoilTracker tracker = (GTCoilTracker)lease.tracker.get();
        if (tracker != null) {
            tracker.deactivateImpl(lease);
        }
    }

    public static class MultiCoilLease {
        final WeakReference<GTCoilTracker> tracker;
        final WeakReference<MTEMultiBlockBase> multi;
        final LongList coils;

        MultiCoilLease(WeakReference<GTCoilTracker> tracker, MTEMultiBlockBase multi, LongList coils) {
            this.tracker = tracker;
            this.multi = new WeakReference<MTEMultiBlockBase>(multi);
            this.coils = coils;
        }
    }
}

