/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers.redstone;

import com.google.common.io.ByteArrayDataInput;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import gregtech.api.covers.CoverContext;
import gregtech.api.gui.modularui.CoverUIBuildContext;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.common.covers.CoverLiquidMeter;
import gregtech.common.covers.CoverPosition;
import gregtech.common.covers.redstone.CoverAdvancedRedstoneTransmitterBase;
import gregtech.common.gui.mui1.cover.WirelessFluidDetectorUIFactory;
import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import org.jetbrains.annotations.NotNull;

public class CoverWirelessFluidDetector
extends CoverAdvancedRedstoneTransmitterBase {
    private int threshold;
    private boolean physical;

    public CoverWirelessFluidDetector(CoverContext context, ITexture coverTexture) {
        super(context, coverTexture);
    }

    public int getThreshold() {
        return this.threshold;
    }

    public CoverWirelessFluidDetector setThreshold(int threshold) {
        this.threshold = threshold;
        return this;
    }

    public boolean isPhysical() {
        return this.physical;
    }

    public CoverWirelessFluidDetector setPhysical(boolean physical) {
        this.physical = physical;
        return this;
    }

    @Override
    protected void initializeData() {
        super.initializeData();
        this.threshold = 0;
        this.physical = true;
    }

    @Override
    protected void loadFromNbt(NBTBase nbt) {
        super.loadFromNbt(nbt);
        NBTTagCompound tag = (NBTTagCompound)nbt;
        this.threshold = tag.func_74762_e("threshold");
        this.physical = tag.func_74764_b("physical") ? tag.func_74767_n("physical") : false;
    }

    @Override
    protected void readFromPacket(ByteArrayDataInput byteData) {
        super.readFromPacket(byteData);
        this.threshold = byteData.readInt();
        this.physical = byteData.readBoolean();
    }

    @Override
    @NotNull
    protected NBTBase saveDataToNbt() {
        NBTTagCompound tag = (NBTTagCompound)super.saveDataToNbt();
        tag.func_74768_a("threshold", this.threshold);
        tag.func_74757_a("physical", this.physical);
        return tag;
    }

    @Override
    protected void writeDataToByteBuf(ByteBuf byteBuf) {
        super.writeToByteBuf(byteBuf);
        byteBuf.writeInt(this.threshold);
        byteBuf.writeBoolean(this.physical);
    }

    @Override
    public void doCoverThings(byte aInputRedstone, long aTimer) {
        ICoverable coverable = (ICoverable)this.coveredTile.get();
        if (coverable == null) {
            return;
        }
        byte signal = CoverLiquidMeter.computeSignalBasedOnFluid(coverable, this.invert, this.threshold);
        CoverPosition key = CoverWirelessFluidDetector.getCoverKey(coverable, this.coverSide);
        CoverWirelessFluidDetector.setSignalAt(this.getUuid(), this.getFrequency(), key, signal);
        if (this.physical) {
            coverable.setOutputRedstoneSignal(this.coverSide, signal);
        } else {
            coverable.setOutputRedstoneSignal(this.coverSide, (byte)0);
        }
    }

    @Override
    public boolean letsRedstoneGoOut() {
        return true;
    }

    @Override
    public boolean manipulatesSidedRedstoneOutput() {
        return true;
    }

    @Override
    public ModularWindow createWindow(CoverUIBuildContext buildContext) {
        return new WirelessFluidDetectorUIFactory(buildContext).createWindow();
    }
}

