/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers;

import gregtech.api.GregTechAPI;
import gregtech.api.covers.CoverContext;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.common.covers.Cover;
import gregtech.common.covers.CoverRedstoneWirelessBase;
import java.util.Objects;

public class CoverRedstoneTransmitterInternal
extends CoverRedstoneWirelessBase {
    public CoverRedstoneTransmitterInternal(CoverContext context, ITexture coverTexture) {
        super(context, coverTexture);
    }

    @Override
    public boolean isRedstoneSensitive(long aTimer) {
        return false;
    }

    @Override
    public void onCoverRemoval() {
        GregTechAPI.sWirelessRedstone.remove(this.coverData);
    }

    @Override
    public void doCoverThings(byte aInputRedstone, long aTimer) {
        ICoverable coverable = (ICoverable)this.coveredTile.get();
        if (coverable == null) {
            return;
        }
        GregTechAPI.sWirelessRedstone.put(this.coverData, coverable.getOutputRedstoneSignal(this.coverSide));
    }

    @Override
    public void preDataChanged(Cover newCover) {
        if (newCover instanceof CoverRedstoneTransmitterInternal) {
            CoverRedstoneTransmitterInternal newTransmitterCover = (CoverRedstoneTransmitterInternal)newCover;
            if (!Objects.equals(this.coverData, newTransmitterCover.coverData)) {
                GregTechAPI.sWirelessRedstone.remove(this.coverData);
            }
        }
    }

    @Override
    public boolean letsRedstoneGoOut() {
        return true;
    }

    @Override
    public boolean manipulatesSidedRedstoneOutput() {
        return true;
    }
}

