/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers;

import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import gregtech.api.covers.CoverContext;
import gregtech.api.gui.modularui.CoverUIBuildContext;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.items.MetaGeneratedTool;
import gregtech.api.metatileentity.implementations.MTEMultiBlockBase;
import gregtech.api.util.GTUtility;
import gregtech.common.covers.CoverLegacyData;
import gregtech.common.gui.mui1.cover.NeedMaintainanceUIFactory;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;

public class CoverNeedMaintainance
extends CoverLegacyData {
    public CoverNeedMaintainance(CoverContext context, ITexture coverTexture) {
        super(context, coverTexture);
    }

    public static boolean isRotor(ItemStack rotor) {
        return rotor != null && rotor.func_77973_b() instanceof MetaGeneratedTool && rotor.func_77960_j() >= 170 && rotor.func_77960_j() <= 176;
    }

    @Override
    public boolean isRedstoneSensitive(long aTimer) {
        return false;
    }

    @Override
    public void doCoverThings(byte aInputRedstone, long aTimer) {
        IGregTechTileEntity tTileEntity;
        IMetaTileEntity mTileEntity;
        ICoverable coverable = (ICoverable)this.coveredTile.get();
        if (coverable == null) {
            return;
        }
        boolean needsRepair = false;
        if (coverable instanceof IGregTechTileEntity && (mTileEntity = (tTileEntity = (IGregTechTileEntity)coverable).getMetaTileEntity()) instanceof MTEMultiBlockBase) {
            MTEMultiBlockBase multi = (MTEMultiBlockBase)mTileEntity;
            int ideal = multi.getIdealStatus();
            int real = multi.getRepairStatus();
            ItemStack tRotor = multi.getRealInventory()[1];
            int coverVar = this.coverData >>> 1;
            if (coverVar < 5) {
                if (ideal - real > coverVar) {
                    needsRepair = true;
                }
            } else if (coverVar == 5 || coverVar == 6) {
                if (CoverNeedMaintainance.isRotor(tRotor)) {
                    long mExpectedDamage;
                    long tMax = MetaGeneratedTool.getToolMaxDamage(tRotor);
                    long tCur = MetaGeneratedTool.getToolDamage(tRotor);
                    needsRepair = coverVar == 5 ? tCur >= tMax * 8L / 10L : tCur + (mExpectedDamage = Math.round(Math.min((double)(multi.mEUt / multi.damageFactorLow), Math.pow(multi.mEUt, multi.damageFactorHigh)))) * 2L >= tMax;
                } else {
                    needsRepair = true;
                }
            }
        }
        if (this.coverData % 2 == 0) {
            needsRepair = !needsRepair;
        }
        coverable.setOutputRedstoneSignal(this.coverSide, (byte)(needsRepair ? 0 : 15));
        coverable.setOutputRedstoneSignal(this.coverSide.getOpposite(), (byte)(needsRepair ? 0 : 15));
    }

    @Override
    public void onCoverScrewdriverClick(EntityPlayer aPlayer, float aX, float aY, float aZ) {
        this.coverData = (this.coverData + (aPlayer.func_70093_af() ? -1 : 1)) % 14;
        if (this.coverData < 0) {
            this.coverData = 13;
        }
        switch (this.coverData) {
            case 0: {
                GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("056", "Emit if 1 Maintenance Needed"));
                break;
            }
            case 1: {
                GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("057", "Emit if 1 Maintenance Needed(inverted)"));
                break;
            }
            case 2: {
                GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("058", "Emit if 2 Maintenance Needed"));
                break;
            }
            case 3: {
                GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("059", "Emit if 2 Maintenance Needed(inverted)"));
                break;
            }
            case 4: {
                GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("060", "Emit if 3 Maintenance Needed"));
                break;
            }
            case 5: {
                GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("061", "Emit if 3 Maintenance Needed(inverted)"));
                break;
            }
            case 6: {
                GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("062", "Emit if 4 Maintenance Needed"));
                break;
            }
            case 7: {
                GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("063", "Emit if 4 Maintenance Needed(inverted)"));
                break;
            }
            case 8: {
                GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("064", "Emit if 5 Maintenance Needed"));
                break;
            }
            case 9: {
                GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("065", "Emit if 5 Maintenance Needed(inverted)"));
                break;
            }
            case 10: {
                GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("066", "Emit if rotor needs maintenance low accuracy mod"));
                break;
            }
            case 11: {
                GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("067", "Emit if rotor needs maintenance low accuracy mod(inverted)"));
                break;
            }
            case 12: {
                GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("068", "Emit if rotor needs maintenance high accuracy mod"));
                break;
            }
            case 13: {
                GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("069", "Emit if rotor needs maintenance high accuracy mod(inverted)"));
            }
        }
    }

    @Override
    public boolean letsEnergyIn() {
        return true;
    }

    @Override
    public boolean letsEnergyOut() {
        return true;
    }

    @Override
    public boolean letsFluidIn(Fluid aFluid) {
        return true;
    }

    @Override
    public boolean letsFluidOut(Fluid aFluid) {
        return true;
    }

    @Override
    public boolean letsItemsIn(int aSlot) {
        return true;
    }

    @Override
    public boolean letsItemsOut(int aSlot) {
        return true;
    }

    @Override
    public boolean manipulatesSidedRedstoneOutput() {
        return true;
    }

    @Override
    public int getMinimumTickRate() {
        return 60;
    }

    @Override
    public boolean hasCoverGUI() {
        return true;
    }

    @Override
    public ModularWindow createWindow(CoverUIBuildContext buildContext) {
        return new NeedMaintainanceUIFactory(buildContext).createWindow();
    }
}

