/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers;

import com.google.common.collect.ImmutableList;
import com.google.common.io.ByteArrayDataInput;
import cpw.mods.fml.common.eventhandler.Event;
import gregtech.api.covers.CoverContext;
import gregtech.api.enums.ItemList;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.metatileentity.IMetricsExporter;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.interfaces.tileentity.IGregTechDeviceInformation;
import gregtech.api.metatileentity.BaseMetaTileEntity;
import gregtech.common.covers.Cover;
import gregtech.common.events.MetricsCoverDataEvent;
import gregtech.common.misc.GlobalMetricsCoverDatabase;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.NotNull;

public class CoverMetricsTransmitter
extends Cover {
    public static final String FREQUENCY_MSB_KEY = "gt.metricscover.freq_msb";
    public static final String FREQUENCY_LSB_KEY = "gt.metricscover.freq_lsb";
    public static final String MACHINE_KEY = "machine_name";
    public static final String CARD_STATE_KEY = "card_state";
    private UUID frequency;

    public static boolean isCoverPlaceable(ForgeDirection side, ItemStack coverItem, ICoverable coverable) {
        IGregTechDeviceInformation device;
        return coverable instanceof IGregTechDeviceInformation && (device = (IGregTechDeviceInformation)((Object)coverable)).isGivingInformation();
    }

    public CoverMetricsTransmitter(CoverContext context, ITexture coverTexture) {
        super(context, coverTexture);
        this.initializeData(context.getCoverInitializer());
    }

    public UUID getFrequency() {
        return this.frequency;
    }

    @Override
    protected void initializeData() {
        this.frequency = UUID.randomUUID();
    }

    @Override
    protected void loadFromNbt(NBTBase nbt) {
        if (nbt instanceof NBTTagCompound) {
            NBTTagCompound tag = (NBTTagCompound)nbt;
            this.frequency = new UUID(tag.func_74763_f(FREQUENCY_MSB_KEY), tag.func_74763_f(FREQUENCY_LSB_KEY));
        } else {
            this.initializeData();
        }
    }

    @Override
    protected void readFromPacket(ByteArrayDataInput byteData) {
        this.frequency = new UUID(byteData.readLong(), byteData.readLong());
    }

    @Override
    @NotNull
    protected NBTBase saveDataToNbt() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74772_a(FREQUENCY_MSB_KEY, this.frequency.getMostSignificantBits());
        tag.func_74772_a(FREQUENCY_LSB_KEY, this.frequency.getLeastSignificantBits());
        return tag;
    }

    @Override
    protected void writeDataToByteBuf(ByteBuf byteBuf) {
        byteBuf.writeLong(this.frequency.getMostSignificantBits());
        byteBuf.writeLong(this.frequency.getLeastSignificantBits());
    }

    @Override
    public int getMinimumTickRate() {
        return 20;
    }

    @Override
    public void doCoverThings(byte aInputRedstone, long aTimer) {
        BaseMetaTileEntity baseMTE;
        Object t = this.coveredTile.get();
        if (t instanceof BaseMetaTileEntity && (baseMTE = (BaseMetaTileEntity)t).isGivingInformation()) {
            Object payload;
            IMetaTileEntity iMetaTileEntity = baseMTE.getMetaTileEntity();
            if (iMetaTileEntity instanceof IMetricsExporter) {
                IMetricsExporter metricsExporter = (IMetricsExporter)((Object)iMetaTileEntity);
                payload = metricsExporter.reportMetrics();
            } else {
                payload = ImmutableList.copyOf((Object[])baseMTE.getInfoData());
            }
            MinecraftForge.EVENT_BUS.post((Event)new MetricsCoverDataEvent(this.frequency, (List<String>)payload, new GlobalMetricsCoverDatabase.Coordinates(baseMTE.getWorld().field_73011_w.func_80007_l(), baseMTE.getXCoord(), baseMTE.getYCoord(), baseMTE.getZCoord())));
        }
    }

    @Override
    public void onPlayerAttach(EntityPlayer player, ItemStack coverItem) {
        BaseMetaTileEntity baseMTE;
        ItemStack baseMTEStack;
        UUID newFrequency = UUID.randomUUID();
        ItemStack cardStack = ItemList.NC_AdvancedSensorCard.get(1L, new Object[0]);
        ICoverable coverable = (ICoverable)this.coveredTile.get();
        if (cardStack == null || coverable == null) {
            return;
        }
        NBTTagCompound tagCompound = new NBTTagCompound();
        tagCompound.func_74772_a(FREQUENCY_MSB_KEY, newFrequency.getMostSignificantBits());
        tagCompound.func_74772_a(FREQUENCY_LSB_KEY, newFrequency.getLeastSignificantBits());
        tagCompound.func_74768_a(CARD_STATE_KEY, GlobalMetricsCoverDatabase.State.OPERATIONAL.getType());
        if (coverable instanceof BaseMetaTileEntity && (baseMTEStack = (baseMTE = (BaseMetaTileEntity)coverable).getStackForm(1L)) != null) {
            tagCompound.func_74782_a(MACHINE_KEY, (NBTBase)baseMTEStack.func_77955_b(new NBTTagCompound()));
        }
        cardStack.func_77982_d(tagCompound);
        this.frequency = newFrequency;
        EntityItem cardEntity = new EntityItem(player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v, cardStack);
        cardEntity.field_145804_b = 0;
        player.field_70170_p.func_72838_d((Entity)cardEntity);
    }

    @Override
    public boolean allowsCopyPasteTool() {
        return false;
    }

    @Override
    @NotNull
    public List<String> getAdditionalTooltip() {
        return ImmutableList.of((Object)StatCollector.func_74837_a((String)"gt.item.adv_sensor_card.tooltip.frequency", (Object[])new Object[]{EnumChatFormatting.UNDERLINE.toString() + EnumChatFormatting.YELLOW + this.frequency.toString()}));
    }
}

